define(function (require, exports) {

    function EBookContext() {
        var path = require('../common/path');
        var _user = require('./user');
        var shellcmd = require('../common/shellcmd');
        var _self = this;
        _self._curUser = null;
        _self._binPath = '';
        //以下字段只用在电子书界面
        _self.curBookCode = '';
        _self.WBEB = '';
        _self.matchCode = "";
        //这个字段正常情况下只用在当前文件中,故写作私有
        var _isU = '';

        _self.setIsU = function(isU){
            _isU = isU;
        }

        _self.setBinPath = function (dir) {
            _self._binPath = dir;
        }

        _self.setUser=function(username,password){
            _self._curUser = new _user.User();
            _self._curUser.setBasePath(_self._binPath);
            _self._curUser.setName(username);
            _self._curUser.setPassword(password);
        }

        _self.setUserBaseInfo = function(uid,email,phone,userName,province){
            uid && _self._curUser.setUid(uid);
            email && _self._curUser.setEmail(email);
            phone && _self._curUser.setPhoneNum(phone);
            userName && _self._curUser.setUserName(userName);
            province && _self._curUser.setProvince(province);
        }

        _self.setUserExtInfo = function(ticket,isOnline,isActive,userloginname,loginFrom,points,SSO,books){
            ticket && _self._curUser.setTicket(ticket);
            isOnline && _self._curUser.setIsOnline(isOnline);
            isActive && _self._curUser.setIsActive(isActive);
            userloginname && _self._curUser.setUserLoginName(userloginname);
            loginFrom && _self._curUser.setLoginFrom(loginFrom);
            points && _self._curUser.setPoints(points);
            books && _self._curUser.setBooks(books);
            SSO && _self._curUser.setSSOTicket(SSO);
        }

        _self.getUser = function () {
            return _self._curUser;
        };

        _self.setBookCode = function (bookcode) {
            _self.curBookCode = bookcode;
        };

        _self.getBookCode = function () {
            return _self.curBookCode;
        };

        _self.getUserBookPath = function () {
            var usrbk = path.join(_self._curUser.getUserBookBasePath(), _self.curBookCode);
            return usrbk;
        };

        _self.getStdBookPath = function () {
            var usrbk = (_self.curBookCode == AppCfg.testBook) ? (_self._curUser.getStdTestBookBasePath()): path.join(_self._curUser.getStdBookBasePath(), _self.curBookCode);
            return usrbk;
        };

        /**
         * 临时目录地址
         * @returns {*}
         */
        _self.getTmpPath=function(){
            return path.trimPosix(path.join(_self._binPath,'temp'));
        }

        /***
         * 操作系统 %TEMP%/iflybook
         * @returns {*}
         */
       _self.getSysTmpPath=function(){
           return path.trimPosix(Config.tmpPath);
       }

        _self.setWBEB = function(wbeb){
            _self.WBEB = wbeb;
        }

        _self.getWBEB = function(){
            return _self.WBEB;
        }

        _self.getTransformMatrix = function(page){
            var matrixTransform = page ? page.css('-webkit-transform') : $('.pageItem').css('-webkit-transform');
            matrixTransform = matrixTransform && matrixTransform != 'none' ? matrixTransform.substr(7, matrixTransform.length - 8).split(",") : [1, 0, 0, 1, 0, 0];
            return matrixTransform;
        }

        _self.getUnTransForm = function(){
            var matrix = this.getTransformMatrix();
            var wZoom = matrix[0] ? 1 / matrix[0] : 1;
            var hZoom = matrix[3] ? 1 / matrix[3] : 1;
            return {
                wZoom: wZoom,
                hZoom: hZoom
            };
        }

        _self.getClientToken = function(){
            var def = $.Deferred();
            shellcmd.getHttpRequestJSON(AppRemoteSvcCfg.ClientToken).done(function(ret){
                if(ret){
                    app_ClientToken = ret.access_token;
                    def.resolve(ret.access_token);
                }
                else{
                    def.resolve("");
                }
            })
            return def.promise();
        }

        _self.getMatchToken = function(){
            var def = $.Deferred();
            if(_self.matchCode){
                def.resolve(_self.matchCode);
            }
            else{
                if(_isU){
                  //返回U盘Token
                  //  var md5helper = require('../common/md5helper');
                  //  _self.matchCode = _curUser.getName() + md5helper.hex_md5(_isU + _curUser.getName());
                    _self.matchCode = _self._curUser.getName() + _isU;
                    def.resolve(_self.matchCode);
                }
                else{
                    _self._curUser.getUserToken().done(function(ret){
                        _self.matchCode = ret;
                        def.resolve(ret);
                    })
                }
            }
            return def.promise();
        }

    }

    exports.Instance = new EBookContext();
});

