/**
 * 画廊卡片模板功能类
 * Created with JetBrains WebStorm.
 * User: qmjie
 * Date: 13-8-28
 * Time: 下午2:17
 * To change this template use File | Settings | File Templates.
 */
define(function (require, exports, module) {
    require('jquery');
    require('dragsort');
    require('zebra_dialog');
    var path = require('../../../common/path');
    var shellcmd = require('../../../common/shellcmd');
    var GalleryItem = require('./galleryItem').Instance;
    var md5helper = require('../../../common/md5helper');
    var define = require('../../define');
    var ebookContext = require('../../ebookcontext').Instance;
    function GalleryCardTemplate() {
        var _self = this;

        _self.num = 1;
        _self.isNoNewIcon = false;
        _self.dirName = "";
        _self.pageIndex = 1;

        _self.buttons = {
            galleryTmpEditBtn: $("#galleryTmpEditBtn"),
            closeBtnGalleryTmpPanel: $("#closeBtn_galleryTmpPanel"),
            galleryImgBtnExt: $("#galleryImgBtnExt"),
            galleryImgBtn: $("#galleryImgBtn"),
            galleryDeleteBtn: $("#galleryDeleteBtn"),
            addImgBtn: $("#addImgBtn"),
            galleryCompleteBtn: $("#galleryCompleteBtn"),
            imgSortBtn: $("#imgSortBtn"),
            sortCompleteBtn: $("#sortCompleteBtn"),
            samrtbarGallery: $("#samrtbar_gallery")
        };

        _self.controls = {
            templatePanel: $("#templatePanel"),
            galleryTmpPanel: $("#galleryTmpPanel"),
            galleryTmpPanelTop: $("#galleryTmpPanelTop"),
            galleryTmpPanelMask: $("#galleryTmpPanelMask"),
            deleteBtnPanel: $("#deleteBtnPanel"),
            galleryTitle: $("#galleryTitle"),
            galleryDescription: $("#galleryDescription"),
            galleryPagePanel: $("#galleryPagePanel"),
            imgSortPanel: $("#imgSortPanel"),
            galleryEditPanel: $("#galleryEditPanel")
        };

        /**
         * 存放画廊图片信息的数据结构
         */
        _self.GalleryItems = [];

        /**
         * 画廊中焦点显示图片的位置
         */
        _self.GalleryPos = 0;

        /**
         * 课本容器对象
         */
        _self.bookContainer = null;

        /**
         * 初始化画廊卡片模板
         */
        _self.init = function (bookContainer) {
            _self.bookContainer = bookContainer;
            var deleBtn = $("#galleryDeleteBtn")[0];
//            if (AppCfg.lang == "uyghur") {
//                deleBtn.className = 'wy_btn_delete';
//                $("#deleteBtnPanel").css("width", "80px");
//            }
            deleBtn.onmousedown = function () {
                this.className = (AppCfg.lang == "uyghur") ? 'wy_btn_delete_pressed' : 'btn_delete_pressed' ;
            }
            deleBtn.onmouseout = function () {
                this.className = (AppCfg.lang == "uyghur") ? 'wy_btn_delete' : 'btn_delete' ;
            }

            //弹出画廊模板界面
            _self.buttons.galleryTmpEditBtn.click(function () {
                _self.showGalleryTmpPanel();
            });

            //samrtbar_gallery
            _self.buttons.samrtbarGallery.click(function () {
                _self.showGalleryTmpPanel()
            });

            //关闭画廊模板界面
            _self.buttons.closeBtnGalleryTmpPanel.click(function () {
                _self.hideGalleryTmpPanel();
            });

            //点击图片区选择图片
            _self.buttons.galleryImgBtn.click(function () {
                //只有当画廊图片数为零时，点击#galleryImgBtn才会弹出图片对话框
                if (_self.GalleryItems.length == 0)
                    _self.selectGalleryImg();
            });

            //鼠标移到图片区时若图片存在则显示删除按钮
            _self.buttons.galleryImgBtnExt.mouseover(function () {
                if (_self.GalleryItems.length > 0)
                    _self.controls.deleteBtnPanel.show();
            });

            //鼠标移出图片区时隐藏删除按钮
            _self.buttons.galleryImgBtnExt.mouseout(function () {
                _self.controls.deleteBtnPanel.hide();
            });

            //鼠标移到删除按钮时显示删除按钮
            _self.buttons.galleryDeleteBtn.mouseover(function () {
                _self.controls.deleteBtnPanel.show();
            });

            //鼠标移出删除按钮时隐藏删除按钮
            _self.buttons.galleryDeleteBtn.mouseout(function () {
                _self.controls.deleteBtnPanel.hide();
            });

            //删除图片
            _self.buttons.galleryDeleteBtn.click(function () {
                _self.deleteGalleryImg(_self.GalleryPos);
            });

            //添加图片按钮
            _self.buttons.addImgBtn.click(function () {
                _self.selectGalleryImg();
            });

            //画廊图片卡片模板创建完成
            _self.buttons.galleryCompleteBtn.click(function () {
                _self.gallery2json();
            });

            //画廊图片排序
            _self.buttons.imgSortBtn.click(function () {
                _self.imgSort();
            });

            //画廊图片排序完成
            _self.buttons.sortCompleteBtn.click(function () {
                _self.imgSortComplete();
            });

            _self.controls.galleryTitle[0].onfocus = function () {
                if (this.value == AppCardTemplateTipsList.clickHereAddTitle)
                    this.value = '';
            }

            _self.controls.galleryTitle[0].onblur = function () {
                if (this.value == '')
                    this.value = AppCardTemplateTipsList.clickHereAddTitle;
            }

            _self.controls.galleryDescription[0].onfocus = function () {
                if (this.value == AppCardTemplateTipsList.clickHereAddComment)
                    this.value = '';
            }

            _self.controls.galleryDescription[0].onblur = function () {
                if (this.value == '')
                    this.value = AppCardTemplateTipsList.clickHereAddComment;
            }

            //这个事件有点奇妙，直接用“change”无效
            _self.controls.galleryTitle.bind('input propertychange', function () {
                if (_self.controls.galleryTitle.val().length > 45) {
                    $.Zebra_Dialog(AppCardTemplateTipsList.TitleTooLong, {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons': [AppTips.OkTips],
                        'onClose': function () {
                            //标题过长，截断处理
                            _self.controls.galleryTitle.val(_self.controls.galleryTitle.val().substr(0, 45));
                        }
                    });
                }
            });

            _self.controls.galleryDescription.bind('input propertychange', function () {
                if (_self.controls.galleryDescription.val().length > 60) {
                    $.Zebra_Dialog(AppCardTemplateTipsList.DescriptionTooLong, {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons': [AppTips.OkTips],
                        'onClose': function () {
                            //标题过长，截断处理
                            _self.controls.galleryDescription.val(_self.controls.galleryDescription.val().substr(0, 60));
                            if (_self.GalleryPos > 0) {
                                _self.GalleryItems[_self.GalleryPos - 1].description = _self.controls.galleryDescription.val();
                                console.log(_self.controls.galleryDescription.attr("value"));
                            }
                        }
                    });
                }
            });

            //图片拖动排序
            $("#imgSortList").dragsort({ dragSelector: "div", dragBetween: true, dragEnd: saveOrder, placeHolderTemplate: "<li class='placeHolder'><div></div></li>" });
            function saveOrder() {
                var data = $("#imgSortList li").map(function () {
                    return $(this).children().html();
                }).get();
                $("input[name=listSortOrder]").val(data.join("|"));
            }
        };

        /**
         * 显示画廊卡片模板面板
         */
        _self.showGalleryTmpPanel = function () {

            _self.isNoNewIcon = false;
            _self.dirName = "";
            //居中显示
            _self.controls.galleryTmpPanel.css({
                position: 'absolute',
                left: ($(window).width() - _self.controls.galleryTmpPanel.outerWidth()) / 2,
                top: ($(window).height() - _self.controls.galleryTmpPanel.outerHeight()) / 2 + $(document).scrollTop()
            });
            _self.controls.templatePanel.hide();
            _self.controls.galleryTmpPanel.show();
            //防止图片排序时直接关闭窗口，再打开画廊卡片模板直接打开图片排序界面而不是画廊编辑界面
            _self.controls.galleryEditPanel.show();
            _self.controls.imgSortPanel.hide();
            _self.controls.galleryTmpPanelMask.hide();
            //设置图片显示最大尺寸，并且居中显示
            _self.buttons.galleryImgBtn.attr("style", "max-height: 312px; max-width: 546px;vertical-align: middle;");
            _self.buttons.galleryImgBtnExt.attr("style", "text-align: center;line-height: 312px;");
            _self.buttons.galleryDeleteBtn.attr("style", "vertical-align:top"); //防止删除按钮位于图片底部

            _self.controls.galleryTmpPanel.draggable({
                handle: "#" + _self.controls.galleryTmpPanelTop.attr("id"),
                containment: "parent",
                start: function () {
                    _self.controls.galleryTmpPanelMask.show();
                },
                stop: function () {
                    _self.controls.galleryTmpPanelMask.hide();
                }
            });

            //画廊图片描述信息更新
            //jquery2.0.3中使用_self.controls.galleryDescription.attr("value")获取到的值还是input的默认值value,不能动态获取修改后的值
            _self.controls.galleryDescription.bind("change", function () {
                if (_self.GalleryPos > 0) {
                    _self.GalleryItems[_self.GalleryPos - 1].description = _self.controls.galleryDescription.val();
                    console.log(_self.controls.galleryDescription.attr("value"));
                }
            });

            //弹出画廊模板时使搜索输入框不能编辑
            $("#outerSearchText").attr("disabled", "disabled");
            $("#btnOuterSearch>input").attr("disabled", "disabled");
        };


        /*
         *显示画廊反编辑界面
         * @author pengfu
         * @param galleryJson
         */
        _self.showEditGalleryTplPanel = function(galleryJson,isNoNewIcon,dir,pageIndex){
            _self.clearGalleryData();
            _self.isNoNewIcon = isNoNewIcon;
            _self.dirName = dir ? dir:"";
            _self.pageIndex = pageIndex;
            //居中显示
            _self.controls.galleryTmpPanel.css({
                position: 'absolute',
                left: ($(window).width() - _self.controls.galleryTmpPanel.outerWidth()) / 2,
                top: ($(window).height() - _self.controls.galleryTmpPanel.outerHeight()) / 2 + $(document).scrollTop()
            });
            _self.controls.templatePanel.hide();
            _self.controls.galleryTmpPanel.show();
            //防止图片排序时直接关闭窗口，再打开画廊卡片模板直接打开图片排序界面而不是画廊编辑界面
            _self.controls.galleryEditPanel.show();
            _self.controls.imgSortPanel.hide();
            _self.controls.galleryTmpPanelMask.hide();
            //设置图片显示最大尺寸，并且居中显示
            _self.buttons.galleryImgBtn.attr("style", "max-height: 312px; max-width: 546px;vertical-align: middle;");
            _self.buttons.galleryImgBtnExt.attr("style", "text-align: center;line-height: 312px;");
            _self.buttons.galleryDeleteBtn.attr("style", "vertical-align:top"); //防止删除按钮位于图片底部

            _self.controls.galleryTmpPanel.draggable({
                handle: "#" + _self.controls.galleryTmpPanelTop.attr("id"),
                containment: "parent",
                start: function () {
                    _self.controls.galleryTmpPanelMask.show();
                },
                stop: function () {
                    _self.controls.galleryTmpPanelMask.hide();
                }
            });

            //在这个地方渲染出图片
            for (var i = 0; i < galleryJson.images.length; i++) {
                var galleryImgItem = new GalleryItem();
                galleryImgItem.url = galleryJson.images[i].src;
                galleryImgItem.title = galleryJson.title;
                galleryImgItem.description = galleryJson.images[i].des;
                _self.GalleryPos = _self.GalleryItems.push(galleryImgItem);
            }

            var tempItem = _self.GalleryItems[_self.GalleryPos - 1];

            var str = "";
            if (tempItem) {
                var fileName = path.filename(path.toPosix(tempItem.url));
                str = tempItem.url.substr(0, tempItem.url.length - fileName.length) + encodeURIComponent(fileName);
            }
            _self.controls.galleryTitle.val(galleryJson.title);
            _self.buttons.galleryImgBtn.attr("src", str);
            _self.controls.galleryDescription.attr("disabled", false);
            _self.controls.galleryDescription.val(tempItem.description);
            _self.refreshGallery(_self.GalleryPos);

            //判断当前图片个是否超过10 使添加图片按钮disabled
            if (_self.GalleryItems.length == 10) {
                _self.buttons.addImgBtn.attr("disabled", true);
            }
            //判断当前图片个数是否为0 使排序按钮disable
            if (_self.GalleryItems.length > 0) {
                _self.buttons.imgSortBtn.attr("disabled", false);
                _self.buttons.galleryCompleteBtn.attr("disabled", false);
            }


            //画廊图片描述信息更新
            //jquery2.0.3中使用_self.controls.galleryDescription.attr("value")获取到的值还是input的默认值value,不能动态获取修改后的值
            _self.controls.galleryDescription.bind("change", function () {
                if (_self.GalleryPos > 0) {
                    _self.GalleryItems[_self.GalleryPos - 1].description = _self.controls.galleryDescription.val();
                    console.log(_self.controls.galleryDescription.attr("value"));
                }
            });

            //弹出画廊模板时使搜索输入框不能编辑
            $("#outerSearchText").attr("disabled", "disabled");
            $("#btnOuterSearch>input").attr("disabled", "disabled");
        }

        /**
         *隐藏画廊卡片模板面板
         */
        _self.hideGalleryTmpPanel = function () {
            //清除数据
            _self.clearGalleryData();
            _self.controls.galleryTmpPanel.hide();

            //关闭画廊模板时使搜索输入框能够编辑
            $("#outerSearchText").removeAttr("disabled");
            $("#btnOuterSearch>input").removeAttr("disabled");
        };

        /**
         * 画廊模板退出时清除画廊数据
         */
        _self.clearGalleryData = function () {
            _self.GalleryItems.length = 0;
            _self.GalleryPos = 0;
            _self.controls.galleryPagePanel.html("");
            //这里有语言切换
            _self.buttons.galleryImgBtn.attr("src", AppCfg.lang == "zhcn" ? "assert/images/gallery_img.png" : "assert/images/wy_gallery_img.png");
            _self.controls.galleryDescription.attr("disabled", "true");
            _self.controls.galleryDescription.val("");
            _self.controls.galleryTitle.val(AppCardTemplateTipsList.clickHereAddTitle);
            //画廊模板退出后再打开时排序按钮、完成按钮应为disabled
            _self.buttons.imgSortBtn.attr("disabled", true);
            _self.buttons.galleryCompleteBtn.attr("disabled", true);
            _self.buttons.addImgBtn.attr("disabled", false);
        };

        /**
         *选择图片上传
         */
        _self.selectGalleryImg = function () {
            var filterStr = "图片文件 (*.bmp;*.jpg;*.jpeg;*.gif;*.png;*.tif)|" +
                "*.bmp;*.jpg;*.jpeg;*.gif;*.png;*.tif|Bitmaps (*.bmp)|*.bmp|" +
                "GIFs (*.gif)|*.gif|JPEGs (*.jpg)|*.jpg;*.jpeg|PNGs (*.png)|*.png|TIFs (*.tif)|*.tif|All Files (*.*)|*.*";

            // 新的Opendialog方法
            var options = {"multi": true, "ext": ['.jpg', '.jpeg', '.gif', '.png', '.bmp']};
            shellcmd.openFileDialog(options).done(function (result) {
                if (result) {
                    console.log('opendialog result', result);
                    //处理选取多个图片
                    if (result.length > 0) {
                        paths = result;
                        var imgNum = paths.length + _self.GalleryItems.length;
                        //限制最多添加10张照片,超过10张则添加图片数够10就行
                        if (imgNum > 10) {
                            var tips = AppCardTemplateTipsList.GalleryImgTips.format(imgNum);
                            $.Zebra_Dialog(tips, {
                                'type': 'information',
                                'title': AppTips.WarmTips,
                                'buttons': [ AppTips.OkTips]
                            });
                            paths.length = 10 - _self.GalleryItems.length;
                        }

                        for (var i = 0; i < paths.length; i++) {
                            var galleryImgItem = new GalleryItem();
                            galleryImgItem.url = paths[i];
                            galleryImgItem.title = _self.controls.galleryTitle.attr("value");
                            galleryImgItem.description = AppCardTemplateTipsList.clickHereAddComment;
                            _self.GalleryPos = _self.GalleryItems.push(galleryImgItem);
                        }
                        var tempItem = _self.GalleryItems[_self.GalleryPos - 1];

                        var str = "";
                        if (tempItem) {
                            var fileName = path.filename(path.toPosix(tempItem.url));
                            str = tempItem.url.substr(0, tempItem.url.length - fileName.length) + encodeURIComponent(fileName);
                        }
                        _self.buttons.galleryImgBtn.attr("src", str);
                        _self.controls.galleryDescription.attr("disabled", false);
                        _self.refreshGallery(_self.GalleryPos);
                    }
                }
                //判断当前图片个是否超过10 使添加图片按钮disabled
                if (_self.GalleryItems.length == 10) {
                    _self.buttons.addImgBtn.attr("disabled", true);
                }
                //判断当前图片个数是否为0 使排序按钮disable
                if (_self.GalleryItems.length > 0) {
                    _self.buttons.imgSortBtn.attr("disabled", false);
                    _self.buttons.galleryCompleteBtn.attr("disabled", false);
                }
            });
        };

        /**
         *删除画廊图片
         * @param page 待删除图片的序号
         */
        _self.deleteGalleryImg = function (page) {
            _self.GalleryItems.splice(page - 1, 1);

            var length = _self.GalleryItems.length;
            if (length === 0) {
                _self.buttons.galleryImgBtn.attr("src", "assert/images/gallery_img.png");
                _self.GalleryPos = 0;
                _self.refreshGallery(0);
            }
            else if (length > 0) {
                if (page == 1) {               //第1张图片
                    _self.buttons.galleryImgBtn.attr("src", _self.GalleryItems[0].url);
                    _self.GalleryPos = page;
                    _self.refreshGallery(page);
                } else if (page == length + 1) { //最后一张图片
                    _self.buttons.galleryImgBtn.attr("src", _self.GalleryItems[length - 1].url);
                    _self.GalleryPos = length;
                    _self.refreshGallery(length);
                } else {                      //中间图片
                    _self.buttons.galleryImgBtn.attr("src", _self.GalleryItems[page - 1].url);
                    _self.GalleryPos = page;
                    _self.refreshGallery(page);
                }
            }

            //判断当前图片个数是否超过10 使添加图片按钮disable
            if (_self.GalleryItems.length < 10)
                _self.buttons.addImgBtn.attr("disabled", false);
            //判断当前图片个数是否为0 使排序按钮disable
            if (_self.GalleryItems.length == 0) {
                _self.buttons.imgSortBtn.attr("disabled", true);
                _self.buttons.galleryCompleteBtn.attr("disabled", true);
            }
        };

        /**
         * 更新画廊信息，根据画廊图片列表信息，决定画廊面板界面
         * @param page 待显示图片的序号
         */
        _self.refreshGallery = function (page) {
            //更新图片描述信息
            if (page > 0) {
                _self.controls.galleryDescription.val(_self.GalleryItems[page - 1].description);
            }
            else {
                _self.controls.galleryDescription.val("");
                _self.controls.galleryDescription.attr("disabled", true);
            }

            //根据画廊图片个数决定galleryPagePanel的界面
            _self.controls.galleryPagePanel.html("");
            var index = 0;
            for (var i = 0; i < _self.GalleryItems.length; i++) {
                var btn = $("<input/>");
                btn.attr("type", "button");
                if (page === i + 1) {
                    btn.removeClass();
                    btn.addClass("btn_flip2");
                }
                else {
                    btn.addClass("btn_flip");
                    btn.mousedown(function () {
                        $(this).removeClass();
                        $(this).addClass("btn_flip2");
                    });
                }
                btn.val(i + 1);
                btn.click(function () {
                    var val = $(this).val();
                    var index = parseInt(val - 1);
                    _self.buttons.galleryImgBtn.attr("src", _self.GalleryItems[index].url);
                    _self.controls.galleryDescription.val(_self.GalleryItems[index].description);
                    console.log(_self.GalleryItems[index].description);
                    _self.GalleryPos = parseInt(val);//更新焦点图片
                    _self.refreshGallery(parseInt(val));
                    $(this).removeClass();
                    $(this).addClass("btn_flip2");

                });
                _self.controls.galleryPagePanel.append(btn);
            }
        };

        /**
         * 画廊卡片模板创建完成，将画廊信息写入json文件
         */
        _self.gallery2json = function () {
            //画廊模板信息文件所在路径
            if (_self.controls.galleryTitle.val() == AppCardTemplateTipsList.clickHereAddTitle)
                _self.controls.galleryTitle.val("");

            if (_self.dirName == "") {
                var date = new Date();
                _self.dirName = "画廊_" + date.getTime();
            }

            _self.createTmpDir(_self.dirName).done(function (dir) {
                if (!dir) return;
                var imgArrJson = [];
                for (var i = 0; i < _self.GalleryItems.length; i++) {
                    //拷贝图片文件
                    var imgMd5 = md5helper.hex_md5(i + _self.GalleryItems[i].url);
                    var imgExt = path.extname(_self.GalleryItems[i].url);
                    shellcmd.copyFile(_self.GalleryItems[i].url, path.join(dir, imgMd5 + imgExt));
                    if (_self.GalleryItems[i].description == AppCardTemplateTipsList.clickHereAddComment)
                        _self.GalleryItems[i].description = "";
                    //TODO:过滤description中的“|”字符,可以用正则优化
//                    var _descriptStr = _self.GalleryItems[i].description.split("|");
//                    _self.GalleryItems[i].description = _descriptStr.join("");
                    var imgJson = {src: imgMd5 + imgExt, des: _self.GalleryItems[i].description, index: i.toString()};
                    imgArrJson.push(imgJson);
                }

                var galleryInfo = {"cardtype": "gallery", "thumbnail": '', "title": _self.controls.galleryTitle.val(), "keywords": 'test', "images": imgArrJson};
                console.log(JSON.stringify(galleryInfo));
                shellcmd.XinJiang_saveFilAsync(JSON.stringify(galleryInfo), path.join(dir, 'meta.json')).done(function (ret) {
                    console.log("saveFilAsync result: " + ret);
                    if (ret == 'true') {
                        //在主界面上添加画廊图标
                        var option = {
                            title : "画廊" + _self.num ,
                            userName:ebookContext.getUser().getUserName() || ebookContext.getUser().getName(),
                            uploadTime:new Date().toLocaleString(),
                            noNewIcon : _self.isNoNewIcon
                        }
                        _self.bookContainer.insertSingleWidget(dir, define.WidgetType.Gallery,null,option);
                        _self.num ++;
                        //关闭画廊模板对话框
                        _self.hideGalleryTmpPanel();
                    }
                });

            });

        };

        /**
         * 画廊图片排序
         */
        _self.imgSort = function () {
            //弹出图片排序界面
            _self.controls.galleryEditPanel.hide();
            _self.controls.imgSortPanel.show();
            //清空#imgSortList中的子元素,删除图片或者添加图片后继续排序将重新获取子元素
            $("#imgSortList").html("");
            //获得图片列表
            for (var i = 0; i < _self.GalleryItems.length; i++) {
                var li = $("<li>");
                var div = $("<div>");
                var img = $("<img/>");
                img.attr({"src": _self.GalleryItems[i].url, "alt": _self.GalleryItems[i].description, "style": "max-height: 117px; max-width: 117px;"});
                div.append(img);
                li.append(div);
                $("#imgSortList").append(li);
            }
        };

        /**
         * 画廊图片排序完成
         */
        _self.imgSortComplete = function () {
            //根据图片排序结果更新画廊图片数组数据
            //清空数组
            _self.GalleryItems.length = 0;
            //对数组重新赋值
            $("#imgSortList>li").each(function () {
                var item = new GalleryItem();
                item.title = _self.controls.galleryTitle.val();
                //获取<li>中的子元素<div>
                $(this).children().each(function () {
                    $(this).children().each(function () {
                        //获取<div>中的子元素<img>
                        item.url = $(this).attr("src");
                        item.description = $(this).attr("alt");
                    });
                });
                _self.GalleryItems.push(item);
            });
            _self.controls.galleryEditPanel.show();
            _self.controls.imgSortPanel.hide();
            //转到画廊添加编辑界面，更新焦点图片和图片描述
            _self.buttons.galleryImgBtn.attr("src", _self.GalleryItems[_self.GalleryPos - 1].url);
            _self.controls.galleryDescription.val(_self.GalleryItems[_self.GalleryPos - 1].description);
        };

        /**
         * 根据待创建的新目录名创建目录，返回新创建目录路径
         * @param newDirName
         * @returns {dir}
         */
        _self.createTmpDir = function (newDirName) {
            //画廊模板信息文件所在路径
            var ebookContext = require('../../ebookcontext').Instance;
            var ubPath = path.trimPosix(ebookContext.getWBEB() == "WB" ? ebookContext.getUser().getUserWBPath() :
                ebookContext.getUserBookPath());
            console.log(ubPath);
            //根据当前用户设置模板目录
            //注意获取页码的方法 不能用bookcontaner.getPageIndex（）方法
            var _str = ebookContext.getWBEB() == "WB" ? _self.bookContainer.getWbIndex() : _self.pageIndex;
            var dir = path.join(ubPath, _str + '/' + newDirName);

            var defer = $.Deferred();
            shellcmd.isDirExist(dir).done(function (ret1) {
                console.log("isDirExist done : " + ret1);
                if (!ret1) {
                    shellcmd.createDir(dir).done(function (ret2) {
                        if (!ret2) {
                            $.Zebra_Dialog(dir + AppCardTemplateTipsList.FailCreateDir, {
                                'type': 'information',
                                'title': AppTips.WarmTips,
                                'buttons': [AppTips.OkTips]
                            });
                            defer.resolve(null);
                        }
                    });
                }
                defer.resolve(dir);
            });
            return defer.promise();
        };
    }

    exports.GalleryCardTemplate = GalleryCardTemplate;
    exports.Instance = new GalleryCardTemplate();
});
