/**
 * Created by pengfu on 14-7-14.
 */
define(function (require, exports) {
    var _helper = require("./choicecardtmphelper").Instance;
    var md5helper = require('../../../../common/md5helper');
    var QuestionItemBase = require("./choicecardbase").QuestionItemBase;
    var path = require('../../../../common/path');
    var shellcmd = require('../../../../common/shellcmd');
    var define = require('../../../define');
    require('jquery');

    /**
     *
     * @constructor
     */
    function TextChoiceWithImageQuestion(questionObj) {
        var _textChoiceWithImageQuestion = this;
        this.type = _helper.QuestionType.TextChoiceWithImage;

        /**
         * 图片路径
         */
        this.imagePath = "";

        this.choiceItems = [];

        this.correctAnswer = -1;//初始化一个默认值

        var labelList = ['A', 'B', 'C', 'D', 'E', 'F'];
        var input_txt = AppCardTemplateTipsList.clickHereAddAnswer;
        var input_txt_title = AppCardTemplateTipsList.clickHereAddTheme;

        var domstr = '<div>' +
            '<div class="shit_input"><label></label><input class="choice_theme" class1="questionText"  type="text" value="{text}"/>' +
            '</div><div class="withChoiceImgDiv" style="border: 1px solid #E8E8E8"><img  class1="textChoiceWithImageButton" src="assert/images/add_img_big.jpg" style="margin-right: 15px;margin-top: 0px;"/>' + '</div>' +
            '</div>';

        var tmpChoiceItemTpl = '<li index="{index}" class="chioceti">' +
            '<a title="" id="{id}" class1="radioform" class="check_btn "></a>' + '<span class="sub_tit">{lable}.</span>' +
            '<input type="text" class1="choicetext" class="add_answer"  value="{addAnswer}" >' +
            '</li>';
//        var choiceItemTpl = tmpChoiceItemTpl.replace("{addAnswer}", input_txt);
        var choiceItemTpl = tmpChoiceItemTpl;

        var _this = this;

        function init(questionObj) {
            if(!questionObj){
                _this.questionText = input_txt_title;
                _this.questionId = "TCWithI_" + new Date().getTime();

                //TODO: 初始化choiceItems
                for (var i = 0; i < 4; i++) {
                    var item = new _helper.ChoiceItem();
                    item.label = labelList[i];
                    _this.choiceItems.push(item);
                }
            }else{
                _this.questionText = questionObj.theme;
                _this.questionId = "TCWithI_" + new Date().getTime();

                // 初始化choiceItems
                for (var j = 0; j < questionObj.choiceItems.length; j++) {
                    var item = new _helper.ChoiceItem();
                    item.label = labelList[j];
                    item.text = questionObj.choiceItems[j].text;
                    _this.choiceItems.push(item);
                }
            }

        }

        function _selectedTextChoiceImage(_this) {

            var filterStr = "图片文件 (*.bmp;*.jpg;*.jpeg;*.gif;*.png;*.tif)|" +
                "*.bmp;*.jpg;*.jpeg;*.gif;*.png;*.tif|Bitmaps (*.bmp)|*.bmp|" +
                "GIFs (*.gif)|*.gif|JPEGs (*.jpg)|*.jpg;*.jpeg|PNGs (*.png)|*.png|TIFs (*.tif)|*.tif|All Files (*.*)|*.*";

            // 新的Opendialog方法
            var options = {"multi": false, "ext": ['.jpg', '.jpeg', '.gif', '.png', '.bmp']};
            shellcmd.openFileDialog(options).done(function (result) {
                if (result.length > 0) {
                    console.log('opendialog result', result);

                    var imgMd5 = md5helper.hex_md5(result[0]);
                    var imgExt = path.extname(result[0]);
                    _textChoiceWithImageQuestion.imagePath = imgMd5 + imgExt;
                    _textChoiceWithImageQuestion.srcImgPath = result[0];//记录文件名为后面拷贝工作

                    var pictureItem = {};
                    pictureItem.url = result[0];

                    var fileName = path.filename(path.toPosix(result[0]));
                    var str = result[0].substr(0, result[0].length - fileName.length) + encodeURIComponent(fileName);
                    //TODO:怎么样使得变小
                    _this.attr("src", str);
                    // 创建对象
                    var img = new Image();
                    // 改变图片的src
                    img.src = str;
                    // 加载完成执行
                    img.onload = function () {
//                        alert('width:'+img.width+',height:'+img.height);
                        var w, h, magin_top, magin_left;
                        if (img.height <= 264 && img.width <= 264) {
                            magin_top = (264 - img.height) / 2;
                            magin_left = (264 - img.width) / 2;
                        } else if (img.height > 264 && img.width <= 264) {
                            h = 264;
                            w = (img.width / img.height) * h;
                            magin_top = 0;
                            magin_left = (264 - w) / 2;
                        } else if (img.height <= 264 && img.width > 264) {
                            w = 264;
                            h = (img.height / img.width) * w;
                            magin_top = (264 - h) / 2;
                            magin_left = 0;
                        } else {
                            if (img.width / img.height >= 1) {
                                w = 264;
                                h = (img.height / img.width) * w;
                                magin_top = (264 - h) / 2;
                                magin_left = 0;
                            } else {
                                h = 264;
                                w = (img.width / img.height) * h;
                                magin_top = 0;
                                magin_left = (264 - w) / 2;
                            }
                        }
                        _this.css({
                            maxWidth: 264 + 'px',
                            maxHeight: 264 + 'px',
                            marginTop: magin_top + 'px',
                            marginLeft: magin_left + 'px'
                        });
                    };
                }
            });
        }

        /**
         *
         * @returns {Array.<ChoiceItem>}
         */
        this.getChoiceItems = function () {
            return this.choiceItems;
        }

        this.buildHTML = function (questionObj) {

//            var choiceItemTpl =  '<li index="{index}" class="chioceti">'+
//                '<a title="" id="{id}" class1="radioform" class="check_btn "></a>' +'<span class="sub_tit">{lable}.</span>'+
//                '<input type="text" class1="choicetext" class="add_answer"  value="点击此处添加答案" >'+
//                '</li>';

            var themeContent ;
            if(!questionObj){
                themeContent = input_txt_title;
            }else{
                themeContent = questionObj.theme;
            }
            var dom = $(domstr.replace("{text}", themeContent));

            var choiceItemArr = this.getChoiceItems();
            var choiceItemsHTMLArr = [];
            for (var i = 0, len = choiceItemArr.length; i < len; i++) {
                var choiceItem = choiceItemArr[i];
                var choiceId = "" + i + new Date().getTime();
                var html = choiceItemTpl.replace("{index}", i)
                    .replace(/\{id\}/g, choiceId)
                    .replace("{lable}", choiceItem.label)
                    .replace("{addAnswer}",choiceItem.text);
                choiceItemsHTMLArr.push(html);
            }

//            var choiceItemsDomStr = '<div id="{questionId}"> </div>'.replace("{questionId}",_this.questionText);
//            var choiceItemsDomStr = '<div class="sub_type_3 clearfix sub_type_1 fl" id="{questionId}"> </div>'.replace("{questionId}",_this.questionId);
            var choiceItemsDomStr = '<div class="sub_type_3 clearfix"><ul class="sub_type_1 fl" id="{questionId}"> </ul></div>'
                .replace("{questionId}", _this.questionId);
            var choiceItemsDom = $(choiceItemsDomStr);
//            choiceItemsDom.find(".sub_type_1 fl").append(choiceItemsHTMLArr.join(''));//不知道为什么找不到？？？
            choiceItemsDom.children().append(choiceItemsHTMLArr.join(''));
            dom.append(choiceItemsDom);
            var imgDom =  dom.find("img[class1=textChoiceWithImageButton]");

            if(questionObj && questionObj.answer > -1){
                //设置正确答案样式
                dom.find("a[class1=radioform]").eq(questionObj.answer).removeClass().addClass('check_btn checked');
                this.correctAnswer = questionObj.answer;

                //渲染图片
                imgDom.attr('src',questionObj.imgPath);
                // 创建对象
                var img = new Image();

                var dirstr = questionObj.imgPath;
                // 改变图片的src
                img.src = dirstr;
                // 加载完成执行
                img.onload = function () {
//                        alert('width:'+img.width+',height:'+img.height);
                    var w, h, magin_top, magin_left;
                    if (img.height <= 264 && img.width <= 264) {
                        magin_top = (264 - img.height) / 2;
                        magin_left = (264 - img.width) / 2;
                    } else if (img.height > 264 && img.width <= 264) {
                        h = 264;
                        w = (img.width / img.height) * h;
                        magin_top = 0;
                        magin_left = (264 - w) / 2;
                    } else if (img.height <= 264 && img.width > 264) {
                        w = 264;
                        h = (img.height / img.width) * w;
                        magin_top = (264 - h) / 2;
                        magin_left = 0;
                    } else {
                        if (img.width / img.height >= 1) {
                            w = 264;
                            h = (img.height / img.width) * w;
                            magin_top = (264 - h) / 2;
                            magin_left = 0;
                        } else {
                            h = 264;
                            w = (img.width / img.height) * h;
                            magin_top = 0;
                            magin_left = (264 - w) / 2;
                        }
                    }
                   imgDom.css({
                        maxWidth: 264 + 'px',
                        maxHeight: 264 + 'px',
                        marginTop: magin_top + 'px',
                        marginLeft: magin_left + 'px'
                    });
                };
                //不带路径的纯文件名
                var fileName = path.filename(path.toPosix(dirstr));
                this.imagePath = fileName;
                this.srcImgPath = '';
//                this.srcImgPath = questionObj.imgPath;
//                var imgMd5 = md5helper.hex_md5(questionObj.imgPath);
//                var imgExt = path.extname(questionObj.imgPath);
//                this.imagePath = imgMd5 + imgExt;

                var questionDom = dom.find('#'+this.questionId);
                this.changeChoiceItemStyle(questionDom,questionObj.choiceItems.length);

            }

//            dom.append(choiceItemsHTMLArr.join(''));
            var questionTxtDom = dom.find('input[class1=questionText]');
            questionTxtDom.focusout(function () {
                if ($(this).val().trim() === '') {
                    $(this).val(input_txt_title);
                }
                _this.questionText = $(this).val();
            }).focusin(function () {
                    if ($(this).val().trim() === input_txt_title) {
                        $(this).val("");
                    }
                });

            //题目描述信息过长的处理
            questionTxtDom.bind('input propertychange',function(){
                var _self = this;
                if($(_self).val().length>45){
                    $.Zebra_Dialog(AppCardTemplateTipsList.ThemeTooLong, {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons':  [AppTips.OkTips],
                        'onClose': function(){
                            //题目过长，截断处理
                            $(_self).val($(_self).val().substr(0,45));
                            _this.questionText = $(_self).val();
                        }
                    });
                }
            });

            var choiceTxtDoms = dom.find('input[class1=choicetext]');
            choiceTxtDoms.focusout(function () {
                if ($(this).val().trim() === '') {
                    $(this).val(input_txt);
                }
                var i = $(this).parent().attr("index");
                // TODO: 同步数据
                _this.getChoiceItems()[i].text = $(this).val();

            }).focusin(function () {
                    if ($(this).val().trim() === input_txt) {
                        $(this).val("");
                    }
                });

            //答案选项不允许输入过长
            choiceTxtDoms.bind('input propertychange',function(){
                var _self = this;
                var i = $(this).parent().attr("index");
                if($(_self).val().length>45){
                    $.Zebra_Dialog(AppCardTemplateTipsList.AnswerTooLong, {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons':  [AppTips.OkTips],
                        'onClose': function(){
                            //答案过长，截断处理
                            $(_self).val($(_self).val().substr(0,45));
                            _this.getChoiceItems()[i].text = $(_self).val();
                        }
                    });
                }
            });

            dom.find("a[class1=radioform]").click(function () {
                var len = $(this).parent().parent().children().length;//选项数
                for (var i = 0; i < len; i++) {
                    var obj = $($($(this).parent().parent().children()[i]).children()[0]).attr("class", "check_btn");
                }

                $(this).attr("class", "check_btn checked");

                var index = $(this).attr("id")[0];
                _this.correctAnswer = index;

            });

            imgDom.dblclick(function () {

                _selectedTextChoiceImage($(this));
            });

            this._dom = dom;
            return this._dom;
        }

        this.travel2Json = function (currentIndex, dir) {
            var questionItem = {};
            var choiceItem = {};
            questionItem.type = this.type;//题目类型
            questionItem.imgPath = this.imagePath;
            if (!this.imagePath) {
                $.Zebra_Dialog("请为第" + (currentIndex + 1) + "题添加图片", {
                    'type': 'information',
                    'title': AppTips.WarmTips,
                    'buttons': [AppTips.OkTips]
                });
                return null;
            }
            //拷贝图片
            var imgMd5,imgExt;
            if(this.srcImgPath){
                imgMd5 = md5helper.hex_md5(this.srcImgPath);
                imgExt = path.extname(this.srcImgPath);
                shellcmd.copyFile(this.srcImgPath, path.join(dir, imgMd5 + imgExt));
            }

            questionItem.theme = this.questionText;//题面信息,初始化值是单击此处添加测试题目
            if (questionItem.theme == AppCardTemplateTipsList.clickHereAddTheme) {
                $.Zebra_Dialog("请为第" + (currentIndex + 1) + "题添加题干信息", {
                    'type': 'information',
                    'title': AppTips.WarmTips,
                    'buttons': [AppTips.OkTips]
                });
                return null;
            }

            questionItem.answer = this.correctAnswer;//正确答案
            //解决bug，比如现在有4个选项，正确答案原来设置为第4个选项，当减少选项数为3时，这时点击完成，实际上正确答案没有设置，
            var choiceNumber = this.choiceItems.length;
            if ((questionItem.answer == -1) || (questionItem.answer >= choiceNumber)) {
                $.Zebra_Dialog("请为第" + (currentIndex + 1) + "题设置正确答案", {
                    'type': 'information',
                    'title': AppTips.WarmTips,
                    'buttons': [AppTips.OkTips]
                });
                return null;
            }
            questionItem.choiceNum = this.choiceItems.length;//选项个数
            questionItem.choiceItems = [];
            for (var j = 0; j < this.choiceItems.length; j++) {
                choiceItem = {};

                choiceItem.label = this.choiceItems[j].label;
                choiceItem.text = this.choiceItems[j].text;
                if ((!choiceItem.text) || (choiceItem.text == AppCardTemplateTipsList.clickHereAddAnswer)) {
                    $.Zebra_Dialog("请为第" + (currentIndex + 1) + "题的第" + (j + 1) + "选项添加答案信息", {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons': [AppTips.OkTips]
                    });
                    return null;
                }

                choiceItem.imgPath = "";

                questionItem.choiceItems.push(choiceItem);
            }
            return questionItem;
        }

        init(questionObj);
    }

    TextChoiceWithImageQuestion.prototype = new QuestionItemBase();
    TextChoiceWithImageQuestion.prototype.constructor = TextChoiceWithImageQuestion;
    exports.TextChoiceWithImageQuestion = TextChoiceWithImageQuestion;
})