/**
 * Created by pengfu on 14-7-14.
 */
;
define(function (require, exports) {
    var _helper = require("./choicecardtmphelper").Instance;
    var md5helper = require('../../../../common/md5helper');
    var _labelList = ['A', 'B', 'C', 'D', 'E', 'F'];
    var QuestionItemBase = require("./choicecardbase").QuestionItemBase;
    var path = require('../../../../common/path');
    var shellcmd = require('../../../../common/shellcmd');
    var define = require('../../../define');
    require('jquery');
    /**
     *
     * @constructor
     */
    function ImageChoiceQuestion(questionObj) {
        var _this = this;
        this.type = _helper.QuestionType.ImageChoice;
        this.choiceItems = [];
        this.correctAnswer = -1;
        var choiceItemsDom;
        var labelList = ['A', 'B', 'C', 'D', 'E', 'F'];

        var domstr = '<div >' +
            '<div class="shit_input"><label></label><input class="choice_theme" class1="questionText"  type="text" value="{text}"/></div></div>';

        var choiceItemTpl = '<li index="{index}" class1="li_image" style="border: 1px solid #E8E8E8">' +
            '<img title=""  class1="add_image"  src="assert/images/add_img.jpg" style="border: 0px"></>' +
            '<a class1="radio_form" class="check_btn" style="border:0px;"></a></li>';

        var input_txt_title = AppCardTemplateTipsList.clickHereAddTheme;

        function init(questionObj) {
            if(!questionObj){
                _this.questionText = input_txt_title;
                _this.questionId = "ICQ_" + new Date().getTime();
                // 初始化choiceItems
                for (var i = 0; i < 4; i++) {
                    var item = new _helper.ChoiceItem();
                    item.label = labelList[i];
                    _this.choiceItems.push(item);
                }
            }else{
                _this.questionText = questionObj.theme;
                _this.questionId = "ICQ_" + new Date().getTime();
                // 初始化choiceItems
                for (var i = 0; i < questionObj.choiceItems.length; i++) {
                    var item = new _helper.ChoiceItem();
                    item.label = labelList[i];
                    item.imgPath = path.filename(path.toPosix(questionObj.choiceItems[i].imgPath));

//                    var imgMd5 = md5helper.hex_md5(questionObj.choiceItems[i].imgPath);
//                    var imgExt = path.extname(questionObj.choiceItems[i].imgPath);
//                    item.imgPath = imgMd5 + imgExt;//为保持代码通用性，对imgPath重新命名。
//                    item.srcImg = questionObj.choiceItems[i].imgPath;//保存路径等回头拷贝
                    item.srcImg = '';
                    _this.choiceItems.push(item);
                }
            }

        }

        /**
         *
         * @returns {Array.<ChoiceItem>}
         */
        this.getChoiceItems = function () {
            return this.choiceItems;
        }

        this._computeMarginValue = function(img,width,height){
            var w, h, margin_top, margin_left;
            var marginObj = {};
            if (img.height <= height && img.width <= width) {
                margin_top = (height - img.height) / 2;
                margin_left = (width - img.width) / 2;
            } else if (img.height > height && img.width <= width) {
                h = height;
                w = (img.width / img.height) * h;
                margin_top = 0;
                margin_left = (width - w) / 2;
            } else if (img.height <= height && img.width > width) {
                w = width;
                h = (img.height / img.width) * w;
                margin_top = (height - h) / 2;
                margin_left = 0;
            } else {
                if (img.width / img.height >= width / height) {
                    w = width;
                    h = (img.height / img.width) * w;
                    margin_top = (height - h) / 2;
                    margin_left = 0;
                } else {
                    h = height;
                    w = (img.width / img.height) * h;
                    margin_top = 0;
                    margin_left = (width - w) / 2;
                }
            }
            marginObj.margintop = margin_top;
            marginObj.marginleft = margin_left;
            return marginObj;

        }

        this.buildHTML = function (questionObj) {
            var _this = this;
            var themeContent ;
            if(!questionObj){
                themeContent = input_txt_title;
            }else{
                themeContent = questionObj.theme;
            }
            var dom = $(domstr.replace("{text}", themeContent));

            var choiceItemArr = this.getChoiceItems();
            var choiceItemsHTMLArr = [];
            for (var i = 0, len = choiceItemArr.length; i < len; i++) {
                var choiceItem = choiceItemArr[i];
                var choiceId = "" + i + new Date().getTime();
                var html = choiceItemTpl.replace("{index}", i);
                choiceItemsHTMLArr.push(html);
            }

            var choiceItemsDomStr = ' <div id="realChoiceBody" class="sub_type_2"><ul class="sub_type_2_list" id="{questionId}"> </ul></div>'
                .replace("{questionId}", _this.questionId);
            choiceItemsDom = $(choiceItemsDomStr);
            choiceItemsDom.find(".sub_type_2_list").append(choiceItemsHTMLArr.join(''));
            dom.append(choiceItemsDom);

            this._dom = dom;

            if(questionObj && questionObj.answer > -1){
                //设置正确答案样式
                dom.find("a[class1=radio_form]").eq(questionObj.answer).removeClass().addClass('check_btn checked');
                this.correctAnswer = questionObj.answer;
            }

            var imgDoms = dom.find('img[class1=add_image]');

            var loadImg = function(k){
                if(!questionObj) return;
                if(k >= questionObj.choiceItems.length){
                    return;
                }
                imgDoms.eq(k).attr('src',questionObj.choiceItems[k].imgPath);
                var marginobj = {};
                var imgDom = imgDoms.eq(k);
                // 创建对象
                var img = new Image();
                // 改变图片的src
                img.src = questionObj.choiceItems[k].imgPath;
                // 加载完成执行
                img.onload = function(){
                    console.log('img onloaded')
                    if(questionObj.choiceItems.length <= 4){
                        marginobj = _this._computeMarginValue(img,180,135);
                        $(imgDom).css({
                            maxWidth: 180,
                            maxHeight: 135,
                            marginTop: marginobj.margintop,
                            marginLeft: marginobj.marginleft
                        });
                    }else{
                        marginobj = _this._computeMarginValue(img,172,135);
                        $(imgDom).css({
                            maxWidth: 172,
                            maxHeight: 135,
                            marginTop: marginobj.margintop,
                            marginLeft: marginobj.marginleft
                        });
                    }

                    setTimeout(loadImg(++k),50);

                }

            }

            questionObj && loadImg(0);

            if(questionObj){
                if(questionObj.choiceItems.length > 4){
                    this.change2More4Style();
                }
            }

            var questionTxtDom = dom.find('input[class1=questionText]');

            //给选择题theme同步数据
            questionTxtDom.focusout(function () {
                if ($(this).val().trim() === '') {
                    $(this).val(input_txt_title);
                }
                _this.questionText = $(this).val();
            }).focusin(function () {
                    if ($(this).val().trim() === input_txt_title) {
                        $(this).val("");
                    }
                });

            //题目描述不允许过长
            questionTxtDom.bind('input propertychange',function(){
                var _self = this;
                if($(this).val().length>45){
                    $.Zebra_Dialog(AppCardTemplateTipsList.ThemeTooLong, {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons':  [AppTips.OkTips],
                        'onClose': function(){
                            //题目过长，截断处理
                            $(_self).val($(_self).val().substr(0,45));
                            _this.questionText = $(_self).val();
                        }
                    });
                }
            });

            //给每个选项的图片同步数据
            //单击改双击
            imgDoms.dblclick(function () {
                var _selfImg = this;
                var i = $(this).parent().attr("index");
                var filterStr = "图片文件 (*.bmp;*.jpg;*.jpeg;*.gif;*.png;*.tif)|" +
                    "*.bmp;*.jpg;*.jpeg;*.gif;*.png;*.tif|Bitmaps (*.bmp)|*.bmp|" +
                    "GIFs (*.gif)|*.gif|JPEGs (*.jpg)|*.jpg;*.jpeg|PNGs (*.png)|*.png|TIFs (*.tif)|*.tif|All Files (*.*)|*.*";

                // 新的Opendialog方法
                var options = {"multi": false, "ext": ['.jpg', '.jpeg', '.gif', '.png', '.bmp']};
                shellcmd.openFileDialog(options).done(function (result) {
                    if (result.length > 0) {
                        console.log('opendialog result', result);

                        var imgMd5 = md5helper.hex_md5(result[0]);
                        var imgExt = path.extname(result[0]);
                        _this.getChoiceItems()[i].imgPath = imgMd5 + imgExt;//同步图片路径
                        _this.getChoiceItems()[i].srcImg = result[0];//保存本地路径等回头拷贝

                        var pictureItem = {};
                        pictureItem.url = result[0];

                        var fileName = path.filename(path.toPosix(result[0]));//不带路径的文件名
                        var str = result[0].substr(0, result[0].length - fileName.length) + encodeURIComponent(fileName);
                        //TODO:怎么样使得变小
                        $(_selfImg).attr("src", str);
                        // 创建对象
                        var img = new Image();
                        // 改变图片的src
                        img.src = str;
                        // 加载完成执行
                        img.onload = function () {
                            var marginobj = {};
                            marginobj = _this._computeMarginValue(img,180,135);

                            $(_selfImg).css({
                                maxWidth: 180,
                                maxHeight: 135,
                                marginTop: marginobj.margintop,
                                marginLeft: marginobj.marginleft
                            });
                        }
                    }
                });
            });

            // TODO: add event
            //给单选按钮同步数据
            dom.find("a[class1=radio_form]").click(function () {
                //TODO:改变checked状态
                var len = $(this).parent().parent().children().length;
                console.log(len);
                for (var i = 0; i < len; i++) {
                    $($($(this).parent().parent().children()[i]).children()[1]).attr("class", "check_btn");
                }
                $(this).attr("class", "check_btn checked");
                var index = $(this).parent().attr("index");
                _this.correctAnswer = index;
            });

//            this._dom = dom;
            return this._dom;
        };

        this.changeChoiceItem = function (queId, optionCount) {
            var i;
            var curCount = this.choiceItems.length;
            if (optionCount === curCount) {
                return;
            }
            else if (optionCount < curCount) {
                //解决bug：减少选项数时，判断正确答案的选项是否删除，若删除，则重置答案项为没有设置
                if(this.correctAnswer >= optionCount){
                    this.correctAnswer = -1;
                }
                //调整DomItem数量
                while (this.choiceItems.length > optionCount) {
                    $(choiceItemsDom.find(".sub_type_2_list").children()[this.choiceItems.length - 1]).remove();
                    this.choiceItems.pop();
                }

                if (optionCount <= 4) {
                    //TODO : $.each(arr,function(){})
//                    var eachLiObj = choiceItemsDom.find(".sub_type_2_list").children();
//                    var len = eachLiObj.length;
//                    for(var i=0;i<len;i++){
//                        $(eachLiObj[i]).css(_cssMore4);
//                    }
//                   $(choiceItemsDom.find(".sub_type_2_list").children()).css(_cssMore4);
                    this.change2Less4Style();
                }

            }
            else if (optionCount > curCount) {
                //调整DomItem数量
                var _num = optionCount - curCount;
                for (i = curCount; i < optionCount; i++) {
                    var _domChoice = choiceItemTpl.replace("{index}", i + '');
                    choiceItemsDom.find(".sub_type_2_list").append(_domChoice);
                    var item = new _helper.ChoiceItem();
                    this.choiceItems.push(item);
                }

                if (optionCount > 4) {
//                    $.each(choiceItemsDom.find(".sub_type_2_list").children(),function(){
//                        $(this).css(_cssMore4);
//                    })

                    this.change2More4Style();
                }

                //TODO:为增加的选项设置监听事件
                choiceItemsDom.find('img[class1=add_image]').unbind("dblclick").dblclick(function () {
                    var _selfImg1 = this;

                    var i = $(this).parent().attr("index");

                    var filterStr = "图片文件 (*.bmp;*.jpg;*.jpeg;*.gif;*.png;*.tif)|" +
                        "*.bmp;*.jpg;*.jpeg;*.gif;*.png;*.tif|Bitmaps (*.bmp)|*.bmp|" +
                        "GIFs (*.gif)|*.gif|JPEGs (*.jpg)|*.jpg;*.jpeg|PNGs (*.png)|*.png|TIFs (*.tif)|*.tif|All Files (*.*)|*.*";

                    // 新的Opendialog方法
                    var options = {"multi": false, "ext": ['.jpg', '.jpeg', '.gif', '.png', '.bmp']};
                    shellcmd.openFileDialog(options).done(function (result) {
                        if (result.length > 0) {

                            console.log('opendialog result', result);
                            $(_selfImg1).removeClass();

                            var imgMd5 = md5helper.hex_md5(result[0]);
                            var imgExt = path.extname(result[0]);
                            _this.getChoiceItems()[i].imgPath = imgMd5 + imgExt;//同步图片路径
                            _this.getChoiceItems()[i].srcImg = result[0];//保存本地路径等回头拷贝

                            var pictureItem = {};
                            pictureItem.url = result[0];

                            var fileName = path.filename(path.toPosix(result[0]));//不带路径的文件名
                            var str = result[0].substr(0, result[0].length - fileName.length) + encodeURIComponent(fileName);
                            //TODO:怎么样使得变小
                            $(_selfImg1).attr("src", str);
//                            alert("image width:"+$(_selfImg1).width());
//                            alert("image height:"+$(_selfImg1).height());
                            if (_this.choiceItems.length <= 4) {//注意：此处写成optionCount则写成了闭包
                                // 创建对象
                                var img = new Image();
                                // 改变图片的src

                                // 加载完成执行
                                img.onload = function () {
                                    var marginobj = {};
                                    marginobj = _this._computeMarginValue(img,180,135);
                                    $(_selfImg1).css({
                                        maxWidth: 180 + 'px',
                                        maxHeight: 135 + 'px',
                                        marginTop: marginobj.margintop + 'px',
                                        marginLeft: marginobj.marginleft + 'px'
                                    });
                                }
                                img.src = str;
                            } else {
                                // 创建对象
                                var img = new Image();
                                // 改变图片的src

                                // 加载完成执行
                                img.onload = function () {
                                    var marginobj = {};
                                    marginobj = _this._computeMarginValue(img,172,135);
                                    $(_selfImg1).css({
                                        maxWidth: 172 + 'px',
                                        maxHeight: 135 + 'px',
                                        marginTop: marginobj.margintop + 'px',
                                        marginLeft: marginobj.marginleft + 'px'
                                    });
                                }
                                img.src = str;
                            }
                        }
                        // TODO: 同步数据

                    });
                });

                choiceItemsDom.find('a[class1=radio_form]').unbind("click").click(function () {
                    var len = $(this).parent().parent().children().length;
                    console.log(len);
                    for (var i = 0; i < len; i++) {
                        $($($(this).parent().parent().children()[i]).children()[1]).attr("class", "check_btn");
                    }
                    $(this).attr("class", "check_btn checked");
                    var index = $(this).parent().attr("index");
                    _this.correctAnswer = index;
                });
            }
        }

        this.change2Less4Style = function () {
            var bodyobj = $("#realChoiceBody");
            var imgobjs = $("#" + this.questionId).find('img[class1=add_image]');
            var liobjs = $("#" + this.questionId).find('li[class1=li_image]');
            var imglen = imgobjs.length;
            var lilen = liobjs.length;
            //414为UI给的固定宽度
            bodyobj.css("width", 430);

            var tmplicss_less4 = {
                position: "relative",
                float: "left",
                display: "inline",
                width: 180 + 'px',
                height: 135 + 'px',
                marginBottom: 10 + 'px',
                marginRight: 50 + 'px',
                marginLeft: 0 + 'px'

            };

            //改变li的style，主要是各margin值
            for (var j = 0; j < lilen; j++) {
                $(liobjs[j]).css(tmplicss_less4);
            }
            //把图片恢复成原来每排放3张的样子
            for (var i = 0; i < imglen; i++) {
                if (path.filename(path.toPosix($(imgobjs[i]).attr("src"))) == "add_img.jpg") {//是原来的背景图片
                    $(imgobjs[i]).attr("class", "img_less");
                } else {
//                    $(imgobjs[i]).removeClass("img_less");
                    $(imgobjs[i]).removeClass("");
                    // 创建对象
                    var img = new Image();
                    // 改变图片的src
                    img.src = $(imgobjs[i]).attr("src");
                    // 加载完成执行
                    var marginobj = {};
                    marginobj = this._computeMarginValue(img,180,135);
                    $(imgobjs[i]).css({
                        maxWidth: 180 + 'px',
                        maxHeight: 135 + 'px',
                        marginTop: marginobj.margintop + 'px',
                        marginLeft: marginobj.marginleft + 'px'
                    });

                }
                //TODO:改变已有图片的样式
            }
        }

        this.change2More4Style = function () {
//            var bodyobj = $("#realChoiceBody");
            var bodyobj =this._dom.find("#realChoiceBody");
            var bodycss = {width: 550 + 'px'};
//            var imgobjs = $("#" + this.questionId).find('img[class1=add_image]');
//            var liobjs = $("#" + this.questionId).find('li[class1=li_image]');
            var imgobjs = this._dom.find("#" + this.questionId).find('img[class1=add_image]');
            var liobjs = this._dom.find("#" + this.questionId).find('li[class1=li_image]');
            var imglen = imgobjs.length;
            var lilen = liobjs.length;
            var tmplicssMore4 = {
                position: "relative",
                float: "left",
                display: "inline",
                width: 172 + 'px',
                height: 135 + 'px',
                marginBottom: 10 + 'px',
                marginRight: 4 + 'px',
                marginLeft: 4 + "px"
            }
            bodyobj.css(bodycss);//增加宽度足以让一排放下3张图片
            //改变li的style，主要是各margin值
            for (var j = 0; j < lilen; j++) {
                $(liobjs[j]).css(tmplicssMore4);
            }
            //把图片放小点，以便能够放得下
            for (var i = 0; i < imglen; i++) {
//                $(imgobjs[i]).attr("class", "img_more");

                if (path.filename(path.toPosix($(imgobjs[i]).attr("src"))) == "add_img.jpg") {//是原来的背景图片
                    $(imgobjs[i]).attr("class", "img_more");
                } else {
//                    $(imgobjs[i]).removeClass("img_more");
                    $(imgobjs[i]).removeClass("");
                    var srcstr = $(imgobjs[i]).attr("src");
//                    var fileName = path.filename(path.toPosix( srcstr));//不带路径的文件名
//                    var str = srcstr.substr(0, srcstr.length - fileName.length) + encodeURIComponent(fileName);

                    // 创建对象
                    var img = new Image();
                    // 改变图片的src
                    img.src = srcstr; //这个地方奇怪，onload事件并不会执行
                    // 加载完成执行
                    var marginobj = {};
                    marginobj = this._computeMarginValue(img,172,135);
                    $(imgobjs[i]).css({
                        maxWidth: 172 + 'px',
                        maxHeight: 135 + 'px',
                        marginTop: marginobj.margintop + 'px',
                        marginLeft: marginobj.marginleft + 'px'
                    });

                }

            }
        }

        this.travel2Json = function (currentIndex, dir) {
            var questionItem = {};
            var choiceItem = {};
            questionItem.type = this.type;//题目类型
            questionItem.imgPath = "";
            questionItem.theme = this.questionText;//题面信息,初始化值是单击此处添加测试题目
            if (questionItem.theme == AppCardTemplateTipsList.clickHereAddTheme) {
                $.Zebra_Dialog("请为第" + (currentIndex + 1) + "题添加题干信息", {
                    'type': 'information',
                    'title': AppTips.WarmTips,
                    'buttons': [AppTips.OkTips]
                });
                return null;
            }

            questionItem.answer = this.correctAnswer;//正确答案
            //解决bug，比如现在有4个选项，正确答案原来设置为第4个选项，当减少选项数为3时，这时点击完成，实际上正确答案没有设置，
            var choiceNumber = this.choiceItems.length;

            if ((questionItem.answer == -1) || (questionItem.answer >= choiceNumber) ) {
                $.Zebra_Dialog("请为第" + (currentIndex + 1) + "题设置正确答案", {
                    'type': 'information',
                    'title': AppTips.WarmTips,
                    'buttons': [AppTips.OkTips]
                });
                return null;
            }
            questionItem.choiceNum = this.choiceItems.length;//选项个数
            questionItem.choiceItems = [];
            for (var j = 0; j < this.choiceItems.length; j++) {
                choiceItem = {};
                choiceItem.label = "";
                choiceItem.text = "";

                //TODO:加上路径,并且要完成拷贝工作
                choiceItem.imgPath = this.choiceItems[j].imgPath;
                if (!choiceItem.imgPath) {
                    $.Zebra_Dialog("请为第" + (currentIndex + 1) + "题第" + (j + 1) + "选项添加图片", {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons': [AppTips.OkTips]
                    });
                    return null;
                }
                var imgMd5 = md5helper.hex_md5(this.choiceItems[j].srcImg);
                var imgExt = path.extname(this.choiceItems[j].srcImg);
                shellcmd.copyFile(this.choiceItems[j].srcImg, path.join(dir, imgMd5 + imgExt));

                questionItem.choiceItems.push(choiceItem);
            }
            return questionItem;
        }
//        var dbclickhelper = function(targetCount){
//
//        }

        init(questionObj);
    }

    ImageChoiceQuestion.prototype = new QuestionItemBase();
    ImageChoiceQuestion.prototype.constructor = ImageChoiceQuestion;
    exports.ImageChoiceQuestion = ImageChoiceQuestion;
})