/**
 * 卡片模板功能管理类，卡片模板功能入口
 * Created with JetBrains WebStorm.
 * User: qmjie
 * Date: 13-8-28
 * Time: 下午2:29
 * To change this template use File | Settings | File Templates.
 */
define(function (require, exports, module) {

    function CardTemplateManager(){
        var _self = this;

        /**
         * 卡片模板界面按钮列表
         * @type {{templateBtn: (*|jQuery|HTMLElement), evaluationTmpBtn: (*|jQuery|HTMLElement), galleryTemplateBtn: (*|jQuery|HTMLElement), closeBtnTemplatePanel: (*|jQuery|HTMLElement), evaluationTmpCHN: (*|jQuery|HTMLElement), evaluationTmpEN: (*|jQuery|HTMLElement), galleryTmpEditBtn: (*|jQuery|HTMLElement)}}
         */
        _self.buttons = {
            templateBtn: $("#templateBtn"),
            evaluationTmpBtn: $("#evaluationTmpBtn"),
            galleryTemplateBtn: $("#galleryTemplateBtn"),
            choiceTemplateBtn:$("#choiceTemplateBtn"),
            closeBtnTemplatePanel: $("#closeBtn_templatePanel"),
            evaluationTmpCHN: $("#evaluationTmpCHN"),
            evaluationTmpEN: $("#evaluationTmpEN"),
            galleryTmpEditBtn: $("#galleryTmpEditBtn")

        };

        /**
         * 卡片模板界面控件列表
         * @type {{templateIfrm: (*|jQuery|HTMLElement), templatePanel: (*|jQuery|HTMLElement), templatePanelTop: (*|jQuery|HTMLElement), templatePanelMask: (*|jQuery|HTMLElement), galleryTemplate: (*|jQuery|HTMLElement), evaluationTmp: (*|jQuery|HTMLElement)}}
         */
        _self.controls = {
            templatePanel: $("#templatePanel"),
            templatePanelTop: $("#templatePanelTop"),
            templatePanelMask: $("#templatePanelMask"),
            galleryTemplate: $("#galleryTemplate"),
            evaluationTmp: $("#evaluationTmp"),
            choiceTemplate:$("#choiceTemplate"),
            evaluationPanel : $("#evaluationTmpPanel"),
            galleryPanel : $("#galleryTmpPanel")
        };

        //smartbar 新建上的 选择题卡片
        _self.sbButtons ={
            smartbar_btnChoice:$("#smartbar_btnChoice"),
            sb_closeBtnTemplatePanel: $("#sb_closeBtn_templatePanel")
        };

        _self.sbControls = {
            sb_templatePanel: $("#sb_templatePanel"),
            sb_templatePanelTop: $("#sb_templatePanelTop"),
            sb_templatePanelMask: $("#sb_templatePanelMask"),
            sb_choiceTemplate:$("#sb_choiceTemplate")
        };


        /**
         * 初始化卡片模板管理功能
         * @param bookContainer 书本容器对象
         */
        _self.init = function (bookContainer) {
//            if(AppCfg.lang == "uyghur"){
//                $("#evaluationDescription").css("height","288px");
//                $("#cardEdit").css("width","300px");
//                $("#evaluationTips").css("direction","rtl").css("text-align","right").css("font-size","14px");
//                $("#galleryTitle").css("width","400px");
//            }

            _self.buttons.templateBtn.click(function () {
                if(!(_self.controls.templatePanel.is(":visible")||_self.controls.evaluationPanel.is(":visible")||_self.controls.galleryPanel.is(":visible"))){
                    _self.showTemplatePanel();
                }
            });
            _self.buttons.evaluationTmpBtn.click(function (){
                _self.evaluationTmpClick();
            });
            _self.buttons.galleryTemplateBtn.click(function (){
                _self.galleryTemplateClick();
            });

            _self.buttons.choiceTemplateBtn.click(function(){
                console.log("has clicked choiceTemplateBtn");
                _self.choiceTemplateClick();
            });
            _self.buttons.closeBtnTemplatePanel.click(function () {
                _self.hideTemplatePanel();
            });

            //smartbar 新建 试题模板
            _self.sbButtons.smartbar_btnChoice.click(function(){
                _self.showSBTemplatePanel();
            });

            _self.sbButtons.sb_closeBtnTemplatePanel.click(function(){
                _self.hideSBTemplatePanel();
            });

            //中英文评测卡片模板
            var _evaluationCardTemplate = require('./evaluationcardtemplate');
            var evaluationCardTemplate = new _evaluationCardTemplate.EvaluationCardTemplate();
            evaluationCardTemplate.init(bookContainer);
            //画廊卡片模板
//            var _galleryCardTemplate = require('./gallerycardtemplate');
//            var galleryCardTemplate = new _galleryCardTemplate.GalleryCardTemplate();
//            galleryCardTemplate.init(bookContainer);
            var galleryCardTemplate = require('./gallerycardtemplate').Instance;
            galleryCardTemplate.init(bookContainer);

            //随堂测试选择题卡片模板
//            var _choiceCardTemplate = require('./choicecardtpl/choicecardtemplate');
//            var choiceCardTemplate = new _choiceCardTemplate.ChoiceCardTemplate();
//            choiceCardTemplate.init(bookContainer);
            //--改成单例模式--pengfu
            var choiceCardTemplate = require('./choicecardtpl/choicecardtemplate').Instance;
            choiceCardTemplate.init(bookContainer);
        };

        /**
         * 切换为中英文评测卡片模板界面
         */
        _self.evaluationTmpClick = function (){
            _self.buttons.evaluationTmpBtn.removeClass();
            _self.buttons.galleryTemplateBtn.removeClass();
            _self.buttons.choiceTemplateBtn.removeClass();
            _self.buttons.evaluationTmpBtn.addClass("current");
            _self.buttons.galleryTemplateBtn.addClass("normal");
            _self.buttons.choiceTemplateBtn.addClass("normal");
            _self.controls.choiceTemplate.hide();
            _self.controls.galleryTemplate.hide();
            _self.controls.evaluationTmp.show();
        };

        /**
         * 切换为画廊卡片模板界面
         */
        _self.galleryTemplateClick = function (){
            _self.buttons.evaluationTmpBtn.removeClass();
            _self.buttons.galleryTemplateBtn.removeClass();
            _self.buttons.choiceTemplateBtn.removeClass();
            _self.buttons.evaluationTmpBtn.addClass("normal");
            _self.buttons.choiceTemplateBtn.addClass("normal");
            _self.buttons.galleryTemplateBtn.addClass("current");
            _self.controls.choiceTemplate.hide();
            _self.controls.galleryTemplate.show();
            _self.controls.evaluationTmp.hide();
        };

        /**
         * 切换为随堂测试卡片模板界面
         */
        _self.choiceTemplateClick = function(){
            _self.buttons.evaluationTmpBtn.removeClass();
            _self.buttons.galleryTemplateBtn.removeClass();
            _self.buttons.choiceTemplateBtn.removeClass();
            _self.buttons.choiceTemplateBtn.addClass("current");
            _self.buttons.evaluationTmpBtn.addClass("normal");
            _self.buttons.galleryTemplateBtn.addClass("normal");
            _self.controls.galleryTemplate.hide();
            _self.controls.evaluationTmp.hide();
            _self.controls.choiceTemplate.show();
        };

        /**
         *隐藏卡片模板面板
         */
        _self.hideTemplatePanel = function () {
            _self.controls.templatePanel.hide();
        };

        /**
         * 显示卡片模板面板
         */
        _self.showTemplatePanel = function () {
            //居中显示
            _self.controls.templatePanel.css({
                position:'absolute',
                left: ($(window).width() - _self.controls.templatePanel.outerWidth())/2,
                top: ($(window).height() - _self.controls.templatePanel.outerHeight())/2 + $(document).scrollTop()
            });
            //correctToBaseResolution(_self.controls.templatePanel);

            _self.controls.templatePanel.show();
            _self.controls.templatePanelMask.hide();
            _self.controls.templatePanel.draggable({
                handle: "#" + _self.controls.templatePanelTop.attr("id"),
                containment: "parent",
                start: function () {
                    _self.controls.templatePanelMask.show();
                },
                stop: function () {
                    _self.controls.templatePanelMask.hide();
                }
            });
        };

        /**
         *隐藏smartbar卡片模板面板
         */
        _self.hideSBTemplatePanel = function () {
            _self.sbControls.sb_templatePanel.hide();
        };

        /**
         * 显示smartbar卡片模板面板
         */
        _self.showSBTemplatePanel = function () {
            //居中显示
            _self.sbControls.sb_templatePanel.css({
                position:'absolute',
                left: ($(window).width() - _self.sbControls.sb_templatePanel.outerWidth())/2,
                top: ($(window).height() - _self.sbControls.sb_templatePanel.outerHeight())/2 + $(document).scrollTop()
            });

            _self.sbControls.sb_templatePanel.show();
            _self.sbControls.sb_templatePanelMask.hide();
            _self.sbControls.sb_templatePanel.draggable({
                handle: "#" + _self.sbControls.sb_templatePanelTop.attr("id"),
                containment: "parent",
                start: function () {
                    _self.sbControls.sb_templatePanelMask.show();
                },
                stop: function () {
                    _self.sbControls.sb_templatePanelMask.hide();
                }
            });
        };

        _self.setIsEditing=function(value){
            !value&&_self.hideTemplatePanel();
        }


    }

    exports.CardTemplateManager =  CardTemplateManager;
});
