﻿/**
 * 卡片包装类，提供卡片的展示界面外壳
 * Date: 2013/06/16
 * Author: luxing@iflytek.com
 * @version 1.0
 * @module common/cardwrapper
 */

define(function (require, exports, module) {

    var trace = require('../trace').Instance;
    var actionType = require('../trace').ActionType;
    var shellcmd = require('../../common/shellcmd');
    var EventUtil = require('../../common/eventUtil');

    function CardWrapper() {
        this.isMax = false;
        this.mainArea = null;
        this.btnLeft = null;
        this.btnRight = null;
        this.innerObj = null;
        this.curCardId = null;
        this.imgEle = null;

        //以下是图片工具放大缩小时使用的参数
        this.btnZoomIn = null;
        this.btnZoomOut = null;
        this.enableZoom = false;
        this.enableMove = false;
        this.hasMove = false;  //判断图片是否移动，防止坐标计算错误
        this.rate = 1;         //缩放比例，仅用于图片工具
        this.mousePoint = {    //鼠标位置
            x: 0,
            y: 0
        }
        this.offset = {       //translate偏移计算
            x: 0,
            y: 0,
            baseX: 0,
            baseY: 0
        }
        this.bound = {       //边界信息，用于判断是否可以移动
            //图片宽高
            height: 0,
            width: 0,
            //容器div宽高
            maxHeight: 0,
            maxWidth: 0,
            //图片中心点
            centerPointX: 0,
            centerPointY: 0
        }
    }

    CardWrapper.prototype = new EventUtil();
    CardWrapper.constructor = CardWrapper;

    /**
     * @description 初始化卡片展示区域的基本信息
     * @param {string}  wrapperId  卡片展示区域div的Id
     * @param {string}  btnLeftId     左侧按钮Id
     * @param {string}  btnRightId    右侧按钮Id
     * @param {string}  btnZoomOut    缩小按钮Id
     * @param {string}  btnZoomIn     放大按钮Id
     * @returns {}
     */
    CardWrapper.prototype.init = function (wrapperId, btnLeftId, btnRightId, btnZoomOut, btnZoomIn) {
        this.mainArea = $("#" + wrapperId);
        this.btnLeft = $("#" + btnLeftId);
        this.btnRight = $("#" + btnRightId);
        this.btnZoomInRight = $("#" + btnZoomIn + "_right");
        this.btnZoomOutRight = $("#" + btnZoomOut + "_right");
        this.btnZoomInLeft = $("#" + btnZoomIn + "_left");
        this.btnZoomOutLeft = $("#" + btnZoomOut + "_left");

        var btnZoomInEle = "#" + btnZoomIn + "_right," + "#" + btnZoomIn + "_left";
        var btnZoomOutEle = "#" + btnZoomOut + "_right," + "#" + btnZoomOut + "_left";

        this.btnZoomIn = $(btnZoomInEle);
        this.btnZoomOut = $(btnZoomOutEle);
    };

    /**
     * 打开卡片之前，需要预先处理的事情
     */
    CardWrapper.prototype.hideOtherControls = function () {
        //修复bug：在点开卡片时需要暂停播放的音频
        app_global_playerMgr && app_global_playerMgr.pause();
        //在打开卡片前，隐藏课本目录
        $("#directory_box_left").hide();
        $("#directory_box_right").hide();
        $("#localResId").hide();
        $("#localResNoneId").hide();
        //隐藏随写板
        $('#miniBoardControl').hide();
    }

    /**
     * @description 最大化卡片展示区域
     * @returns {}
     */
    CardWrapper.prototype.maximize = function () {
        var actualWidth = Math.min($(document).width(), Config["Width"]);
        var actualHeight = Math.min($(document).height(), Config["Height"]);
        this.mainArea.animate({
            left: "0px",
            top: "0px",
            width: actualWidth,
            height: actualHeight,
            opacity: '0.7'
        }, 500);

        var _self = this;
        $(this.innerObj).animate({
            width: actualWidth - 100,
            height: actualHeight,
            left: 50,
            opacity: '1',
            zIndex: 600
        }, 500, function () {
            _self.triggerHandler('maxmize');
        })
        this.btnLeft.animate({
            left: 0,
            top: actualHeight * 0.45,
            zIndex: 601
        }, 500)
        this.btnRight.animate({
            left: actualWidth - 48,
            top: actualHeight * 0.45,
            zIndex: 601
        }, 500)

        if (this.enableZoom) {
            this.btnZoomInRight.animate({
                left: actualWidth - 40,
                top: actualHeight * 0.6,
                zIndex: 601
            }, 500);

            this.btnZoomOutRight.animate({
                left: actualWidth - 40,
                top: actualHeight * 0.65,
                zIndex: 601
            }, 500);

            this.btnZoomInLeft.animate({
                left: 10,
                top: actualHeight * 0.6,
                zIndex: 601
            }, 500);

            this.btnZoomOutLeft.animate({
                left: 10,
                top: actualHeight * 0.65,
                zIndex: 601
            }, 500);

            this.btnZoomIn.css("display", "block");
            this.btnZoomOut.css("display", "block");
        }

        this.btnLeft.css("display", "block");
        this.btnRight.css("display", "block");
        this.mainArea.css("zIndex", 600);
        this.mainArea.parent().css("zIndex", 600);
        trace.log('ebook', actionType.OpenWidget, {cardId: CardWrapper.curCardId});
    }
    /**
     * @description 最小化卡片展示区域
     * @returns {}
     */
    CardWrapper.prototype.minimize = function () {

        if (!this.isMax)  return;

        this.mainArea.animate({
            width: 0,
            height: 0,
            opacity: '0'
        }, 500);

        this.btnLeft.animate({
            left: 0,
            top: 0
        }, 500)
        this.btnRight.animate({
            left: 0,
            top: 0
        }, 500)

        if (this.enableZoom) {
            this.btnZoomIn.animate({
                left: 0,
                top: 0
            }, 500)
            this.btnZoomIn.css("display", "none");

            this.btnZoomOut.animate({
                left: 0,
                top: 0
            }, 500)
            this.btnZoomOut.css("display", "none");

            this.btnZoomIn.unbind();
            this.btnZoomOut.unbind();
            this.imgEle.unbind();
            $(this.innerObj).unbind();
        }

        this.btnLeft.css("display", "none");
        this.btnRight.css("display", "none");
        this.btnLeft.unbind();
        this.btnRight.unbind();
        $("#cardWrapper").unbind();
        this.mainArea.parent().css("zIndex", 0);

        //修复多次点击卡片导致生成多个innerObj，remove时只remove最后一个obj的bug
        var innerObjs = $("#cardWrapperDiv").children();
        for (var i = 2; i < innerObjs.length; i++) {
            innerObjs[i].remove();
        }

        this.innerObj = null;
        this.isMax = false;
        this.rate = 1;

        app_global_playerMgr && app_global_playerMgr.stop();
        trace.log('ebook', actionType.CloseWidget, {cardId: CardWrapper.curCardId});

        /********************************************
         * 这一行是为了在打开时屏蔽按键
         ******************************************/
        global_flag = false;
    }

    /**
     * @description 显示卡片展示区域，并加载内部资源
     * @param {dom} innerObj
     * @param {string} cardId
     * @returns {}
     */
    CardWrapper.prototype.show = function (innerObj, cardId) {

        //修复多次点击卡片导致生成多个innerObj的bug，只append一个
        var innerObjs = $("#cardWrapperDiv").children();
        if (innerObjs.length > 2) return;

        this.enableZoom = (arguments[2] == undefined ? false : true);
        this.curCardId = cardId;
        this.hideOtherControls();

        innerObj.style.position = "absolute";
        innerObj.style.width = "0px";
        innerObj.style.height = "0px";
        innerObj.style.top = "0px";
        innerObj.style.opacity = '0';
        innerObj.style.overflow = 'hidden';

        this.innerObj = innerObj;
        this.imgEle = $(this.innerObj).find("img");
        $("#cardWrapperDiv").append(innerObj);

        /********************************************
         * 这一行是为了在打开时屏蔽按键
         ******************************************/
        global_flag = true;

        if (this.isMax == false) {
            this.isMax = true;
            this.maximize();
        }

        var _self = this;
        this.btnLeft.click(function () {
            _self.minimize();
            _self.triggerHandler('minmize');
        });
        this.btnRight.click(function () {
            _self.minimize();
            _self.triggerHandler('minmize');
        });

        if (this.enableZoom) {

            this.offset.x = 0;
            this.offset.y = 0;
            this.offset.baseX = 0;
            this.offset.baseY = 0;
            this.enableMove = false;
            this.hasMove = false;
            this.rate = 1;
            setTimeout(function () {
                _self.bound.height = _self.imgEle.height();
                _self.bound.width = _self.imgEle.width();
                _self.bound.maxHeight = $("#cardWrapper").height();
                _self.bound.maxWidth = $("#cardWrapper").width();
                _self.bound.centerPointX = _self.bound.maxWidth / 2;
                _self.bound.centerPointY = _self.bound.maxHeight / 2;
            }, 1000);

            this.imgEle.bind({
                dragstart: function () {
                    return false;
                },
                mousedown: function (e) {
                    _self.enableMove = true;
                    _self.mousePoint.x = e.originalEvent.pageX;
                    _self.mousePoint.y = e.originalEvent.pageY;
                },
                mousemove: function (e) {
//                    if (_self.enableMove) {
//                        var bound = _self.bound;
//                        var rate = _self.rate;
//                        if(bound.centerPointY < bound.height * rate/2
//                            || bound.centerPointY > (bound.maxHeight - bound.height * rate/2)
//                            || bound.centerPointX < bound.width * rate/2
//                            || bound.centerPointX > (bound.maxWidth - bound.width * rate/2))
//                        {
//                        _self.hasMove = true;
//                        _self.offset.x = e.originalEvent.pageX - _self.mousePoint.x;
//                        _self.offset.y = e.originalEvent.pageY - _self.mousePoint.y;
//                        var offsetX = _self.offset.x + _self.offset.baseX;
//                        var offsetY = _self.offset.y + _self.offset.baseY;
//                        $(_self.innerObj).css({
//                            '-webkit-transform': 'translate(' + offsetX + "px," + offsetY + "px" + ') scale(' + _self.rate + ')'
//                        })
//                        }
//                    }
                    if (_self.enableMove) {
                        var bound = _self.bound;
                        var rate = _self.rate;
                        if(true)
                        {
                            _self.hasMove = true;
                            _self.offset.x = e.originalEvent.pageX - _self.mousePoint.x;
                            _self.offset.y = e.originalEvent.pageY - _self.mousePoint.y;
                            var offsetX = _self.offset.x + _self.offset.baseX;
                            var offsetY = _self.offset.y + _self.offset.baseY;

                            //在这限制拖动范围的相关参数,offsetX 和 offsetY 为坐标偏移,相对（0,0）的偏移
                            //中心点超出边界时重新计算 _self.offset.x,offsetX,_self.offset.y,offsetY
                            //--------以下限制拖动范围代码由pengfu添加-------------
//                            var centerPointXPosition = _self.bound.centerPointX +  _self.offset.x;
//                            var centerPointYPosition = _self.bound.centerPointY +  _self.offset.y;
//                            if(centerPointXPosition > _self.bound.maxWidth){
//                                _self.offset.x =  _self.bound.maxWidth - _self.bound.centerPointX;
//                                offsetX = _self.bound.maxWidth - _self.bound.centerPointX + _self.offset.baseX;
//                            }else if(centerPointXPosition < 0){
//                                _self.offset.x =  0 -  _self.bound.centerPointX;
//                                offsetX = 0 -  _self.bound.centerPointX + _self.offset.baseX;
//                            }
//
//                            if(centerPointYPosition > _self.bound.maxHeight){
//                                _self.offset.y = _self.bound.maxHeight - _self.bound.centerPointY;
//                                offsetY = _self.bound.maxHeight - _self.bound.centerPointY + _self.offset.baseY;
//                            }else if(centerPointYPosition < 0){
//                                _self.offset.y = 0 - _self.bound.centerPointY;
//                                offsetY = 0 - _self.bound.centerPointY + _self.offset.baseY;
//                            }
                            //--------以上限制拖动范围代码由pengfu添加-------------

                            $(_self.innerObj).css({
                                '-webkit-transform':
                                    'translate(' + offsetX + "px," + offsetY + "px" + ') scale(' + _self.rate + ')'
                            })
                        }
                    }
                },
                mouseup: function (e) {
                    _self.enableMove = false;
                    if (_self.hasMove) {
                        _self.offset.baseX += _self.offset.x;
                        _self.offset.baseY += _self.offset.y;
                        _self.bound.centerPointX += _self.offset.x;
                        _self.bound.centerPointY += _self.offset.y;
                        _self.hasMove = false;
                    }
                    e.stopPropagation();
                }
            });

            $(window).mouseup(function(e){
//                alert('window mousup')
                _self.enableMove = false;
                if (_self.hasMove) {
                    _self.offset.baseX += _self.offset.x;
                    _self.offset.baseY += _self.offset.y;
                    _self.bound.centerPointX += _self.offset.x;
                    _self.bound.centerPointY += _self.offset.y;
                    _self.hasMove = false;
                }
                e.stopPropagation();

            })

            $(this.innerObj).mouseup(function (e) {
                _self.enableMove = false;
                if (_self.hasMove) {
                    _self.offset.baseX += _self.offset.x;
                    _self.offset.baseY += _self.offset.y;
                    _self.bound.centerPointX += _self.offset.x;
                    _self.bound.centerPointY += _self.offset.y;
                    _self.hasMove = false;
                }
                e.stopPropagation();
            })

            $("#cardWrapper").mouseup(function () {
                _self.enableMove = false;
                if (_self.hasMove) {
                    _self.offset.baseX += _self.offset.x;
                    _self.offset.baseY += _self.offset.y;
                    _self.bound.centerPointX += _self.offset.x;
                    _self.bound.centerPointY += _self.offset.y;
                    _self.hasMove = false;
                }
            })

            this.btnZoomIn.click(function () {
                _self.enableMove = false;
                _self.rate += 0.1;
                $(_self.innerObj).css({
                    '-webkit-transform': 'translate(' + _self.offset.baseX + "px," + _self.offset.baseY + "px" + ') scale(' + _self.rate + ')'
                });
                _self.btnZoomOut.find("img").attr("src", "assert/images/tool_zoomout.png");

            })
                .mouseover(function () {
                    _self.btnZoomIn.css({
                        '-webkit-transform': 'scale(1.3)'
                    })
                })
                .mouseout(function () {
                    _self.btnZoomIn.css({
                        '-webkit-transform': 'scale(1.0)'
                    })
                })

            this.btnZoomOut.click(function () {
                _self.enableMove = false;
                if (_self.rate >= 1.1) {
                    _self.rate -= 0.1;
                    if (_self.rate == 1) {
                        _self.offset.baseX = 0;
                        _self.offset.baseY = 0;
                        _self.bound.centerPointX = _self.bound.maxWidth / 2;
                        _self.bound.centerPointY = _self.bound.maxHeight / 2;
                        _self.btnZoomOut.find("img").attr("src", "assert/images/tool_zoomout_disabled.png");
                    }
                    $(_self.innerObj).css({
                        '-webkit-transform': 'translate(' + _self.offset.baseX + "px," + _self.offset.baseY + "px" + ') scale(' + _self.rate + ')'
                    });
                }
            })
                .mouseover(function () {
                    _self.btnZoomOut.css({
                        '-webkit-transform': 'scale(1.3)'
                    })
                })
                .mouseout(function () {
                    _self.btnZoomOut.css({
                        '-webkit-transform': 'scale(1.0)'
                    })
                })
        }
    };
    exports.Instance = new CardWrapper();
});