﻿/**
 * 卡片信息读取类，提供读取卡片内容的功能
 * Date: 2013/06/28
 * Author: luxing@iflytek.com
 * @version 1.0
 * @module common/cardreader
 */

define(function (require, exports, module) {
    var shellcmd = require("../../common/shellcmd");

    var CardReader = {};

    CardReader.cardPath = "";
    CardReader.cardType = "";
    CardReader.cardContent = null;

    var _isJsonExist;

    /**
     * @description 根据卡片路径，读取卡片Content
     * @param {string} filePath  可以是没有加密的资源文件夹路径，也可以是卡片路径，会自动判断
     * @returns {Array} [this.cardType, this.cardContent]包含卡片类型与卡片内容的数组对象
     */
    CardReader.getContent = function (filePath) {
        var def= $.Deferred();
        this._getCardPath(filePath).done(function () {
            if (_isJsonExist) {
                var jsonStr = shellcmd.readFile(CardReader.cardPath);
                if(jsonStr){
                    jsonStr = jsonStr.replace(/\n/g, "").replace(/\r/g, "").replace(/\0/g, "");
                    var metaObj = $.parseJSON(jsonStr);
                    CardReader.cardContent = metaObj;
                    def.resolve(CardReader.cardContent);
                }else{
                    console.error("shellcmd读取资源为空： "+CardReader.cardPath);
                }

            } else {
                this._getCardType();
                var contentPath = this._getContentPath();
                var contentStr = shellcmd.readFile(this.cardPath + "/" + contentPath);
                var xmlDoc = null;
                var domParser = new DOMParser();
                xmlDoc = domParser.parseFromString(contentStr, 'text/xml');
                if (this.cardType == "en_word") {
                    var wordList = xmlDoc.getElementsByTagName(
                        "Word");
                    var wordArray = [];
                    for (var i = 0; i < wordList.length; i++) {
                        wordArray.push(wordList[i].firstChild.nodeValue)
                    }
                    this.cardContent = wordArray;
                } else if (this.cardType == "cn_word") {
                    var wordStr = xmlDoc.getElementsByTagName(
                        "Word")[0].firstChild.nodeValue;
                    this.cardContent = wordStr;
                } else if (this.cardType == "gallery") {
                    this.cardContent = xmlDoc;
                    return [this.cardType, this.cardContent, this.cardPath];
                } else if (this.cardType == "situ" || this.cardType == "immitate") {
                    //存放最后键值对的数组
                    var keyValueArray = [];
                    //获取文本内容
                    //查询xaml节点时，不需要加上前面的“rec：”前缀
                    var textDataCollection = xmlDoc.getElementsByTagName(
                        "AreaControl.TextDataCollection");
                    var audioInfoCollection = xmlDoc.getElementsByTagName(
                        "AreaControl.FirstLanguageAudioInfoCollection");
                    if (textDataCollection.length == audioInfoCollection.length) {
                        for (var i = 0; i < textDataCollection.length; i++) {
                            //解析xaml时，需要使用textContent来获取节点值，nodeValue获取不到
                            var textDataString = textDataCollection[i].firstChild.textContent;
                            if (textDataString == null) {
                                textDataCollection = xmlDoc.getElementsByTagName(
                                    "AreaControl.NoteDataCollection");
                                textDataString = textDataCollection[i].firstChild.textContent;
                            }
                            var regx = /<.+?>/gi;
                            //最终文本
                            var innerText = textDataString.replace(regx, "");
                            //最终音频地址
                            var audioInfoArray = audioInfoCollection[i].firstChild.getAttribute("FilePath").split("\\");
                            var audioInfo = this.cardPath + "\\" + audioInfoArray.pop();
                            keyValueArray.push([innerText, audioInfo]);
                        }
                    } else {
                        console.log("获取的音频数量与文本数量不一致，请检查资源是否正常");
                    }
                    this.cardContent = keyValueArray;
                }
                def.resolve([this.cardType, this.cardContent]);
            }

        });

        return def.promise();
    }

    /**
     * @description 根据卡片路径，读取index.xmlx中的Content文件路径
     * @param {}
     * @returns {string} contentPath 包含卡片内容的文件路径
     */
    CardReader._getContentPath = function () {
        var xmlStr = shellcmd.readFile(this.cardPath + "/index.xmlx");
        //var xmlStr = callClient('syscmd', 'readfile', this.cardPath + "/index.xmlx" , 0);
        if (xmlStr == "") {
            //xmlStr = callClient('syscmd', 'readfile', this.cardPath + "/index.xml", 0);
            xmlStr = shellcmd.readFile(this.cardPath + "/index.xml");
        }
        var xmlDoc = null;
        var domParser = new DOMParser();
        xmlDoc = domParser.parseFromString(xmlStr, 'text/xml');
        var contentPath = null;
        if (this.cardType == "en_word" || this.cardType == "cn_word" || this.cardType == "gallery") {
            var fullContentPath = xmlDoc.getElementsByTagName(
                "Value")[0].firstChild.nodeValue;
            var contentPathArray = fullContentPath.split("\\");
            contentPath = contentPathArray.pop();
        } else if (this.cardType == "situ" || this.cardType == "immitate") {
            var contentCode = xmlDoc.getElementsByTagName(
                "Code")[1].firstChild.nodeValue;
            contentPath = contentCode + ".xaml";
        }
        return contentPath;
    }

    /**
     * @description 根据卡片路径，判断卡片类型，并赋值给CardReader.cardType
     * @param {}
     * @returns {}
     */
    CardReader._getCardType = function () {
        //var xmlStr = callClient('syscmd', 'readfile', this.cardPath + "/index.xmlx", 0);
        var xmlStr = shellcmd.readFile(this.cardPath + "/index.xmlx");
        if (xmlStr == "") {
            //xmlStr = callClient('syscmd', 'readfile', this.cardPath + "/index.xml", 0);
            xmlStr = shellcmd.readFile(this.cardPath + "/index.xml");
            if (xmlStr == "") {
                console.error("cef的readfile方法读取字符串为空！");
            }
        }

        var xmlDoc = null;
        var cardTypeStr = null;
        try {
            var domParser = new DOMParser();
            xmlDoc = domParser.parseFromString(xmlStr, 'text/xml');
            cardTypeStr = xmlDoc.getElementsByTagName("AdvancedCardClass")[0].firstChild.nodeValue;
        } catch (e) {
            if (cardTypeStr == null) {
                try {
                    cardTypeStr = xmlDoc.getElementsByTagName(
                        "ExtendInfoType")[0].firstChild.nodeValue;
                } catch (e) {
                    console.error("读取ExtendInfoType失败");
                }
            }
            if (cardTypeStr == null) {
                console.error("无法正常读取资源，资源路径：" + this.cardPath);
            }
        }
        if (cardTypeStr == "AdvancedCard.WordEvalCard.WordEvalCard" || cardTypeStr == "AdvancedCard.WordEval.WordEvalCard") {
            this.cardType = "en_word";
        } else if (cardTypeStr == "AdvancedCard.CnWordEvalCard.CnWordEvalCard" || cardTypeStr == "AdvancedCard.CnWordEval.CnWordEvalCard") {
            this.cardType = "cn_word";
        } else if (cardTypeStr == "AdvancedCard.Multimedia.GalleryControl") {
            this.cardType = "gallery";
        } else if (cardTypeStr == "SituationalDialogue") {
            this.cardType = "situ";
        } else if (cardTypeStr == "ImatationRead") {
            this.cardType = "immitate";
        }
        console.log("资源类型：" + this.cardType);
    }
    /**
     * @description 获取实际资源路径，如果是scard路径，则返回mount后的路径
     * @param {string} filePath
     * @returns {string}
     */
    CardReader._getCardPath = function (filePath) {
        if (this._stringContains(filePath, "file:/", true)) {
            filePath = filePath.replace("file:/", "");
        }
        console.log(filePath);
        var filePathArray = filePath.split("/");
        var lastStr = filePathArray.pop();
        var isMountPath = this._stringContains(filePath, ".scard", true);
        if (isMountPath) {
            var _self=this;
            shellcmd.mount(filePath).done(function(ret){
                _self.cardPath=ret;
            });
           // this.cardPath = callClient('syscmd', 'mount', filePath, 0);
        } else {
            this.cardPath = filePath;
        }

        var def = $.Deferred();
        shellcmd.isFileExist(filePath + "/meta.json").done(function (ret) {
            if (ret) {
                CardReader.cardPath = filePath + "/meta.json";
                _isJsonExist = true;
            }
            console.log("资源地址：" + CardReader.cardPath);
            def.resolve();
        });

        return def.promise();
    }

    /**
     * @description 判断string中是否包含子字符串
     * @param {string} str 完整字符串
     * @param {string} substr 子字符串
     * @param {string} isIgnoreCase 是否大小写敏感，true表示不敏感，false表示敏感
     * @returns {boolean} 返回是否str中是否包含substr的判断结果
     */
    CardReader._stringContains = function (str, substr, isIgnoreCase) {
        if (isIgnoreCase) {
            str = str.toLowerCase();
            substr = substr.toLowerCase();
        }
        var startChar = substr.substring(0, 1);
        var strLen = substr.length;
        for (var j = 0; j < str.length - strLen + 1; j++) {
            if (str.charAt(j) == startChar) {
                if (str.substring(j, j + strLen) == substr) {
                    return true;
                }
            }
        }
        return false;
    }

    exports.Instance = CardReader;
});