/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 13-9-17
 * Time: 下午8:06
 * To change this template use File | Settings | File Templates.
 */
define(function (require, exports, module) {
    function EventLogic() {

        var _self = this;

        _self.buttons = {};
        _self.controls = {};

        _self.init = function (buttons, controls) {

            _self.buttons = buttons;
            _self.controls = controls;

            var _clickPanel = false;

            /**
             * 拉环单击，弹出年级册别面板
             */
            _self.controls.leftRing.click(function () {
                if (_clickPanel) {
                    return;
                }
                _clickPanel = true;
                //只在全部书本下可用
                bookShelfStatus.setShowFlipOrNot((bookShelfStatus.getShowFlipOrNot() == false) ? true : false);
                _self.GradeVolumnFlipOrNOt().done(function () {
                    _clickPanel = false;
                });
            });

            _self.controls.rightRing.click(function () {
                if (_clickPanel) {
                    return;
                }
                _clickPanel = true;
                //只在全部书本下可用
                bookShelfStatus.setShowFlipOrNot((bookShelfStatus.getShowFlipOrNot() == false) ? true : false);
                _self.GradeVolumnFlipOrNOt().done(function () {
                    _clickPanel = false;
                });
            });

            _self.controls.leftArrow.click(function () {
                if (_clickPanel) {
                    return;
                }
                _clickPanel = true;
                //只在全部书本下可用
                bookShelfStatus.setShowFlipOrNot((bookShelfStatus.getShowFlipOrNot() == false) ? true : false);
                _self.GradeVolumnFlipOrNOt().done(function () {
                    _clickPanel = false;
                });
            });

            _self.controls.rightArrow.click(function () {
                if (_clickPanel) {
                    return;
                }
                _clickPanel = true;
                //只在全部书本下可用
                bookShelfStatus.setShowFlipOrNot((bookShelfStatus.getShowFlipOrNot() == false) ? true : false);
                _self.GradeVolumnFlipOrNOt().done(function () {
                    _clickPanel = false;
                });
            });
        }

        /**
         * 是否禁用拖拽排序
         * @param true 禁用 false 启用
         */
        _self.isCanSortable = function (res) {
            //缩略图模式
            _self.controls.ctrBookInfoContentDiv.sortable({
                disabled: res
            });
            _self.controls.ctrBookInfoContentDiv.disableSelection();
            //列表模式拖动排序
            _self.controls.ctrBooksListDiv.sortable({
                disabled: res
            });
            _self.controls.ctrBooksListDiv.disableSelection();
        }


        /**
         * 是否显示年级册别
         * @constructor
         */
        _self.GradeVolumnFlipOrNOt = function () {
            var def = $.Deferred();
            if (bookShelfStatus.getShowFlipOrNot()) {
                _self.flipDown().done(function () {
                    def.resolve();
                });
            }
            else {
                _self.flipSlideUp().done(function () {
                    def.resolve();
                });
            }
            return def.promise();
        }

        /**
         * 刷新书架，先刷新书本列表，再刷新年级册别
         * @returns {*}
         */
        _self.reNewBookSelf = function () {
            var def = $.Deferred();
            if (bookShelfStatus.getReadOrSelect() == 1) {
                //loadbook方法会按照"全部书本""最近使用""新书"分类去刷新书架
                // 防止“新书”按钮乱显示
                //如果现在是书本的编辑状态，则不刷新书架
                _bookLoader.loadBook().done(function () {
                    _self.reNewGradeVolumn().done(function () {
                        def.resolve();
                    });
                });
            }
            else {
                _self.reNewGradeVolumn().done(function () {
                    def.resolve();
                });
            }
            return def.promise();
        }

        /**
         * 刷新年级册别面板
         * @returns {*}
         */
        _self.reNewGradeVolumn = function () {
            var def = $.Deferred();
            _self.drawAllGrades().done(function () {
                _self.drawAllScetion().done(function () {
                    def.resolve();
                });
            });
            return def.promise();
        }

        /**
         * 移除年级册别下面拉环
         */
        _self.removeRing = function () {
            _self.controls.ctrRingLeftImg.find('img').remove();
            _self.controls.ctrRingRightImg.find('img').remove();
        }

        /**
         * 添加年级册别下拉环（有可能已经存在，先remove，再添加）
         */
        _self.addRing = function () {
            _self.controls.ctrRingLeftImg.find('img').remove();
            _self.controls.ctrRingRightImg.find('img').remove();
            //如果只有一个对象，只能在一个地方加，用"_1"表示区别
            var imgNew = $("<img/>");
            imgNew.attr("src", "assert/images/ring.png");
            var imgNew_1 = $("<img/>");
            imgNew_1.attr("src", "assert/images/ring.png");
            _self.controls.ctrRingLeftImg.find('a').append(imgNew_1);
            _self.controls.ctrRingRightImg.find('a').append(imgNew);

            var imgArrow = $("<img/>");
            imgArrow.attr("src", "assert/images/ring_arrow.png");
            var imgArrow_1 = $("<img/>");
            imgArrow_1.attr("src", "assert/images/ring_arrow.png");
            _self.controls.ctrRingLeftImg.find('span').append(imgArrow_1);
            _self.controls.ctrRingRightImg.find('span').append(imgArrow);

            _self.controls.ctrRingLeftImg.css("display", "inline");
            _self.controls.ctrRingRightImg.css("display", "inline");
        }

        /**
         * 显示“全部书本”或者“已选课本”
         */
        _self.drawBookButton = function () {
            if (bookShelfStatus.getAllBookOrSelectedBooks() == _define.FirstButton.allBooks) {
                _self.buttons.btnAllBooks.css("display", "inline");
                _self.buttons.btnSelectedBooks.css("display", "none");
                if(bookShelfStatus.getBookShowModel() == 1){
                    _self.buttons.btnAllBooks.removeClass("grain01_normal").addClass("grain01_current");
                }
            }
            else if (bookShelfStatus.getAllBookOrSelectedBooks() == _define.FirstButton.selectedBooks) {
                _self.buttons.btnAllBooks.css("display", "none");
                _self.buttons.btnSelectedBooks.css("display", "inline");
                if(bookShelfStatus.getBookShowModel() == 4){
                    _self.buttons.btnSelectedBooks.removeClass("grain01_normal").addClass("grain01_current");
                }
            }
        }

        /**
         * 加载年级
         * @returns {*}
         */
        _self.drawAllGrades = function () {
            var def = $.Deferred();
            var gradeboxcheckboxstr = "<p><input type='button' value='{{grade}}' gradecode='{{gradecode}}' class='btn_flip'/></p>";
            var gradeHtml = [];
            var h = 0;
            gradeHtml[0] = "<p><input type='button' value='全部' gradecode='' class='btn_flip2'/></p>";

            var gradeListTask = bookAccessor.getAllGrades(ebookContext.getUser());
            gradeListTask.done(function (res) {
                for (var i = 0; i < res.length; i++) {
                    var gradecode = res[i].grade;
                    var grade = _BookItemMapping.parseGrades(res[i].grade);
                    gradeHtml[++h] = gradeboxcheckboxstr.replace('{{grade}}', grade).replace('{{gradecode}}', gradecode);
                }
                var gradeboxcheckboxhtml = gradeHtml.join('');
                //为按钮注册事件
                var gradeElements = $(gradeboxcheckboxhtml);
                // 注册事件
                gradeElements.find('input').click(function () {
                    var $this = $(this);
                    bookShelfStatus.setBookShowModel(4);

                    bookShelfStatus.setAllBookOrSelectedBooks(_define.FirstButton.selectedBooks);
                    bookShelfStatus.setSelectedGrade($this.attr('gradecode'));

                    if (bookShelfStatus.getSelectedGrade() == "" && bookShelfStatus.getSelectedSection() == "") {
                        bookShelfStatus.setBookShowModel(1);
                        bookShelfStatus.setAllBookOrSelectedBooks(_define.FirstButton.allBooks);
                    }
                    _self.drawBookButton();
                    var obj = $this.parent().parent();
                    obj.find('input').removeClass("btn_flip2").addClass("btn_flip");
                    $this.removeClass("btn_flip").addClass("btn_flip2");
                    _bookLoader.loadBook();
                });
                _self.controls.ctrGradePanelDiv.empty();
                _self.controls.ctrGradePanelDiv.append(gradeElements);
                def.resolve();
            });
            return def.promise();
        }

        /**
         * 加载册别
         * @returns {*}
         */
        _self.drawAllScetion = function () {
            var def = $.Deferred();
            var sectionListTask = bookAccessor.getAllSection(ebookContext.getUser());

            var sectioncheckboxstr = "<p><input type='button' value='{{section}}' sectioncode='{{sectioncode}}' class='btn_flip'/></p>";

            var sectionHtml = [];
            var h = 0;
            sectionHtml[0] = "<p><input type='button' value='全部' sectioncode='' class='btn_flip2'/></p>";
            sectionListTask.done(function (res) {
                for (var i = 0; i < res.length; i++) {
                    var sectioncode = res[i].volumn;
                    var section = _BookItemMapping.parseVolumn(res[i].volumn);
                    sectionHtml[++h] = sectioncheckboxstr.replace('{{section}}', section).replace('{{sectioncode}}', sectioncode);
                }
                var sectioncheckboxhtml = sectionHtml.join('');
                //为按钮注册事件
                var sectionElements = $(sectioncheckboxhtml);
                // 注册事件
                sectionElements.find('input').click(function () {
                    var $this = $(this);
                    bookShelfStatus.setBookShowModel(4);
                    bookShelfStatus.setSelectedSection($this.attr('sectioncode'));
                    bookShelfStatus.setAllBookOrSelectedBooks(_define.FirstButton.selectedBooks);
                    if (bookShelfStatus.getSelectedGrade() == "" && bookShelfStatus.getSelectedSection() == "") {
                        bookShelfStatus.setBookShowModel(1);
                        bookShelfStatus.setAllBookOrSelectedBooks(_define.FirstButton.allBooks);
                    }
                    _self.drawBookButton();
                    var obj = $this.parent().parent();
                    obj.find('input').removeClass("btn_flip2").addClass("btn_flip");
                    $this.removeClass("btn_flip").addClass("btn_flip2");
                    _bookLoader.loadBook();
                })
                _self.controls.ctrSectionPanelDiv.empty();
                _self.controls.ctrSectionPanelDiv.append(sectionElements);
                def.resolve();
            });
            return def.promise();
        }

        /**
         * 年级册别面板收起
         */
        _self.flipSlideUp = function () {
            var def = $.Deferred();

            var task1 = _self.controls.ctrFlipPanelDiv.stop(true, true).slideUp("slow");
            var task2 = _self.controls.ctrClassBookCaseDiv.stop(true, true).animate({top: '-=87px'}, "slow");
            var task3 = _self.controls.ctrRingLeftImg.stop(true, true).animate({top: '53px'}, "slow");
            var task4 = _self.controls.ctrRingRightImg.stop(true, true).animate({top: '53px'}, "slow");
            var task5 = _self.controls.ctrBookCaseTopShadowImg.stop(true, true).animate({top: '53px'}, "slow");
            var task6 = _self.controls.ctrBookShowListDiv.stop(true, true).animate({top: '-=87px'}, "slow");

            var _height = _self.controls.ctrBookShowListDiv.css("height");
            _self.controls.ctrBookShowListDiv.css("min-height", _height + 87);

            $.when(task1, task2, task3, task4, task5, task6).done(function () {
                def.resolve();
            });
            return def.promise();
        }

        /**
         * 年级册别面板弹出
         */
        _self.flipDown = function () {
            var def = $.Deferred();

            var task1 = _self.controls.ctrFlipPanelDiv.stop(true, true).slideDown("slow");
            var task2 = _self.controls.ctrClassBookCaseDiv.stop(true, true).animate({top: '+=87px'}, "slow");
            var task3 = _self.controls.ctrRingLeftImg.stop(true, true).animate({top: '139px'}, "slow");
            var task4 = _self.controls.ctrRingRightImg.stop(true, true).animate({top: '139px'}, "slow");
            var task5 = _self.controls.ctrBookCaseTopShadowImg.stop(true, true).animate({top: '139px'}, "slow");
            var task6 = _self.controls.ctrBookShowListDiv.stop(true, true).animate({top: '+=87px'}, "slow");

            var _height = _self.controls.ctrBookShowListDiv.css("height");
            _self.controls.ctrBookShowListDiv.css("min-height", _height - 87);

            $.when(task1, task2, task3, task4, task5, task6).done(function () {
                def.resolve();
            });
            return def.promise();
        }

        _self.drawSelectedGradeSection = function () {
            var grade = bookShelfStatus.getSelectedGrade();
            var section = bookShelfStatus.getSelectedSection();
            //grade 和 section 为“”是合理的
            var gradeBtns = _self.controls.ctrGradePanelDiv.find("input");
            var sectionBtns = _self.controls.ctrSectionPanelDiv.find("input");
            var flag1 = 0, flag2 = 0;
            $.each(gradeBtns, function () {
                var $this = $(this);
                if (grade == $this.attr("gradecode")) {
                    flag1 = 1;
                    var obj = $this.parent().parent();
                    obj.find('input').removeClass("btn_flip2").addClass("btn_flip");
                    $this.removeClass("btn_flip").addClass("btn_flip2");
                }
            });
            $.each(sectionBtns, function () {
                var $this = $(this);
                if (section == $this.attr("sectioncode")) {
                    flag2 = 1;
                    var obj = $this.parent().parent();
                    obj.find('input').removeClass("btn_flip2").addClass("btn_flip");
                    $this.removeClass("btn_flip").addClass("btn_flip2");
                }
            });
            //如果已经不存在原来的年级和册别
            if (flag1 == 0 || flag2 == 0) {
                bookShelfStatus.setBookShowModel(1);
                bookShelfStatus.setAllBookOrSelectedBooks(_define.FirstButton.allBooks);
                _self.drawBookButton();
                _self.buttons.btnAllBooks.trigger("click");
            }
        }

        _self.initAllBookList = function () {
            var def = $.Deferred();
            bookAccessor.initAllBookList(ebookContext.getUser()).done(function () {
                def.resolve();
            });
            return def.promise();
        }
    }

    require('jquery');
    require('jquery_ui');
    require('../user');
    var _define = require('../define');
    var bookAccessor = require('./bookaccessor').Instance;
    var ebookContext = require('../ebookcontext').Instance;
    var _BookItemMapping = require('../../common/metadatamapping').Instance;
    var bookShelfStatus = require('./bookshelfstatus').Instance;
    var _bookLoader = require('./bookloader').Instance;

    exports.Instance = new EventLogic;
});

