/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 13-8-6
 * Time: 16:04
 * To change this template use File | Settings | File Templates.
 */
define(function (require, exports, module) {
    require('jquery');
    require('jquery_ui');
    require('../user');
    require('zebra_dialog');
    var path = require('../../common/path');
    var bookAccessor = require('./bookaccessor').Instance;
    var ebookContext = require('../ebookcontext').Instance;
    var bookShelfStatus = require('./bookshelfstatus').Instance;
    var _shellcmd = require('../../common/shellcmd');
    var _bookLoader = require('./bookloader').Instance;
    var _eventLogic = require('./eventlogic').Instance;
    var resUpdateMgr = require('./resupdatemgr').Instance;
    var imBook = require('./bookexportimport/imbook').Instance;
    var bookExportMgr = require('./bookexportimport/bookexport').Instance;

    function BookShelfToolBarManager() {
        var _self = this;
        _self.buttons = {};
        _self.controls = {};

        /*要删除的书本BookCode
         */
        var _deleteList = new Array();

        //要导出的书本BookCode列表
        var _exportList = [];

        /**
         * @param buttons   按钮
         * @param controls  非按钮类控件
         * @param bookContainer
         */
        this.init = function (buttons, controls) {
            _self.buttons = buttons;
            _self.controls = controls;

            _self.buttons.btnEditBooks.click(function () {
                _self.buttons.btnRecentBooks.css("display", "none");
                _self.buttons.btnAllBooks.css("display", "none");
                _self.buttons.btnSelectedBooks.css("display", "none");
                _self.buttons.btnEditBooks.css("display", "none");
                _self.buttons.btnNewBooks.css("display", "none");
                _self.buttons.btnEditCancel.css("display", "inline");
                _self.buttons.btnEditAllSelect.css("display", "inline");
                _self.buttons.btnEditDelete.css("display", "inline");
                ebookContext.getUser().getName() != AppCfg.defaultuser && (_self.buttons.btnExBook.css("display", "inline"));

                _self.buttons.btnInBook.css("display", "none");
                _self.buttons.btnYJBookStack.css("display","none");

                _self.buttons.btnNameModelDisplay.css("display", "none");
                _self.buttons.btnIconModelDisplay.css("display", "none");
                _self.buttons.btnBookLib.css("display", "none");
                _self.buttons.btnBooksNeedUpdate.css("display", "none");

                _eventLogic.isCanSortable( (bookShelfStatus.getBookShowModel() == 1 ? false : true) );

                _self.controls.ctrBooksListDiv.disableSelection();
                if (bookShelfStatus.getShowFlipOrNot()) {
                    bookShelfStatus.setShowFlipOrNot(false);
                    _eventLogic.GradeVolumnFlipOrNOt();
                }
                bookShelfStatus.setReadOrSelect(2);

                if (bookShelfStatus.getThumbnailOrList() == 2) {
//                    _self.controls.ctrBooksListDiv.children().children().removeClass("checked").addClass("unchecked");
//                    _self.controls.ctrBooksListDiv.children().find('input').removeClass("cb_checked").addClass("cb_unchecked").css("visibility", "visible");
                }
                else {
                    //缩略图模式，加红叉
                    _self.controls.ctrBookInfoContentDiv.find('b').show()
                        .click(function () {
                            var $this = $(this).parent();
                            _deleteList = [];
                            _deleteList.push($this.attr("bookCode"));
                            _self.realDeleteBooks(2, $this.parent());
                        });

                    _self.controls.ctrBookInfoContentDiv.find('font').show();
                }
                _self.controls.ctrBookInfoContentDiv.find(".btn_add_book").hide();
                _eventLogic.removeRing();
                //把阴影高度设为27，不遮挡
                _self.controls.ctrRingLeftImg.height(27);
                _self.controls.ctrRingRightImg.height(27);
            });

            _self.buttons.btnEditCancel.click(function () {
                _self.toolBarBack();
                //还原原本按钮（新书界面，应还原至新书）,重新绘制
                if (bookShelfStatus.getBookShowModel() == 3) {
                    _self.buttons.btnNewBooks.trigger("click");
                }
                else if (bookShelfStatus.getBookShowModel() == 1) {
                    _self.buttons.btnAllBooks.trigger("click");
                }
                else if (bookShelfStatus.getBookShowModel() == 4) {
                    //筛选时读出数据为空数组是正常的
                    //但这时读出空数据是不合适的
                    _eventLogic.addRing();
                    //退出时不读取数据库
                    _bookLoader.loadBook().done(function () {
                        _eventLogic.drawSelectedGradeSection();
                    });
                }
            });

            _self.buttons.btnAllBooks.click(function () {
                bookShelfStatus.setBookShowModel(1);
                _self.buttons.btnRecentBooks.removeClass("grain02_current").addClass("grain02_normal");
                _self.buttons.btnAllBooks.removeClass("grain01_normal").addClass("grain01_current");
                _self.buttons.btnNewBooks.removeClass("grain_pressed").addClass("grain_normal");
                _self.buttons.btnEditBooks.css("display", "inline");
                _self.buttons.btnCancelBooks.hide();
                _self.buttons.btnInBook.show();
                _eventLogic.addRing();
                _self.controls.ctrBookInfoContentDiv.empty();
                _bookLoader.loadBook();
            });

            _self.buttons.btnSelectedBooks.click(function () {
                bookShelfStatus.setBookShowModel(4);
                _self.buttons.btnSelectedBooks.removeClass("grain01_normal").addClass("grain01_current");
                _self.buttons.btnAllBooks.removeClass("grain01_current").addClass("grain01_normal");
                _self.buttons.btnRecentBooks.removeClass("grain02_current").addClass("grain02_normal");
                _self.buttons.btnNewBooks.removeClass("grain_pressed").addClass("grain_normal");

                _self.buttons.btnEditBooks.css("display", "inline");
                _self.buttons.btnCancelBooks.css("display", "none");

                _eventLogic.addRing();

                _self.controls.ctrBookInfoContentDiv.empty();
                if (bookShelfStatus.getShowFlipOrNot()) {
                    bookShelfStatus.setShowFlipOrNot(false);
                    _eventLogic.GradeVolumnFlipOrNOt();
                }
                _bookLoader.loadBook();
            });

            _self.buttons.btnRecentBooks.click(function () {

                bookShelfStatus.setBookShowModel(2);
                _self.buttons.btnRecentBooks.removeClass("grain02_normal").addClass("grain02_current");
                _self.buttons.btnAllBooks.removeClass("grain01_current").addClass("grain01_normal");
                _self.buttons.btnSelectedBooks.removeClass("grain01_current").addClass("grain01_normal");
                _self.buttons.btnNewBooks.removeClass("grain_pressed").addClass("grain_normal");

                _self.buttons.btnEditBooks.css("display", "none");
                _self.buttons.btnCancelBooks.css("display", "inline");
                _self.buttons.btnInBook.hide();

                if (bookShelfStatus.getShowFlipOrNot()) {
                    bookShelfStatus.setShowFlipOrNot(false);
                    _eventLogic.GradeVolumnFlipOrNOt();
                }

                _eventLogic.removeRing();
                _bookLoader.loadBook();

            });

            _self.buttons.btnNewBooks.click(function () {
                if (bookShelfStatus.getShowFlipOrNot()) {
                    bookShelfStatus.setShowFlipOrNot(false);
                    _eventLogic.GradeVolumnFlipOrNOt();
                }
                bookShelfStatus.setBookShowModel(3);
                _self.buttons.btnRecentBooks.removeClass("grain02_current").addClass("grain02_normal");
                _self.buttons.btnAllBooks.removeClass("grain01_current").addClass("grain01_normal");
                _self.buttons.btnSelectedBooks.removeClass("grain01_current").addClass("grain01_normal");

                _self.buttons.btnNewBooks.removeClass("grain_normal").addClass("grain_pressed");

                _self.buttons.btnEditBooks.css("display", "inline");
                _self.buttons.btnCancelBooks.css("display", "none");
                _eventLogic.removeRing();
                _bookLoader.loadBook().done(function () {

                });
            });

            _self.buttons.btnCancelBooks.click(function () {
                var task = bookAccessor.clearBookUsedTime(ebookContext.getUser());
                task.done(function () {
                    _bookLoader.loadBook();
                });
            });

            _self.buttons.btnNameModelDisplay.click(function () {
                if (bookShelfStatus.getThumbnailOrList() == 1) {
                    bookShelfStatus.setThumbnailOrList(2);
                    _self.buttons.btnIconModelDisplay.removeClass("grain01_current").addClass("grain01_normal");
                    _self.buttons.btnNameModelDisplay.removeClass("grain02_normal").addClass("grain02_current");

                    _self.controls.ctrBookOutSideDiv.css("display", "none");
                    _self.controls.ctrBookShowListDiv.css("display", "inline");
                    _bookLoader.loadBook();
                }
                else {
                    return;
                }
            });

            _self.buttons.btnIconModelDisplay.click(function () {
                if (bookShelfStatus.getThumbnailOrList() == 2) {
                    bookShelfStatus.setThumbnailOrList(1);
                    _self.buttons.btnIconModelDisplay.removeClass("grain01_normal").addClass("grain01_current");
                    _self.buttons.btnNameModelDisplay.removeClass("grain02_current").addClass("grain02_normal");

                    _self.controls.ctrBookOutSideDiv.css("display", "block");
                    _self.controls.ctrBookShowListDiv.css("display", "none");
                    _bookLoader.loadBook();
                }
                else {
                    return;
                }
            });

            _self.buttons.btnEditAllSelect.click(function () {
                _self.buttons.btnEditNoSelect.css("display", "inline");
                _self.buttons.btnEditAllSelect.css("display", "none");
                // 只在_readOrSelect==2时使用，全部选中,图片画钩
                if (bookShelfStatus.getThumbnailOrList() == 1) {
                  //  var imgNew = $("<img/>");
                  //  imgNew.attr("src", "assert/images/radio_btn2.png");
                  //  var font = $("<font></font>");
                  //  font.append(imgNew);
                    _self.controls.ctrBookInfoContentDiv.find("font").addClass("cur_r");

                }
                else if (bookShelfStatus.getThumbnailOrList() == 2) {
//                    _self.controls.ctrBooksListDiv.children().children().removeClass("unchecked").addClass("checked");
//                    _self.controls.ctrBooksListDiv.children().find('input').removeClass("cb_unchecked").addClass("cb_checked");
                }
            });

            _self.buttons.btnEditNoSelect.click(function () {
                // 只在_readOrSelect==2时使用，全部取消选中,图片去除钩
                _self.buttons.btnEditNoSelect.css("display", "none");
                _self.buttons.btnEditAllSelect.css("display", "inline");
                //不管<a>有多少<font>标签,全部删除
                if (bookShelfStatus.getThumbnailOrList() == 1) {
                    _self.controls.ctrBookInfoContentDiv.find("font").removeClass("cur_r");
                }
                else if (bookShelfStatus.getThumbnailOrList() == 2) {
//                    _self.controls.ctrBooksListDiv.children().children().removeClass("checked").addClass("unchecked");
//                    _self.controls.ctrBooksListDiv.children().find('input').removeClass("cb_checked").addClass("cb_unchecked");

                }
            });

            _self.buttons.btnEditDelete.click(function () {
                //先判断有没有书被选中
                _deleteList = getSelectBooks();

                if (_deleteList.length > 0) {
                    _self.realDeleteBooks(1, null);
                }
                else {
                    $.Zebra_Dialog(AppBookShelfTipsList.SelectBooksFirst, {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons': [AppTips.OkTips]
                    });
                }
            });

            _self.buttons.btnBooksNeedUpdate.click(function () {
                //面板把按钮遮挡，不改动按钮样式
                resUpdateMgr.showUpdateBooks();
            });

            _self.buttons.btnExBook.click(function(){

                //先判断有没有U盘插入
                _shellcmd.GetUpanInfo().done(function(ret){
                    //ret为""，表示未检测到有U盘插入
                    if(!ret){
                        $.Zebra_Dialog(AppTips.needToInsertUpan, {
                            'type': 'information',
                            'title': AppTips.WarmTips,
                            'buttons': [AppTips.OkTips]
                        });
                        return;
                    }
                    else{
                        //先判断选中的课本中是否包含人教数字课本，人教数字课本不支持导出功能
                        var isU = hasYJBookInSelBooks();
                        if(isU){
                            $.Zebra_Dialog(AppBookShelfTipsList.YJBookCannotBeExport, {
                                'type': 'information',
                                'title': AppTips.WarmTips,
                                'buttons': [AppTips.OkTips]
                            });
                            return;
                        }
                        //再判断有没有书被选中
                        _exportList = getSelectBooks();
                        if (_exportList.length > 0) {
                            var hasTestBook = _exportList.some(function(ele,index,array){
                                return ele == AppCfg.testBook;
                            });
                            if(!hasTestBook){
                                bookExportMgr.showBookExportPanel(_exportList);
                            }else{
                                showAlertTips(AppBookShelfTipsList.TestBookCannotBeExport);
                            }
                        }
                        else {
                            showAlertTips(AppBookShelfTipsList.SelectExportBooksFirst);
                        }
                    }
                })

            });

            _self.buttons.btnInBook.click(function(){
                imBook.show();
            });

            bookExportMgr.init();
        };

        /**
         *
         * @param num 1 表示单击工具栏“删除”按钮删除，2 表示单击红叉叉删除
         * @param obj
         */
        _self.realDeleteBooks = function (num, obj) {
            var str = AppBookShelfTipsList.DeleteBooks_first +" "+ _deleteList.length +" "+ AppBookShelfTipsList.DeleteBooks_last;
            $.Zebra_Dialog(str, {
                'type': 'question',
                'title': AppTips.WarmTips,
                'buttons': [AppTips.CancelTips, AppBookShelfTipsList.OnlyBooks, AppBookShelfTipsList.DeleteAll],
                'onClose': function (capition) {
                    if (capition == AppBookShelfTipsList.DeleteAll) {
                        showLoading({tips: AppBookShelfTipsList.DeletingTips});
                        _self.OKforDeleteBooks().done(function () {
                            _self.deleteDoneGoShelf(num, obj);
                        });
                    }
                    else if (capition == AppBookShelfTipsList.OnlyBooks) {
                        showLoading({tips: AppBookShelfTipsList.DeletingTips});
                        _self.OnlyDeleteBooks().done(function () {
                            _self.deleteDoneGoShelf(num, obj);
                        });
                    }
                }
            });
        }

        /**
         * 工具栏按钮还原
         */
        _self.toolBarBack = function () {
            bookShelfStatus.setReadOrSelect(1);
            _self.buttons.btnEditBooks.css("display", "inline");
            _self.buttons.btnRecentBooks.css("display", "inline");
            _eventLogic.drawBookButton();
            _self.buttons.btnEditCancel.css("display", "none");
            _self.buttons.btnEditAllSelect.css("display", "none");
            _self.buttons.btnEditDelete.css("display", "none");
            _self.buttons.btnEditNoSelect.css("display", "none");
            _self.buttons.btnExBook.css("display", "none");
            _self.buttons.btnInBook.show();

            (AppVersionCfg.AppVersion == "YueJiaoYun") &&_self.buttons.btnYJBookStack.show();

            _self.buttons.btnNameModelDisplay.css("display", "inline");
            _self.buttons.btnIconModelDisplay.css("display", "inline");
            _self.buttons.btnBookLib.show();

            _eventLogic.isCanSortable(true);
        }

        /**
         * 删除全部(异步)
         */
        _self.OKforDeleteBooks = function () {
            var def = $.Deferred();
            var allDeleNum = _deleteList.length;
            var len = allDeleNum, i = 0;
            var bookId = "";
            //删除可更新面板记录
            for (i = 0; i < len; i++) {
                bookId = _deleteList[i];
                resUpdateMgr.deleMergeDInfoByBookCode(bookId);
            }
            bookAccessor.deleteBookALot(_deleteList, ebookContext.getUser()).done(function () {
                _self.deletePhysicalBooks().done(function () {
                    _self.deleteBookRes().done(function () {
                        def.resolve();
                    });
                });
            });
            return def.promise();
        }

        /**
         * 只删课本（异步）
         */
        _self.OnlyDeleteBooks = function () {
            var def = $.Deferred();
            var allnum = _deleteList.length;
            var len = allnum;
            for (var i = 0; i < len; i++) {
                var bookId = _deleteList[i];
                resUpdateMgr.deleMergeDInfoByBookCode(bookId);
            }
            //并发执行
            bookAccessor.deleteBookALot(_deleteList, ebookContext.getUser()).done(function () {
                _self.deletePhysicalBooks().done(function (res2) {
                    def.resolve();
                });
            });
            return def.promise();
        }

        /**
         * 删除书本完成后刷新书架列表（读数据库）
         */
        _self.deleteDoneGoShelf = function (num, obj) {
            hideLoading();
            if (num == 1) {
                _self.toolBarBack();
                _eventLogic.initAllBookList().done(function () {
                    _eventLogic.reNewBookSelf().done(function () {
                        //再现筛选时的按钮状态
                        //如果这个时候“已选课本”已经没有书，会在这时触发更新
                        _eventLogic.drawSelectedGradeSection();

                    });
                });
            }
            else if (num == 2) {
                //删除之后读数据库，可以防止单击“我的课本”发送数据出错。
                _eventLogic.initAllBookList().done(function () {
                    _eventLogic.reNewGradeVolumn().done(function () {
                        obj.remove();
                    });
                });
            }
        }

        /**
         * 删除书的物理文件（.book2）
         * @param bookCode
         * @returns {*}
         */
        _self.deletePhysicalBooks = function () {
            var des = $.Deferred();
            var file = "";
            for (var i = 0; i < _deleteList.length - 1; i++) {
                var fileDir = path.join(path.trimPosix(Config.binPath), 'users/' + ebookContext.getUser().getName() + '/ebook/' + _deleteList[i]);
                file += fileDir + "|";
            }
            file += path.join(path.trimPosix(Config.binPath), 'users/' + ebookContext.getUser().getName() + '/ebook/' + _deleteList[_deleteList.length - 1]);
            _shellcmd.deleteDir(file).done(function () {
                des.resolve();
            });
            return des.promise();
        }

        /**
         * 删除相应资源
         * @param bookCode
         * @returns {*}
         */
        _self.deleteBookRes = function (bookCode) {
            var des = $.Deferred();
            var file = "";
            for (var i = 0; i < _deleteList.length - 1; i++) {
                var fileDir = path.join(path.trimPosix(Config.binPath), 'users/' + ebookContext.getUser().getName() + '/userbook/' + _deleteList[i]);
                file += fileDir + "|";
            }
            file += path.join(path.trimPosix(Config.binPath), 'users/' + ebookContext.getUser().getName() + '/userbook/' + _deleteList[_deleteList.length - 1]);
            _shellcmd.deleteDir(file).done(function () {
                des.resolve();
            });
            return des.promise();
        }

        function getSelectBooks(){
            var  selectBooks = [],books = null ;
            if (bookShelfStatus.getThumbnailOrList() == 1) {
                books = $("a.bookthumbnail");
                for (var i = 0; i < books.length; i++) {
                    var selectTag = $(books[i]).find('font');
                    if (selectTag.hasClass("cur_r")) {
                        var bookID = books[i].getAttribute("BookCode");
                        selectBooks.push(bookID);
                    }
                }
            }
            else if (bookShelfStatus.getThumbnailOrList() == 2) {
//                books = _self.controls.ctrBooksListDiv.find('dd');
//                for (var i = 0; i < books.length; i++) {
//                    if ($(books[i]).hasClass("checked")) {
//                        var bookID = books[i].getAttribute("BookCode");
//                        selectBooks.push(bookID);
//                    }
//                }
            }
            return selectBooks;
        }

        //判断选中的课本是否包含“人教数字”课本
        function hasYJBookInSelBooks(){
            var books = null;
            if (bookShelfStatus.getThumbnailOrList() == 1) {
                books = $("a.bookthumbnail");
                for (var i = 0; i < books.length; i++) {
                    var selectTag = $(books[i]).find('font');
                    if (selectTag.hasClass("cur_r")) {
                        var isu = books[i].getAttribute("isu");
                        if(isu == 'RJ'){
                            return true;
                        }
                    }
                }
            }
            return false;
        }

    }

    exports.Instance = new BookShelfToolBarManager();
})
;