/**
 * Created with JetBrains WebStorm.
 * User: xhrong
 * Date: 13-8-6
 * Time: 上午9:40
 * To change this template use File | Settings | File Templates.
 */
define(function (require, exports, module) {

    function BookLoader() {
        var _self = this;
        _self.buttons = {};
        _self.controls = {};
        _self._toBeUpdateBooksInfo = [];

        //下面这些是鼠标长按和短按的标志，有些已经用不到了
        var longMouseDownFlag = 0, _longMouseDownFlag = 0;
        var isclick = false, _isclick = false;
        var mouseY, originalTop, endY, mouseX;
        var _mouseY, _originalTop, _endY, _mouseX;
        var _flipPanelHeight = 83;
        var _allBookShelfHeight, _allBookListHeight;

        var num;

        var mouseDownAndUpTimer = null;
        var onMouseDownFlag = false;

        _self.setToBeUpdateBooks = function (booksInfo) {
            _self._toBeUpdateBooksInfo = booksInfo;
            console.log(_self._toBeUpdateBooksInfo);
            _self.loadBook();
        }

        _self.init = function (buttons, controls) {

            _self.buttons = buttons;
            _self.controls = controls;

            //缩略图模式拖动排序
            _self.controls.ctrBookInfoContentDiv.sortable({
                opacity: 0.5,
                delay: 0,
                helper: 'clone',
                distance:40,
                tolerance: "intersect",
                containment: "#bookInfoContent",
                disabled:true,
                scroll: true,
                start: function (event, ui) {
                    isclick = false;
                },
                stop: function (event, ui) {
                    //更新order
                    _self.controls.ctrBookInfoContentDiv.find('li').css({ opacity: 1 });
                    clearTimeout(mouseDownAndUpTimer); // 清除延迟时间
                    var books = $("#bookInfoContent li a");
                    var len = books.length ,num = 0;
                    var showlist = [];
                    for(var i= 0;i<len;i++){
                        showlist.push(books[i].getAttribute("BookCode"));
                    }
                    /*先保证界面显示正确*/
                    bookAccessor.changePosition(showlist);
                    /*sqlite驱动不支持多条语句一起执行*/
//                    var showlist = [];
//                    for(var i= 0;i<len;i++){
//                        showlist.push(books[i].getAttribute("BookCode"));
//                    }
//                    bookAccessor.updateShowOrderALot(showlist,ebookContext.getUser()).done(function(){
//                        console.log("updateOk");
//                        bookAccessor.initAllBookList(ebookContext.getUser());
//                    });

                    /*然后在后台慢慢更新数据*/
                    for (var i = 2; i < len + 2; i++) {
                        //i从2开始累加，故-2
                        var bookID = books[i - 2].getAttribute("BookCode");
                        //一直很怀疑这一块怎么并发执行成功的(数据库并发执行的效率是很低的)
                        bookAccessor.updateBooksOrder(bookID, i, ebookContext.getUser());
                    }
                }
            });

            _self.controls.ctrBookInfoContentDiv.disableSelection();
            //列表模式拖动排序
            _self.controls.ctrBooksListDiv.sortable({
                forcePlaceholderSize: true,
                placeholder: "ui-state-highlight",
                opacity: 0.6,
                delay: 0,
                cursor: "move",
                tolerance: "pointer",
                containment: "window",
                disabled:true,
                scroll: true,
                start: function (event, ui) {
                    _longMouseDownFlag = 2;
                    _isclick = false;
                },
                stop: function (event, ui) {
                    //更新order
                    var books = $("#bookslist dd");
                    var len = books.length ,num = 0;
                    var showlist = [];
                    for(var i= 0;i<len;i++){
                        showlist.push(books[i].getAttribute("BookCode"));
                    }
                    bookAccessor.changePosition(showlist);

                    for (var i = 2; i < len + 2; i++) {
                        var bookID = books[i - 2].getAttribute("BookCode");
                        bookAccessor.updateBooksOrder(bookID, i, ebookContext.getUser());
                    }
                }
            });
            _self.controls.ctrBooksListDiv.disableSelection();

            _self.controls.ctrBookCaseDiv.mousedown(function (e) {
                isclick = true;
                longMouseDownFlag = 1;
                mouseY = e.clientY;
                mouseX = e.clientX;
                //这儿会有问题 top 和 offsettop
                originalTop = _self.controls.ctrBookCaseDiv.offset().top;
                _allBookShelfHeight = _self.controls.ctrBookCaseDiv.height();

            });
            _self.controls.ctrBookCaseDiv.mousemove(function (e) {
                if (longMouseDownFlag == 2) {
                    //移动书
                    return;
                }
                if (longMouseDownFlag == 1) {
                    //移动书架
                    if ((e.clientY - mouseY > 20) || (e.clientY - mouseY < -20) || (e.clientX - mouseX > 20) || (e.clientX - mouseX < -20))isclick = false;

                    endY = _self.controls.ctrBookCaseDiv.scrollTop() - e.clientY + mouseY;
                    _self.controls.ctrBookCaseDiv.scrollTop(endY);
                }
            });
            _self.controls.ctrBookCaseDiv.mouseup(function () {
                longMouseDownFlag = 0;
                originalTop = endY;
            });
            _self.controls.ctrBookCaseDiv.mouseout(function () {
                longMouseDownFlag = 0;
                originalTop = endY;
            });

            _self.controls.ctrBookListOutSide.mousedown(function (e) {
                _isclick = true;
                _longMouseDownFlag = 1;
                _mouseY = e.clientY;
                _mouseX = e.clientX;
                _originalTop = _self.controls.ctrBookListAndListTopDiv.offset().top;
                _allBookListHeight = _self.controls.ctrBookListAndListTopDiv.height();

            });
            _self.controls.ctrBookListOutSide.mousemove(function (e) {
                if (_longMouseDownFlag == 2) {
                    //移动书
                    return;
                }
                if (_longMouseDownFlag == 1) {
                    //移动书架
                    if ((e.clientY - _mouseY > 20) || (e.clientX - _mouseX > 20) || (e.clientY - _mouseY < -20) || (e.clientX - _mouseX < -20))_isclick = false;
                    _endY = _self.controls.ctrBookListOutSide.scrollTop() - e.clientY + _mouseY;
                    //console.log(_endY);
                    _self.controls.ctrBookListOutSide.scrollTop(_endY);
                }
            });
            _self.controls.ctrBookListOutSide.mouseup(function () {
                _longMouseDownFlag = 0;
                _originalTop = _endY;
            });
            _self.controls.ctrBookListOutSide.mouseout(function () {
                _longMouseDownFlag = 0;
                _originalTop = _endY;
            });
        }

        /**
         *  分类加载书
         */
        _self.loadBook = function () {
            var def = $.Deferred();
            num = bookShelfStatus.getBookShowModel();
            switch (num) {
                case 1:
                    _self.loadAllBooks().done(function () {
                        def.resolve();
                    });
                    break;
                case 2:
                    _self.loadRecentBooks().done(function () {
                        def.resolve();
                    });
                    break;
                case 3:
                    _self.loadNewBooks().done(function () {
                        def.resolve();
                    });
                    break;
                case 4:
                    _self.loadBooksByGradeOrSection().done(function () {
                        def.resolve();
                    });
                    break;
            }
            return def.promise();
        }

        /**
         * 加载全部书本
         * @returns {*}
         */
        _self.loadAllBooks = function () {
            var def = $.Deferred();
            bookAccessor.getAllBooks(ebookContext.getUser()).done(function (res) {
                _self.drawBooks(res);
                def.resolve();
            });
            return def.promise();
        }

        /**
         * 加载新书
         * @returns {*}
         */
        _self.loadNewBooks = function () {
            var def = $.Deferred();
            bookAccessor.getNewBooks(ebookContext.getUser()).done(function (res) {
                //在新书全部被删除以后，单击“取消”返回以后，进入“全部书本”
                if(res.length<1){
                     bookShelfStatus.setNewFlag(false);
                    _self.buttons.btnAllBooks.trigger("click");
                    def.resolve();
                }
                else{
                    _self.drawBooks(res);
                    def.resolve();
                }
            });
            return def.promise();
        }

        /**
         * 根据年级册别筛选书
         * @returns {*}
         */
        _self.loadBooksByGradeOrSection = function () {
            var def = $.Deferred();
            bookAccessor.selectBookByGradeOrSection(bookShelfStatus.getSelectedSection(),
                bookShelfStatus.getSelectedGrade(), ebookContext.getUser()).done(function (res) {
                _self.drawBooks(res);
                def.resolve();
            });
            return def.promise();
        }

        /**
         * 加载最近使用的书
         * @returns {*}
         */
        _self.loadRecentBooks = function () {
            var def = $.Deferred();
            bookAccessor.getRecentBooks(ebookContext.getUser()).done(function (res) {
                _self.drawBooks(res);
                def.resolve();
            });
            return def.promise();
        }

        /**
         * 加载书逻辑
         * @param _bookArray
         */
        _self.drawBooks = function (_bookArray) {

            var _Uspan = '<span class="book_title">U盘文件</span>';

            var _YJspan = '<span class="book_title2">人教数字</span>';

            var _newBookThumb = (AppCfg.lang == "uyghur") ?  '<p><img src="assert/images/wy_new_book.png"></p>' : '<p><img src="assert/images/new_book.png"></p>';
            var _updateThumb = (AppCfg.lang == "uyghur") ?  '<p><img src="assert/images/wy_updatebook1.png"></p>' : '<p><img src="assert/images/updatebook1.png"></p>';

            if (bookShelfStatus.getThumbnailOrList() == 1) {
                //这两个标记是为了在单击“编辑”返回后按钮能正常
                bookShelfStatus.setUpdateFlag(false);
                var existnew = false;
                var existupdate = false;
                // 渲染页面
                var htmlText = [], h = -1;
                $.each(_bookArray, function () {
                    var title = this.title;
                    var bookCode = this.bookCode;
                    var lastPage = this.lastPage;
                    var isU = this.isU;
                    var isNew = this.isNew === '1';
                    var hasUpdate = false;
                    for (var i in _self._toBeUpdateBooksInfo) {
                        if (bookCode == _self._toBeUpdateBooksInfo[i].bookCode) {
                            hasUpdate = true;
                            break;
                        }
                    }
                    /*有新书，标记新书字段。反之，只有在“全部课本”和“新书”查不出新书时把标签置为false
                     *“新书”查不出新书，重置标签在loadNewBook方法中
                     *“新书”“更新”按钮一旦显示，在筛选书本时不可以被隐藏
                     */
                    if (isNew){
                        existnew = true;
                    }
                    if(hasUpdate){
                        existupdate = true;
                        bookShelfStatus.setUpdateFlag(true);
                    }
                    var imageUrl = this.thumbnail;
                    htmlText[++h] = _bookTemplate.replace('{{bookID}}', bookCode)
                        .replace('{{title}}', title)
                        .replace('{{lastPage}}', lastPage)
                        .replace('{{imageUrl}}', imageUrl)
                        .replace('{{isU}}',isU)
                        .replace('{{Uspan}}',isU ? ( isU == "RJ" ? _YJspan : _Uspan ): "")
                        .replace('{{newBook}}', hasUpdate ?_updateThumb:(isNew? _newBookThumb : ""));
                });
                htmlText[++h] = _addbookBtn;

                if (existnew){
                    bookShelfStatus.setNewFlag(true);
                }
                else{
                    if(bookShelfStatus.getBookShowModel() == 1){
                        bookShelfStatus.setNewFlag(false);
                    }
                }
                if (existupdate){
                    bookShelfStatus.setUpdateFlag(true);
                }
                else{
                    if(bookShelfStatus.getBookShowModel() == 1){
                        bookShelfStatus.setUpdateFlag(false);
                    }
                }

                /*根据新书字段，显示“新书”按钮，没有，不显示
                 *如果当前是“新书”模式，且新书显示，改变“新书”按钮样式
                 */
                if (bookShelfStatus.getNewFlag() && (bookShelfStatus.getReadOrSelect() == 1)){
                    if ((bookShelfStatus.getBookShowModel() == 3)) {
                        _self.buttons.btnNewBooks.removeClass("grain_normal").addClass("grain_pressed").css("display", "inline");
                    }
                    else {
                        _self.buttons.btnNewBooks.removeClass("grain_pressed").addClass("grain_normal").css("display", "inline");
                    }
                }
                else{
                    _self.buttons.btnNewBooks.css("display", "none");
                }
                if (bookShelfStatus.getUpdateFlag() && (bookShelfStatus.getReadOrSelect() == 1)) {
                    _self.buttons.btnBooksNeedUpdate.css("display", "inline");
                }

                var html = htmlText.join('');
                var bookElements = $(html);
                var $bfbs = bookElements.find('b');
                var $bffs = bookElements.find('font');
                (bookShelfStatus.getReadOrSelect() == 1) ? ($bfbs.hide()) : ($bfbs.show());
                (bookShelfStatus.getReadOrSelect() == 1) ? ($bffs.hide()) : ($bffs.show());

                // 注册事件 (暂时问题解决)
                bookElements.find('a').mouseup(function () {
                    var $this = $(this);
                    if (bookShelfStatus.getReadOrSelect() == 1) {
                        //移动书
                        if (!isclick) {
                            return;
                        }
                        longMouseDownFlag = 0;
                        isclick = false;
                        _self.goToIndex($this.attr("BookCode"),$this.attr("LastPage"),$this.attr("IsU"));
                    }
                    else if (bookShelfStatus.getReadOrSelect() == 2) {
                        //寻找font标签
                        var selectTag = $this.find('font');
                        var searcharea = $("a.bookthumbnail");
                        if (!selectTag.hasClass("cur_r")) {
                            selectTag.addClass("cur_r");
                            //判断是否存在没有选中的图标，显示“全选”或“不选”
                            var _all = true;
                            for (var i = 0; i < searcharea.length; i++) {
                                var flag = $(searcharea[i]).find('font').hasClass("cur_r");
                                if (!flag) {
                                    _all = false;
                                    break;
                                }
                            }
                            if (_all) {
                                _self.buttons.btnEditAllSelect.css("display", "none");
                                _self.buttons.btnEditNoSelect.css("display", "inline");
                            }
                        }
                        else {
                            selectTag.removeClass("cur_r");
                            //隐藏“不选”，显示全选
                            _self.buttons.btnEditAllSelect.css("display", "inline");
                            _self.buttons.btnEditNoSelect.css("display", "none");
                        }
                    }
                });
                //默认缩略图；
                bookElements.children().find('img').error(function () {
                    $(this).attr('src', './assert/images/book_touming.png');
                });

                bookElements.filter(".btn_add_book").click(function(){

                    $("#personalInfoPanel").hide();
                    $("#purchasedBooksPanel").hide();

                    app_global_bookLibMgr.showBookLibPanel();
                })

                _self.controls.ctrBookInfoContentDiv.empty().append(bookElements);

                //长按显示透明
                _self.controls.ctrBookInfoContentDiv.find('li').mousedown(function () {
                    if (bookShelfStatus.getReadOrSelect() == 2) {
                        return;
                    }
                    else {
                        var hereSelf = $(this);
                        onMouseDownFlag = false;
                        mouseDownAndUpTimer = setTimeout(function () {
                            // OnMouseDown Code in here
                            hereSelf.css({ opacity: 0.4 });
                            onMouseDownFlag = true;
                        }, 2500);
                    }
                }).mousemove(function () {
                        if (onMouseDownFlag) {
                            // OnMouseUp Code in here
                        } else {
                            clearTimeout(mouseDownAndUpTimer); // 清除延迟时间
                        }
                    }).mouseup(function () {
                        if (onMouseDownFlag) {
                            // OnMouseUp Code in here
                        } else {
                            clearTimeout(mouseDownAndUpTimer); // 清除延迟时间
                        }
                    });
            }
            else {
                /***
                 * 这块功能舍弃，暂时不再维护
                 *
                 * 没有维护“isU”  -----  by  yczhu 2014年10月9日19:14:40
                 */

//                if (bookShelfStatus.getShowFlipOrNot()) {
//                    _self.controls.ctrBookShowListDiv.css("top", _flipPanelHeight);
//                }
//                bookShelfStatus.setNewFlag(false);
//                bookShelfStatus.setUpdateFlag(false);
//                var htmlText = [], h = -1;
//                $.each(_bookArray, function () {
//                    var bookCode = this.bookCode;
//                    var lastPage = this.lastPage;
//                    var isNew = this.isNew === '1';
//                    var hasUpdate = false;
//                    for (var i in _self._toBeUpdateBooksInfo) {
//                        if (bookCode == _self._toBeUpdateBooksInfo[i].bookcode) {
//                            hasUpdate = true;
//                            break;
//                        }
//                    }
//                    if (isNew)bookShelfStatus.setNewFlag(true);
//                    if(hasUpdate) bookShelfStatus.setUpdateFlag(true);
//                    var thumbnail = this.thumbnail;
//                    var title = this.title;
//                    var subject = _BookItemMapping.parseSubject(this.subject);
//                    var grade = _BookItemMapping.parseGrades(this.grade);
//                    var volumn = _BookItemMapping.parseVolumn(this.volumn);
//                    var publisher = _BookItemMapping.parsePublisher(this.publisher);
//                    htmlText[++h] = '<li><dd BookCode="';
//                    htmlText[++h] = bookCode;
//                    htmlText[++h] = '" LastPage = "';
//                    htmlText[++h] = lastPage;
//                    htmlText[++h] = '" class="">';
//                    htmlText[++h] = _bookListItemTemplate.replace("{{thumbnail}}", thumbnail).replace('{{subject}}', subject).replace('{{grade}}', grade).replace('{{volumn}}', volumn).replace('{{publisher}}', publisher);
//                    htmlText[++h] = '</dd></li>'
//                })
//                var html = htmlText.join('');
//                var bookElement = $(html);
//                if (bookShelfStatus.getNewFlag() && (bookShelfStatus.getReadOrSelect() == 1)) {
//                    if ((bookShelfStatus.getBookShowModel() == 3)) {
//                        _self.buttons.btnNewBooks.removeClass("grain_normal").addClass("grain_pressed").css("display", "inline");
//                    }
//                    else {
//                        _self.buttons.btnNewBooks.removeClass("grain_pressed").addClass("grain_normal").css("display", "inline");
//                    }
//                }
//                if (bookShelfStatus.getUpdateFlag() && (bookShelfStatus.getReadOrSelect() == 1)) {
//                    _self.buttons.btnBooksNeedUpdate.css("display", "inline");
//                }
//                bookElement.find('dd').click(function () {
//                    if (bookShelfStatus.getReadOrSelect() == 1) {
//                        if (_isclick == false) {
//                            //移动书
//                            return;
//                        }
//                        _longMouseDownFlag = 0;
//                        _isclick = false;
//                        _self.goToIndex($(this).attr("BookCode"), $(this).attr("LastPage"));
//
//                    }
//                    else if (bookShelfStatus.getReadOrSelect() == 2) {
//                        var _hereSelf = $(this);
//                        if (_hereSelf.hasClass("unchecked")) {
//                            _hereSelf.removeClass("unchecked").addClass("checked");
//                            _hereSelf.find('input').removeClass("cb_unchecked").addClass("cb_checked");
//                            var _all = true;
//                            var _searcharea = _self.controls.ctrBooksListDiv.find('dd');
//                            for (var i = 0; i < _searcharea.length; i++) {
//                                if ($(_searcharea[i]).hasClass("unchecked")) {
//                                    _all = false;
//                                    break;
//                                }
//                            }
//                            if (_all) {
//                                _self.buttons.btnEditAllSelect.css("display", "none");
//                                _self.buttons.btnEditNoSelect.css("display", "inline");
//                            }
//                        }
//                        else if (_hereSelf.hasClass("checked")) {
//                            _hereSelf.removeClass("checked").addClass("unchecked");
//                            _hereSelf.find('input').removeClass("cb_checked").addClass("cb_unchecked");
//                            //隐藏“不选”，显示全选
//                            _self.buttons.btnEditAllSelect.css("display", "inline");
//                            _self.buttons.btnEditNoSelect.css("display", "none");
//                        }
//                    }
//                });
//                if (Config.Width < 1000) {
//                    bookElement.find('.w180').css("width", "120px");
//                    bookElement.find('.km').css("width", "110px");
//                }
//
//                bookElement.find('img').error(function () {
//                    $(this).attr('src', './assert/images/book.jpg');
//                });
//                _self.controls.ctrBookShowListDiv.find('#bookslist').empty();
//                _self.controls.ctrBookShowListDiv.find('#bookslist').append(bookElement);
            }
        }

        /**
         * 跳转到Index页面
         * @param bookCode
         */
        _self.goToIndex = function (bookCode, pageNum,isU) {
            //這里添加書本版權過期检测
            if (AppCfg.isShowVerify) {
                showLoading({tips: AppTips.DefaultLoadingTips});
            }
            if(isU){
                if(isU != "RJ"){
                    var _bookAccessor = require('./bookaccessor').Instance;
                    //TODO　：ｕ盘授权文件更新为本地授权，成功后执行ｅｌｓｅ部分，失败依旧执行这部分
                    var bookObj = $.extend({}, _bookAccessor.getBookInfoByCode(bookCode));
                    var hdInfoTask = _shellcmd.getHardwareInfo(ebookContext.getUser().getName());
                    var hdTypeTask = _shellcmd.getHardwareType();
                    $.when(hdInfoTask, hdTypeTask).done(function (hdInfo, hdType) {
                        _bookLicHelper.callGetBookLicense(bookObj.id,
                                bookCode, ebookContext.getUser(),
                                hdInfo,
                                hdType).done(function (bookLicResult) {
                                if (!bookLicResult) {
                                    console.log("下载书本授权文件失败");
                                    _shellcmd.checkU(isU,ebookContext.getUser().getName()).done(function(U){
                                        if(U){
                                            _bookLicHelper.checkULicOutDate(U,ebookContext.getUser().getName(),bookCode,isU).done(function(ret){
                                                console.log(ret);
                                                if(ret == 4){
                                                    _bookLicHelper.checkUBookOutdate(bookCode,isU,ebookContext.getUser()).done(function (isBookLicOutdate) {
                                                        hideLoading();
                                                        if (isBookLicOutdate) {  //如果过期
                                                            showTipsHere(AppTips.bookLicOutdateMsg);
                                                        } else {
                                                            _pageNavigatorHelper.goToIndex(bookCode, ebookContext.getUser(), pageNum,isU);
                                                        }
                                                    });
                                                }
                                                else if(ret == 3){
                                                    hideLoading();
                                                    showTipsHere(AppBookShelfTipsList.ULicOutDate);
                                                }
                                                else if(ret == -1){
                                                    hideLoading();
                                                    showTipsHere(AppBookShelfTipsList.ULicOutDate);
                                                }
                                            });
                                        }
                                        else{
                                            hideLoading();
                                            showTipsHere(AppTips.NotFindURight);
                                        }
                                    });
                                }else{
                                    _pageNavigatorHelper.goToIndex(bookCode, ebookContext.getUser(), pageNum,isU);
                                }
                            });
                    });



//                    _shellcmd.checkU(isU,ebookContext.getUser().getName()).done(function(U){
//                        if(U){
//                            _bookLicHelper.checkULicOutDate(U,ebookContext.getUser().getName(),bookCode,isU).done(function(ret){
//                                console.log(ret);
//                                if(ret == 4){
//                                    _bookLicHelper.checkUBookOutdate(bookCode,isU,ebookContext.getUser()).done(function (isBookLicOutdate) {
//                                        hideLoading();
//                                        if (isBookLicOutdate) {  //如果过期
//                                            showTipsHere(AppTips.bookLicOutdateMsg);
//                                        } else {
//                                            _pageNavigatorHelper.goToIndex(bookCode, ebookContext.getUser(), pageNum,isU);
//                                        }
//                                    });
//                                }
//                                else if(ret == 3){
//                                    hideLoading();
//                                    showTipsHere(AppBookShelfTipsList.ULicOutDate);
//                                }
//                                else if(ret == -1){
//                                    hideLoading();
//                                    showTipsHere(AppBookShelfTipsList.ULicOutDate);
//                                }
//                            });
//                        }
//                        else{
//                            hideLoading();
//                            showTipsHere(AppTips.NotFindURight);
//                        }
//                    });
                }
                else {
                    var username = ebookContext.getUser().getName();
                    openYJReader(username , bookCode);
                }
            }
            else{
                _bookLicHelper.checkBookOutdate(bookCode, ebookContext.getUser()).done(function (isBookLicOutdate) {
                    hideLoading();
                    if (isBookLicOutdate) {  //如果过期
                        showTipsHere(AppTips.bookLicOutdateMsg);
                    } else {
                        _pageNavigatorHelper.goToIndex(bookCode, ebookContext.getUser(), pageNum,isU);
                    }
                });
            }
        }
    }

    function showTipsHere(tips){
        $.Zebra_Dialog(tips, {
            'type': 'information',
            'title': AppTips.WarmTips,
            'buttons': [AppTips.OkTips]
        });
    }

    function openYJReader(username ,bookCode){
        hideLoading();
      //  alert("打开粤教云阅读器!");
        YJ_setReaderXml(username , bookCode).done(function(){
            var Bkplayerexe = Config.binPath +  'Bkplayer/Bkplayer.exe';
            _shellcmd.shellexecutewithargs(Bkplayerexe , "");
        });
    }

    function YJ_setReaderXml(username , bookId){
        var def = $.Deferred();
        var XmlContent = '';
        var XmlPath = Config.binPath + 'Bkplayer/params.xml';
        var cpuId = '';
        var workPath = Config.binPath + 'Bkplayer/win/';
        var command = 'cpuid.exe';
        _shellcmd.getCpuId(command , workPath).done(function(ret){
            ret = ret.replace('\n','')  ;//delphi 处理时多一个换行，交个JS处理
            ret = ret.trim();
            if (ret != ''){
                cpuId = ret;
                XmlContent = '<params cpuid=\"'+ cpuId + '\" username=\"'+username+'\" bookid=\"'+bookId+'\"/>';
                _shellcmd.rewriteReaderXml(XmlPath , XmlContent).done(function(ret){
                    def.resolve(ret);
                });
            }
        });
        return def.promise();
    }

    require('jquery');
    require('jquery_ui');
    require('../user');
    require('zebra_dialog');
    var bookShelfStatus = require('./bookshelfstatus').Instance;
    var bookAccessor = require('./bookaccessor').Instance;
    var _BookItemMapping = require('../../common/metadatamapping').Instance;
    var ebookContext = require('../ebookcontext').Instance;
    var userLog = require('../logmgr').Instance;
    var _bookLicHelper = require('./booklichelper');
    var _shellcmd = require('../../common/shellcmd');
    var _pageNavigatorHelper = require('../../common/pagenavigatorhelper');

    var _bookTemplate = '<li><a class="bookthumbnail" BookCode="{{bookID}}" LastPage="{{lastPage}}" IsU="{{isU}}" Title="{{title}}">'+
        '<img width="100px" height="140px" src="{{imageUrl}}">{{newBook}}' +
        '<font style="cursor:pointer;" class="right_btn" ></font>'+
        '<b><img class="delebookcss" src="assert/images/failure.png"></b>' +
        '{{Uspan}}</a></li>';
 //   var _selectedBookThumb = '<font><img src="assert/images/radio_btn2.png"></font>';

    var _bookListItemTemplate = '<p class="btn"><input type="button" value="" class="cb_checked" style="visibility: hidden"></p><p class="slt"><img src="{{thumbnail}}"></p><p class="km">{{subject}}</p><p class="w180">{{grade}}</p><p class="w180">{{volumn}}</p><p>{{publisher}}</p>';
    var _addbookBtn = '<li class="btn_add_book"></li>';

    exports.openYJReader = openYJReader;
    exports.Instance = new BookLoader;
});