/**
 * Created with JetBrains WebStorm.
 * User: xhrong
 * Date: 13-9-4
 * Time: 下午1:27
 * To change this template use File | Settings | File Templates.
 */

define(function (require, exports) {
    var _path = require('../../common/path');
    var _shellcmd = require('../../common/shellcmd');
    var loginAssistor = require("../login/loginAssistor");

    /**
     * 解析书本授权License下载结果
     * @param bookLicObj
     * @returns {boolean}
     * @private
     */
    function _handlerBookLicenseResult(statusCode, bookId) {
        switch (statusCode) {
            case 1:
                console.log("用户不存在");
                return false;
                break;
            case 2:
                console.log("用户未激活");
                return false;
                break;
            case 3:
                console.log("该硬件用户未绑定");
                return false;
                break;
            case 4:
                console.log("资源问题，资源不存在等");
                return false;
                break;
            case 5:
                console.log("请求参数非法");
                return false;
                break;
            case 6:
                console.log("获取授权文件失败 ,可能商务平台或者授权服务出现故障等");
                return false;
                break;
            case 0:
                console.log("获取授权文件请求处理成功");
                return true;
                break;
            default :
                console.log("如果授权服务不正常 license = null或者");
                var respJson = '{"evt":"downbooklicfail","data":{"bookid":"' + bookId + '"}}';
                console.log(respJson);
                dispatchClientMsg(respJson);
                return false;
                break;
        }
    }

    /**
     * 下载本书授权License
     * 获取书本授权信息请求处理
     * statuscode
     * 0=获取授权文件请求处理成功
     * 1=用户不存在
     * 2=用户未激活
     * 3=该硬件用户未绑定
     * 4=资源问题，资源不存在，资源未购买等
     * 5=请求参数非法
     * 6=获取授权文件失败 ,可能商务平台或者授权服务出现故障等
     * @param bookId
     * @param bookCode
     * @param user
     * @param hdInfo
     * @param hdType
     * @returns {{}}
     */
    function callGetBookLicense(bookId, bookCode, user, hdInfo, hdType) {
        var def = $.Deferred();
        var httpurl = AppRemoteSvcCfg.BookLicenseGetUrl;
        var savePath = _path.trimPosix(user.getBookLicenseFullPath(bookCode));
        _shellcmd.getBookLic(httpurl, bookId, user.getName(), hdInfo, hdType, savePath)
            .done(function (dataReceived) {
                console.log("get Lic StatusCode:" + dataReceived);
                var statusCode = parseInt(dataReceived);
                def.resolve(_handlerBookLicenseResult(statusCode, bookId));
            });
        return def.promise();
    }

    function getUDiskBookLicense(bookId, user, hdInfo, hdType, savePath) {
        var def = $.Deferred();
        var httpurl = AppRemoteSvcCfg.BookLicenseGetUrl;
        _shellcmd.getBookLic(httpurl, bookId, user.getName(), hdInfo, hdType, savePath)
            .done(function (dataReceived) {
                console.log("get Lic StatusCode:" + dataReceived);
                var statusCode = parseInt(dataReceived);
                def.resolve(_handlerBookLicenseResult(statusCode, bookId));
            });
        return def.promise();
    }

    /**
     * 检测书本是否过期
     * @param bookCode
     */
    function checkBookOutdate(bookCode, user) {
        var def = $.Deferred();
        user.getUserToken().done(function (token) {
            var licPath = _path.trimPosix(user.getBookLicenseFullPath(bookCode));
            var paramJson = {
                licpath: licPath,
                token: token,
                lickey: "TimeLine"
            };
            _shellcmd.getBookLicNode(JSON.stringify(paramJson)).done(function (data) {
                if (!data) {
                    def.resolve(false);
                } else {
                    var now = new Date();
                    var nowMon = (now.getMonth() + 1);
                    var nowday = now.getDate();
                    try {
                        var licData = Date.parse(data);
                        var nowDate = now.getFullYear() + '-' + (nowMon < 10 ? ('0' + nowMon) : nowMon) + '-' + (nowday < 10 ? ('0' + nowday) : nowday); //获取当前日期
                        var _nowDate = Date.parse(nowDate);
                        def.resolve(_nowDate > licData ? true : false);
                    } catch (e) {
                        def.resolve(false);
                    }
                }
            });
        });
        return def.promise();
    }

    function checkUBookOutdate(bookCode,isU,user) {
        var def = $.Deferred();
            var licPath = _path.trimPosix(user.getBookLicenseFullPath(bookCode));
            var paramJson = {
                licpath: licPath,
                token:  isU,
                lickey: "TimeLine"
            };
            _shellcmd.getBookLicNode(JSON.stringify(paramJson)).done(function (data) {
                if (!data) {
                    def.resolve(false);
                } else {
                    var now = new Date();
                    var nowMon = (now.getMonth() + 1);
                    var nowday = now.getDate();
                    try {
                        var licData = Date.parse(data);
                        var nowDate = now.getFullYear() + '-' + (nowMon < 10 ? ('0' + nowMon) : nowMon) + '-' + (nowday < 10 ? ('0' + nowday) : nowday); //获取当前日期
                        var _nowDate = Date.parse(nowDate);
                        def.resolve(_nowDate > licData ? true : false);
                    } catch (e) {
                        def.resolve(false);
                    }
                }
            });
        return def.promise();
    }

    function checkULicOutDate(U,account,bookCode,isU){
        var defer = $.Deferred();
        var dirBook = _path.join(_path.trimPosix(Config.binPath) , "users/" + account + "/ebook/" + bookCode + "/bookInfo.json");
        _shellcmd.readFileAsync(dirBook).done(function (str) {
            if (str) {
                var book = JSON.parse(str);
                _shellcmd.desDecrpty(book.datata, account).done(function (ret) {
                    loginAssistor.checkUAuthor(account, ret, isU, U).done(function (isValid) {
                        switch (isValid) {
                            case '-2':
                                defer.resolve(-2);
                                break;
                            case '-1':
                                defer.resolve(-1);
                                break;
                            case '0':
                                defer.resolve(0);
                                break;
                            case '1':
                                defer.resolve(1);
                                break;
                            case '2':
                                defer.resolve(2);
                                break;
                            case '3':
                                defer.resolve(3);
                                break;
                            case '4':
                                defer.resolve(4);
                                break;
                            default:
                                defer.resolve(5);
                        }
                    });
                });
            }
        });

        return defer.promise();
    }

    exports.callGetBookLicense = callGetBookLicense;
    exports.getUDiskBookLicense = getUDiskBookLicense;
    exports.checkBookOutdate = checkBookOutdate;
    exports.checkUBookOutdate = checkUBookOutdate;
    exports.checkULicOutDate = checkULicOutDate;
})
;
