/**
 * Created by pengfu on 14-10-8.
 */
;
define(function (require, exports, module) {
    var _shellcmd = require('../../../common/shellcmd');
    var md5helper = require('../../../common/md5helper');
    var _bookAccessor = require('../bookaccessor').Instance;
    var _bookLicHelper = require('../booklichelper');
    var _ebookContext = require('../../ebookcontext').Instance;
    var _path = require('../../../common/path');
    var _loginAssistor = require('../../../app/login/loginAssistor');
    var _bookExportSuccessMgr = require('./bookexportsuccess').Instance;

    function BookExportMgr() {
        var _this = this;
        _this._exportBookList = [];
        _this._uDiskArr = [];
        _this._currentUDisk = {};

        _this.exMtbk = false;

        _this.controls = {
            bookExportPanel: $('#bookExportPanel'),
            udiskList: $('#udiskList'),
            bookExportPanelTop: $('#bookExportPanelTop'),
            mobileDeviceId: $('#mobileDeviceId'),
            unbindLicence: $('#unbindLicence'),
            exMtbkPanel : $("#exMtbkPanel"),
            exBookPanel : $("#exBookPanel")
        };

        _this.buttons = {
            closeBtn_bookExportPanel: $('#closeBtn_bookExportPanel'),
            bookExportBtn: $('#bookExportBtn'),
            btn_removeBindLic: $('#btn_removeBindLic'),
            exMtbkOkBtn : $("#exMtbkOkBtn"),
            exMtbkNoBtn : $("#exMtbkNoBtn")
        };

        _this.init = function () {

            _this.controls.bookExportPanel.draggable({
                handle: "#" + _this.controls.bookExportPanelTop.attr("id"),
                containment: "parent",
                start: function () {
                },
                stop: function () {
                }
            });

            _this.buttons.closeBtn_bookExportPanel.click(function () {
                _this.hideBookExportPanel();
            });

            /**
             * 课本U盘导出
             */
            _this.buttons.bookExportBtn.click(function () {
                console.log('导出至U盘开始');
                //根据界面上选择相应的目标U盘
                var hasCheck = false;
                $.each(_this.controls.mobileDeviceId.find('input'), function () {
                    if (this.checked) {
                        var index = $(this).parent().parent().index();
                        _this._currentUDisk = _this._uDiskArr[index];
                        hasCheck = true;
                    }
                })

                if (!hasCheck) {
                    showAlertTips(AppTips.checkAtLeastOneU);
                    return;
                }

                var hdInfo = _this._currentUDisk.hdInfo,
                    hdType = _this._currentUDisk.hdType ,
                    hdName = _this._currentUDisk.hdName;
                var userLicDir = _this._currentUDisk.drive + ':/iflybook_books';
                var userName = _ebookContext.getUser().getName();

                showExBookRes(hdInfo, hdType, hdName, userLicDir, userName);
            });

            _this.buttons.btn_removeBindLic.click(function () {
                var removeRebindUrl = AppRemoteSvcCfg.RemoveRebindUrl + "&ticket=" + _ebookContext.getUser().getSSOTicket();

                _shellcmd.openPageOutside(removeRebindUrl);
            })

            _this.buttons.exMtbkOkBtn.click(function(){
                _this.exMtbk = true;
                _this.controls.exMtbkPanel.hide();
                _this.controls.exBookPanel.show();
            });

            _this.buttons.exMtbkNoBtn.click(function(){
                _this.exMtbk = false;
                _this.controls.exMtbkPanel.hide();
                _this.controls.exBookPanel.show();
            });

            //初始化导出成功面板
            _bookExportSuccessMgr.init();
        }

        /**
         * 读取U盘并显示在界面上
         */
        function getAndSetUDiskList() {
            //一个或者二个U盘显示模板
            var eachTpl, uTemplate = '<p><label for="{udiskId}"> <input type="radio" value="" name="move" id="{udiskId}">{displayName}</label></p>';
            //移动设备（G：）
            //调用江健提供的接口获取挂载的U盘列表
            _shellcmd.GetUpanList().done(function (list) {
                //渲染之前，先将U盘列表清空
                //将U盘列表塞往界面显示
                _this.controls.mobileDeviceId.empty();
                var uDiskObjs = [], uDiskObj = {};
                var tempStr = '';
                var tmpId = '';
                for (var i = 0, len = list.length; i < len; i++) {
                    tmpId = '' + i + new Date().getTime();
                    uDiskObj = {};
                    uDiskObj.drive = list[i][0];
                    uDiskObj.hdName = list[i][1];
                    uDiskObj.hdInfo = md5helper.hex_md5(list[i][2] + _ebookContext.getUser().getName());
                    uDiskObj.hdType = '1';//0:PC 1:移动设备
                    uDiskObjs.push(uDiskObj);
                    tempStr = uDiskObj.hdName + '（' + uDiskObj.drive + '：）';
                    eachTpl = uTemplate;
                    eachTpl = eachTpl.replace('{displayName}', tempStr)
                        .replace(/\{udiskId\}/g, tmpId);
                    _this.controls.mobileDeviceId.append(eachTpl);
                }
                _this._uDiskArr = uDiskObjs;
            });

        }

        /**
         * 显示导出面板
         */
        _this.showBookExportPanel = function (exportBookList) {
            _this._exportBookList = exportBookList;

            getAndSetUDiskList();

            //居中显示
            _this.controls.bookExportPanel.css({
                position: 'absolute',
                top: ($(window).height() - _this.controls.bookExportPanel.outerHeight()) / 2 + $(document).scrollTop()
            });

            //显示导出面板之前隐藏 解除绑定 的一行红字
            _this.controls.unbindLicence.hide();
            _this.controls.bookExportPanel.show();
            _this.controls.exMtbkPanel.show();
            _this.controls.exBookPanel.hide();

            _this.exMtbk = false;

        }

        /**
         * 关闭导出面板
         */
        _this.hideBookExportPanel = function () {
            _this.controls.bookExportPanel.hide();
        }

        /**
         * 根据U盘信息获取用户授权
         * @param hdInfo
         * @param hdType
         * @param hdName
         * @param userLicDir
         * @param userName
         * @returns {*}
         */
        function overWriteUserLic(hdInfo, hdType, hdName, userLicDir, userName) {
            var defer = $.Deferred();
            //调用该接口检查有没有绑定，没有绑定会帮助绑定
            _loginAssistor.callCheckBind(userName, hdInfo, hdType, hdName)
                .done(function (ret) {
                    console.log(ret);
                    if (!ret) {
                        //网络连接问题，返回""
                        showAlertTips(AppTips.exFailDueToNetWork);
                        return;
                    }
                    var retObj = JSON.parse(ret), statusCode = retObj.statuscode;
                    if (0 == statusCode) {
                        _this.hideBookExportPanel();
                        showLoading({tips: AppTips.handingExport});
                        getUserLic(hdInfo, hdType, userLicDir, userName).done(function (result) {
                            defer.resolve(result);
                        });
                    } else if (1 == statusCode) {
                        //授权已满
                        defer.resolve({EC: '1001'})
                    } else if (2 == statusCode) {
                        //该硬件授权已绑
                        //可以直接调用下载授权接口获取授权
                        _this.hideBookExportPanel();
                        showLoading({tips: AppTips.handingExport});
                        getUserLic(hdInfo, hdType, userLicDir, userName).done(function (result) {
                            defer.resolve(result);
                        });
                    } else if (3 == statusCode) {
                        //获取授权信息失败
                        _this.hideBookExportPanel();
                        showLoading({tips: AppTips.handingExport});
                        console.error('callCheckBind:获取授权信息失败');
                        defer.resolve({EC: '1002'});
                    }
                })
            return defer.promise();
        }

        /**
         * 获取用户授权
         * @param hdInfo
         * @param hdType
         * @param userLicDir
         * @param userName
         * @returns {*}
         */
        function getUserLic(hdInfo, hdType, userLicDir, userName) {
            var defer = $.Deferred();
            _loginAssistor.callGetNewUserLicense(_ebookContext.getUser(), hdInfo, hdType)
                .done(function (dataReceived) {
                    var retObj = _loginAssistor.userLicDataConverter(dataReceived);
                    if (retObj.statusCode == 0 && retObj.data) {
                        var userLicFullName = userLicDir + '/' + userName + '.dat';
                        if (_shellcmd.isDirExistSync(userLicDir)) {
                            _shellcmd.saveFile(retObj.data, userLicFullName);
                            defer.resolve({EC: '0'});
                        } else {
                            _shellcmd.createDir(userLicDir).done(function (ret) {
                                if (ret) {
                                    _shellcmd.saveFile(retObj.data, userLicFullName);
                                    defer.resolve({EC: '0'});
                                } else {
                                    defer.resolve({EC: '1004'})
                                }
                            })
                        }

                    } else {
                        defer.resolve({EC: '1003'});
                    }
                });
            return defer.promise();
        }

        /**
         * 导出一本或者多本书本
         * @param hdInfo
         * @param hdType
         * @returns {*}
         */
        function exMultiBooks(hdInfo, hdType) {
            var len = _this._exportBookList.length;
            var def = $.Deferred();
            var hereUser = _ebookContext.getUser();
            hereUser.getP().done(function (ret) {
                var username = hereUser.getUserName();
                var name = hereUser.getName();
                var stdBBPath = hereUser.getStdBookBasePath();
                var userdirpath = _path.trimPosix(hereUser.getUserBookBasePath());
                exBook(0, len, ret, hdInfo, hdType, username, name, stdBBPath,userdirpath).done(function (retbook) {
                    def.resolve(retbook);
                });
            })
            return def.promise();
        }

        function exBook(i, len, ret, hdInfo, hdType, userName, name, stdBBPath,userdirpath) {
            var def = $.Deferred();
            if (i >= len) {
                def.resolve({SC: '0'});
            } else {
                var bookCode = _this._exportBookList[i];
                //以下代码为什么写成$.extend，与处理的导入过程有关
                var bookObj = $.extend({}, _bookAccessor.getBookInfoByCode(bookCode));
                bookObj.isU = hdInfo;
                bookObj.datata = ret;
                bookObj.user_Name = userName;
                var bookId = bookObj.id;
                var tmpLongStr = bookCode + '_+_' + name + '_+_' + bookObj.title;
                var dir = _this._currentUDisk.drive + ':/iflybook_books/' + tmpLongStr + '/' + bookCode;
                var bookLicFullName = dir + '/' + bookCode + '.lic';
                var stdBookBasePath = stdBBPath;
                var book2src = stdBookBasePath + '/' + bookCode + '/' + bookCode + '.book2';
                var book2dst = dir + '/' + bookCode + '.book2';
                var thumbnailsrc = stdBookBasePath + '/' + bookCode + '/' + bookCode + '_Thumbnail.png';
                var thumbnaildst = dir + '/' + bookCode + '_Thumbnail.png';
                var userBookpath = userdirpath + "/" + bookCode;
                _shellcmd.isDirExist(dir).done(function (retdir) {
                    if (!retdir) {
                        _shellcmd.createDir(dir).done(function (result) {
                            if (result) {
                                copyBook2(bookObj, dir, bookId, hdInfo, hdType, bookLicFullName, book2src, book2dst,
                                    thumbnailsrc, thumbnaildst,userBookpath,userdirpath).done(function (retcopybook2) {
                                    if (retcopybook2.SC != 0) {
                                        def.resolve(retcopybook2);
                                    }
                                    else {
                                        exBook(++i,len, ret, hdInfo, hdType, userName, name, stdBBPath,userdirpath).done(function (reti) {
                                            def.resolve(reti);
                                        });
                                    }
                                });
                            }
                            else {
                                def.resolve({SC: '2001'});
                            }
                        })
                    }
                    else {
                        copyBook2(bookObj, dir, bookId, hdInfo, hdType, bookLicFullName, book2src, book2dst,
                            thumbnailsrc,thumbnaildst,userBookpath,userdirpath).done(function (retcopybook2) {
                            if (retcopybook2.SC != 0) {
                                def.resolve(retcopybook2);
                            }
                            else {
                                exBook(++i,len, ret, hdInfo, hdType, userName, name, stdBBPath,userdirpath).done(function (reti) {
                                    def.resolve(reti);
                                });
                            }
                        });
                    }
                });
            }
            return def.promise();
        }


        function copyBook2(bookObj, dir, bookId, hdInfo, hdType, bookLicFullName, book2src, book2dst,
                           thumbnailsrc,thumbnaildst,userbookpath,userdirpath) {
            var def = $.Deferred();
            //保存bookInfo.json ,这是个同步方法
            _shellcmd.saveFile(JSON.stringify(bookObj), _path.join(dir, 'bookInfo.json'))
            //获取书本授权
            _bookLicHelper.getUDiskBookLicense(bookId, _ebookContext.getUser(),
                    hdInfo, hdType, bookLicFullName).done(function (res) {
                    if (!res) {
                        def.resolve({SC: '2002'})
                    } else {
                        var task2 = _shellcmd.UcopyFile(_path.trimPosix(book2src), book2dst);
                        var task3 = _shellcmd.UcopyFile(_path.trimPosix(thumbnailsrc), thumbnaildst);
                        $.when(task2, task3).done(function (ret1, ret2) {
                            if (ret1.indexOf('系统找不到指定的路径') > -1 || ret2.indexOf('系统找不到指定的路径') > -1) {
                                def.resolve({SC: '2004'});
                            }
                            if (ret1.indexOf('磁盘空间不足') > -1 || ret2.indexOf('磁盘空间不足') > -1) {
                                def.resolve({SC: '2003'});
                            }
                            else{
                                if(_this.exMtbk){
                                        exMtbk(userbookpath,bookObj.bookCode,bookObj.bookCode,dir,userdirpath).done(function(){
                                        def.resolve({SC: '0'});
                                    });
                                }
                                else{
                                    def.resolve({SC: '0'});
                                }
                            }
                        })
                    }
                })
            return def.promise();
        }

        function exMtbk(userbookpath,bookCode,name,exportpos,userdirpath){
            var def = $.Deferred();
            _shellcmd.getAllFolderList(_path.trimPosix(userbookpath + "/")).done(function(list){
                //找到所有页面
                var args ={
                    exportpos : exportpos,
                    name : name,
                    rootdir:userdirpath,
                    bookcode : bookCode,
                    folders:list
                }
                _shellcmd.resExport(JSON.stringify(args)).done(function () {
                    def.resolve();
                });
            })

            return def.promise();
        }

        function showExBookRes(hdInfo, hdType, hdName, userLicDir, userName){
            //获取用户授权,成功后方进行后续书本导出工作
            overWriteUserLic(hdInfo, hdType, hdName, userLicDir, userName).done(function (result) {
                if (result.EC === '0') {
                    exMultiBooks(hdInfo, hdType).done(function (ret) {
                        if (ret.SC === '0') {
                            console.log('书本导出至U盘成功完成');
                            hideLoading();
                            _bookExportSuccessMgr.showBookExportSuccessPanel();
                        } else if (ret.SC === '2003') {
                            //U盘空间不足，导致的拷贝失败
                            console.error('磁盘空间不足');
                            hideLoading();
                            showAlertTips(AppTips.exBookFailNotEnoughSpace);
                        } else if (ret.SC === '2004') {
                            //可能U盘被拔出导致的拷贝失败
                            console.error('可能U盘被拔出');
                            hideLoading();
                            showAlertTips(AppTips.exBookFailUpanExtract);
                        }
                        else {
                            console.error('书本导出至U盘过程中失败,错误码：' + ret.SC);
                            hideLoading();
                            showAlertTips(AppTips.exBookFailed);
                        }
                    })
                } else if (result.EC === '1001') {
                    _this.controls.unbindLicence.show();

                } else {
                    console.error('重写用户授权过程中失败,错误码：' + result.EC);
                    hideLoading();
                    showAlertTips(AppTips.exBookFailed);
                }
            })
        }

    }

    exports.Instance = new BookExportMgr();

})