/**
 * Created with JetBrains WebStorm.
 * User: xhrong
 * Date: 13-9-17
 * Time: 下午2:04
 * To change this template use File | Settings | File Templates.
 */

define(function (require, exports) {
    var _path = require('../../common/path');
    var _shellcmd = require('../../common/shellcmd');
    var bookAccessor = require('./bookaccessor').Instance;
    var _bookLicHelper = require('./booklichelper');

    function updateBook(bookJson,user){
        var hdInfoTask = _shellcmd.getHardwareInfo(user.getName());
        var hdTypeTask = _shellcmd.getHardwareType();
        $.when(hdInfoTask, hdTypeTask).done(function (hdInfo, hdType) {

            _bookLicHelper.callGetBookLicense(bookJson.id,
                    bookJson.bookCode, user, hdInfo, hdType)
                .done(function (bookLicResult) {
                    if (!bookLicResult) {
                        console.log("下载书本授权文件失败");
                        return;
                    }
                    bookJson["sourcepage"] = "bookupdate";  //添加文件来源
                    bookJson["moreparam"] = "true";
                    var bookExtension = ".book2";
                    bookJson["filesavename"] = bookJson.bookCode + bookExtension;
                    var rawThumbnailUrl=   bookJson.thumbnail;
                    var temp=bookJson.thumbnail.indexOf('?');
                    if(temp>0){
                        rawThumbnailUrl=  bookJson.thumbnail.substring(0,temp);
                    }
                    var thumbnailExtension =rawThumbnailUrl.substring(rawThumbnailUrl.lastIndexOf('.'), rawThumbnailUrl.length);
                    bookJson["thumbnailsavename"] = bookJson.bookCode + '_Thumbnail' + thumbnailExtension;
                    bookJson["savepath"] = user.getStdBookRelativeBasePath() + '/' + bookJson.bookCode;  //文件保存路径
                    bookJson["dbpath"] = user.getUserDbFullPath();
                    var downloadRawData = JSON.stringify(bookJson);
                    _shellcmd.fileDownload(downloadRawData);
                });
        });
    }

    function downloadBook(bookJson,user) {
        var hdInfoTask = _shellcmd.getHardwareInfo(user.getName());
        var hdTypeTask = _shellcmd.getHardwareType();
        $.when(hdInfoTask, hdTypeTask).done(function (hdInfo, hdType) {
            _bookLicHelper.callGetBookLicense(bookJson.id,
                    bookJson.bookCode, user, hdInfo, hdType)
                .done(function (bookLicResult) {
                    if (!bookLicResult) {
                        console.log("下载书本授权文件失败");
                        return;
                    }
                    bookJson["sourcepage"] = "booklib";  //添加文件来源
                    bookJson["moreparam"] = "true";
                    var bookExtension = ".book2";
                    bookJson["filesavename"] = bookJson.bookCode + bookExtension;
                    var rawThumbnailUrl=   bookJson.thumbnail;
                    var temp=bookJson.thumbnail.indexOf('?');
                    if(temp>0){
                        rawThumbnailUrl=  bookJson.thumbnail.substring(0,temp);
                    }
                    var thumbnailExtension =rawThumbnailUrl.substring(rawThumbnailUrl.lastIndexOf('.'), rawThumbnailUrl.length);
                    bookJson["thumbnailsavename"] = bookJson.bookCode + '_Thumbnail' + thumbnailExtension;
                    bookJson["savepath"] = user.getStdBookRelativeBasePath() + '/' + bookJson.bookCode;  //文件保存路径
                    bookJson["dbpath"] = user.getUserDbFullPath();
                    var downloadRawData = JSON.stringify(bookJson);
                    _shellcmd.fileDownload(downloadRawData);
                });
        });
    }

    /**
     * 为书库返回本地书本信息
     * @returns {*}
     * @private
     */
    function prepareLocalBooksInfoForBookLib(user) {
        var def = $.Deferred();
        bookAccessor.getAllBooks(user).done(function (localBookList) {
            var localBookJson = [];
            for (var x in localBookList) {
                var localBookItemJson = {};
                localBookItemJson.id = localBookList[x].id;
                localBookItemJson.bookCode = localBookList[x].bookCode;
                localBookItemJson.mtbkId=localBookList[x].mtbkId;
                localBookJson.push(localBookItemJson);
            }
            var respJson = {};
            respJson.evt = "booklist_downloaded";
            respJson.data = localBookJson;
            var respJsonStr = JSON.stringify(respJson);
            def.resolve(respJsonStr);
        });
        return def.promise();
    }

    exports.prepareLocalBooksInfoForBookLib = prepareLocalBooksInfoForBookLib;
    exports.downloadBook=downloadBook;
    exports.updateBook=updateBook;
});


