/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-4
 * Time: 上午9:37
 * To change this template use File | Settings | File Templates.
 */
;
define(function (require, exports) {
    var WidgetBase = require("./widgetbase").WidgetBase;
    var WidgetImg = require("./widgetimg").WidgetImg;
    require('browserContext');
    var define = require('../../define');
    var path = require('../../../common/path');
    require('jqjson');
    var shellcmd = require('../../../common/shellcmd');
    var trace = require('../../trace').Instance;
    var actionType = require('../../trace').ActionType;
    var playerMgr = require('../hotspot/playerMgr').Instance;
    require('popover');

    function _getPro3dIcon(file) {
        var icon;
        var ext = path.extname(file).toLowerCase();
        var extFilter = define.extFilter.array;
        for (var i in extFilter.officeExtArray) {
            if (extFilter.officeExtArray.hasOwnProperty(i) && $.inArray(ext, extFilter.officeExtArray[i]) != -1) {
                icon = i + "_ic.png";
                break;
            }
        }
        if (!icon) {
            if ($.inArray(ext, extFilter.htmlExtArray) != -1)
                icon = "htm_ic.png";
            else if ($.inArray(ext, extFilter.execExtArray) != -1)
                icon = 'exe_ic.png';
            else icon = "default.png";
        }
        return icon;
    }

    function WidgetProc3d() {
    }

    WidgetProc3d.prototype = new WidgetBase();
    WidgetProc3d.prototype.constructor = WidgetProc3d;

    function WidgetProc3d(widgetType, obj) {
        var _this = this;
        this.WidgetType = widgetType;
        this.parse(obj);
        this.obj = obj;
        if (obj.file["src"] != undefined) {
            _this.File = obj.file["src"];
        }
        _this.realPath = obj.realPath || obj.file.realPath;
        _this.Title = obj.file["title"];
        //兼容新疆
//        if (_this.Title == undefined){
//            var titleUnit = _this.File.split('`');
//            var title='';
//            for(var i = 0 ;i < titleUnit.length ; i++){
//                title += String.fromCharCode(parseInt(titleUnit[i]));
//            }
//             _this.Title = title;
//        }
        _this.showTitleFlag = !!(obj.file["showTitleFlag"] == "true");
        _this.showIconFlag = !!(obj.file["showIconFlag"] == "true");
        _this.description = obj.file["description"] || "";
        _this.userName = obj.file["userName"] || "";
        _this.uploadTime = obj.file["uploadTime"] || "";
        _this.score = obj.file["score"] || 0;
        _this.userAddressInfo = obj.file["userAddressInfo"] || "";
        _this.resourceId = obj.file["resourceId"] || "";
        var icon = 'assert/images/bookicon/' + _getPro3dIcon(_this.File);
        var src = path.join(obj.XamlPath, '../' + _this.File);

        this.Content = this.getContent(icon, [this.Left, this.Top, this.Width, this.Height]);
        this.Content.click(function (event) {

            if (!_this.getIsEditing()) {
//                //查看的不是原物理路径，而是userBook文件夹下的文件
//                shellcmd.isFileExist(_this.realPath).done(function (ret) {
////                    var executePath = _this.realPath;
////                    if (!ret) executePath = src;
//                    var executePath = src;
//                    shellcmd.shellExecute(executePath);
//                    trace.log('ebook', actionType.OpenWidget, {cardId: _this.Id});
//                })
                _this.resourcePreview();
            }
            else {
                if ($(_this.Content.find(".user-popover")[1]).css("display") == "block")
                    $(_this.Content.find(".user-popover")[1]).hide();
                else {
                    $("#bookContainer").find(".user-popover").hide();
                    _this.Content.popover("show", "toolbar");
                }
            }
            event.stopPropagation();
        });
        this.Content.attr('id', _this.Id);
        this.src = src;
        this.attachOnDragEvent();
        this.setTitle();
        this.setPopover();
    }


    /**
     * 资源查看
     */
    WidgetProc3d.prototype.resourcePreview = function (event) {
        var _this = this;
        var obj = this.obj;
        var src = path.join(obj.XamlPath, '../' + _this.File);
        shellcmd.isFileExist(_this.realPath).done(function (ret) {
//            var executePath = _this.realPath;
//            if (!ret) executePath = src;
            var executePath = src;
            shellcmd.shellExecute(executePath);
            trace.log('ebook', actionType.OpenWidget, {cardId: _this.Id});
        })
//        event.stopPropagation();
    };

    /**
     * 资源编辑
     */
    WidgetProc3d.prototype.resourceEditor = function (event, mode) {
        var _this = this;
        var obj = this.obj;
        var src = path.join(obj.XamlPath, '../' + _this.File || _this.file.src);
        var executePath = src;
        if (mode == 'edit') {
            //  alert('mode');
            executePath = executePath + '| ';
        }
        shellcmd.shellExecute(executePath);
        trace.log('ebook', actionType.OpenWidget, {cardId: _this.Id});
        //   shellcmd.isFileExist(_this.realPath).done(function (ret) {
        //     var executePath = _this.realPath;
        //   if (!ret) executePath = src;
        //  if (mode == 'edit'){
        //  alert('mode');
        //     executePath = executePath + '| ';
        // }

        //   shellcmd.shellExecute(executePath);
        //     trace.log('ebook', actionType.OpenWidget, {cardId: _this.Id});
        //   })
        event.stopPropagation();
    };

//gallery
    WidgetProc3d.prototype.getToolBarContent = function (event) {
        var $content = WidgetImg.prototype.getToolBarContent.call(this);
        var _this = this;
        $content.find("#btnFullScreen").unbind().click(function () {
            _this.IsEditing = false;
            _this.Content.triggerHandler('click');
            _this.IsEditing = true;
            event.stopPropagation();
        });
        return $content;
    }

    WidgetProc3d.prototype.destroy = function (isDeleteSrc) {
        if (this.Content) {
            isDeleteSrc = isDeleteSrc == undefined ? true : isDeleteSrc;
            if (isDeleteSrc && this.src) {
                var dst = this.src.replace(/\//g, "\\");
                shellcmd.deleteFile(dst);
            }
            this.Content.remove();
            this.Content = null;
        }
    }

    WidgetProc3d.prototype.toXml = function () {
        var xmlResult = '\n<eb:';
        var widgetContent;
        widgetContent = '\n<file src= "{0}" uploadTime="{9}" score="{10}" userAddressInfo="{11}" resourceId="{12}" title="{1}" realPath="{2}" showTitleFlag="{3}" showIconFlag="{4}" description="{7}" userName="{8}" />\n<layout src="{5}" style="{6}"/>'
            .format(this.File, this.Title, this.realPath,
                (this.showTitleFlag === undefined) ? true : this.showTitleFlag,
                (this.showIconFlag === undefined) ? true : this.showIconFlag,
                this.layout.src, this.layout.style, this.description,
                this.userName, this.uploadTime, this.score, this.userAddressInfo, this.resourceId);

        var left = parseFloat(this.Content.css('left')), top = parseFloat(this.Content.css('top'));
        xmlResult += '{0} id="{1}" bound="{2};{3};{4};{5}" editable="{6}" style="{7}" '
            .format(this.WidgetType, this.Id, left, top, this.PlayAreaWidth, this.PlayAreaHeight, this.IsEditing, this.style.toString());

        xmlResult += 'type="' + this.type + '"';
        xmlResult += ">";
        xmlResult += widgetContent;
        xmlResult += "\n</eb:{0}>".format(this.WidgetType);
        return xmlResult;

        return xmlResult;

    }

    WidgetProc3d.prototype.setIsEditing = function (value) {
        this.IsEditing = value;
        !this.IsEditing ? this.Content.find("#resourceDelete").hide() : this.Content.find("#resourceDelete").show();
        !this.IsEditing ? this.Content.find("#resRDEdit").hide() : this.Content.find("#resRDEdit").show();

        this.showTitleSet();
        this.resourceIconHide();
    }

    /**
     * @param icon 资源图标
     * @param bound 定位
     * @returns {*|jQuery}
     */
    WidgetProc3d.prototype.getContent = function (icon, bound) {
        if (!icon || !bound) return;
        var Obj = this.getUnTransForm();
        var content = null;

        var extension = path.extname(this.File).toLowerCase();
        if(extension=='.doc'||extension=='.docx'||extension=='.txt'||extension=='.ppt'||extension=='.pptx'
            ||extension=='.xlsx'||extension=='.xls'||extension=='.pps'||extension=='.ppsx'){
            content = $("<div class='widgeticon' style='position: absolute;-webkit-transform:matrix(" +
                Obj.wZoom + ",0,0," + Obj.hZoom + ",0,0)'/>").css({
                    'top': bound[0] + 'px',
                    'left': bound[1] + 'px',
                    'width': bound[2] + 'px',
                    'height': bound[3] + 'px'
                }).append("<div class='fs_closed'  >" +
                    "<img  id='normal' src='" + icon + "' width='" + bound[2] + "' height='" + bound[3] + "'>" +
                    "<img  id='tiny'  src='assert/images/bookicon/ic_black.png'>" +
                    "<a id='resourceDelete' ></a>" +
                    "<div class='iconedit'><a id='resRDEdit' ></a></div></div>");
        }
        else{
            content = $("<div class='widgeticon' style='position: absolute;-webkit-transform:matrix(" +
                Obj.wZoom + ",0,0," + Obj.hZoom + ",0,0)'/>").css({
                    'top': bound[0] + 'px',
                    'left': bound[1] + 'px',
                    'width': bound[2] + 'px',
                    'height': bound[3] + 'px'
                }).append("<div class='fs_closed'  >" +
                    "<img  id='normal' src='" + icon + "' width='" + bound[2] + "' height='" + bound[3] + "'>" +
                    "<img  id='tiny'  src='assert/images/bookicon/ic_black.png'>" +
                    "<a id='resourceDelete' class='icondel'></a></div>");
        }

        (this.style && this.style.tiny !== 'true') ? (content.find("#tiny").hide()) : content.find("#normal").hide();

        return content;
    }


    exports.WidgetProc3d = WidgetProc3d;
});
