/**
 * Created with JetBrains WebStorm.
 * User: Administrator
 * Date: 14-7-4
 * Time: 上午9:36
 * To change this template use File | Settings | File Templates.
 */
;
define(function(require,exports){
    var WidgetBase = require("./widgetbase").WidgetBase;
    require('browserContext');
    var define = require('../../define');
    var path = require('../../../common/path');
    var ebookContext = require('../../ebookcontext').Instance;
    require('jqjson');
    var shellcmd = require('../../../common/shellcmd');
    var trace = require('../../trace').Instance;
    var playerMgr=require('../hotspot/playerMgr').Instance;
    require('popover');


    function _getOnlineResIcon(widgetType) {
        var icon;
        switch (widgetType) {
            case  define.OnlineResType.Dictionary:
                icon = "dic_ic.png";
                break;
            case define.OnlineResType.StrokeOrder:
                icon = "stroke_ic.png";
                break;
            case define.OnlineResType.VirtualExperiment:
                icon = "exp_ic.png";
                break;
            default :
                icon = "f_ic2.png"

        }
        return icon;
    }

    function WidgetOnlineResCard(widgetType, obj) {
        var _this = this;
        this.WidgetType = widgetType;
        this.parse(obj);

        this.type = obj.type;
        if (obj.file["src"] != undefined) {
            _this.File = obj.file["src"];
        }
        _this.Title = obj.file["title"];
        _this.showTitleFlag = !!(obj.file["showTitleFlag"] == "true");
        _this.showIconFlag = !!(obj.file["showIconFlag"] == "true");
        _this.description = obj.file["description"]||"";
        _this.userName = obj.file["userName"]||"";
        _this.uploadTime = obj.file["uploadTime"]||"";
        _this.score = obj.file["score"]|| 0 ;
        _this.userAddressInfo = obj.file["userAddressInfo"]||"";
        _this.resourceId = obj.file["resourceId"]||"";

        var icon = 'assert/images/bookicon/' + _getOnlineResIcon(obj.type);
        this.Content=this.getContent(icon,[this.Left,this.Top,this.Width,this.Height]);
        this.Content.click(function (event) {

            if (!_this.getIsEditing()) {
                shellcmd.checkOnline().done(function (isNetWorking) {
                    if (!isNetWorking) {
                        console.error(AppTips.NetWorkConnectFailed);
                        var tips = "";
                        if (!ebookContext.getUser().getIsOnline()) {
                            tips = AppTips.LocalLoignMsg;
                        } else {
                            tips = AppTips.NetWorkConnectFailed
                        }
                        $.Zebra_Dialog(tips, {
                            'type': 'information',
                            'title': AppTips.WarmTips,
                            'buttons': [ AppTips.OkTips]
                        });
                    }
                    else {
                        var onlineResCardUrl = AppRemoteSvcCfg.StrokeOrderAndVirLabPageUrl + "&u=" + _this.File;
                        if (_this.type == "dictionary") {
                            onlineResCardUrl = _this.File;
                            console.log(onlineResCardUrl);
                        }

                        shellcmd.checkUrlAccess(onlineResCardUrl).done(function (ret) {
                            if (ret) WidgetEvalCard.prototype.readCard.apply(_this, [onlineResCardUrl]);
                            else $.Zebra_Dialog(AppTips.RequestServerPageFailed, {
                                'type': 'information',
                                'title': AppTips.WarmTips,
                                'buttons': [ AppTips.OkTips]
                            });
                        });
                    }
                });
            }
            else  {
                if($(_this.Content.find(".user-popover")[1]).css("display")=="block")
                    $(_this.Content.find(".user-popover")[1]).hide();
                else{
                    $("#bookContainer").find(".user-popover").hide();
                    _this.Content.popover("show", "toolbar");
                }
            }
            event.stopPropagation();
        });
        this.Content.attr('id', _this.Id);
        this.src = _this.File;
        this.attachOnDragEvent();
        this.setPopover();
    }

    WidgetOnlineResCard.prototype = new WidgetBase();
    WidgetOnlineResCard.prototype.constructor = WidgetOnlineResCard;

    /**
     * 资源查看
     */
    WidgetOnlineResCard.prototype.resourcePreview = function(event){
        var _this = this;
            shellcmd.checkOnline().done(function (isNetWorking) {
                if (!isNetWorking) {
                    console.error(AppTips.NetWorkConnectFailed);
                    var tips = "";
                    if (!ebookContext.getUser().getIsOnline()) {
                        tips = AppTips.LocalLoignMsg;
                    } else {
                        tips = AppTips.NetWorkConnectFailed
                    }
                    $.Zebra_Dialog(tips, {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons': [ AppTips.OkTips]
                    });
                }
                else {
                    var onlineResCardUrl = AppRemoteSvcCfg.StrokeOrderAndVirLabPageUrl + "&u=" + _this.File;
                    if (_this.type == "dictionary") {
                        onlineResCardUrl = _this.File;
                        console.log(onlineResCardUrl);
                    }

                    shellcmd.checkUrlAccess(onlineResCardUrl).done(function (ret) {
                        if (ret) WidgetEvalCard.prototype.readCard.apply(_this, [onlineResCardUrl]);
                        else $.Zebra_Dialog(AppTips.RequestServerPageFailed, {
                            'type': 'information',
                            'title': AppTips.WarmTips,
                            'buttons': [ AppTips.OkTips]
                        });
                    });
                }
            });
//        event.stopPropagation();

    };
    /**
     * 资源编辑
     */
    WidgetOnlineResCard.prototype.resourceEditor = function(event){
        alert("当前资源不可编辑")
    };



    WidgetOnlineResCard.prototype.destroy=function(){
        if(this.Content){
            this.Content.remove();
            this.Content=null;
        }
    }

    WidgetOnlineResCard.prototype.toXml=function(){
        var xmlResult = '\n<eb:';
        var widgetContent;
        widgetContent = '\n<file src= "{0}" uploadTime="{8}" score="{9}" userAddressInfo="{10}" resourceId="{11}"  title="{1}" showTitleFlag="{2}" showIconFlag="{3}" description="{6}" userName="{7}" />\n<layout src="{4}" style="{5}" />'
            .format(this.File, this.Title ,
                (this.showTitleFlag === undefined) ? true : this.showTitleFlag ,
                (this.showIconFlag === undefined) ? true : this.showIconFlag,
                this.layout.src, this.layout.style,this.description,
                this.userName,this.uploadTime,this.score,this.userAddressInfo,this.resourceId);
        widgetContent += ' \n<event action="opened" style="zoomin_anim" />' +
            '\n<event action="closed" style="zoomout_anim" />';

        var left=parseFloat(this.Content.css('left')),top=parseFloat(this.Content.css('top'));
        xmlResult += '{0} id="{1}" bound="{2};{3};{4};{5}" editable="{6}" style="{7}" '
            .format(this.WidgetType, this.Id,left , top, this.PlayAreaWidth, this.PlayAreaHeight, this.IsEditing,this.style.toString());

        xmlResult += 'type="' + this.type + '"';
        xmlResult += ">";
        xmlResult += widgetContent;
        xmlResult += "\n</eb:{0}>".format(this.WidgetType);
        return xmlResult;
    }

    exports.WidgetOnlineResCard = WidgetOnlineResCard;
});
