/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-4
 * Time: 上午9:39
 * To change this template use File | Settings | File Templates.
 */
;define(function(require,exports){
    var WidgetBase = require("./widgetbase").WidgetBase;
    require('browserContext');
    var define = require('../../define');
    var path = require('../../../common/path');
    require('jqjson');
    var shellcmd = require('../../../common/shellcmd');
    var trace = require('../../trace').Instance;
    var playerMgr=require('../hotspot/playerMgr').Instance;
    var ebookContext = require('../../../app/ebookcontext').Instance;
    require('popover');

    //便签
    function WidgetNote() {

    }

    WidgetNote.prototype = new WidgetBase();
    WidgetNote.prototype.constructor = WidgetNote;
    WidgetNote.num = 0;//设置便签上的标题

    function WidgetNote(widgetType, obj) {
        var _this = this;

        _this.showTitleFlag = !!(obj.note["showTitleFlag"] == "true");
        _this.showIconFlag = !!(obj.note["showIconFlag"] == "true");

        this.Title = obj.note.title;
        if (this.Title == undefined) this.Title = AppNoteTips.note + (++WidgetNote.num);
        this.WidgetType = widgetType;
        this.parse(obj);
        if (obj.note["src"] != undefined) {
            _this.File = obj.note["src"];
        }
        else _this.File=this.Id+".note";
        var icon = 'assert/images/tool_note.png';
        var src = path.join(obj.XamlPath, '../' + _this.File);

        this.Content=this.getContent(icon,[this.Left,this.Top,this.Width,this.Height]);
        this.Content.click(function (event) {
            _this.NoteBox.show();
            //trace.log('ebook', actionType.OpenWidget, {cardId: _this.Id});
            event.stopPropagation();
        });
        this.Content.attr('id', _this.Id);
        this.src = src;
        this.NoteBox = new NoteBox(this);
        this.attachOnDragEvent();
        this.setTitle();
        this.setPopover();
        this._bindCommands(obj);
    }

    WidgetNote.prototype.resourcePreview = function(){
        var _this = this;
        _this.NoteBox.show();
    }

    WidgetNote.prototype.getToolBarContent=function(){
        return null;
    }

    WidgetNote.prototype._bindCommands=function(obj){
        var _self=this;
        this.Content.bind('reposition',function(event,pos){
            _self.NoteBox.hide();
            if (pos) _self.NoteBox.reposition(pos); //在拖动过程中重-新计算便签位置防止其超出边界
            event.stopPropagation();
        });
        this.Content.one('pageLoaded',function(){
            obj.insertFromOuter&&_self.NoteBox.show(true);
        })
    }

    WidgetNote.prototype.setIsEditing=function(value){
        this.NoteBox.setIsEditing(value);

//        if(this.IsEditing===value) return;
        this.IsEditing = value;
        !this.IsEditing ? this.Content.find("#resourceDelete").hide() : this.Content.find("#resourceDelete").show();
        if (value) {
            this.Content.popover('show', 'title');
        }
        else {
            this.Content.popover('hide');
        }
    }

    WidgetNote.prototype.destroy=function(isDeleteSrc){
        if(this.Content){
            isDeleteSrc = isDeleteSrc == undefined ? true : isDeleteSrc;
            if (isDeleteSrc && this.src) {
                var dst = this.src.replace(/\//g, "\\");
                shellcmd.deleteFile(dst);
            }
            this.Content.remove();
            this.Content=null;
            this.releaseRes();
        }
    }

    WidgetNote.prototype.toXml=function(){
        var xmlResult = '\n<eb:';
        var widgetContent;
        widgetContent = '\n<note src= "{0}" title="{1}" />\n<layout src="{2}" style="{3}" />'
            .format(this.File, this.Title, this.layout.src, this.layout.style);
        widgetContent += ' \n<event action="opened" style="zoomin_anim" />' +
            '\n<event action="closed" style="zoomout_anim" />';

        var left=parseFloat(this.Content.css('left')),top=parseFloat(this.Content.css('top'));
        xmlResult += '{0} id="{1}" bound="{2};{3};{4};{5}" editable="{6}" style="{7}" '
            .format(this.WidgetType, this.Id,left , top, this.PlayAreaWidth, this.PlayAreaHeight, this.IsEditing,this.style.toString());

        xmlResult += ">";
        xmlResult += widgetContent;
        xmlResult += "\n</eb:{0}>".format(this.WidgetType);

        return xmlResult;
    }

    WidgetNote.prototype.hide=function(){
        this.NoteBox.hide();
    }

    WidgetNote.prototype.releaseRes=function(){
        if(this.NoteBox){
            this.NoteBox&&this.NoteBox.destroy();
            this.NoteBox=null;
        }
    }

    /**
     *便签
     * @param {object.<WidgetNote>} parent
     * @constructor
     */
    function NoteBox(parent) {
        this.parent = parent;
        this.isShow = false;
        this.hasInit = false;
    }

    NoteBox.prototype._bindCommands = function () {
        var _self = this;
        var $noteBox = this._content;
        $noteBox.click(function () {
            event.stopPropagation();
        })

        $noteBox.find("#delete").click(function () {
            var pageItem=_self.parent.Content.data('pagedata');
            pageItem&&pageItem.trigger("widgetDeleted", [_self.parent.Id]);
            event.stopPropagation();
        });

        $noteBox.find("#packUp").click(function () {
            _self.show(false);
            event.stopPropagation();
        });

        $noteBox.find(".notes_tab")[0].addEventListener("input", function () {
            var $this = $(this);
            if ($this.val().length >= 14) $this.val($this.val().substr(0, 14));

            _self.parent.Title = $this.val();
            _self.parent.isModify = true;
            event.stopPropagation();
        }, false);

        setTimeout(function () {
            var $noteEdit = _self._content.find(".notes_edit");
            var previousContent = "";

            if ((previousContent = shellcmd.readFile(_self.parent.src)))
                $noteEdit.val(previousContent);

            $noteEdit.blur(function () {            //失去焦点保存文件
                var currentContent = $noteEdit.val().trim();
                if (currentContent != previousContent) {
                    previousContent = currentContent;
                    shellcmd.saveFile($noteEdit.val(), _self.parent.src);
                }
                event.stopPropagation();
            });
        }, 1000);

        //防止在选择文本时产生滑动事件
        $noteBox.on('mousedown',function(){
            event.stopPropagation();
        });

    }

    /**
     * @param {boolean=} isShow
     */

    NoteBox.prototype.show = function (isShow) {
        if (isShow !== undefined) this.isShow = isShow;
        else this.isShow = !this.isShow;
        this.hasInit = false;
        var display = !this._content || this._content.css('display') === 'none';
        if (display) this.isShow = true;
        else  this.isShow = false;
        if (this.isShow) {
            var pageItem=this.parent.Content.data('pagedata');
            pageItem&&pageItem.trigger("hideAllNote");
            this.isShow=true;
            this.init();
            this.reposition();
            this.setIsEditing(this.parent.getIsEditing());
            this._content.show();
        }
        else {
            this.hide();
            this.parent.Content.popover("content", this.parent.getTitleContent(), "title");
            if (this.parent.getIsEditing()) this.parent.Content.popover("show");
        }
    }

    NoteBox.prototype.hide = function () {
        if (!this._content) return;
        this._content.hide();
        this.isShow = false;
    }

    /**
     * 重新计算便签弹出框的位置
     * @param {Array=} pos
     */
    NoteBox.prototype.reposition = function (pos) {

        if (!this.isShow) return;
        var parentContent= this.parent.Content,obj=parentContent.parent();
        var maxLeft = obj.width(),maxTop = obj.height(),currentLeft,currentTop;
        if(!pos) currentLeft = parseFloat(parentContent.css("left")),currentTop = parseFloat(parentContent.css("top"));
        else  currentLeft = pos[0],currentTop = pos[1];


        var leftOffset = currentLeft + this.parent.Width , offsetX = 10, offsetY = 0;
        if (this.matrixTransform[0] > 1) leftOffset += (this.matrixTransform[0] - 1) * this.parent.Width + offsetX;
        var topOffset = currentTop;
        if (this.matrixTransform[3] > 1) offsetY = (this.matrixTransform[3] - 1) * this.parent.Height;

        var actualWidth = this._content.outerWidth() * this.matrixTransform[0],
            actualHeight = this._content.outerHeight() * this.matrixTransform[3];

        if (leftOffset + actualWidth > maxLeft ) {
            leftOffset = currentLeft - actualWidth - offsetX+10;
            var containerWidth = parseInt($("#bookContainer").css("width"));
            if (containerWidth <1400) {
                leftOffset = currentLeft - actualWidth - offsetX+50;
            }
            if (containerWidth >1600) {
                leftOffset = currentLeft - actualWidth - offsetX-50;
            }
        }


        if(app_global_bookContainer.getPageViewType()=="3"||app_global_bookContainer.getPageViewType()=="4"){
            if(currentLeft + actualWidth > maxLeft)  leftOffset = leftOffset-100;
            else leftOffset = leftOffset-50;
        }
        if (currentTop + actualHeight > maxTop) {
            topOffset = currentTop - actualHeight + offsetY + this.parent.Height;
        }
        if(app_global_bookContainer.getPageViewType()=="4"){
            topOffset = topOffset-100;
        }
        this._content.css({'position': "absolute", 'left': leftOffset, "top": topOffset});
        if(app_global_bookContainer.getPageViewType()=="3"||app_global_bookContainer.getPageViewType()=="4"){
            this._content.css("-webkit-transform","matrix(0.7,0,0,0.7,0,0)");
        }
//        correctToBaseResolution(this._content, { scaleOrder: false, keepScale: true, width: page_base_resolution.width, height: page_base_resolution.height, scaleFromCenter: false});
    }

    NoteBox.prototype.init = function () {
        if (!this.hasInit) {

            var _self = this;
            this._content = (function () {
                var $noteBox=$(document.getElementById("template_note").innerHTML);
                if(AppCfg.lang == "uyghur"){
                    $noteBox.find(".notes_btn input").css("width","120px");
                };
                $noteBox.find("#delete").val(AppNoteTips.del);
                $noteBox.find("#packUp").val(AppNoteTips.packup);
                $noteBox.find(".notes_tab").val(_self.parent.Title);
//                console.log(_self.parent.Content.parent())
                _self.parent.Content.parent().append($noteBox);
                return $noteBox;
            })();

            this._bindCommands();
            this.hasInit = true;
            this.matrixTransform = this.parent.getTransformMatrix(this.parent.Content);
//            console.log(this.matrixTransform)
        }
    }

    NoteBox.prototype.setIsEditing = function (value) {

        this.init();
        if (!value) {
            this.hide();
            this._content.find(".notes_btn").hide();
            this._content.find(".notes_edit").attr("disabled", true);
            this._content.find(".notes_tab").attr("disabled", true);
        }
        else {
            this._content.find(".notes_btn").show();
            this._content.find(".notes_edit").attr("disabled", false);
            this._content.find(".notes_tab").attr("disabled", false);
        }
    }

    NoteBox.prototype.destroy = function () {
        if(this._content){
            this._content && this._content.remove();
            this.parent = this._content = null;
        }
    }


    exports.WidgetNote = WidgetNote;
});

