/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-9-16
 * Time: 下午5:18
 * To change this template use File | Settings | File Templates.
 */
;
define(function(require,exports){

    var WidgetBase = require("./widgetbase").WidgetBase;
    var path = require('../../../common/path');
    var ResizeableAndDraggableBound=require('../../../common/resizeableAndDraggableBound');
    var shellcmd = require('../../../common/shellcmd');

    function WidgetImgPaint(widgetType, obj){

        var _self = this;
        _self.WidgetType = widgetType;
        _self.parse(obj);

        //幕布图片
        if (obj.imgPaint){
            _self.src = path.trimPosix(path.join(obj.XamlPath, '../' + path.basename(obj.imgPaint.src)));
            _self.imgsrc = obj.imgPaint.src;
        }
        else{
            _self.src = _self.imgsrc = "";
        }

        _self.showTitleFlag = !!(obj.imgPaint["showTitleFlag"] == "true");
        _self.showIconFlag = !!(obj.imgPaint["showIconFlag"] == "true");
        _self.description = obj.imgPaint["description"]||"";
        _self.userName = obj.imgPaint["userName"]||"";
        _self.uploadTime = obj.imgPaint["uploadTime"]||"";
        _self.score = obj.imgPaint["score"]|| 0 ;
        _self.userAddressInfo = obj.imgPaint["userAddressInfo"]||"";
        _self.resourceId = obj.imgPaint["resourceId"]||"";
        _self.Content = null;
        _self._rect = null;

        _self.paintFile = path.trimPosix(path.join(obj.XamlPath, '../' + _self.Id + ".dat"));

        if (_self.style.isShow === undefined) _self.style.isShow = 'true';
        _self.Content = $(document.getElementById('template_imgPaint').innerHTML);
        _self.canvas =  _self.Content.find(".canPaintCan");
        _self.canvasCtx = _self.canvas[0].getContext('2d');
        _self.Content.attr('id', _self.Id).css('z-index', 1);
        _self.Content.one('pageLoaded', function () {
            _self.addToBook();
            _self.hideBound();
        });

    }

    WidgetImgPaint.prototype = new WidgetBase();
    WidgetImgPaint.prototype.constructor = WidgetImgPaint;

    WidgetImgPaint.prototype.addToBook = function () {
        var _self = this;
        _self._rect = new ResizeableAndDraggableBound({
            left: _self.Left,
            top: _self.Top,
            minWidth: 30,
            minHeight: 30,
            content: _self.Content,
            container: _self.Content.parent(),
            draggable: false //不使用自身的drag，使用html5的drag
        });
        //加载背景图
        var innerImage = _self.Content.find("#imgPaintImg");
        innerImage.attr("src",_self.src);


        _self._bindCommands();
        _self.attachOnDragEvent();

        _self.Content.find('.user-popover').css('-webkit-transform', 'matrix(' + _self.getTransformMatrix(_self.Content).join(',') + ')');
        _self.Content.css('-webkit-transform', 'matrix(1,0,0,1,0,0)');
        _self._rect.show({width: _self.PlayAreaWidth, height: _self.PlayAreaHeight});
        _self.Content.find("#imgPaintDiv").css("width",_self.PlayAreaWidth).css("height", _self.PlayAreaHeight);
        _self.canvas.attr("width",_self.PlayAreaWidth).attr("height", _self.PlayAreaHeight);
        //加载笔迹
        _self.getPaint();
    }

    WidgetImgPaint.prototype._bindCommands = function () {
        var _self = this;

        _self._rect.bind(_self.Content, 'resizeStart', function () {
            _self.isModify = true;

            var strokeBase64 = _self.canvas[0].toDataURL();
            shellcmd.saveFile(strokeBase64, _self.paintFile);
        });

        _self._rect.bind(_self.Content, 'resize', function (event, bound) {
            _self.isModify = true;
            _self.PlayAreaWidth = bound.width;
            _self.PlayAreaHeight = bound.height;

            _self.Content.find("#imgPaintDiv").css("width",bound.width).css("height",bound.height);
            _self.canvas.attr("width",bound.width).attr("height",bound.height);
            _self.getPaint();
//            var strokeFileExist = shellcmd.isFileExistSync(_self.paintFile);
//            if (strokeFileExist) {
//                var strokeBase64 = shellcmd.readFile(_self.paintFile);
//                var image = new Image();
//                image.src = strokeBase64;
//                image.onload = function () {
//                    _self.canvasCtx.clearRect(0, 0, bound.width,bound.height);
//                    //拉伸绘制
//                    _self.canvasCtx.drawImage(image, 0, 0,bound.width,bound.height);
//                }
//            };
        });

        _self.Content.find("#resDel").bind("click",function(e){
            var pageItem  = _self.Content.data("pagedata");
            pageItem && pageItem.trigger("widgetDeleted",[_self.Id]);
            e.stopPropagation();
            return false;
        });
    }

    WidgetImgPaint.prototype.setIsEditing = function (value) {
        if (value == this.IsEditing) return;
        this.IsEditing = value;
        var _self = this;
        if (this.IsEditing) {
            // Caution :
            // 不要在这里做保存笔迹的操作
            // 重新加载页面的时候，会做title正位的操作
            // 而为了做title正位的操作，会调用 setIsEditing 方法
            // 如果在这里保存，将会清空上次的笔迹

            this.canvas.hide();
            this.Content.find('#btnRestore').prop('checked', (this.style.isShow !== 'false' ? true : false));
            this.Content.find('.resizeCorner').show();
            this.Content.show();
            this._rect && this._rect.setOptions({
                resizable: true
            });
        }
        else {
            this.canvas.show();
            this.hideBound();
        }
        this.resourceIconHide();
    }

    /**
     * 图标隐藏
     */
    WidgetImgPaint.prototype.resourceIconHide  = function(){
        var _self = this;
        this.showIconFlag ?_self.style.tiny = 'true':_self.style.tiny = 'false';
        //当前图标显示
        if ( _self.style.tiny === 'true') {
            _self.style.isShow = 'true';
            _self.Content.find("img").css('opacity','1');
        }
        //当前图标隐藏
        else{
            if(this.IsEditing&&$("#editorflag").css("display")=="block"){
                this.showIconFlag=true;
                _self.style.isShow = 'true';
                _self.Content.find("img").css('opacity','1');
            }else{
                //   _self.style.isShow = 'true';
                //      _self.Content.fadeOut(500);
            }
        }
        _self.isModify = true;

        !this.showIconFlag ?  $(_self.Content.find("a[name='resourceItem']")[0]).attr("title","图标隐藏")
            :$(this.Content.find("a[name='resourceItem']")[0]).attr("title","图标显示");
        !this.showIconFlag ?  $(_self.Content.find("a[name='resourceItem']")[0]).text("图标隐藏")
            :$(this.Content.find("a[name='resourceItem']")[0]).text("图标显示");

    }

    WidgetImgPaint.prototype.hideBound = function () {
        if (this.style.isShow === 'false') this.Content.hide();
        else  this.Content.find('.resizeCorner').hide();
        this._rect && this._rect.setOptions({
            resizable: false
        });
    }

    /**
     /**
     * 删除widget
     * @param {boolean=} isDeleteSrc 是否删除源文件
     */
    WidgetImgPaint.prototype.destroy=function(isDeleteSrc){
        if(this.Content){
            isDeleteSrc = isDeleteSrc == undefined ? true : isDeleteSrc;
            if (isDeleteSrc && this.src) {
                var dst = this.src.replace(/\//g, "\\");
                shellcmd.deleteFile(dst);
            }
            this.Content.remove();
            this.Content=null;
        }
    }

    WidgetImgPaint.prototype.toXml=function(){

        var _self = this;
        _self.setPaint();

        var xmlResult = '\n<eb:';
        var widgetContent;
        widgetContent = '\n<imgPaint src= "{0}"  uploadTime="{8}" score="{9}" userAddressInfo="{10}" resourceId="{11}"  title="{1}" showTitleFlag="{2}" showIconFlag="{3}" description="{6}" userName="{7}" />\n<layout src="{4}" style="{5}" />'
            .format(this.src, this.Title ,
                (this.showTitleFlag === undefined) ? true : this.showTitleFlag ,
                (this.showIconFlag === undefined) ? true : this.showIconFlag,
                this.layout.src, this.layout.style,this.description,this.userName,this.uploadTime,this.score,this.userAddressInfo,this.resourceId);

        widgetContent += ' \n<event action="opened" style="zoomin_anim" />' +
            '\n<event action="closed" style="zoomout_anim" />';

        var left = parseFloat(this.Content.css('left')),top=parseFloat(this.Content.css('top'));
        xmlResult += '{0} id="{1}" bound="{2};{3};{4};{5}" editable="{6}" style="{7}" '
            .format(this.WidgetType, this.Id,left , top, this.PlayAreaWidth, this.PlayAreaHeight, this.IsEditing,this.style.toString());

        xmlResult += ">";
        xmlResult += widgetContent;
        xmlResult += "\n</eb:{0}>".format(this.WidgetType);
        return xmlResult;
    }

    /**
     * 保存画布笔迹
     */
    WidgetImgPaint.prototype.setPaint = function(){
        var strokeBase64 = this.canvas[0].toDataURL();
        shellcmd.saveFile(strokeBase64, this.paintFile);
    }

    /**
     * 绘制画布笔迹
     */
    WidgetImgPaint.prototype.getPaint = function(){
        var _self = this;
        var strokeFileExist = shellcmd.isFileExistSync(_self.paintFile);
        if (strokeFileExist) {
            var strokeBase64 = shellcmd.readFile(_self.paintFile);
            var image = new Image();
            image.src = strokeBase64;
            image.onload = function () {
                _self.canvasCtx.clearRect(0, 0, _self.PlayAreaWidth, _self.PlayAreaHeight);
                //拉伸绘制
                _self.canvasCtx.drawImage(image, 0, 0,_self.PlayAreaWidth, _self.PlayAreaHeight);
            }
        };
    }

    exports.WidgetImgPaint = WidgetImgPaint;
});
