/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-9-16
 * Time: 下午5:18
 * To change this template use File | Settings | File Templates.
 */
;
define(function(require,exports){

    var WidgetBase = require("./widgetbase").WidgetBase;
    var CardWrapper = require('../../../app/card/cardwrapper').Instance;
    var path = require('../../../common/path');
    var shellcmd = require('../../../common/shellcmd');
    function WidgetICW(widgetType, obj){
        var _this = this;
        this.WidgetType = widgetType;
        this.parse(obj);
        (obj.icw["src"]) && (_this.File = obj.icw["src"]);
        _this.Title = obj.icw["title"];
        _this.showTitleFlag = !!(obj.icw["showTitleFlag"] == "true");
        _this.showIconFlag = !!(obj.icw["showIconFlag"] == "true");
        _this.description = obj.icw["description"]||"";
        _this.userName = obj.icw["userName"]||"";
        _this.uploadTime = obj.icw["uploadTime"]||"";
        _this.score = obj.icw["score"]|| 0 ;
        _this.userAddressInfo = obj.icw["userAddressInfo"]||"";
        _this.resourceId = obj.icw["resourceId"]||"";
        var src = path.join(obj.XamlPath, '../' + path.basename(_this.File,".icw"));

        _this.src = src;

        this.Content=this.getContent('assert/images/bookicon/ic_icw.png',[this.Left,this.Top,this.Width,this.Height]);

        /**
         * 完成状态下打开
         */
        this.Content.click(function (event) {
            if (!_this.getIsEditing()) {
//                var localresUrl = Config.binPath + "slideapp/main/player.html?package="+src;
//                var innerObj = $('<div>').append($('<iframe src="' + localresUrl + '">').css({
//                    'width': (Config.Width - 100) + "px",
//                    'height': Config.Height,
//                    'verticalAlign': 'middle'
//                }));
//                var actualHeight=Math.min($(document).height(),Config["Height"]);
//                innerObj.css({textAlign: 'center', lineHeight: actualHeight + 'px'});
//                setTimeout(function(){CardWrapper.show(innerObj[0], _this.Id, true);},1000);
                _this.resourcePreview();

            }
            else  {
                if($(_this.Content.find(".user-popover")[1]).css("display")=="block"){
                    $(_this.Content.find(".user-popover")[1]).hide();
                }
                else{
                    $("#bookContainer").find(".user-popover").hide();
                    _this.Content.popover("show", "toolbar");
                }

            }
            event.stopPropagation();
        });
        this.Content.attr('id', _this.Id);
        this.src = src;
        this.encodeSrc= path.join(obj.XamlPath, '../' + encodeURIComponent(_this.File));
        this.attachOnDragEvent();
        this.setTitle();
        this.setPopover();
    }

    WidgetICW.prototype = new WidgetBase();
    WidgetICW.prototype.constructor = WidgetICW;

    /**
     * ICW查看
     */
    WidgetICW.prototype.resourcePreview = function(){
        var _this = this;
        var localresUrl = Config.binPath + "slideapp/main/player.html?package="+_this.src;
        var innerObj = $('<div>').append($('<iframe src="' + localresUrl + '">').css({
            'width': (Config.Width - 100) + "px",
            'height': Config.Height,
            'verticalAlign': 'middle'
        }));
        var actualHeight=Math.min($(document).height(),Config["Height"]);
        innerObj.css({textAlign: 'center', lineHeight: actualHeight + 'px'});
        setTimeout(function(){CardWrapper.show(innerObj[0], _this.Id, true);},1000);
    }


    /**
     /**
     * 删除widget
     * @param {boolean=} isDeleteSrc 是否删除源文件
     */
    WidgetICW.prototype.destroy=function(isDeleteSrc){
        if(this.Content){
            isDeleteSrc = isDeleteSrc == undefined ? true : isDeleteSrc;
            if (isDeleteSrc && this.src) {
                var dstfileFolder = this.src.replace(/\//g, "\\");
                var dstFile = dstfileFolder + '.icw';
                shellcmd.deleteFile(dstFile);
                shellcmd.deleteDir(dstfileFolder);
            }
            this.Content.remove();
            this.Content=null;
        }
    }



    //TODO : 这里要重写
    WidgetICW.prototype.toXml=function(){
        var xmlResult = '\n<eb:';
        var widgetContent;
        widgetContent = '\n<icw src= "{0}"  uploadTime="{8}" score="{9}" userAddressInfo="{10}" resourceId="{11}"  title="{1}" showTitleFlag="{2}" showIconFlag="{3}" description="{6}" userName="{7}" />\n<layout src="{4}" style="{5}" />'
            .format(this.File, this.Title ,
                (this.showTitleFlag === undefined) ? true : this.showTitleFlag ,
                (this.showIconFlag === undefined) ? true : this.showIconFlag,
                this.layout.src, this.layout.style,this.description,this.userName,this.uploadTime,this.score,this.userAddressInfo,this.resourceId);

        widgetContent += ' \n<event action="opened" style="zoomin_anim" />' +
            '\n<event action="closed" style="zoomout_anim" />';

        var left=parseFloat(this.Content.css('left')),top=parseFloat(this.Content.css('top'));
        xmlResult += '{0} id="{1}" bound="{2};{3};{4};{5}" editable="{6}" style="{7}" '
            .format(this.WidgetType, this.Id,left , top, this.PlayAreaWidth, this.PlayAreaHeight, this.IsEditing,this.style.toString());

        xmlResult += ">";
        xmlResult += widgetContent;
        xmlResult += "\n</eb:{0}>".format(this.WidgetType);
        return xmlResult;
    }


    exports.WidgetICW = WidgetICW;
});

