/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-4
 * Time: 上午9:35
 * To change this template use File | Settings | File Templates.
 */
;define(function(require,exports){
    var WidgetBase = require("./widgetbase").WidgetBase;
    require('browserContext');
    var define = require('../../define');
    var speechuiDefine = require('../../../speechui/code/define');
    var path = require('../../../common/path');
    var ebookContext = require('../../ebookcontext').Instance;
    require('jqjson');
    var CardWrapper = require('../../../app/card/cardwrapper').Instance;
    var cardResMgr = require('../../card/cardresourcemgr');
    var shellcmd = require('../../../common/shellcmd');
    var cardReader = require('../../card/cardreader');
    var trace = require('../../trace').Instance;
    var playerMgr=require('../hotspot/playerMgr').Instance;
    require('popover');

    function WidgetEvalCard(widgetType, obj) {
        var _this = this;
        this.WidgetType = widgetType;
        this.parse(obj);

        this.type = obj.type;
        this.obj = obj;
        if (obj.file["src"] != undefined) {
            _this.File = obj.file["src"];
        }
        _this.Title = obj.file["title"];
        _this.showTitleFlag = !!(obj.file["showTitleFlag"] == "true");
        _this.showIconFlag = !!(obj.file["showIconFlag"] == "true");
        _this.description = obj.file["description"]||"";
        _this.userName = obj.file["userName"]||"";
        _this.uploadTime = obj.file["uploadTime"]||"";
        _this.score = obj.file["score"]|| 0 ;
        _this.userAddressInfo = obj.file["userAddressInfo"]||"";
        _this.resourceId = obj.file["resourceId"]||"";
        var icon = 'assert/images/bookicon/ic_poetry.png';
        if (_this.type == define.EvalCardType.Poem) {
            icon = 'assert/images/bookicon/ic_shi.png';
        }
        if (_this.type == define.EvalCardType.En_Word) {
            icon = 'assert/images/bookicon/ic_reading.png';
        }
        if (_this.type == define.EvalCardType.Situ) {
            icon = 'assert/images/bookicon/ic_dialogue.png';
        }
        var src = path.join(obj.XamlPath, '../' + _this.File);

        this.Content=this.getContent(icon,[this.Left,this.Top,this.Width,this.Height]);
        this.Content.click(function (event) {
            if (!_this.getIsEditing()) {
                shellcmd.checkOnline().done(function (isNetWorking) {
                    if (!isNetWorking) {
                        console.error(AppTips.NetWorkConnectFailed);
                        var tips = "";
                        if (!ebookContext.getUser().getIsOnline()) {
                            tips = AppTips.LocalLoignMsg;
                        } else {
                            tips = AppTips.NetWorkConnectFailed
                        }
                        $.Zebra_Dialog(tips, {
                            'type': 'information',
                            'title': AppTips.WarmTips,
                            'buttons': [ AppTips.OkTips]
                        });
                    } else {
                        var speechuiIndex = AppRemoteSvcCfg.SpeechUIPageUrl;
                        if (AppCfg.isDebug) {
                            speechuiIndex += "?d=" + new Date().getTime();
                        }
                        shellcmd.checkUrlAccess(speechuiIndex).done(function (ret) {
                            if (ret) {
                                var cardOptions = null;
                                try {
                                    var cardInfo = [];
                                    if (_this.type === 'poem') {
                                        cardInfo = ['poem', obj.file['title']];
                                        cardOptions = _this._getCardOptions(cardInfo, src);
                                    }
                                    else {
                                        cardReader.Instance.getContent(src).done(function (cardInfo) {
                                            cardOptions = _this._getCardOptions(cardInfo, src);
                                            var task = _this.readCard(speechuiIndex);
                                            task.done(function(iframe){
                                                iframe && iframe.load(function () {
                                                    dispatchClientMsg({evt: 'loadCard', data: cardOptions});
                                                    event.stopPropagation();
                                                });
                                            })
                                        });
                                    }

                                } catch (ex) {
                                    $.Zebra_Dialog(AppBlackBoardTipsList.ReadCardOptionsFailed, {
                                        'type': 'information',
                                        'title': AppTips.WarmTips,
                                        'buttons': [ AppTips.OkTips]
                                    });
                                    console.error('WidgetEvalCard::_getCardOptions exception:');
                                }
                                if (cardOptions) {
                                    var task = _this.readCard(speechuiIndex);
                                    task.done(function(iframe){
                                        iframe && iframe.load(function () {
                                            dispatchClientMsg({evt: 'loadCard', data: cardOptions});
                                            event.stopPropagation();
                                        });
                                    })
                                }
                            }
                            else {
                                $.Zebra_Dialog(AppTips.RequestServerPageFailed, {
                                    'type': 'information',
                                    'title': AppTips.WarmTips,
                                    'buttons': [ AppTips.OkTips]
                                });
                            }
                        });
                    }
                });
            }
            else  {
                if($(_this.Content.find(".user-popover")[1]).css("display")=="block")
                    $(_this.Content.find(".user-popover")[1]).hide();
                else{
                    $("#bookContainer").find(".user-popover").hide();
                    _this.Content.popover("show", "toolbar");
                }
            }
            event.stopPropagation();
        });

        this.Content.attr('id', _this.Id);
        this.src = src;
        this.attachOnDragEvent();
        this.setTitle();
        this.setPopover();
    }


    WidgetEvalCard.prototype = new WidgetBase();
    WidgetEvalCard.prototype.constructor = WidgetEvalCard;

    WidgetEvalCard.prototype.readCard = function (serverSrc) {
        if (!serverSrc) return null;
        var deferred= $.Deferred();

        //此时不允许在点击客户区,否则如果在加载情景卡片的过程中点击热区的话，情景卡片会自动播放
        app_global_playerMgr.stop();
        var fun=function(){
            event.stopPropagation();
            return false;
        }
        document.addEventListener('mousedown',fun,true);

        setTimeout(function(){
            var frameId = '_' + new Date().getTime();
            var iframeWidth = Config.Width - 100, iframeHeight = Config.Height;
            var cardIframe = $('<iframe frameborder="0" allowtransparency="true" scrolling="no" id="' + frameId + '" src="' + serverSrc + '"></iframe>').
                load(function () {
                    //console.log('card frame load');
                    var _self = this;
                    setTimeout(function () {
                        $(_self.contentWindow.document).ready(function () {
                            var element = $(_self.contentWindow.document.body);
                            var elementHeight = element.outerHeight();
                            var scale = correctToBaseResolution(element, {max_width: iframeWidth, max_height: iframeHeight, width: element.outerWidth(), height: elementHeight, keepScale: true});
                            if (!(scale[0] == 1 && scale[3] == 1))
                                element.css({
                                    '-webkit-transform': 'matrix(' + scale.join(',') + ')'
                                });

                            scale[0] = 1 / scale[0], scale[3] = 1 / scale[3];
                            if (scale[0] > 1 || scale[3] > 1) {
                                element.find("#recorder").css({
                                    'transform-origin': '-100% 100%',
                                    '-webkit-transform': 'matrix(' + scale.join(',') + ')'
                                })
                            }

                            //解决卡片不居中的问题
                            //var speechuiPaddingTop = (Config.Height - elementHeight)/2;
                            var speechuiPaddingTop = (Config.Height - 550)/2;
                            element.css("padding-top",speechuiPaddingTop);

                            document.removeEventListener('mousedown',fun,true);
                            cardIframe.show();
                        })
                    }, 1000)
                });

            registerIframe(frameId, '*');
            CardWrapper.show(cardIframe[0], this.Id);
            CardWrapper.one('minmize',function(){
                document.removeEventListener('mousedown',fun,true);
            });
            cardIframe.hide();

            deferred.resolve(cardIframe);
        },500);

        return deferred.promise();
    }


    /**
     * 资源查看
     */
    WidgetEvalCard.prototype.resourcePreview = function(){
        var _this = this;
        var obj = this.obj;
        if (obj.file["src"] != undefined) {
            _this.File = obj.file["src"];
        }
        var src = path.join(obj.XamlPath, '../' + _this.File);
            shellcmd.checkOnline().done(function (isNetWorking) {
                if (!isNetWorking) {
                    console.error(AppTips.NetWorkConnectFailed);
                    var tips = "";
                    if (!ebookContext.getUser().getIsOnline()) {
                        tips = AppTips.LocalLoignMsg;
                    } else {
                        tips = AppTips.NetWorkConnectFailed
                    }
                    $.Zebra_Dialog(tips, {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons': [ AppTips.OkTips]
                    });
                } else {
                    var speechuiIndex = AppRemoteSvcCfg.SpeechUIPageUrl;
                    if (AppCfg.isDebug) {
                        speechuiIndex += "?d=" + new Date().getTime();
                    }
                    shellcmd.checkUrlAccess(speechuiIndex).done(function (ret) {
                        if (ret) {
                            var cardOptions = null;
                            try {
                                var cardInfo = [];
                                if (_this.type === 'poem') {
                                    cardInfo = ['poem', obj.file['title']];
                                    cardOptions = _this._getCardOptions(cardInfo, src);
                                }
                                else {
                                    cardReader.Instance.getContent(src).done(function (cardInfo) {
                                        cardOptions = _this._getCardOptions(cardInfo, src);
                                        var task = _this.readCard(speechuiIndex);
                                        task.done(function(iframe){
                                            iframe && iframe.load(function () {
                                                dispatchClientMsg({evt: 'loadCard', data: cardOptions});
                                                event.stopPropagation();
                                            });
                                        })
                                    });
                                }

                            } catch (ex) {
                                $.Zebra_Dialog(AppBlackBoardTipsList.ReadCardOptionsFailed, {
                                    'type': 'information',
                                    'title': AppTips.WarmTips,
                                    'buttons': [ AppTips.OkTips]
                                });
                                console.error('WidgetEvalCard::_getCardOptions exception:');
                            }
                            if (cardOptions) {
                                var task = _this.readCard(speechuiIndex);
                                task.done(function(iframe){
                                    iframe && iframe.load(function () {
                                        dispatchClientMsg({evt: 'loadCard', data: cardOptions});
                                        event.stopPropagation();
                                    });
                                })
                            }
                        }
                        else {
                            $.Zebra_Dialog(AppTips.RequestServerPageFailed, {
                                'type': 'information',
                                'title': AppTips.WarmTips,
                                'buttons': [ AppTips.OkTips]
                            });
                        }
                    });
                }
            });

    };
    /**
     * 资源编辑
     */
    WidgetEvalCard.prototype.resourceEditor = function(){
        alert("当前资源不可编辑")
    };

    WidgetEvalCard.prototype.upload = function(){
        alert("当前资源不可上传")
    };


    /**
     *
     * @param cardInfo
     * @returns {null}
     * @private
     */
    WidgetEvalCard.prototype._getCardOptions = function (cardInfo, src) {
        var cardOptions = null;
        //console.log(cardInfo);
        var cardType;
        if (cardInfo instanceof Array) {
            cardType = cardInfo[0];
        } else {
            cardType = cardInfo.cardtype;
        }

        // 英文单词评测
        if (cardType == define.EvalCardType.En_Word) {
            var options = cardResMgr.getEvalCardOptions(cardInfo, src);
            //console.log(options);
            cardOptions = {
                cardName: speechuiDefine.CardName.EnWordEval,
                options: options
            };
        }
        // 中文字词评测
        else if (cardType == define.EvalCardType.Cn_Word) {
            var options = cardResMgr.getCnEvalCardOptions(cardInfo, src);
            //console.log(options);
            cardOptions = {
                cardName: speechuiDefine.CardName.CnWordEval,
                options: options
            };
        }
        // 诗歌对答
        else if (cardType == define.EvalCardType.Poem) {
            //console.log(cardInfo[1]);
            cardOptions = {
                cardName: speechuiDefine.CardName.Poetry,
                options: { PoetryName: cardInfo[1] }
            };
        }
        // 情景对话
        else if (cardType == define.EvalCardType.Situ) {
            var options = cardResMgr.getSituCardOptions(cardInfo, src);
            //console.log(options);
            cardOptions = {
                cardName: speechuiDefine.CardName.Situ,
                options: options
            };
        }

        else {
            alert('卡片资源异常');
            console.warn('unhandled cardType:%s', cardType);
        }

        return cardOptions;
    }

    WidgetEvalCard.prototype.destroy=function(isDeleteSrc){
        if(this.Content){
            isDeleteSrc = isDeleteSrc == undefined ? true : isDeleteSrc;
            if (this.type !== define.EvalCardType.Cn_Word && this.EvalCardType !== define.EvalCardType.En_Word)  isDeleteSrc = false;
            if (isDeleteSrc && this.src) {
                var dst = this.src.replace(/\//g, "\\");
                shellcmd.deleteDir(dst);
            }
            this.Content.remove();
            this.Content=null;
        }
    }


    WidgetEvalCard.prototype.toXml=function(){
        var xmlResult = '\n<eb:';
        var widgetContent;
        widgetContent = '\n<file src= "{0}"  uploadTime="{8}" score="{9}" userAddressInfo="{10}" resourceId="{11}"  title="{1}" showTitleFlag="{2}" showIconFlag="{3}" description="{6}" userName="{7}" />\n<layout src="{4}" style="{5}" />'
            .format(this.File, this.Title ,
                (this.showTitleFlag === undefined) ? true : this.showTitleFlag ,
                (this.showIconFlag === undefined) ? true : this.showIconFlag,
                this.layout.src, this.layout.style,this.description,
                this.userName,this.uploadTime,this.score,this.userAddressInfo,this.resourceId);
        widgetContent += ' \n<event action="opened" style="zoomin_anim" />' +
            '\n<event action="closed" style="zoomout_anim" />';

        var left=parseFloat(this.Content.css('left')),top=parseFloat(this.Content.css('top'));
        xmlResult += '{0} id="{1}" bound="{2};{3};{4};{5}" editable="{6}" style="{7}" '
            .format(this.WidgetType, this.Id,left , top, this.PlayAreaWidth, this.PlayAreaHeight, this.IsEditing,this.style.toString());

        xmlResult += 'type="' + this.type + '"';
        xmlResult += ">";
        xmlResult += widgetContent;
        xmlResult += "\n</eb:{0}>".format(this.WidgetType);
        return xmlResult;
    }

    exports.WidgetEvalCard = WidgetEvalCard;
});