/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-4
 * Time: 上午9:22
 * To change this template use File | Settings | File Templates.
 */
;
define(function (require, exports) {
    require('browserContext');
    var define = require('../../define');
    var path = require('../../../common/path');
    require('jqjson');
    var shellcmd = require('../../../common/shellcmd');
    var model = require('../../model');
    var trace = require('../../trace').Instance;
    var playerMgr = require('../hotspot/playerMgr').Instance;
    var ebookContext = require('../../../app/ebookcontext').Instance;
    var InfoWidget = require('./infowidget').InfoWidget;
    require('popover');

    function WidgetBase() {
        this.WidgetType = '';
        this.Id = '';
        this.Width = 0;
        this.Height = 0;
        this.Left = 0;
        this.Top = 0;
        this.File = '';
        this.Title = '';
        this.layout = null;
        this.Content = null;
        this.IsEditing = false;
        this.showTitleFlag = true;
        this.showIconFlag = true;
        this.description = '';
        this.userName = '';
        this.style = {};
        this.src = '';
        this.bookContainer = "";
        this.fileSize = "";
        this.uploadTime = "";
        this.userPhoto = "";
        this.score = "";
        this.thumbnail = "";
        this.infoWidget = null;
        this.userAddressInfo = "";
        this.resourceId = "";
    }


    /**
     * 设置编辑状态
     * @param value type bool
     */
    WidgetBase.prototype.setIsEditing = function (value) {
        this.IsEditing = value;
        !this.IsEditing ? this.Content.find("#resourceDelete").hide() : this.Content.find("#resourceDelete").show();
        this.showTitleSet();
        this.resourceIconHide();
    }

    WidgetBase.prototype.getIsEditing = function () {
        return this.IsEditing;
    }

    WidgetBase.prototype.trigger = function (evt) {
        (this.Content) && (this.Content.triggerHandler(evt, Array.prototype.slice.call(arguments, 1)));
    }

    WidgetBase.prototype.parse = function (ctrl) {
        var bounds = [0, 0, 0, 0];
        this.Id = ctrl.id;
        if (ctrl.bound != undefined) bounds = ctrl.bound.split(';');
        this.Left = parseFloat(bounds[0]);
        this.Top = parseFloat(bounds[1]);
        this.layout = ctrl.layout;
        //58,60是默认图标的大小,暂时用magic code
        this.Width = 58;
        this.Height = 60;
        this.PlayAreaWidth = parseFloat(bounds[2]);
        this.PlayAreaHeight = parseFloat(bounds[3]);

        this.style = (function () {
            var temp = {};
            if (ctrl.style) {
                var arr = ctrl.style.split(';');
                for (var i = 0, len = arr.length; i < len; ++i) {
                    var val = arr[i].split(':');
                    val && (temp[val[0]] = val[1]);
                }
            }
            else temp.tiny = 'false';
            return temp;
        })();

        this.style.toString = function () {
            var str = [];
            for (var key in this) {
                if (key !== 'toString' && this.hasOwnProperty(key))
                    str.push(key + ":" + this[key]);
            }
            return str.join(';');
        };
    }
    WidgetBase.prototype.bindEvent = function () {
        var _self = this;
        this.Content.find("#resourceDelete").on("click", function (e) {
            $.Zebra_Dialog("您确认要删除该资源吗？", {
                'type': 'question',
                'title': "提示",
                'buttons': ["取消","确定"],
                'onClose': function (a){
                    if(a == "确定"){
                        var pageItem = _self.Content.data("pagedata");
                        pageItem && pageItem.trigger("widgetDeleted", [_self.Id]);
                        e.stopPropagation();
                    }
                }
            });
            //var pageItem = _self.Content.data("pagedata");
            //pageItem && pageItem.trigger("widgetDeleted", [_self.Id]);
            //e.stopPropagation();
            return false;
        });

        this.Content.find("#resRDEdit").on("click", function (e) {
           //Caution : 此处第二个参数是为ppt专用，对其他调用应该木有影响
            _self.resourceEditor(e,'edit');

            e.stopPropagation();
            return false;
        });

        _self.showTitleSet();
    }


    WidgetBase.prototype.attachOnDragEvent = function () {
        var _self = this;
        var startPoint, initPoint, cloneContent;
        var bookContainer;
        _self.Content.find('img').attr('draggable', true);

        _self.Content.on('dragstart', function (event) {
            event = event.originalEvent;
            if ($(_self.Content.find(".user-popover")[1]).css("display") == "block" && _self.Content.find("#normal")[0] == event.target)
                $(_self.Content.find(".user-popover")[1]).hide();
            bookContainer = null;
            if (_self.getIsEditing()) {
                _self.Content.trigger("unSwipable").trigger("unDraggable"); //禁止滑动防止拖动过快引起翻页
                bookContainer = $('#bookContainer');
                var bookContainerOffset = bookContainer.offset(), contentOffset = _self.Content.offset();
                startPoint = new model.Point(event.pageX, event.pageY);
                initPoint = new model.Point(contentOffset.left - bookContainerOffset.left, contentOffset.top - bookContainerOffset.top);
            }
            else event.dataTransfer.effectAllowed = 'none';

            //由于drag时会有一个阴影，暂时把它们都设为一个很小的图片，相当于没有阴影
            var dragIcon = document.createElement('img');
            dragIcon.src = 'assert/images/book_bot.png';
            event.dataTransfer.setDragImage(dragIcon, 0, 0);

            event.stopPropagation();
        });

        this.Content.on('drag', function () {
            if (!bookContainer) return;
            var isDoublePage = bookContainer.find('.pageItem').length === 2;
            var srcPageIndex, content = _self.Content;
            if (!cloneContent) {
                cloneContent = _self.Content.clone().removeAttr('id');
                var parentScale = _self.getTransformMatrix(_self.Content.parent());
                var viewDomScale = _self.getTransformMatrix($('.viewdom'));
                var contentScale = _self.getTransformMatrix(_self.Content);
                var maxLeft = bookContainer.width() / 2;

                parentScale[0] *= viewDomScale[0], parentScale[3] *= viewDomScale[3];
                contentScale[0] *= parentScale[0], contentScale[3] *= parentScale[3];
                contentScale[4] = contentScale[5] = 0;
                cloneContent.css({
                    '-webkit-transform': 'matrix(' + contentScale.join(',') + ')',
                    'transform-origin': '0% 0%',
                    opacity: 0.7
                });
                cloneContent.on('dragover', function () {
                    event.preventDefault();
                });
                cloneContent.on('drop', function () {
                    var pageItem = content.data('pagedata');
                    var endPoint = new model.Point(event.pageX, event.pageY);
                    //需要判断是否跨页
                    if (isDoublePage) {
                        var pageOffset = 0, width = content.width() * parentScale[0];
                        var curLeft = event.pageX - startPoint.x + initPoint.x;

                        //判断widget初始在哪个页面
                        if (initPoint.x < maxLeft) srcPageIndex = 1;
                        else  srcPageIndex = 2;

                        //判断当前widget在哪一个页面
                        if (srcPageIndex === 1 && curLeft >= maxLeft) {
                            pageOffset = 1;
                            startPoint.x += maxLeft * viewDomScale[0];
                        }
                        else if (srcPageIndex === 2 && curLeft + width <= maxLeft) {
                            pageOffset = -1;
                            endPoint.x += maxLeft * viewDomScale[0];
                        }
                        else pageOffset = 0;
                        if (pageOffset) {
                            cloneContent.remove();
                            cloneContent = null;
                            _self.Content.trigger("swipable").trigger("draggable"); //重新设置滑动防止拖动过快引起翻页
                        }
                    }
                    var srcPos = [_self.Content[0].offsetLeft, _self.Content[0].offsetTop];
                    var left = (endPoint.x - startPoint.x) / parentScale[0] + srcPos[0], top = (endPoint.y - startPoint.y) / parentScale[3] + srcPos[1];
                    if (left < 30) left = 30;//设置距离左边的最小距离，防止距离太小
                    var curPos = [left, top];
                    pageItem.trigger('insertWidget', [pageOffset, _self.Id, srcPos, curPos]);
                });
                cloneContent.appendTo(bookContainer);
            }

            //设置拖动时的阴影
            var left = event.pageX - startPoint.x + initPoint.x, top = event.pageY - startPoint.y + initPoint.y;
            cloneContent.css({
                left: left,
                top: top
            });
        });

        this.Content.on('dragend', function () {
            if (!bookContainer) return;
            cloneContent && cloneContent.remove();
            cloneContent = null;
            _self.Content.trigger("draggable").trigger("swipable"); //重新设置滑动防止拖动过快引起翻页
        });

        this.Content.on('reposition', function (event, pos) {
            if (pos) _self.isModify = true;
        });

        //阻止事件冒泡,防止拖动
        this.Content.on('mousedown', function (event) {
            event.stopPropagation();
        });
    }

    /**
     *  完成状态下查看资源
     * @param content  资源内容
     */
    WidgetBase.prototype.showResScanPanel = function (content) {
        if (!content) return;

        var resDialog = $.Zebra_Dialog(content, {
            'type': false,
            'title': this.Title,
            'buttons': false
        });

        correctToBaseResolution(resDialog.dialog, {width: 1366, height: 768, keepScale: true});
        resDialog.dialog.draggable({
            containment: "parent",
            handle: ".ZebraDialog_Title"
        });

        return resDialog.dialog;
    }

    /**
     * 设置widget上工具栏的内容
     * @returns {*|jQuery|HTMLElement}
     */
    WidgetBase.prototype.getToolBarContent = function () {
        var _self = this;
        <!--/资源属性框-->
        (!_self.infoWidget) && (_self.infoWidget = new InfoWidget(),
            _self.infoWidget.init(null, null, null, _self));

        return _self.infoWidget.getDom();
    }

    /**
     * 修改标题
     */
    WidgetBase.prototype.reSetTitle = function (title) {
        this.Content.find(".widgetTitle").html(title);
    };

    /**
     * 资源查看
     */
    WidgetBase.prototype.resourcePreview = function (event) {
//        alert(32)
    };
    /**
     * 资源编辑
     */
    WidgetBase.prototype.resourceEditor = function (event, mode) {

    };

    /**
     * 资源标题设置
     */
    WidgetBase.prototype.showTitleSet = function () {
        this.Content.popover((this.showTitleFlag == "false" || !this.showTitleFlag) ? 'hide' : 'show', 'title');
        $(this.Content.find("a[name='resourceItem']")[2]).attr("title", this.showTitleFlag ? "名称隐藏" : "名称显示");
        $(this.Content.find("a[name='resourceItem']")[2]).html(this.showTitleFlag ? "名称隐藏" : "名称显示");
    };

    /**
     * 图标隐藏
     */
    WidgetBase.prototype.resourceIconHide = function () {
        var _self = this;
        _self.style.tiny = this.showIconFlag ? 'false' : 'true';
        //当前图标显示
        if (_self.style.tiny === 'true') {
            _self.Content.find("#normal").css('opacity', '1');
            _self.Content.find("#tiny").hide();
            _self.Content.find("#normal").show();
            _self.style.tiny = 'false';
        }
        //当前图标隐藏
        else if (_self.style.tiny === 'false') {
            //完成状态下虚化
            if (!this.IsEditing) {
                _self.Content.find("#tiny").show();
                _self.Content.find("#normal").hide();
                _self.style.tiny = 'true';
            }
            //编辑状态下变成一条线
            else {
                _self.Content.find("#normal").css('opacity', '0.3');
                _self.Content.find("#tiny").hide();
                _self.Content.find("#normal").show();
                _self.style.tiny = 'false';
            }
        }
        _self.isModify = true;

        $(this.Content.find("a[name='resourceItem']")[3]).attr("title", this.showIconFlag ? "图标显示" : "图标隐藏");
        $(this.Content.find("a[name='resourceItem']")[3]).text(this.showIconFlag ? "图标显示" : "图标隐藏");
    };

    /**
     * 设置widget的标题
     */
    WidgetBase.prototype.getTitleContent = function (title) {
        if (!title) title = this.Title;
        if (title.length > 8) title = title.substr(0, 5) + "..." + title.substr(title.length - 3, 3);
        return $('<div><p class="widgetTitle" style="font-size: 18px;text-align: center;width: 150px;font-weight: bold">' + title + '</p></div>');
    }

    /**
     *设置widget工具栏
     */
    WidgetBase.prototype.setPopover = function () {
        var _self = this;
        _self.bindEvent();
        var element = this.Content;
        var toolBarContent = _self.getToolBarContent();
        this.getTitleContent && element.popover({position: 'bottom', content: this.getTitleContent(), wrapper: element, popoverId: "title", hideOnHTMLClick: false});
        if (toolBarContent) {
            element.popover({position: 'left', content: toolBarContent, wrapper: element, popoverId: "toolbar", zIndexOwner: 2, hideOnHTMLClick: false});

            element.popover('setOption', 'toolbar', {
                beforeShow: function (popover) {
                    if (!popover) return;
                    setGlobalCurWidget(_self);
                    var pageTrans = _self.getTransformMatrix();
                    var widgetTrans = _self.getTransformMatrix(element);

                    _self.infoWidget && _self.infoWidget.showTabContainer();

                    var Obj = {
                        wZoom: 1 / (pageTrans[0] * widgetTrans[0]),
                        hZoom: 1 / (pageTrans[3] * widgetTrans[3])
                    }
                    toolBarContent.css("-webkit-transform", "matrix(" + Obj.wZoom + ",0,0," + Obj.hZoom + ",0,0)");
                    //    var flag = parseInt(element.css('top')) - popover.height() + parseInt(popover.css('marginTop')) || 0 - (matrixTransform[3] - 1) * (element.height() + popover.height()) / 2;
                    console.log(app_global_bookContainer.getPageViewType())
                    var _type = app_global_bookContainer.getPageViewType();



                    var resEditBox =  _self.Content.find('.res_editor_box');
                    var resEditBoxHeight = 369;
                    var Xflag = parseInt($("#bookContainer").css("width"))/2 -
                        ( parseInt(element.css('left'))/Obj.wZoom/widgetTrans[0] + parseInt(resEditBox.width()) + parseInt(element.css('width')))//parseInt(popover.width())/2 * widgetTrans[3]) * pageTrans[3];
                    var Yflag = parseInt($("#bookContainer").css("height")) -
                        ( parseInt(element.css('top'))/Obj.hZoom/widgetTrans[3] + parseInt(element.height())/Obj.hZoom/2 +
                            resEditBoxHeight/2+ parseInt($("#smartbar").height()));
                    var YYflag = parseInt(element.css('top'))/Obj.hZoom/widgetTrans[3] - resEditBoxHeight/2 - parseInt(element.height())/Obj.hZoom/2;
                   /*if (_type == 4) {
                     //   Yflag = parseInt($("#bookContainer").css("height")) - parseInt(element.css('top')) - parseInt(popover.height()) * Obj.wZoom;
                    }*/
                    if (Xflag < 0) {
                        resEditBox.css({'marginLeft':-275 + "px"});
                      //  resEditBox.find("i[name='arrow']").removeClass("ic_arrowleft").addClass("ic_arrowright");
                        element.popover('setOption', 'toolbar', {position: 'left'});
                        element.find(".newpop").css("-webkit-animation", "popbottom 0.5s")
                        element.find(".newpop").css("marginTop", "80px");
                    }
                    else {
                        resEditBox.css({'marginLeft': 55 + "px"});
                     //   resEditBox.find("i[name='arrow']").addClass("ic_arrowleft").removeClass("ic_arrowright")
                        element.popover('setOption', 'toolbar', {position: 'right'});
                        element.find(".newpop").css("-webkit-animation", "poptop 0.5s")
                    }

                 //   return;

                    resEditBox.find("i[name='arrow']").css("marginTop","-8px");
                    if( Yflag< 0){
                     //   var _marginTop = parseInt(resEditBox.find("i[name='arrow']").css("marginTop"));
                        resEditBox.css({"marginTop": -160+ "px"});
                        resEditBox.css({ "marginTop":  -160 + Yflag   + "px"});
                      //  resEditBox.find("i[name='arrow']").css("marginTop", _marginTop - Yflag - 40 +"px");
                    }else{
                        if(  YYflag< 0){
                    //        var _marginTop = parseInt(resEditBox.find("i[name='arrow']").css("marginTop"));
                            resEditBox.css({"marginTop": (-160 - YYflag+ 20) *Obj.hZoom  +"px"});
                  //          resEditBox.find("i[name='arrow']").css("marginTop",_marginTop + YYflag + 20 +"px");
                        }else{
                            resEditBox.css({"marginTop": -160+ "px"});
                        }
                    }
                 //   resEditBox.css({"marginTop": -160+ "px"});
                    if(_type==3) {
                        resEditBox.css({"marginTop": -160+ "px"});
                        //resEditBox.find("i[name='arrow']").css("marginTop","-8px");
                    }
               //     if(_type==4) {resEditBox.css({"marginTop": -160+ "px"});resEditBox.find("i[name='arrow']").css("marginTop","-8px");}

                    return;

                    var _L = 156 * 1.428;//+150/Obj.wZoom;


                    var _marL = _L - (parseInt(element.css('left')) + parseInt(element.css('width')) / 2);


                    //距离右边的距离
                    var _marR = parseInt($(".pageItem").css("width")) - parseInt(element.css('left')) - parseInt(element.css('width'));
                    //左边不靠边
                    if (_marL < 0) {
                        //右边不靠边L
                        if (_marR > _L) {
                            //图标在上面
                            if (flag < 0) {
                                _self.Content.find('.point_bot_pop').css('marginLeft', '155px');
                                //图标在下面
                            } else {
                                _self.Content.find('.point_bot01_pop').css('marginLeft', '155px');
                            }
                            _self.Content.find('.card_warp').css('marginLeft', '100px');
                            //右边靠边
                        } else {

                            if (flag < 0) {
                                _self.Content.find('.point_bot_pop').css('marginLeft', 160 + 162 * 1.7 * widgetTrans[0] - _marR - 20 - parseInt(element.css('width')) / 2);
                            } else {
                                _self.Content.find('.point_bot01_pop').css('marginLeft', 160 + 162 * 1.3 * widgetTrans[0] - _marR - 20 - parseInt(element.css('width')) / 2);
                            }

                            _self.Content.find('.card_warp').css('marginLeft', -(250 - (_marR + parseInt(element.css('width'))) * 0.556) / 0.556 - 70 / 0.556 + "px");
                        }
                        //左边靠边
                    } else {
                        _self.Content.find('.card_warp').css('marginLeft', _marL + 200 / 0.556 + "px");
                        //    _self.Content.find('.card_warp').parent().css('left', -127 + "px");

//                        var mL =  - parseInt(element.css('width')) / 2;
//                        var minmL = 150- parseInt(element.css('width'))*0.556 / 2- parseInt(element.css('left'))*0.556;
//                     //   var _marginLeft=0;
//                        _marginLeft = minmL;
//                        _self.Content.find('.card_warp').css('marginLeft', _marginLeft + "px");
                        return;

//
//                        //图标左边离边界距离大于半个图标宽度
//                        if (_marL < 162 * 1.428 * widgetTrans[0] - parseInt(element.css('width')) / 2 - 40) {
//                            if (flag < 0) {
//                                _self.Content.find('.point_bot_pop').css('marginLeft', 160 - _marL + parseInt(element.css('width')) / 2 - 25 + "px");
//                            } else {
//                                _self.Content.find('.point_bot01_pop').css('marginLeft', 160 - _marL + parseInt(element.css('width')) / 2 - 25 + "px");
//                            }
//                            _self.Content.find('.card_warp').css('marginLeft', _marL + "px");
//                            //图标左边离边界距离不大于半个图标宽度
//                        } else {
//                            if (flag < 0) {
//                                _self.Content.find('.point_bot_pop').css('marginLeft', parseInt(element.css('width')) / 2 + "px");
//                            } else {
//                                _self.Content.find('.point_bot01_pop').css('marginLeft', parseInt(element.css('width')) / 2 + "px");
//                            }
//                            var mL =  - parseInt(element.css('width')) / 2;
//                            var minmL = parseInt($(".pageItem").css("width"))*0.24;
//                            var _marginLeft=0;
//                            _marginLeft = mL>minmL?mL:minmL;
//                            _self.Content.find('.card_warp').css('marginLeft', _marginLeft + "px");
                        //  }
                    }
                }
            });
        }
        this.Content.find("#btnTiny").prop('checked', (this.style && this.style.tiny !== 'true' ) ? false : true);
    }

    /**
     * 增加title为了在widget下显示
     * @param {string=} src
     */
    WidgetBase.prototype.setTitle = function (src) {
        if (src == undefined) src = this.src;
        if (!this.Title && src)  this.Title = path.filename(src);
        var extName = path.extname(this.Title);
        var replaceStr = "";
        if (extName && (!/.*[\u4e00-\u9fa5]+.*$/.test(extName))) {
            try {
                replaceStr = new RegExp(extName, "g");
            }
            catch (e) {
                replaceStr = extName;
            }
            finally {
                this.Title = this.Title.replace(replaceStr, "");
            }
        }
    }

    /**
     * 获得放缩矩阵
     * @param {object=} page
     * @return {Array}
     */
    WidgetBase.prototype.getTransformMatrix = function (page) {
        return ebookContext.getTransformMatrix(page);
    };

    WidgetBase.prototype.widgetExecute = function (executePath) {
        if (!executePath) return;
        shellcmd[(this.WidgetType === define.WidgetType.Video || this.WidgetType === define.WidgetType.Audio) ? 'simpleShellExecute' : 'shellExecute'](executePath)
            .done(function (ret) {
                if (parseInt(ret) < 1) {
                    $.Zebra_Dialog(AppTips.ShellExecuteFailed, {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons': [AppTips.OkTips]
                    });
                }
            });
    }

    /**
     * @param icon 资源图标
     * @param bound 定位
     * @returns {*|jQuery}
     */
    WidgetBase.prototype.getContent = function (icon, bound) {
        if (!icon || !bound) return;
        var Obj = this.getUnTransForm();
        var content = $("<div class='widgeticon' style='position: absolute;-webkit-transform:matrix(" +
            Obj.wZoom + ",0,0," + Obj.hZoom + ",0,0)'/>").css({
                'top': bound[0] + 'px',
                'left': bound[1] + 'px',
                'width': bound[2] + 'px',
                'height': bound[3] + 'px'
            }).append("<div class='fs_closed'  >" +
                "<img  id='normal' src='" + icon + "' width='" + bound[2] + "' height='" + bound[3] + "'>" +
                "<img  id='tiny'  src='assert/images/bookicon/ic_black.png'>" +
                "<a id='resourceDelete' ></a></div>");

        (this.style && this.style.tiny !== 'true') ? (content.find("#tiny").hide()) : content.find("#normal").hide();

        return content;
    }

    WidgetBase.prototype.upload = function () {
        var _this = this;
        if (ebookContext.getUser().getName() != AppCfg.defaultuser) {
            var bookCode = app_global_bookContainer.bookCode;
            var unitCode = app_global_bookContainer.getCurrUnit();
            var courseCode = app_global_bookContainer.getCurrCourse();
            var thumbnailWidth = "185";
            var thumbnailHeight = "185";
            var aliasName = _this.Title;
            var obj = {
                localPath: path.trimPosix(this.src),
                webPath: (AppRemoteSvcCfg.uploadWebPath + "&access_token=" + ebookContext.getUser().getDynamicToken() )
                    .format(ebookContext.getUser().getUid(), "yun_beike", encodeURI(_this.Title), bookCode, unitCode, courseCode, thumbnailWidth, thumbnailHeight, encodeURI(aliasName))
            };
            if (path.extname(obj.localPath) == ''){
                obj.localPath += '.icw';
            }
            shellcmd.uplaodByDll(obj.localPath, obj.webPath);
        }
        else {
            app_global_loginMgr.show();
        }
    }

    WidgetBase.prototype.onMessageReceived = function () {

    }

    WidgetBase.prototype.getUnTransForm = function () {
        var obj = ebookContext.getUnTransForm()
        return {
            wZoom: obj.wZoom * 0.7,
            hZoom: obj.hZoom * 0.7
        };

    }

    exports.WidgetBase = WidgetBase;
});
