/**
 * Created with JetBrains WebStorm.
 * User: Administrator
 * Date: 14-7-4
 * Time: 上午9:39
 * To change this template use File | Settings | File Templates.
 */
;define(function(require,exports){
    var WidgetBase = require("./widgetbase").WidgetBase;
    var WidgetImg =  require("./widgetimg").WidgetImg;
    require('browserContext');
    var define = require('../../define');
    var path = require('../../../common/path');
    require('jqjson');
    var shellcmd = require('../../../common/shellcmd');
    var trace = require('../../trace').Instance;
    var actionType = require('../../trace').ActionType;
    var playerMgr=require('../hotspot/playerMgr').Instance;
    require('popover');

    function WidgetAudio() {
    }

    WidgetAudio.prototype = new WidgetBase();
    WidgetAudio.prototype.constructor = WidgetAudio;

    function WidgetAudio(widgetType, obj) {
        var _this = this;
        this.player = obj.player;

        this.Title = obj.audio.title;
        this.WidgetType = widgetType;
        this.parse(obj);

        if (obj.audio["src"] != undefined) {
            _this.File = obj.audio["src"];
        }
        _this.showTitleFlag = !!(obj.audio["showTitleFlag"] == "true");
        _this.showIconFlag = !!(obj.audio["showIconFlag"] == "true");
        _this.description = obj.audio["description"]||"";
        _this.userName = obj.audio["userName"]||"";
        _this.uploadTime = obj.audio["uploadTime"]||"";
        _this.score = obj.audio["score"]|| 0 ;
        _this.userAddressInfo = obj.audio["userAddressInfo"]||"";
        _this.resourceId = obj.audio["resourceId"]||"";
        var icon = 'assert/images/bookicon/y_stop.png';
        var playingIcon = 'assert/images/bookicon/y_playing.png';
        var src = path.join(obj.XamlPath, '../' + _this.File);

        var isPlay = this.player.isPlay(_this.Id);

        this.Content = this.getContent(isPlay ? playingIcon : icon,[this.Left,this.Top,this.Width,this.Height]).attr("state", isPlay ? "playing" : "stop");
        this.Content.click(function (event) {

            if (!_this.getIsEditing()) {
                var extName = path.extname(_this.src);
                if (extName == '.wma'||_this.PlayAreaWidth<0) {
                    shellcmd.simpleShellExecute(_this.src);
                }
                else {
                    if (_this.Content.attr('state') == 'playing') {
                        _this.player.stop();
                        trace.log('ebook', actionType.CloseWidget, {cardId: _this.Id});
                    } else {
                        _this.player.play(_this.Id,path.trimPosix(_this.encodeSrc));
                        trace.log('ebook', actionType.OpenWidget, {cardId: _this.Id});
                    }
                }
            }
            else  {
                if($(_this.Content.find(".user-popover")[1]).css("display")=="block")
                    $(_this.Content.find(".user-popover")[1]).hide();
                else{
                    $("#bookContainer").find(".user-popover").hide();
                    _this.Content.popover("show", "toolbar");
                }
            }
            event.stopPropagation();
        });
        this.Content.attr('id', _this.Id);
        this.attachOnDragEvent();
        this.encodeSrc= path.join(obj.XamlPath, '../' + encodeURIComponent(_this.File));
        this.src = src;
        this.setTitle();
        this.setPopover();
        this._bindCommands();
    }

    WidgetAudio.prototype._bindCommands=function(){
        var _self=this;
        this.player.on(this.Content,'play',function(){
            _self.Content.attr('state', 'playing');
            _self.Content.find('img:first').attr('src', 'assert/images/bookicon/y_playing.png');
        });

        this.player.on(this.Content,'pause',function(){
            _self.Content.attr('state', 'stop');
            _self.Content.find('img:first').attr('src', 'assert/images/bookicon/y_stop.png');
        });

        this.player.on(this.Content,'ended',function(){
            _self.Content.attr('state', 'stop');
            _self.Content.find('img:first').attr('src', 'assert/images/bookicon/y_stop.png');
        });

        this.player.one(this.Content,'play_error',function(event,continuePlay){
            continuePlay&&shellcmd.simpleShellExecute(_self.src);
            _self.PlayAreaWidth=_self.PlayAreaHeight=-1;
        });

    }

    /**
     * 资源查看
     */
    WidgetAudio.prototype.resourcePreview = function(event){
        var _this = this;
        var extName = path.extname(_this.src);
        if (extName == '.wma'||_this.PlayAreaWidth<0) {
            shellcmd.simpleShellExecute(_this.src);
        }
        else {
            if (_this.Content.attr('state') == 'playing') {
                _this.player.stop();
                trace.log('ebook', actionType.CloseWidget, {cardId: _this.Id});
            } else {
                _this.player.play(_this.Id,path.trimPosix(_this.encodeSrc));
                trace.log('ebook', actionType.OpenWidget, {cardId: _this.Id});
            }
        }
//        event.stopPropagation();
    };

    /**
     * 资源编辑
     */
    WidgetAudio.prototype.resourceEditor = function(event){
        alert("当前资源不可编辑")
    };

    WidgetAudio.prototype.getToolBarContent = function () {
        var $content = WidgetImg.prototype.getToolBarContent.call(this);
        var _this = this;

        $content.find("#btnFullScreen").unbind().click(function (event) {
            var extName = path.extname(_this.src);
            if (extName == '.wma'||_this.PlayAreaWidth<0) {
                shellcmd.simpleShellExecute(_this.src);
            }
            else {
                var content = $('<audio id="audioRes" style="width:400px; height:40px;"  controls="controls"/>');
                _this.player.setTempNewPlayer(content);
                _this.showResScanPanel(content);
                _this.player.play(content.attr('id'),"file:///" + _this.encodeSrc);
            }
            event.stopPropagation();
        });
        return $content;
    }

    WidgetAudio.prototype.destroy=function(isDeleteSrc){
        if(this.Content){
            isDeleteSrc = isDeleteSrc == undefined ? true : isDeleteSrc;
            if (isDeleteSrc && this.src) {
                var dst = this.src.replace(/\//g, "\\");
                shellcmd.deleteFile(dst);
            }
            this.Content.remove();
            this.Content=this.player=null;
        }
    }


    WidgetAudio.prototype.toXml=function(){
        var xmlResult = '\n<eb:';
        var widgetContent;
        widgetContent = '\n<audio src= "{0}"  uploadTime="{8}" score="{9}" userAddressInfo="{10}" resourceId="{11}" title="{1}" showTitleFlag="{2}" showIconFlag="{3}" description="{6}" userName="{7}" />\n<layout src="{4}" style="{5}" />'
            .format(this.File, this.Title ,
                (this.showTitleFlag === undefined) ? true : this.showTitleFlag ,
                (this.showIconFlag === undefined) ? true : this.showIconFlag,
                this.layout.src, this.layout.style,this.description,
                this.userName,this.uploadTime,this.score,this.userAddressInfo,this.resourceId);
        widgetContent += ' \n<event action="opened" style="zoomin_anim" />' +
            '\n<event action="closed" style="zoomout_anim" />';

        var left=parseFloat(this.Content.css('left')),top=parseFloat(this.Content.css('top'));
        xmlResult += '{0} id="{1}" bound="{2};{3};{4};{5}" editable="{6}" style="{7}" '
            .format(this.WidgetType, this.Id,left , top, this.PlayAreaWidth, this.PlayAreaHeight, this.IsEditing,this.style.toString());

        xmlResult += ">";
        xmlResult += widgetContent;
        xmlResult += "\n</eb:{0}>".format(this.WidgetType);

        return xmlResult;
    }

    exports.WidgetAudio = WidgetAudio;
});
