;
define(function (require, exports) {
    var guidCreate = require('../../../common/guid').Instance;
    var shellcmd = require('../../../common/shellcmd');
    var ebookContext = require("../../ebookcontext").Instance;
    var pathTool = require("../../../common/path");

    function Snapshot() {
        // SnapShotMesh1为上半页闪烁效果，
        // SnapShotMesh2为下半页闪烁效果。
        var alertWindow,
            SnapShotMesh1 = $("#SnapShotMesh1"),
            SnapShotMesh2 = $("#SnapShotMesh2");

        var saveTipTpl = "已保存快照{2}<br/>至本地目录{1}";

        this.already = false;

        var headH = 0;
        var bookH = 0;
        var leftTopY = 0;
        var leftTopX = 0;
        var rightBottomY = 0;
        var rightBottomX = 0;
        var selfH;

        var _t = 1;
        var _l = 1;

        this.formatGuid = function (data) {
            return data.length == 2 ? data : ('0' + data);
        }

        this.init = function () {

            headH = parseInt($("#header").css("height"));
            var mainToolbarH = parseInt($("#mainToolBar").css("height"));
            var bookTop = 9;
            var leftToolbarW = parseInt($("#leftToolbar").css("width"));
            var bookDiv = $("#book");
            var bookW = parseInt(bookDiv.css("width"));
            bookH = parseInt(bookDiv.css("height"));

            leftTopY = headH + (app_global_isMainToolBarUp ? 1 : 0) * (mainToolbarH + 5) + bookTop;
            leftTopX = leftToolbarW;
            rightBottomY = leftTopY + bookH;
            rightBottomX = leftTopX + bookW;
            selfH = (rightBottomY - leftTopY)/2;

            _l = (parseInt($("window").css("width")) - 321);
            var correctTopValue = 10 ;
            var correctLeftValue = 0;
            (Config.Width == 800)&&(correctLeftValue = 10);
            SnapShotMesh1.css("left", leftTopX + correctLeftValue)
                .css("top", leftTopY - correctTopValue)
                .css("width", rightBottomX - leftTopX)
                .css('opacity', 0.5)
                .css("background", "#666")
                .css('display', 'inline');

            SnapShotMesh2.css("left", leftTopX + correctLeftValue)
                .css("bottom", 10 - correctTopValue)
                .css("width", rightBottomX - leftTopX)
                .css('opacity', 0.5)
                .css("background", "#666")
                .css('display', 'inline');

//            alertWindow = $('<div class="pop_screen"><p></p></div>');
//            $("body").append(alertWindow);

            this.already = true;
        }

        this.snap = function () {
            !this.already && this.init();
            this.showSnapAnimate();

            var guidNum = guidCreate.guid(18);
            var currentDate = new Date();
            var hours = currentDate.getHours().toString();
            var minutes = currentDate.getMinutes().toString();
            var seconds = currentDate.getSeconds().toString();
            var date = currentDate.toLocaleDateString();
            var DateArr = date.split("/");
            var imageFormat = ".jpg";

            var dateString = DateArr[2] + this.formatGuid(DateArr[0]) + this.formatGuid(DateArr[1])
                + this.formatGuid(hours) + this.formatGuid(minutes) + this.formatGuid(seconds);

            var path = ebookContext.getUser().getUserSnapShotRelativePath() + "/" +
                DateArr[2] + this.formatGuid(DateArr[0]) + this.formatGuid(DateArr[1]) + '/';

            guidNum = guidNum + dateString;

            var filename = '快照' + dateString + guidNum + imageFormat;
            var positionInfo = leftTopX + "|" + leftTopY + "|" + rightBottomX + "|" + rightBottomY;
            var cmdCorrespond = filename + "|" + positionInfo + "|" + path;

            //this.showSaveMsg(path,filename);

            (!shellcmd.isDirExistSync(path)) && (shellcmd.createDir('./' + path));

              shellcmd.snapshot(cmdCorrespond);
              //test audio *  this part will be move to proper place;


            //向监管平台传数据
            var session_id = guidCreate.guid(32);
            var uid = ebookContext.getUser().getUid();
            uid = uid == "0"? "" : uid;
            var monitorMessage ='trigger|||' + session_id + '|{"module":01,"param":"snapShot","user_id":'+uid+'}';
            shellcmd.MonitorSend(monitorMessage);
        }

        this.showSnapAnimate = function(){
            SnapShotMesh1.css("height",0);
            SnapShotMesh1.animate({'height': selfH},250).animate({'height': 0},250);
            SnapShotMesh2.css("height",0);
            SnapShotMesh2.animate({'height': selfH},250).animate({'height': 0},250);
        }

//        this.showSaveMsg = function(path,filename){
//            alertWindow.find("p").html(saveTipTpl.replace("{1}", path).replace("{2}", filename));
//            //top值需要动态计算
//            _t = (bookH - parseInt(alertWindow.css("height"))) / 2;
//            alertWindow.css("left", _l).css("top", _t).show().fadeOut(3000);
//        }
    };

    exports.Instance = new Snapshot();
});