/**
 * User: yuwang@iflytek.com
 * Date: 13-7-20 下午4:50
 * Version: 1.0
 */

define(function (require, exports) {
    require('jquery');
    var _define = require('../../define');
    var shellcmd = require('../../../common/shellcmd');
    /**
     * @type {BookContainer}
     */
    var _bookContainer, toolBoxMgr, cardTemplateManager, resLibManager, searchManager;
    var _btns;
    var pagePreView = require('../preview/pagepreview').Instance;
    var pagePreViewIcon = require('../preview/pagepreviewicon').Instance;
    var WBpreView = require('../preview/whiteboardpreview').Instance;
    var importRes = require("../importexport/importmtbk").Instance;

    /**
     * Caution : 这个 require 放在click函数里面和c这里，作用还不一样。
     * 表现 : exportRes 这个对象里面的pageProVider会变，导致bookMenu取不到
     *              -------   by yczhu
     */
    var exportRes = require("../importexport/exportmtbk").Instance;

    var openaction = true;

    var _isEditing = false;

    app_global_isMainToolBarUp = ((!sessionStorage['isMainToolBarUp']) || sessionStorage['isMainToolBarUp'] == 'undefined' || sessionStorage['isMainToolBarUp'] !== 'false') ? true : false;

    //编辑和备课状态下工具栏的宽度
    var constrants = {
        EDIT_WIDTH: 0,
        NO_EDIT_WIDTH: 0
    };
    var mainToolbarScale;//主工具栏放缩比

    /**
     * @param btns {{
     *     btnToggleHotspot: jQuery
     *     btnTogglePlay: jQuery
     * }}
     * @param bookContainer {BookContainer}
     */
    function init(btns, bookContainer, pageIndex, bookCode) {
        _bookContainer = bookContainer;
        _btns = btns;
        _bindCommands();
        !app_global_isMainToolBarUp && setMainToolBarPosition(app_global_isMainToolBarUp);

        //初始化工具箱
        initToolBox(_bookContainer);
        //初始化模板
        initTemplate(_bookContainer);
        //初始化幕布
        initCurtain(_bookContainer);
        //初始化页面预览
        pageIndex && bookCode && initPagePreView(_bookContainer, pageIndex, bookCode);
        initWBView(_bookContainer);
        initPagePreViewIcon();
        setIsEditing(false);
    }

    function _bindCommands() {
        var toggleHotspotImg = _btns.btnToggleHotspot.find('img');
        var isShowAllHotspots = false;
        _btns.btnToggleHotspot.click(function (e, isShow) {
            if (isShow != undefined) isShowAllHotspots = isShow;
            if (isShowAllHotspots) {
                isShowAllHotspots = false;
                toggleHotspotImg.attr('src', 'assert/images/tool_xsrq.png');
                _bookContainer.hideAllHotspots();
            } else {
                isShowAllHotspots = true;
                toggleHotspotImg.attr('src', 'assert/images/tool_qxrq.png');
                _bookContainer.showAllHotspots();
            }
            e.stopPropagation();
        });

        _btns.btnTogglePlay.click(function (event) {
            var state = _btns.btnTogglePlay.attr('state');
            if (state === 'playing') {
                app_global_playerMgr.pause();
            }
            else if (state === 'stop') {
                app_global_playerMgr.resume();
            }
            event.stopPropagation();
        });

        _btns.btnMoveMenuBar.click(function () {
            setMainToolBarPosition(!app_global_isMainToolBarUp);
            $("#blackBoardEvalControl").hide();
            $("#blackBoardStrokeAndDicControl").hide();
            event.stopPropagation();
        });

        /**
         * 清空资源
         */
        var btnClearResContent = _getClearResContent();

        //翻译
        LAN.translateObj(btnClearResContent);

        _btns.btnClearRes.click(function () {
            var $this = $(this);
            if (!$this.popover('isShow', 'title'))
                $this.popover({content: btnClearResContent, userDefinePopover: true, popoverId: 'title'}).popover('show', 'title',
                    {position: app_global_isMainToolBarUp ? 'bottom' : 'top'});  // userDefinePopover 自定义字段
            else  $this.popover('hide', 'title');

            btnClearResContent.find(app_global_isMainToolBarUp ? ".bot_arrow" : ".top_arrow").hide().siblings().show();
            var scale = correctToBaseResolution(btnClearResContent, {scaleFromCenter: false});
            if (mainToolbarScale)  //修正
            {
                scale[4] += (1 - mainToolbarScale[0]) * $(this).outerWidth();
                scale[5] = app_global_isMainToolBarUp ? scale[5] - (1 - mainToolbarScale[3]) * $(this).outerHeight() : scale[5] + (1 - mainToolbarScale[3]) * $(this).outerHeight();
                btnClearResContent.css('-webkit-transform', 'matrix(' + scale.join(',') + ')');
            }
            event.stopPropagation();
        });

        app_global_playerMgr.on('play', function (event, playerType) {
            if (playerType === _define.PlayerType.HotspotPlayer || playerType === _define.PlayerType.AudioPlayer)
                _changeStateToPlay(true);
        });

        app_global_playerMgr.on('pause', function (event, playerType) {
            if (playerType === _define.PlayerType.HotspotPlayer || playerType === _define.PlayerType.AudioPlayer)
                _changeStateToPlay(false);
        });

        app_global_playerMgr.on('ended', function (event, playerType) {
            if (playerType === _define.PlayerType.HotspotPlayer || playerType === _define.PlayerType.AudioPlayer)
                _changeStateToPlay(false);
        });

        $("#btnNote, #smartbar_btnNote").click(function () {
            _bookContainer.insertSingleWidget("", _define.WidgetType.Note);

            if(this.id !='smartbar_btnNote'){
                event.stopPropagation();
            }
        });

        $("#btnImport").click(function () {
            importRes.importBookRes();
            event.stopPropagation();
        });

        $("#btnExport").click(function () {
            exportRes.init(_bookContainer);
            exportRes.exportBookRes();
            event.stopPropagation();
        });

        var camera = require('../../card/template/camera').Instance

        $('#btnCap').click(function () {
            if (!AppCfg.useH5Camera) {
                var videocapexe = Config.binPath + 'iflybookVideoCap.exe';
                shellcmd.shellexecutewithargs(videocapexe, AppCfg.lang,'showvideocap');
            }
            else {
                camera.init();
            }
        });

        $('#smartbar_btnCap').click(function(){
            if(!AppCfg.useH5Camera){
                var videocapexe = Config.binPath + 'iflybookVideoCap.exe';
                shellcmd.shellexecutewithargs(videocapexe,AppCfg.lang,'videocap');
            }
            else{
                camera.init();
            }

        })
    }

    /**
     * 改变 btns.btnTogglePlay的状态
     * @param {boolean=} index
     * @private
     */
    function _changeStateToPlay(index) {
        var togglePlayText = _btns.btnTogglePlay.find('p')[1];
        var togglePlayImg = _btns.btnTogglePlay.find('img');
        if (index) {
            togglePlayImg.attr('src', 'assert/images/tool_pause.png');
            _btns.btnTogglePlay.attr('state', 'playing');
            if (AppCfg.lang == "uyghur") {
                $(togglePlayText).html("");
            }
            else {
                $(togglePlayText).html("暂停");
            }
        }
        else {
            togglePlayImg.attr('src', 'assert/images/tool_play.png');
            _btns.btnTogglePlay.attr('state', 'stop');
            if (AppCfg.lang == "uyghur") {
                $(togglePlayText).html("");
            }
            else {
                $(togglePlayText).html("播放");
            }

        }
    }

    /**
     * 动态计算主工具栏宽度
     * @param mainToolBar
     * @private
     */
    function _getMainToolBarWidth(mainToolBar) {
        if (!mainToolBar) return;
        var width = 0;//动态计算工具栏宽度
        $.each(mainToolBar.children(), function (i, e) {
            if (e.style.display !== 'none') {
                width += e.offsetWidth + ( parseInt($(e).css("marginLeft"), 10) || 0) + 5;
            }
        });
        mainToolBar.css("width", width);
        correctToBaseResolution(mainToolBar, {width: 1024, height: Config.Height});
    }


    /**
     * 清空图标内容
     * @returns {*|jQuery|HTMLElement}
     * @private
     */
    function _getClearResContent() {
        var content = $(document.getElementById('template_clear_res').innerHTML);

        content.find("#clearCurrentPageRes").click(function () {
            _bookContainer.clearCurrentPageRes();
            _btns.btnClearRes.popover("hide");
            event.stopPropagation();
        })
        content.find("#clearBookRes").click(function () {
            _bookContainer.clearBookRes();
            _btns.btnClearRes.popover("hide");
            event.stopPropagation();
        });
        return content;
    }

    /**
     * 设置主工具栏位置
     * @param {boolean} status
     */
    function setMainToolBarPosition(status) {
        sessionStorage['isMainToolBarUp'] = app_global_isMainToolBarUp = status;

        if (!app_global_isMainToolBarUp) {
            $("#main").after($("#mainToolBar").css("margin-top", 0).detach()).css("margin-top", 24);
            $("#blackBoardContainer").css("top",26);
            $("#blackBoardOverlay").css("top",-80);
            _btns.btnMoveMenuBar.attr("src", "assert/images/toolup.png");
        }
        else {
            $("#main").css("margin-top", 0).before($("#mainToolBar").css("margin-top", 24).detach());
            $("#blackBoardContainer").css("top",76);
            $("#blackBoardOverlay").css("top",80);
            _btns.btnMoveMenuBar.attr("src", "assert/images/tooldown.png");
        }
    }

    /**
     *
     * @param {boolean} isEditing
     */
    function setIsEditing(isEditing) {
        var $btnEdit = $('#btnEditing');
        var $ul = _btns.mainToolBar.find(">ul:first");
        if (isEditing) {
            $ul.find("li[menuStatus=edit],li[menuStatus=all]").css("display", "inline");
            $ul.find("li[menuStatus=done]").css("display", "none");
            //板擦要额外处理
            $("#eraserControl").css("display", "none");
            if (AppCfg.lang == "uyghur") {
                $btnEdit.children().removeClass().addClass("cb_complete2");
            }
            else {
                $btnEdit.children().removeClass().addClass("cb_complete");
            }
            if (!constrants.EDIT_WIDTH) {
                constrants.EDIT_WIDTH = _getMainToolBarWidth($ul);
            }
            $ul.css("width", constrants.EDIT_WIDTH);
        }
        else {
            $ul.find("li[menuStatus=edit]").css("display", "none");
            $ul.find("li[menuStatus=done],li[menuStatus=all]").css("display", "inline");
            if (AppCfg.lang == "uyghur") {
                $btnEdit.children().removeClass().addClass("cb_nature2");
            }
            else {
                $btnEdit.children().removeClass().addClass("cb_nature");
            }
            if (!constrants.NO_EDIT_WIDTH) {
                constrants.NO_EDIT_WIDTH = _getMainToolBarWidth($ul);
            }
            $ul.css("width", constrants.NO_EDIT_WIDTH);
        }

        toolBoxMgr.setIsEditing(isEditing);
        cardTemplateManager.setIsEditing(isEditing);
    //    searchManager && searchManager.setIsEditing(isEditing);
    //    resLibManager && resLibManager.setIsEditing(isEditing);
    }

    function changeWBEB(isWB){
       // if(_isEditing) return;

        var $ul = _btns.mainToolBar.find(">ul:first");

        isWB ? $ul.find("li[menuStatus=WB]").css("display", "inline") : $ul.find("li[menuStatus=WB]").css("display", "none");
        isWB ? $ul.find("li[menuStatus=EB]").css("display", "none") : $ul.find("li[menuStatus=EB]").css("display", "inline");

        //电子书页面预览需要单独处理
        isWB ? $("#btnPageView").hide() :  $("#btnPageView").show();

        if (!constrants.NO_EDIT_WIDTH) {
            constrants.NO_EDIT_WIDTH = _getMainToolBarWidth($ul);
        }
        $ul.css("width", constrants.NO_EDIT_WIDTH);
    }

    //工具箱
    function initToolBox(bookContainer) {
        var _toolBoxMgr = require('../toolbox/toolboxmgr');
        toolBoxMgr = new _toolBoxMgr.ToolboxManager();

        var toolBoxPanel = $($("#tool_box_template").html());

        var buttons = {
            btnToolBox: $("#btnToolBox"),
            btnToolBoxEdit: toolBoxPanel.find("#btnToolBoxEdit"),
            btnCloseToolBox: toolBoxPanel.find("#btnCloseToolBox")
        };
        var controls = {
            toolListPanel: toolBoxPanel.find("#toolListPanel"),
            toolBoxPanel: toolBoxPanel,
            Pagination: toolBoxPanel.find("#toolPagination"),
            toolBoxTopBar: toolBoxPanel.find("#toolBoxTopBar")
        };
        toolBoxMgr.init(buttons, controls, bookContainer);
    }

    function initTemplate(bookContainer) {
        var _cardTemplateManager = require('../../card/template/cardtemplatemanager');
        cardTemplateManager = new _cardTemplateManager.CardTemplateManager();
        cardTemplateManager.init(bookContainer);
    }

    //幕布
    function initCurtain(bookContainer) {
        var _curtainMgr = require('../curtainmgr').Instance;
        var buttons = {
            btnCurtain: $("#btnCurtain"),
            smartBarCurtain : $("#smartbar_btnCurtain")
        };
        var controls = {
            templateCurtain: $(document.getElementById('curtain_template').innerHTML)
        }
        _curtainMgr.init(buttons, controls, bookContainer);
    }

    function initPagePreView(_bookContainer, pageIndex, bookCode) {
        var buttons = {
            btnPageView: $("#btnPageView")
        }
        var controls = {
            boxPageView: $(document.getElementById('templatePageView').innerHTML)
        }
        pagePreView.init(buttons, controls, _bookContainer, pageIndex, bookCode);
    }

    function initPagePreViewIcon() {
        var buttons = {
        }
        var controls = {
            pageNum: $("#pageNum"),
            curPageNum: $("#curPageNum")
        }
        pagePreViewIcon.init(controls);
    }

    function initResLib(bookContainer, user) {
        var _resLibManager = require('../resLib/resourcelibrarymgr');
        resLibManager = new _resLibManager.ResourceLibraryManager();
        var buttons = {
            resLibBtn: $("#resLibBtn"),
            cloudResBtn: $("#cloudResBtn"),
            localResBtn: $("#localResBtn"),
            localResManagerBtn: $("#btnLocalResManager"),
            multiSelectBtn: $("#btnMultiSelect"),
            localResDeleteBtn: $("#btnLocalResDelete"),
            localResAllSelectBtn: $("#btnLocalResAllSelect"),
            localResNoSelectBtn: $("#btnLocalResNoSelect"),
            localResResCancelBtn: $("#btnLocalResCancel"),
            localResOpenBtn: $("#btnLocalResOpen"),

            SelectedCategoryValueInResBtn: $("#btnSelectedCategoryValueInRes"),
            SelectedModeValueInResBtn: $("#btnSelectedModeValueInRes"),
            GoBackToResIframeBtn: $("#btnGoBackToResIframe"),
            closeBtnResLibPanel: $("#closeBtn_resLibPanel")    };
        var controls = {
            resLibIfrm: $("#resLibIfrm"),
            resLibPanel: $("#resLibPanel"),
            resLibPanelTop: $("#resLibPanelTop"),
            resLibPanelMask: $("#resLibPanelMask"),
            resItems: $("#resItems"),
            Pagination: $("#Pagination"),
            localResLibPanel: $("#localResLibPanel"),
            pageBtnPanel: $("#pageBtnPanel"),
            elemMaskPanel: $("#elemMaskPanel"),
            noResTips: $("#noResTips"),
            repositoryPanel: $("#repositoryPanel")
        };

        resLibManager.init(buttons, controls, bookContainer);
        resLibManager.setUser(user);
        setGlobalContextResLibMgr(resLibManager);

        var offset = $("#mainToolBar").height() + $("#header").height() - 20;
        resLibManager.setMainToolBarPosition(offset);

        registerIframe("resLibIfrm", "*");
        return  resLibManager;
    }

    function initSearch(bookContainer, user) {
        var _searchManager = require('../resLib/searchmanager');
        searchManager = new _searchManager.SearchManager();
        var buttons = {
            btnInnerSearch: $("#btnInnerSearch"),
            btnOuterSearch: $("#btnOuterSearch"),
            btnInnerLocalSearch: $("#btnInnerLocalSearch"),
            btnInnerCloudSearch: $("#btnInnerCloudSearch"),
            btnInnerWebSearch: $("#btnInnerWebSearch"),
            btnCloseSearchPanel: $("#btnCloseSearchPanel"),
            btnInnerSearchVoiceIme: $("#btnInnerSearchVoiceIme"),
            btnInnerSearchWriteIme: $("#btnInnerSearchWriteIme"),
            btnInnerSearchKeyboardIme: $("#btnInnerSearchKeyboardIme"),
            btnOuterSearchVoiceIme: $("#btnOuterSearchVoiceIme"),
            btnOuterSearchWriteIme: $("#btnOuterSearchWriteIme"),
            btnOuterSearchKeyboardIme: $("#btnOuterSearchKeyboardIme"),
            btnSelectedCategory: $("#btnSelectedCategoryValue"),
            btnInnerSearchAll: $("#btnInnerSearchAll"),
            btnInnerSearchClass: $("#btnInnerSearchClass"),
            btnInnerSearchFile: $("#btnInnerSearchFile")
        };
        var controls = {
            searchIfrm: $("#searchIfrm"),
            searchPanel: $("#searchPanel"),
            searchPanelTop: $("#searchPanelTop"),
            searchPanelMask: $("#searchPanelMask"),
            searchItems: $("#searchItems"),
            searchPagination: $("#searchPagination"),
            localSearchPanel: $("#localSearchPanel"),
            outerSearchText: $("#outerSearchText"),
            innerSearchText: $("#innerSearchText"),
            ResCountValue: $("#ResCount"),
            SearchPageBtnPanel: $("#searchPageBtnPanel"),
            noSearchResTips: $("#noSearchResTips"),
            searchContentPanel: $("#searchContentPanel"),
            searchContentTop: $("#searchContentTop")
        };

        searchManager.init(buttons, controls, bookContainer);
        searchManager.setUser(user);
        setGlobalContextSearchMgr(searchManager);
     //   registerIframe("searchIfrm", "*");
    }

    function initWBView(container){
        WBpreView.init(container);
    }

    function setIsEditingNew(value){
        if (value == _isEditing) return;
        _isEditing = value;
    }

    exports.init = init;
    exports.setIsEditing = setIsEditing;
    exports.changeWBEB = changeWBEB;
    exports.initResLib = initResLib;
    exports.initSearch = initSearch;

    exports.setIsEditingNew = setIsEditingNew;
});
