/**
 * Created by zzsun on 14-9-1.
 */
var rankResData={
    downloadResRankOri:null,
    uploadResRankOri:null,
    httpDownloadParams:null,
    httpUploadParams:null
}

var resTypeClass = {
    "1": "re_group_ja",
    "3": "re_group_sc",
    "4": "re_group_xt",
    "6": "re_group_kj"
};

var resTypeTitle = {
    "1": "教案",
    "3": "素材",
    "4": "习题",
    "6": "课件"
};
define(function (require, exports) {
    var _cloudresourceBase = require('./cloudresourcebase');
    var path = require('../../../common/path');
    var _recommendResUrl = AppRemoteSvcCfg.ResBatch;
    var _ebookContext = require('../../ebookcontext').Instance;
	var _resourceContent = require('./resourcecontent').Instance;
    //资源分类名称
    var _resType={
        "0100": "教案",
        "0300": "素材",
        "0400": "习题",
        "0600": "课件"
    }
    //按照此序列进行排序
    var _resTypeArr=[
        "0600",
        "0100",
        "0400",
        "0300"
    ];
    function synchronizeresource(){
        this.bookContainer = "";
        this.recommendList = {
            data: [],
            total: 0
        };
        this.showStatus = {
            resource: [
            ]
        };
    };

    synchronizeresource.prototype = new _cloudresourceBase();
    /**
     * 初始化
     * @param bookContainer
     */
    synchronizeresource.prototype.init = function(bookContainer,smartBarEle){
        var _this = this;
        _this.bookContainer = bookContainer;
        _this.smartBarEle = smartBarEle;
        _this.smartBarPop = $('#smartbar_pop');
        _this.smartBarTool = $('#smartbar_tool');
        _this.smartBarTitle = _this.smartBarEle.find('.new_pop_tit2');
        _this.smartBarContent = _this.smartBarEle.find('.resource_tool_cont2');
        _this.registerEvent();
        _resourceContent.init(bookContainer,smartBarEle);
    };

    /**
     * 同步资源获取资源列表
     */
    synchronizeresource.prototype.setSynResList = function(result,status){
        var _this = this;
        if (!getBlackboardFlag()){
               //是否显示发布说说
            if(_ebookContext&&_ebookContext._curUser&&_ebookContext._curUser._name&&_ebookContext._curUser._name!="defaultuser")
            {
                $("#gotoResRankPubTalk").show();
            }
            $("#ranking_taba li").remove();
            $("#ranking_tabb li").remove();
            console.log(_ebookContext);
            //请求资源排行参数
            var bookInfo=result.bookContainer.bookMetaInfo;
            var resRankParam = {
                "subject":bookInfo.subject,
                "grade":bookInfo.grade,
                "publisher":bookInfo.publisher,
                "volumn":bookInfo.volumn,
                "edition":"",
                "stage":"",
                "book":bookInfo.bookCode,
    //            "unit":result.request.unit,
    //            "course":result.request.course,
                "order":null,
                "limit":5,   //请求返回的限制
                "unit1":result.request.unit,
                "unit2":result.request.course,
                "thumbsize": "180_255" //缩略图尺寸
            };
            this.downloadResRank(resRankParam);
            this.uploadResRank(resRankParam);
            $("#more_rank_taba").show();
            $("#more_rank_tabb").show();
        } else {
            _this.recommendList=result;
            _this.showStatus.resource = status;
           // result = result.data;
            console.log(result)
            $("#recommend_container").find("h3").show();
            if(this.recommendList.total==0){
                $("#recommend_container").find("h3").hide();
                var no_res = $('<p class="no_res01" name="record_nores">' +
                    '<img src="assert/images/no_res01.png"><br>' +
                    '<span>您的同步资源暂无资源</span></p>');
                $("#recommend_container").append(no_res);
                return;
            }
            $($("#recommend_container").find("ul[name='pop_recommend_list']")).find("li").remove();
            for(i = 0 ; i<_this.recommendList.length ; i++){
                _li = $('<li style="height: 80px;">'+
                    '<a href="javascript:;">'+
                    '<span class="sm_gs_img"><img src="assert/images/word.png" alt=""></span>'+
                    '<span class="sm_gs_text" id="title" style="height: 35px;">{title}</span>'+
                    '</a>'+
                    '</li>');
//                type = path.extname(_this.recommendList[i]);
//                type = type.replace('.','');
                url = _this.setDefaultPic("jpg");
                _li.find('img').attr("src", url);
                _li.attr("order", i);
                _li.attr('srcPath' , _this.recommendList[i].srcPath);
               // var realName = path.basename(_this.recommendList[i],'.jpg');
                realName = _this.recommendList[i].title;
                _li.find('a').attr("title",realName);
                _li.find(".sm_gs_text").text(realName);
                $($("#recommend_container").find("ul[name='pop_recommend_list']")[0]).append(_li);
                $('.smartbar_tab_cont_new').find('h3').hide();
            }
        }


    };
   /**
     * 最热资源获取并显示
     * @para resRankParam 请求参数
     */
    synchronizeresource.prototype.downloadResRank =function(resRankParam){
        resRankParam.order="-statistics.downloadcount";
        rankResData.httpDownloadParams=resRankParam;
        var url = AppRemoteSvcCfg.GetRankRes+ $.param(resRankParam);
        _ebookContext.getUser().getDataByUserToken(url).done(function(result){
            console.log("something");
            console.log(result)
            rankResData.downloadResRankOri=result;
            synchronizeresource.prototype.showDownloadResRank(5);
            synchronizeresource.prototype.showSpecialConut("ranking_taba");
        });
    };
    /**
     * 最新资源获取并显示
     * @para resRankParam 请求参数
     */
    synchronizeresource.prototype.uploadResRank =function(resRankParam){
        resRankParam.order="-date.uploadtime";
        rankResData.httpUploadParams=resRankParam;
        var url = AppRemoteSvcCfg.GetRankRes+ $.param(resRankParam);
        _ebookContext.getUser().getDataByUserToken(url).done(function(result){
            console.log("something");
            rankResData.uploadResRankOri=result;
            synchronizeresource.prototype.showUploadResRank(5);
            synchronizeresource.prototype.showSpecialConut("ranking_tabb");
        });
    };
    /**
     * 最热资源显示
     * @para count 要显示的数目
     */
    synchronizeresource.prototype.showDownloadResRank=function(count){
        $("#ranking_taba li").remove();
        var showData=rankResData.downloadResRankOri.data;
        var lastLength=count;
        var totalLength=showData.length;

        for(var i=0;i<lastLength&&i<totalLength;i++){
             var tempStr=  "<li class='{thisClass}'>";
                 tempStr+=   "<div class='ranking_xh'>"+(i+1)+"</div>";
                 tempStr+=   "<div class='ranking_img'><img src='{imgOri}' class='resRankGoDetail' style='cursor: pointer;'><span class='{re_group_class}'>{re_group_title}</span></div>";
                 tempStr+=   "<div class='ranking_info'>";
                 tempStr+=     "<p class='ranking_tit resRankGoDetail' style='cursor: pointer;'>{ranking_title}</p>";
                 tempStr+=     "<p class='clearfix'><span class='star'><em style='{score}'></em></span></p>";
                 tempStr+=     "<p class='gray'>{downCount}次下载</p>";
                 tempStr+=   "</div>";
                 tempStr+= "<div class='ranking_btn'><a style='cursor: pointer' class='wanglin_btn addResRakToBokA' title='加入课本'>加入课本</a></div>";
                 tempStr+= "</li>";
            var imgUrl=synchronizeresource.prototype.getImgUrl(showData[i].thumburl,showData[i].extension);
            var $tempStr=tempStr.replace('{imgOri}',imgUrl).replace('{ranking_title}',showData[i].title).replace('{downCount}',showData[i].statistics.downloadcount).replace('{score}','width:'+showData[i].statistics.score+'%;').replace('{thisClass}',showData[i].id+"rank")
                .replace('{re_group_class}',showData[i].properties.type&&resTypeClass[showData[i].properties.type[0][1]]||"re_group_sc").replace('{re_group_title}',showData[i].properties.type&&resTypeTitle[showData[i].properties.type[0][1]]||"素材");
            $("#ranking_taba").append($tempStr);
        }
        synchronizeresource.prototype.showSpecialConut("ranking_taba");
    };

    /**
     * 资源图标或预览图
     * @para thumburl 要显示url
     * @para extension 扩展名
     */
    synchronizeresource.prototype.getImgUrl = function(thumburl,extension){
        if(thumburl!=null&&thumburl!=""){
            return thumburl;
        }else{
            return this.setDefaultPic(extension);
        }
    };
    /**
     * 最新资源显示
     * @para count 要显示的数目
     */
    synchronizeresource.prototype.showUploadResRank=function(count){
        $("#ranking_tabb li").remove();
        var showData=rankResData.uploadResRankOri.data;
        var lastLength=count;
        var totalLength=showData.length;
        for(var i=0;i<lastLength&&i<totalLength;i++){
            var tempStr=  "<li class='{thisClass}'>";
            tempStr+=   "<div class='ranking_xh'>"+(i+1)+"</div>";
            tempStr+=   "<div class='ranking_img'><img src='{imgOri}' class='resRankGoDetail' style='cursor: pointer;'><span class='{re_group_class}'>{re_group_title}</span></div>";
            tempStr+=   "<div class='ranking_info'>";
            tempStr+=     "<p class='ranking_tit resRankGoDetail' style='cursor: pointer;'>{ranking_title}</p>";
            tempStr+=     "<p class='clearfix'><span class='star'><em style='{score}'></em></span></p>";
            tempStr+=     "<p class='gray'>{uptime}</p>";
            tempStr+=   "</div>";
            tempStr+= "<div class='ranking_btn'><a style='cursor: pointer' class='wanglin_btn addResRakToBokB' title='加入课本'>加入课本</a></div>";
            tempStr+= "</li>";
            var imgUrl=synchronizeresource.prototype.getImgUrl(showData[i].thumburl,showData[i].extension);
            var $tempStr=tempStr.replace('{imgOri}',imgUrl).replace('{ranking_title}',showData[i].title).replace('{uptime}',showData[i].uploadtime).replace('{score}','width:'+showData[i].statistics.score+'%;').replace('{thisClass}',showData[i].id+"rank")
                                .replace('{re_group_class}',showData[i].properties.type&&resTypeClass[showData[i].properties.type[0][1]]||"re_group_sc").replace('{re_group_title}',showData[i].properties.type&&resTypeTitle[showData[i].properties.type[0][1]]||"素材");
            $("#ranking_tabb").append($tempStr);
        }
        synchronizeresource.prototype.showSpecialConut("ranking_tabb");
    };

    /**
     * 显示资源排名的特殊数字
     * @para panelID 所属类别的ID
     */
    synchronizeresource.prototype.showSpecialConut= function(panelID){
        var tempObj=$("#"+panelID+" li");
        (tempObj[0])&&($(tempObj[0]).addClass('one'));
        (tempObj[1])&&($(tempObj[1]).addClass('two'));
        (tempObj[2])&&($(tempObj[2]).addClass('three'));
    };

    /**
     * 同步资源事件绑定
     */

    synchronizeresource.prototype.registerEvent = function(){
        var _this = this;
        $("#smartbar_recommend_syn").draggable({
            handle : $("#smartbar_recommend_syn").find('.smartbar_tit'),
            containment: 'window'
        });
        $(" #smartbar_recommend_syn_blackboard").draggable({
            handle : $(" #smartbar_recommend_syn_blackboard").find('.smartbar_tit'),
            containment: 'window'
        });


        $(document).on("click","#recommend_container li",function(){
            $("#smartbar_pop_syn").hide();
            var isSelf = false;
            var smartbar_pop= $('<div class="re_group_block_warp re_group_block_warp_top" id="smartbar_pop_syn" style="z-index: 1003;">'+
                '<div class="re_group_block_con re_group_block_warp_top_con">'+
                '<div id="resName" style="margin:10px"></div>'+
                '<dl>'+
                '<dd class="re_gr_img"><img  width = "132px" height="132px" id="previewImg" src="assert/images/re_gr_img01.png" alt=""></dd>'+
                '<dd class="re_gr_btn clearfix">'+
                '<span id="addResToBook">加入黑板</span>'+
                '<span id="previewRes">预览</span>'+
                '</dd>'+
                '</dl>'+
                '</div>'+
                '</div>');
            //    smartbar_pop.removeClass ("re_group_block_warp_top").addClass("re_group_block_warp_bot");
            //  smartbar_pop.find(">div").removeClass ("re_group_block_warp_top_con");
            if( $("#recommend_container").find("#smartbar_pop_syn").length!=0 && $($("#recommend_container").find("#smartbar_pop_syn").find('#previewRes')).attr("srcPath") == $($(this).find('#previewRes')).attr('srcPath')){
                isSelf = true;
            }
            $("#recommend_container").find("#smartbar_pop_syn").remove();

            if (!getBlackboardFlag()){
                var index = $(this).attr("contend"),
                    resType = $(this).attr("resType");
                for(var i in _resTypeArr){
                    if(_resTypeArr[i]==resType) break;
                }
                if(parseInt(index)%7==0) smartbar_pop.addClass("re_g_b_w_t_left");
                if(parseInt(index)%7==6) smartbar_pop.addClass("re_g_b_w_t_right");
                //i为资源分类下标 index为该分类下的资源下标
                _this.resetSmartBarEle('resource', i , index,'syn');
                var _recommendItem = _this.recommendList.data[i].data[index];
                console.log(_recommendItem)
                if (_this.showStatus.resource[i][index]) {
                    $(this).append(smartbar_pop);
                    $("#previewRes").attr("content_li", i);
                    $("#previewRes").attr("content_li_a", index);
                    $("#addResToBook").attr("content_li", i);
                    $("#addResToBook").attr("content_li_a", index);
                    if (_recommendItem.thumburl) $("#previewImg").attr("src", _recommendItem.thumburl);
                    this.scrollIntoView();
                }
            } else {
                if (isSelf == false){
                    var templateRes = $(this).attr('srcPath');
                    var order = $(this).attr('order');
                    if(parseInt(order)%7==0) smartbar_pop.addClass("re_g_b_w_t_left");
                    if(parseInt(order)%7==6) smartbar_pop.addClass("re_g_b_w_t_right");
                    // var realName = path.basename(templateRes,'.jpg');
                    smartbar_pop.find('#resName').text($(this).find('a').attr('title'));
                    $(this).append(smartbar_pop);
                    $("#previewRes").attr("srcPath", templateRes);
                    $("#previewRes").attr("srcName", $(this).find('a').attr('title'));
                    $("#addResToBook").attr("srcPath", templateRes);
                    $("#previewImg").attr("src", templateRes);
                    this.scrollIntoView();
                }

            }
        });
        //同步资源---查看资源
        $(document).on("click","#previewRes",function(event){
            if (!getBlackboardFlag()){
                var resType_index = $(this).attr("content_li"),
                    index = $(this).attr("content_li_a"),
                    resultData = _this.recommendList.data[resType_index].data[index],
                    type = resultData.extension,
                    url = resultData.previewurl;
                $("#smartbar_pop_syn").remove();
                resultData.resFrom = "synRes";
//            _this.resetSmartBarEle('resource', resType_index , index);
                _this.previewRes(type, url,resultData);
                event.stopPropagation();
                return false;
            } else {
                url = $(this).attr('srcPath');
                type = path.extname(url);
                type = type.replace('.','');
                resultData = {"title" : $(this).attr('srcName') , "url" : url};
                _this.previewRes(type, url, resultData);
                event.stopPropagation();
                return false;
            }

        });
        //同步资源---加入到书本
        $(document).on("click","#addResToBook",function(event){
            if (!getBlackboardFlag()){
                var resType_index = $(this).attr("content_li"),
                    index = $(this).attr("content_li_a"),
                    resultData =_this.recommendList.data[resType_index].data[index];
                resultData.resFrom = "synRes";
                newWidgetPos = null;
                $("#smartbar_pop_syn").remove();
//            _this.resetSmartBarEle('resource', resType_index , index);
                _this.downLoadFile(resultData);
                event.stopPropagation();
                return false;
            } else {
                var array = [];
                array[0] = $(this).attr('srcPath');
                _this.bookContainer.insertWidget(array,'');
            }

        });
  //资源榜资源加入课本
        $(document).on("click",".addResRakToBokA",function(event){
//            return false;
            var positionNum=$(this).parent().parent().find('div')[0].innerHTML-1;
            var resultData =rankResData.downloadResRankOri.data[positionNum];
            resultData.resFrom = "resRank";
//            newWidgetPos = null;
//            $("#smartbar_pop_syn").remove();
//            _this.resetSmartBarEle('resource', resType_index , index);
            _this.downLoadFile(resultData);
            event.stopPropagation();
            return false;
        });

        $(document).on("click",".addResRakToBokB",function(event){
//            return false;
            var positionNum=$(this).parent().parent().find('div')[0].innerHTML-1;
            var resultData =rankResData.uploadResRankOri.data[positionNum];
            resultData.resFrom = "resRank";
//            newWidgetPos = null;
//            $("#smartbar_pop_syn").remove();
//            _this.resetSmartBarEle('resource', resType_index , index);
            _this.downLoadFile(resultData);
            event.stopPropagation();
            return false;
        });
        //同步资源---拖拽下载
        $(document).on("dragend","#recommend_container li",function(e){
            var index = $(this).attr("contend"),
                resType = $(this).attr("resType");
            for(var i in _resTypeArr){
                if(_resTypeArr[i]==resType) break;
            }
            newWidgetPos = {
                left : e.originalEvent.clientX,
                top : e.originalEvent.clientY
            }
            var resultData = _this.recommendList.data[i].data[index];
            resultData.resFrom = "synRes";
            console.log(resultData);
            resultData && _this.downLoadFile(resultData);
        });
      //查看更多热门资源
        $("#more_rank_taba").click(function(){
            var currLength=$("#ranking_taba li").length;
            if(currLength<rankResData.downloadResRankOri.data.length){
                synchronizeresource.prototype.showDownloadResRank(currLength+5);
            }else{
                rankResData.httpDownloadParams.limit += 5;
                currLength+5>=rankResData.downloadResRankOri.total?rankResData.httpDownloadParams.limit=rankResData.downloadResRankOri.total:null;
                rankResData.httpDownloadParams.order="-statistics.downloadcount";
                var url = AppRemoteSvcCfg.GetRankRes+ $.param(rankResData.httpDownloadParams);
                _ebookContext.getUser().getDataByUserToken(url).done(function(result){
                    rankResData.downloadResRankOri=result;
                    synchronizeresource.prototype.showDownloadResRank(currLength+5);
                });
            }

            if(currLength+5>=rankResData.downloadResRankOri.total){
                $("#more_rank_taba").hide();
            }

        });
        //查看更多最新资源
        $("#more_rank_tabb").click(function(){
            var currLength=$("#ranking_tabb li").length;
            if(currLength<rankResData.uploadResRankOri.data.length){
                synchronizeresource.prototype.showUploadResRank(currLength+5);
            }else{
                rankResData.httpUploadParams.limit += 5;
                currLength+5>=rankResData.uploadResRankOri.total?rankResData.httpUploadParams.limit=rankResData.uploadResRankOri.total:null;
                rankResData.httpUploadParams.order="-date.uploadtime";
                var url = AppRemoteSvcCfg.GetRankRes+ $.param(rankResData.httpUploadParams);
                _ebookContext.getUser().getDataByUserToken(url).done(function(result){
                    rankResData.uploadResRankOri=result;
                    synchronizeresource.prototype.showUploadResRank(currLength+5);
                });
            }

            if(currLength+5>=rankResData.uploadResRankOri.total){
                $("#more_rank_tabb").hide();
            }
        });   
  //资源排行榜打开资源详情

        $("#ranking_taba").on('click','.resRankGoDetail',function(){
            var resIndex=$(this).parent().parent().find(".ranking_xh").html()-1;
            var resData = rankResData.downloadResRankOri.data[resIndex];
            console.log('open downloadResRankOri detail from resRank');
            _resourceContent.showResContentPanel(resData);
        });
        $("#ranking_tabb").on('click','.resRankGoDetail',function(){
            var resIndex=$(this).parent().parent().find(".ranking_xh").html()-1;
            var resData = rankResData.uploadResRankOri.data[resIndex];
            console.log('open uploadResRankOri detail from resRank');
            _resourceContent.showResContentPanel(resData);
        });
 };
    /**
     * smartBar 重置显示或隐藏状态
     * @param ele
     */
    synchronizeresource.prototype.resetSmartBarEle = function (ele) {
            for (var i in this.showStatus) {
                if (i == ele) {
                    if (typeof this.showStatus[i] == 'object') {
                        for (var j = 0, length = this.showStatus[i].length; j < length; j++) {
                            if (arguments[1] == j) {
                                this.showStatus[i][j][arguments[2]] = !this.showStatus[i][j][arguments[2]];
                            } else {
                                this.showStatus[i][j][arguments[2]] = false;
                            }
                        }
                    } else {
                        this.showStatus[i] = !this.showStatus[i];
                    }
                } else {
                    if (typeof this.showStatus[i] == 'object') {
                        for (j = 0, length = this.showStatus[i].length; j < length; j++) {
                            this.showStatus[i][j][arguments[2]] = false;
                        }
                    } else {
                        this.showStatus[i] = false;
                    }
                }
            }
        };
    exports.Instance = new synchronizeresource();
});
