/**
 *
 * User: chengyang@iflytek.com
 * Date: 14-7-17 下午3:25
 * Version: 1.0
 */

define(function (require, exports) {

    var _searchPanel = require('./search').Instance,
        _defaultDefine = require('../../define'),
        _ebookContext = require('../../ebookcontext').Instance,
        _shellcmd = require('../../../common/shellcmd'),
        _path = require('../../../common/path'),
        _cloudresourceBase = require('./cloudresourcebase'),
        _myNetDiskTpl = require('./netdisk/netdisktypechange').Instance,
        _cloudResourceLibTpl = require('./cloudresourcetypechange').Instance,
        _mainToolbar = require('../toolbar/maintoolbar'),
        _sideToolbar = require('../toolbar/sidetoolbar'),
        _canvasManager = require('../../paint/canvasmgr').Instance,
        shellcmd = require('../../../common/shellcmd'),
        _recommendResUrl = AppRemoteSvcCfg.ResBatch,
        _editionRqstUrl = AppSvcHelper.CYSVC + '&',
        _recommendRes = require('./recommendresource').Instance,
        _synRes = require('./synchronizeresource').Instance,
        _localResMgr = require('../toolbar/localres').Instance;
    curtainmgr = require('../curtainmgr').Instance;
    path = require('../../../common/path');
    require('jquery');
    //资源分类名称
    var _resType = {
        "0100": "教案",
        "0300": "素材",
        "0400": "习题",
        "0600": "课件"
    }
    //按照此序列进行排序
    var _resTypeArr = [
        "0600",
        "0100",
        "0400",
        "0300"
    ];

    function SmartBar() {
        //sidetoolbar侧边栏上的本地资源按钮，为解决循环引用的问题，放在这--pengfu
        this.controls = {
            btnLocalResMgr: $("#btnLocalResMgr")
        }
        this.bookContainer = null;
        this.bookContainWidth = 0;
        //对应smartbar的不同元素
        this.smartBarEle = null;
        this.smartBarTitle = null;
        this.smartBarContent = null;
        this.smartBarPop = null;
        this.smartBarTool = null;
        //编辑状态
        this.editStatus = false;
        //smartbar状态
        this.showStatus = {
            netdisk: false,
            search: false,
            tool: false,
            syn: false,
            resource: [
            ]
        };
        this.request = {
            subject: "",            //学科
            grade: "",              //年级
            publisher: "",          //出版社
            edition: "",            //教材版本
            phase: "",              //学段
            stage: "",              //年级册别
            book: "",               //书本
            unit: "",               //单元
            course: "",             //课时
            thumbsize: "185_185",     //图片大小
            order: "",              //排序
            type: "",               //资源类型
            q: "",                  //关键词
            page: 1,
            limit: 20
        };
        this.recommendList = {
            data: [],
            total: 0
        };
        //要根据bookcode去查edition，至于为什么这样，只有根据edition才能查资源
        this.editionRqst = {
            method: 'res.book.list',
            book: ''
        }
    }

    SmartBar.fn = SmartBar.prototype = new _cloudresourceBase();
    SmartBar.fn = SmartBar.prototype;
    SmartBar.fn.init = function (bookContainer) {
        var _this = this;
        this.editStatus = false;
        this.bookContainer = bookContainer;
        this.smartBarEle = $('#smartbar');
        this.smartBarPop = $('#smartbar_pop');
        this.smartBarTool = $('#smartbar_tool');
        this.smartBarTitle = this.smartBarEle.find("div[name=title_click]");
        this.smartBarContent = this.smartBarEle.find('.resource_tool_cont2');
        var bookContainerWidth = bookContainer.getContent().width(),
            smartBarWidth = this.smartBarEle.width(),
            left = ((bookContainerWidth - smartBarWidth) / 2).toFixed(2),
            height = this.smartBarTitle.height() + this.smartBarContent.height();
        this.bookContainWidth = bookContainerWidth;
        this.smartBarEle
            .css("left", "0px")
            .data("realHeight", height);
        this.registerEvent();
//        _this.registerRecommendPopEvent();
        app_global_alertNotEdit = function () {
            $.Zebra_Dialog("是否进入播放模式？", {
                'type': 'question',
                'title': AppTips.WarmTips,
                'buttons': [AppTips.CancelTips, AppTips.OkTips],
                'zIndex': 1000,
                'onClose': function (capition) {
                    if (capition == AppTips.OkTips) {
//                        _this.smartBarTitle.click();
                        _this.closeSmartBar();
                    }
                }
            });
        }
        //TODO:smartBAr初始化时改变title名称
        if (1 == 0) {
            var _unit = _this.bookContainer.getCurrUnit() || "";
            var _course = _this.bookContainer.getCurrCourse() || "";
            var unit = "";
            (_unit && _unit != "") && (unit = _this.bookContainer.bookMenu[parseInt(_unit) - 1].title);
            var course = "";
            (_course != "" && _course && _unit != "" && _unit) && (course = _this.bookContainer.bookMenu[parseInt(_unit) - 1].courses[parseInt(_course - 1)].Name);
            $("#title_click").find("span[name='tit']").text(course)
        }
//        _searchPanel.init(bookContainer, this.smartBarEle);
        //在smartbar初始化的时候初始化侧边栏上的本地资源管理按钮
        _localResMgr.init(_this);        //初始化云盘
        _myNetDiskTpl.init(bookContainer, this.smartBarEle);
        //初始化资源库
        _cloudResourceLibTpl.init(bookContainer, this.smartBarEle);
        //初始化推荐资源
        _recommendRes.init(bookContainer, this.smartBarEle);
        //初始化同步资源
        _synRes.init(bookContainer, this.smartBarEle);
    };
    //书本翻页时如果当前为编辑状态，则变成完成状态，完成状态不变
    SmartBar.fn.closeSmartBar = function () {
        var _this = this;
        //无论完成还是编辑状态，都关闭资源属性框
        $("#bookContainer").find(".user-popover").hide();
        if (_this.editStatus) {
            _this.editStatus = false;
            _this.smartBarContent.slideToggle("normal");
            if ($("#smartbar").attr("flag") == "top")
                _this.smartBarTitle.find('.resource_tool_tit_wrap2').find("span").addClass('ewmtriangel_up');
            else
                _this.smartBarTitle.find('.resource_tool_tit_wrap3').find("span").removeClass('ewmtriangel_up');
//            _this.smartBarTitle.find('.resource_tool_tit_wrap2').find("span").addClass('ewmtriangel_up');
            //设置推荐资源列表
            _this.getRecommendRes();
            _this.resetSmartBarEle(null);
            // !_this.editStatus && _this.resetSmartBarEle(null);
            $("#editorflag").hide();
            _this.setIsEditing();
        }
    }
    //打开
    SmartBar.fn.openSmartBar = function () {
        var _this = this;
        $("#bookContainer").find(".user-popover").hide();
        _this.editStatus = !_this.editStatus;
        _this.smartBarContent.slideToggle("normal");
        if (!_this.editStatus)
            if ($("#smartbar").attr("flag") == "top")
                _this.smartBarTitle.find('.resource_tool_tit_wrap2').find("span").addClass('ewmtriangel_up');
            else
                _this.smartBarTitle.find('.resource_tool_tit_wrap3').find("span").removeClass('ewmtriangel_up');
        if (_this.editStatus)
            if ($("#smartbar").attr("flag") == "top") {
                _this.smartBarTitle.find('.resource_tool_tit_wrap2').find("span").removeClass('ewmtriangel_up');
            } else {
                _this.smartBarTitle.find('.resource_tool_tit_wrap3').find("span").addClass('ewmtriangel_up');
            }
        //设置推荐资源列表
        _this.getRecommendRes();
        !_this.editStatus && _this.resetSmartBarEle(null);
        if (_this.editStatus)
            if ($("#smartbar").attr("flag") == "top") {
                $("#editorflagtop").show();
                $("#editorflagbottom").hide();
            }
            else {
                $("#editorflagbottom").show();
                $("#editorflagtop").hide();
            }

        var _setInterval;
        _this.editStatus && (_setInterval = setInterval(function () {
            if ($("#smartbar").attr("flag") == "top") $("#editorflagtop").hide();
            else  $("#editorflagbottom").hide();
            clearInterval(_setInterval);
        }, 5000));
        if (!_this.editStatus) {
            $("#editorflagtop").hide();
            $("#editorflagbottom").hide();
        }
        _this.setIsEditing();
    }

    //此函数只是为了简单粗暴的解决title正位问题
    SmartBar.fn.openClose = function () {
        var _this = this;
        //无论完成还是编辑状态，都关闭资源属性框
        $("#bookContainer").find(".user-popover").hide();
        if (!_this.editStatus) {
            _this.editStatus = !_this.editStatus;
            //    _this.getRecommendRes();
            !_this.editStatus && _this.resetSmartBarEle(null);
            _this.setIsEditing();
            $("#editorflag").show();
        }
        if (_this.editStatus) {
            _this.editStatus = !_this.editStatus;
            _this.setIsEditing();
            $("#editorflag").hide();
        }
    }
    /**
     * SmartBar事件绑定
     */
    SmartBar.fn.registerEvent = function () {
        var _this = this,
            resourceList = this.smartBarContent.find('.resource_tool_cont_box'),
            left = parseInt(_this.smartBarEle.css("left").replace(/px/gi, "")),
            bottom, width;
        //smartBar拖动移位
        $("#smartbar").draggable({
            disabled: false,
            handle: _this.smartBarTitle,
            containment: 'parent',
            distance: 30,
            helper: 'clone',
            opacity: 0.5,
            iframeFix: true,
            start: function (event, ui) {
                $("#editorflagbottom").hide();
                $("#editorflagtop").hide();
                $("#smartbar_pop").remove();
                $("#smartbar_tool").hide();
                _this.showStatus.tool = false;
            },
            stop: function (event, ui) {

                if ($("#smartbar").attr("flag") == "top") {
                    $("#smartbar").attr("flag", "bottom");
                    $("#top_tit").hide();
                    $("#bottom_tit").show();

                    $("#smartbar").css("top", "0px");
                    $("#smartbar").css("bottom", "");
                    $("")
//                    $("#smartbar").css("-webkit-transform", "");
                } else {
                    $("#smartbar").css("top", "");
                    $("#smartbar").css("bottom", "0px");
                    $("#top_tit").show();
                    $("#bottom_tit").hide();


                    $("#smartbar").attr("flag", "top");
//                    $("#smartbar").css("-webkit-transform", "rotate(180deg)");
                }
            }
        });
        this.smartBarTitle.off("click").on("click", function () {
            //       console.log(12312123123)
            //无论完成还是编辑状态，都关闭资源属性框
//            $("#bookContainer").find(".user-popover").hide();
//            _this.editStatus = !_this.editStatus;
//            _this.smartBarContent.slideToggle("normal");
//            if(!_this.editStatus)
//                if($("#smartbar").attr("flag")=="top")
//                    _this.smartBarTitle.find('.resource_tool_tit_wrap2').find("span").addClass('ewmtriangel_up');
//                else
//                    _this.smartBarTitle.find('.resource_tool_tit_wrap3').find("span").removeClass('ewmtriangel_up');
//            if(_this.editStatus)
//                if($("#smartbar").attr("flag")=="top"){
//                    _this.smartBarTitle.find('.resource_tool_tit_wrap2').find("span").removeClass('ewmtriangel_up');
//                }else{
//                    _this.smartBarTitle.find('.resource_tool_tit_wrap3').find("span").addClass('ewmtriangel_up');
//                }
//                      //设置推荐资源列表
//            _this.getRecommendRes();
//            !_this.editStatus && _this.resetSmartBarEle(null);
//            if(_this.editStatus)
//                if($("#smartbar").attr("flag")=="top")
//                {
//                    $("#editorflagtop").show();
//                    $("#editorflagbottom").hide();
//                }
//                else
//                {
//                    $("#editorflagbottom").show();
//                    $("#editorflagtop").hide();
//                }
//
//            var _setInterval;
//            _this.editStatus && (_setInterval = setInterval(function(){
//                if($("#smartbar").attr("flag")=="top") $("#editorflagtop").hide();
//                else  $("#editorflagbottom").hide();
//                clearInterval(_setInterval);
//            },5000));
//            if(!_this.editStatus)  { $("#editorflagtop").hide();$("#editorflagbottom").hide();}
//            _this.setIsEditing();
            _this.openSmartBar();
        });

        //云盘关闭
        $("#myNetDiskCloseBtn").click(function () {
            $("#myNetworkDiskTplPanel").hide();
            _this.resetSmartBarEle('netdisk');
        });

        //云资源库关闭
        $("#cloudResourceClose").click(function () {
            _shellcmd.killProcess('osk.exe');
            $("#cloudResLibTplPanel").hide();
            _this.resetSmartBarEle('search');
        });
        //打开我的网盘
        $("#my_netdisk").on("click", function () {
            var that = this;
            if (_ebookContext.getUser().getName() == AppCfg.testUser) {
                app_global_loginMgr.show();
                return;
            }
            _shellcmd.checkOnline().done(function (ret) {
                if (!ret) {
                    $.Zebra_Dialog("请先连接网络！", {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons': [ AppTips.OkTips],
                        'zIndex': 1000
                    });
                    return;
                }
                else {
                    _this.resetSmartBarEle('netdisk');
                    if (_this.showStatus.netdisk) {
                        global_scoll_flag2 = true;
                        _myNetDiskTpl.show();
                    }
                }
            })

        });

        //打开云资源库--8.20
        $("#yun_store").on("click", function () {
            _shellcmd.checkOnline().done(function (ret) {
                if (!ret) {
                    $.Zebra_Dialog("请先连接网络！", {
                        'type': 'information',
                        'title': AppTips.WarmTips,
                        'buttons': [ AppTips.OkTips],
                        'zIndex': 1000
                    });
                    return;
                }
                else {
                    //作用？
                    _this.resetSmartBarEle('search');
                    if (_this.showStatus.search) {
                        _cloudResourceLibTpl.show();
                        global_scoll_flag = true;
                    } else {
                        $("#cloudResLibTplPanel").hide();
                    }
                }
            });
        });
        //打开FileDialog
        $("#openFileDialog").on("click", function () {
            _this.resetSmartBarEle(null);
            setTimeout(_this.openFileDialog.call(_this, this), 5);
        });
        //打开tool
        $("#newCreate").on("click", function () {
            bottom = $("#smartbar").find(".resource_tool_cont2").css("height");
            width = $(this).parent().width();
            left = left - width;
            _this.resetSmartBarEle('tool');
            if (_this.showStatus.tool) {
                if ($("#smartbar").attr("flag") == "top") {
                    _this.smartBarTool.removeClass('new_pop_up').addClass('new_pop');
                    _this.smartBarTool.find('.new_pop_con_up').removeClass('new_pop_con_up').addClass('new_pop_con');
                    _this.smartBarTool.css({
                        left: _this.bookContainWidth - 125,
                        bottom: bottom,
                        top: "",
                        display: 'block',
                        position: "absolute",
                        "z-index": 550
                    });
                } else {
                    _this.smartBarTool.removeClass('new_pop').addClass('new_pop_up');
                    _this.smartBarTool.find('.new_pop_con').removeClass('new_pop_con').addClass('new_pop_con_up');
                    _this.smartBarTool.css({
                        left: _this.bookContainWidth - 125,
                        bottom: "",
                        top: bottom,
                        display: 'block',
                        position: "absolute",
                        "z-index": 550
                    });
                }
            }
        });
        //绑定tool事件
        this.smartBarTool.find('li').on("click", function () {
            _this.resetSmartBarEle('tool_li');
            var self = this;
            if ($(self).index() == 0) {
                shellcmd.shellexecutewithargs(Config.binPath + 'audio/AudioEditTool.exe');
            }
        });
        //打开同步资源
        $("#pop_recommend").click(function () {
            if (!getBlackboardFlag()) {
                //            console.log(_this.bookContainer.bookMetaInfo.title);
//            var BookName = _this.bookContainer.bookMetaInfo.title;
                var _unit = _this.bookContainer.getCurrUnit() || "";
                var _course = _this.bookContainer.getCurrCourse() || "";
                var unit = "";
                (_unit && _unit != "") && (unit = _this.bookContainer.bookMenu[parseInt(_unit) - 1].title);
                var course = "";
                if (_course != "" && _course && _unit != "" && _unit) {
                    var _curunit = _this.bookContainer.bookMenu[parseInt(_unit) - 1];
                    (_curunit.courses[parseInt(_course - 1)]) && (course = _curunit.courses[parseInt(_course - 1)].Name);
                }
//            var resAllName = BookName+"  " +unit +"  "+ course;
                var objTitle = $("#smartbar_recommend_syn h2");
                if (course && course != "") {
                    objTitle.html("资源排行榜—" + course);
                } else {
                    (unit && unit != "") && (objTitle.html("资源排行榜—" + unit));
                }
                console.log(objTitle.html());
//            $("#Book_Title").text(resAllName).attr("title",resAllName);
                _this.resetSmartBarEle('syn');
                if (_this.showStatus.syn) {
                    global_scoll_flag3 = true;
                    $("#smartbar_recommend_syn").show();
                    _synRes.setSynResList(_this, _this.showStatus.resource);
                    var bookContainerWidth = _this.bookContainer.getContent().width(),
                        smartBarWidth = $("#smartbar_recommend_syn").width(),
                        left = ((bookContainerWidth - smartBarWidth + 50) / 2).toFixed(2),
                        bookContainerHeight = _this.bookContainer.getContent().height(),
                        top = (bookContainerHeight - _this.smartBarEle.data("realHeight") - $("#smartbar_recommend_syn").height()) / 2;
                    $("#smartbar_recommend_syn").css({
                        position: "absolute",
                        left: left + "px",
                        top: "50px"
                    });
                    var containerWidth = parseInt($("#bookContainer").css("width"));
                    if (containerWidth < 800) {
                        correctToBaseResolution($("#smartbar_recommend_syn"), {keepScale: true});
                        $("#smartbar_recommend_syn").css("top", "-60px").draggable({disabled: true});
                    }
                }
                if ($("#smartbar_pop_syn").css("display") == "block")   $("#smartbar_pop_syn").hide();
            } else {
                $("li[name=subjectTemplate]").find("#smartbar_pop").remove();
                $("#Book_Title").text('').attr("title", '');
                //$('.smartbar_tit > h2').text('常用学科模板');
                _this.resetSmartBarEle('syn');
                global_scoll_flag3 = true;
                $("#smartbar_recommend_syn_blackboard").show();
                _synRes.setSynResList(_this.subjectTemplateRes, '');
                bookContainerWidth = _this.bookContainer.getContent().width(),
                    smartBarWidth = $("#smartbar_recommend_syn_blackboard").width(),
                    left = ((bookContainerWidth - smartBarWidth + 50) / 2).toFixed(2),
                    bookContainerHeight = _this.bookContainer.getContent().height(),
                    top = (bookContainerHeight - _this.smartBarEle.data("realHeight") - $("#smartbar_recommend_syn_blackboard").height()) / 2;
                $("#smartbar_recommend_syn_blackboard").css({
                    position: "absolute",
                    left: left + "px",
                    top: "50px"
                });
                containerWidth = parseInt($("#bookContainer").css("width"));
                if (containerWidth < 800) {
                    correctToBaseResolution($("#smartbar_recommend_syn_blackboard"), {keepScale: true});
                    $("#smartbar_recommend_syn_blackboard").css("top", "-60px").draggable({disabled: true});
                }
                if ($("#smartbar_pop_syn").css("display") == "block")   $("#smartbar_pop_syn").hide();
            }
        });
        //关闭同步资源
        $("#smartbar_recommend_syn").find(".close_res").click(function () {
            if ($("#smartbar_pop_syn").css("display") == "block")   $("#smartbar_pop_syn").hide();
            $("#smartbar_recommend_syn").hide();
            _this.resetSmartBarEle('syn');
        });

        $("#smartbar_recommend_syn_blackboard").find(".close_res").click(function () {
            if ($("#smartbar_pop_syn").css("display") == "block")   $("#smartbar_pop_syn").hide();
            $("#smartbar_recommend_syn_blackboard").hide();
            _this.resetSmartBarEle('syn');
        });
        //打开发布说说
        $("#gotoResRankPubTalk").click(function () {
            var BookName = _this.bookContainer.bookMetaInfo.title;
            var _unit = _this.bookContainer.getCurrUnit() || "";
            var _course = _this.bookContainer.getCurrCourse() || "";
            var unit = "";
            (_unit && _unit != "") && (unit = _this.bookContainer.bookMenu[parseInt(_unit) - 1].title);
            var course = "";
            if (_course != "" && _course && _unit != "" && _unit) {
                var _curunit = _this.bookContainer.bookMenu[parseInt(_unit) - 1];
                (_curunit.courses[parseInt(_course - 1)]) && (course = _curunit.courses[parseInt(_course - 1)].Name);
            }
            var preContent = "我正在查找" + BookName + "，" + unit + "，" + course + "的资源，快来帮助我吧！";
            $("#resRankPubTalkPanel textarea").val(preContent);
            $("#resRankPubTalkPanel i").html($("#resRankPubTalkPanel textarea").attr('maxlength') - preContent.length);

//            $("#smartbar_recommend_syn").hide();
//            _this.resetSmartBarEle('syn');
            $("#resRankPubTalk").show();
        });
        //关闭说说
        $("#closeResRankPubTalk").click(function () {
            _this.resetSmartBarEle('syn');
            $("#smartbar_recommend_syn").show();
        });
        //发布说说
        $("#subResRankPubTalk").click(function () {
            $("#resRankPubTalk").hide();
            var userId = _ebookContext._curUser._uid;
            var feedContent = $("#resRankPubTalkPanel textarea").val();
            feedContent = feedContent.replace(/\&/g, "%26").replace(/\+/g, "%2B").replace(/\?/g, "%3F").replace(/\#/g, "%23");
            var url = AppRemoteSvcCfg.UserPubStateTalk + "uid=" + userId + "&body=" + feedContent + "&source_url=";
//            _this.resetSmartBarEle('syn');
            $.ajax({
                url: url,
                dataType: 'json',
                timeout: 30000,
                success: function ($result) {
                    console.log($result);
                    if ($result.status == 1) {
                        console.log('发布说说成功');
                        var tips = tipsDialog({
                            "id": "resShareTips" + new Date().getTime(),
                            "content": "说说已发布到我的主页！",
                            "action": "openRemote",
                            "actionName": "点击查看",
                            "callback": function () {
                                _this.resetSmartBarEle('syn');
                                //跳转说说主页
                                shellcmd.openPageOutside(AppRemoteSvcCfg.ChangYanYunSSO);
                            }
                        });
                        console.log(tips);
                    } else {
                        console.log("发送失败:" + JSON.stringify($result));
                    }

                },
                error: function (err) {

                    console.log("发送失败:" + err);
//                   $("#smartbar_recommend_syn").show();
                }


            })


            //show 查看对话框
        });
        //说说输入框字数事件
        $("#resRankPubTalkPanel textarea").bind('input', function () {
            var currentContent = $(this).val();
            var count = parseInt($(this).attr('maxlength')) - currentContent.length;
            $("#resRankPubTalkPanel i").html(count.toString());
        })

    };
    /**
     /**
     * smartBar 重置显示或隐藏状态
     * @param ele
     */
    SmartBar.fn.resetSmartBarEle = function (ele) {
        this.smartBarContent.find('a').removeClass('current');
        this.smartBarPop.css('display', 'none');
        this.smartBarTool.css('display', 'none');
        this.preview.hide();
        //左右箭头是否翻页标志
        global_flag = false;
        global_scoll_flag = false;
        global_scoll_flag2 = false;
        global_scoll_flag3 = false;
        //关闭预览页面的同时将可能播放的音频关掉
        if ($("#audioId").get(0)) {
            $("#audioId").get(0).pause();
        }
        $("#smartbar_recommend_syn").hide();
        $("#smartbar_recommend_syn_blackboard").hide();
        $("#resRankPubTalk").hide();
        $("#resourceContentPage").hide();
        $("#cloudResLibTplPanel").hide();
        $("#resRankPubTalkLookTip").hide();
        _myNetDiskTpl && _myNetDiskTpl.close();
        (ele != 'tool_li') && curtainmgr.closeMainCurtainPanel();
        for (var i in this.showStatus) {
            if (i == ele) {
                if (typeof this.showStatus[i] == 'object') {
                    for (var j = 0, length = this.showStatus[i].length; j < length; j++) {
                        if (arguments[1] == j) {
                            this.showStatus[i][j][arguments[2]] = !this.showStatus[i][j][arguments[2]];
                        } else {
                            this.showStatus[i][j][arguments[2]] = false;
                        }
                    }
                } else {
                    this.showStatus[i] = !this.showStatus[i];
                }
            } else {
                if (typeof this.showStatus[i] == 'object') {
                    for (j = 0, length = this.showStatus[i].length; j < length; j++) {
                        this.showStatus[i][j][arguments[2]] = false;
                    }
                } else {
                    this.showStatus[i] = false;
                }
            }
        }
        if (arguments[3] && (arguments[3] == 'syn')) {
            this.showStatus.syn = true;
            $("#smartbar_recommend_syn").show();
            if (getBlackboardFlag()) {
                $("#smartbar_recommend_syn_blackboard").show();
            }
        }
    };
    /**
     * 获取推荐资源列表
     */
    SmartBar.fn.getRecommendRes = function () {
        var _this = this;
        var $recommendList_re_group = $('#recommendList').find(".re_group");
        if (!getBlackboardFlag()) {
            $recommendList_re_group.show();
            $($recommendList_re_group[4]).hide();
            var unit = _this.bookContainer.getCurrUnit();
            var course = _this.bookContainer.getCurrCourse() || "";
            _this.request.book = (_this.bookContainer.bookMetaInfo && _this.bookContainer.bookMetaInfo.bookCode) || "";
            _this.request.unit = unit;
            _this.request.course = course;
            var url = _recommendResUrl + $.param(_this.request);
            _ebookContext.getUser().getDataByUserToken(url).done(function (result) {
                var $recommendList = $("#recommendList");
                $recommendList.find(".re_group").show();
                $recommendList.show();
                $recommendList.find("p[name=nores]").remove();
                if (!result || result == "" || result.total == 0) {
                    var nores = $('<p class="no_res02" name="nores"></p>');
                    $recommendList.find(".re_group").hide();
                    $("#pop_recommend").hide();
                    $recommendList.find(">div").append(nores);
                    return;
                }
                $("#pop_recommend").show();
                _this.setOrderRecommendList(result);
            });
        } else {
            $("#recommendList").find("p[name=nores]").remove();
            $("#pop_recommend").show();
            var BasePath = path.trimPosix(Config.binPath) + "webapp/assert/images/subjectTemplate/";
            var SubjectTemplate = BasePath + "Subjecttemplate.json";
            var templateJson;
            shellcmd.readFileAsync(SubjectTemplate).done(function (ret) {
                templateJson = JSON.parse(ret);
            });
            for (var i = 0; i < templateJson.subjectTemplate.length; i++) {
                templateJson.subjectTemplate[i].srcPath = BasePath + templateJson.subjectTemplate[i].srcPath;
            }
            $recommendList_re_group.hide();
            $($recommendList_re_group[4]).show();
            _this.subjectTemplateRes = templateJson.subjectTemplate;
            _recommendRes.setRecommendResItem(_this.subjectTemplateRes);
        }
    };
    /**
     * 资源返回列表进行排序
     * 按照【课件--教案--习题--素材】的顺序排序
     * @param result
     */
    SmartBar.fn.setOrderRecommendList = function (result) {
        var _this = this;
        var total = result.total;
        var _result = {
            data: [],
            total: total
        }
        result = result.data;
        for (var i in _resTypeArr) {
            for (var j in result) {
                if (result[j].type == _resTypeArr[i]) {
                    _result.data.push(result[j]);
                }
            }
        }
        _this.recommendList = _result;
        for (var i = 0; i < result.length; i++) {
            var data = result[i].data;
            var tempArr = [];
            for (var j = 0; j < data.length; j++) {
                tempArr.push(false);
            }
            _this.showStatus.resource.push(tempArr);
        }
        _recommendRes.setRecommendResItem(_this.recommendList, _this.showStatus.resource);
    };

    /**
     * 设置编辑\完成状态
     */
    SmartBar.fn.setIsEditing = function () {
        var _this = this;
        var editStatus = this.editStatus;
        //从v2.1起maintoolbar只修改状态，不切换
        _mainToolbar.setIsEditingNew(editStatus);
        _sideToolbar.setIsEditing(editStatus);
        _canvasManager.setIsEditing(editStatus);
        this.bookContainer.setIsEditing(editStatus);

        var itemoverlays = $(".itemOverlay");

        editStatus ? itemoverlays.show() : itemoverlays.hide();

        itemoverlays.unbind().click(function () {

            var dialogs = $(".kk_yc");
            var flag = false;
            $.each(dialogs, function () {
                if ($(this).is(":visible")) flag = true;
            })

            !flag && (_this.closeSmartBar());

        })

        app_global_playerMgr && app_global_playerMgr.stop();
        //隐藏热区工具栏
        $(".hotspotPopToolBar").hide();
        //编辑状态下，隐藏笔迹
        editStatus ? this.bookContainer.hidePageItemCanvas() : this.bookContainer.showPageItemCanvas();
    };

    /**
     * 打开对话框，打开本地文件
     * @param ele
     * @returns {Function}
     */
    SmartBar.fn.openFileDialog = function (ele) {
        var self = this;
        var domEle = ele;
        return function () {
            var extFilter = _defaultDefine.extFilter;
            var ret = "", index = 0, type = extFilter.type;
            var calcFilter = function (arr) {
                var extArr = "";
                var args = arguments;
                if (arr instanceof  Array) {
                    for (var k = 0; k < arr.length; ++k) {
                        extArr += '*' + arr[k] + ';';
                    }
                }
                else if (arr instanceof Object) {
                    $.each(arr, function (i, e) {
                        extArr += args.callee(e);
                    });
                }
                return extArr;
            };

            $.each(extFilter.array, function (i, e) {
                var extArr = calcFilter(e);
                ret += type[index] + "|" + extArr + ";|";
                ++index;
            });
            /// 使用新的opendialog 方法
            ret = { "multi": true, "ext": []};
            _shellcmd.openFileDialog(ret).done(
                function (result) {
                    if (result) {
                        var _userName = decodeURI(_ebookContext.getUser()._userName) || _ebookContext.getUser()._name;
                        //疆版
                        //self.bookContainer.insertWidget(result,{userName:_userName,title:_path.filename(_path.toPosix(result.toString()))});
                        self.bookContainer.insertWidget(result, {userName: _userName});
                        $(domEle).removeClass('current');
                    }
                });
        }
    };
    exports.Instance = new SmartBar();
})
