/**
 *
 * User: chengyang@iflytek.com
 * Date: 14-7-18 下午3:24
 * Version: 1.0
 */

define ( function ( require, exports ) {
    var _shellcmd = require('../../../common/shellcmd'),
        _cloudresourceBase = require('./cloudresourcebase'),
        _ebookContext = require('../../ebookcontext').Instance,
        _tplParse = require('../../../speechui/code/thirdparty/template'),
        _cloudUrl = AppSvcHelper.CYSVC + "&",
        _baiduUrl = AppRemoteSvcCfg.BAIDU_URL,
        _SolrUrl =  App3rdUrl.DYSOLRURL,
        _currentSearch = "",
        url='';
    var cloudList = require('./cloudlist').Instance;

    var _resourceContentPage = require('./resourcecontent').Instance;

    require('jquery');

    function Search(){

        this.cloudSearchDom = $("#cloudResourceSearchPanel");
        this.content = this.cloudSearchDom.find('.has_checked_cont');
        this.searchMoreDom = this.cloudSearchDom.find('.more_btn');

        this.bookContainer = null;
        this.smartBarEle = null;
        this.searchPanel = null;
        this.resultHtmlTpl = null;
        this.hasInit = false;

        this.resSearchMore = false;

        this.resSearchNotFind = false;
        this.inputKeyWord = true;

        this.CloudList = null;

	    this.requestCloud = {
            method  : 'res.resource.list',
            thumbsize : '180_255',
            page:1,
            limit:10,
            q:"",
            filters:'-properties.type:1801'//过滤资源套餐这种类型的资源

    };

        this.result = {
            data  : [],
            total : 0
        };

	    //百度搜索
        this.requestBaidu = {
            page:1,
            pagesize:10,
            keyword:"",
            fileType:"doc",
            searchType:"baidu"
        };
        //东阳搜索
        this.requestSolr = {
            row:10,
            start:0,
            fq:"",
            q:"contentType:2_*",
            wt:"json",
            indent:true
        };

        //每个资源显示的模板
        this._eachResourceTpl = '<li id="{fid}" name="searchItem">' +
            '<div class="has_checked_cont_mid_ifo_top clearfix">' +
            '<a style="cursor:pointer;"  title="" class="has_checked_cont_link">' +
            '<img src="{thumbpath}" name="thumbImage">' +
            '</a>' +
            '<div class="has_checked_cont_mid_ifo">' +
            '<h6>{namePlusExt}</h6>' +
            '<p>{description}</p>' +
            '</div>' +
            '</div>' +
            '<p class="has_checked_cont_info clearfix">' +
            '<span class="color_989797">{modifytime}</span>' +
            '<span class="color_989797">大小：{size}M</span>' +
            '<span class="color_989797">格式：{type}</span>' +
            '<span class="color_989797">下载数：{downloadCount}</span>'+

            '</p>' +
            '<div class="smartbar_btn_box ">' +
            '<a style="cursor:pointer;"  preViewUrl="{preViewUrl}" extension="{type}" contend="{contend}" name="search_resView" class="wanglin_btn" title="资源详情">资源详情</a>' +
            '<a style="cursor:pointer;"  fileUrl="{fileUrl}" thumbnail="{thumbpath}" contend="{contend}" name="search_AddToBook" class="wanglin_btn" title="加入课本">加入课本</a>' +
            ' </div>' +
            '</li>';

    }

    Search.fn = Search.prototype = new _cloudresourceBase();
    Search.fn.constructor = Search;

    Search.fn.init = function(bookContainer, smartBarEle){
        var _this = this;
        var _loginFrom = _ebookContext.getUser().getLoginForm();
        if(_loginFrom=="东阳"){
            $("#dongyangSolr").show();
        }else{
            $("#dongyangSolr").hide();
        }
        //绑定事件
        _this.registerEvent();

        _resourceContentPage.init(bookContainer,smartBarEle);
    };

    Search.fn.show = function(){
        var _this = this;

    };
    Search.fn.registerEvent = function(){
        var _this = this;

        $(document).on("click","a[name='resSearch']",function(){
            $("a[name='resSearch']").removeClass('current');
            $(this).addClass('current');
            _currentSearch = $(this).attr("title");
            $("#searchList").html("");
            $("#no_search").show();
            $("#search_more").hide();
            $("#search_list_not_found").hide();
            console.log(_currentSearch)
        });
     //   correctToBaseResolution(this.searchPanel, {keepScale: true});
        //拖拽下载
        $(document).on("dragend","li[name='searchItem']",function(e){
            var index = $(this).index("#searchList li[name='searchItem']");
            var   resultData = _this.result.data[index];
            resultData.resFrom = "yun_search";
            newWidgetPos = {
                left : e.originalEvent.clientX,
                top : e.originalEvent.clientY
            }
            //调用基类方法中的下载文件方法
            _this.downLoadFile(resultData);
        });

        this.cloudSearchDom
            .on("click", ".btn", function(){
                _shellcmd.killProcess('osk.exe');
//                _currentSearch = $(".smartbar_resource_tab .current").text();
                _currentSearch = $(".smartbar_resource_tab .current").attr('title');
	            switch (_currentSearch){
                    case "畅言资源":  var _request = _this.requestCloud;
                                    _request.q = $(this).siblings(".search_input").find('input').val();
                                    if(!_request.q){ return false;}
                                    _request.page = 1;
                                     _this.search(true);break;
                    case "百度资源": var _request = _this.requestBaidu;
                                    _request.keyword = $(this).siblings(".search_input").find('input').val();
                                    if(!_request.keyword){ return false;}
                                    _request.page = 1;
                                    _this.search(true);break;
                    case "东阳资源": var _request = _this.requestSolr;
                                    _request.q = $(this).siblings(".search_input").find('input').val()||"*:*";
                                    if(!_request.q){ return false;}
                                    _request.start = 0;
                                    _this.search(true);break;

                }
            })
            .on("keydown", ".search_input input", function(e){
                if(e.which == 13){
                    _shellcmd.killProcess('osk.exe');
//                    _currentSearch = $(".smartbar_resource_tab .current").text();
                    _currentSearch = $(".smartbar_resource_tab .current").attr("title");
		            switch (_currentSearch){
                        case "畅言资源":  var _request = _this.requestCloud;
                            _request.q = $(this).val();
                            if(!_request.q){ return false;}
                            _request.page = 1;
                            _this.search(true);break;
                        case "百度资源": var _request = _this.requestBaidu;
                            _request.keyword = $(this).val();
                            if(!_request.keyword){ return false;}
                            _request.page = 1;
                            _this.search(true);break;
                        case "东阳资源": var _request = _this.requestSolr;
                            _request.q = $(this).val()||"*:*";
                            if(!_request.q){ return false;}
                            _request.start = 0;
                            _this.search(true);break;
                    }
                }
            })
            .on("click", "#search_more" , function(){

                switch (_currentSearch){
                    case "畅言资源":  _this.requestCloud.page++;break;
                    case "百度资源":  _this.requestBaidu.page++;break;
                    case "东阳资源":  _this.requestSolr.start++;break;
                }
                _this.search(false);

            })
            //资源预览
            .on("click", "a[name='search_resView']", function(){
                var index = $(this).index("#searchList a[name='search_resView']");
                var resultData = _this.result.data[index];
                var   type = resultData.extension;
                var   url = resultData.previewurl;
                resultData.resFrom = "yun_search";
                //调用基类方法中的预览方法
                if(_currentSearch=="东阳资源"){
                    var _requestUrl = App3rdUrl.DYSOURCEVIEW + resultData.id;
                    _shellcmd.getHttpRequest(_requestUrl).done(function(result){
                        if(result){
                            result = JSON.parse(result);
                                var _previewUrl =result.data.liveUrl;
                            _previewUrl = _previewUrl.replace(App3rdUrl.DYRESOLDPREFIX,App3rdUrl.DYRESVIEWNEWPREFIX);
                            resultData.previewurl=_previewUrl
                            console.log(resultData.previewurl);
                            _this.previewRes(type,resultData.previewurl,resultData);
                        }
                    });
                }else{

                    _resourceContentPage.showResContentPanel(resultData);
                }
//                _this.previewFlash(url);

            })
            .on("click", "img[name=thumbImage]", function(){
                var index = $(this).index("#searchList img[name=thumbImage]");
                var resultData = _this.result.data[index];
                var   type = resultData.extension;
                var   url = resultData.previewurl;
                resultData.resFrom = "yun_search";
                //调用基类方法中的预览方法
                if(_currentSearch=="东阳资源"){
                    var _requestUrl = App3rdUrl.DYSOURCEVIEW + resultData.id;
                    _shellcmd.getHttpRequest(_requestUrl).done(function(result){
                        if(result){
                            result = JSON.parse(result);
                            var _previewUrl =result.data.liveUrl;
                            _previewUrl = _previewUrl.replace(App3rdUrl.DYRESOLDPREFIX,App3rdUrl.DYRESVIEWNEWPREFIX);
                            resultData.previewurl = _previewUrl;
                            console.log(resultData.previewurl);
                            _this.previewRes(type,resultData.previewurl,resultData);
                        }
                    });
                }else{
                    _this.previewRes(type,url,resultData);
                }
            })
            //加入到课本
            .on("click", "a[name='search_AddToBook']", function(){
                var index = $(this).index("#searchList a[name='search_AddToBook']");
                var   resultData = _this.result.data[index];
                resultData.resFrom = "yun_search";
                newWidgetPos=null;
                //调用基类方法中的预览方法
                if(_currentSearch=="东阳资源"){
                    var _requestUrl = App3rdUrl.DYSOURCEVIEW  + resultData.id;
                    _shellcmd.getHttpRequest(_requestUrl).done(function(result){
                        if(result){
                            result = JSON.parse(result);
                            resultData.fileurl= result.data.downloadUrl;
                            console.log(resultData.fileurl);
                            _this.downLoadFile(resultData);
                        }
                    });
                }else{
                    _this.downLoadFile(resultData);
                }
//                //调用基类方法中的下载文件方法
//                _this.downLoadFile(resultData);

            })
            .on("click","#ssearchKeyboard",function(){

                _shellcmd.callIme("keyboard",$(".tool_search input"));
                _this.cloudSearchDom.find(".search_input").find('input').focus();
            })
            .on("click","#ssearchInkWrite",function(){
                //单例调用输入法程序 PC_Win32_iFlyInk

                _shellcmd.callSingleton('iFlyInk.exe', "write", $(".tool_search input"));
               setTimeout(function(){
                   _this.cloudSearchDom.find(".search_input").find('input').focus();
               },500);
            })
            .on("click","#ssearchVioce",function(){

                _shellcmd.killProcess('PC_Win32_iFlyInk').done(function () {
                    //单例调用输入法程序
                    _shellcmd.callSingleton('iFlyVoice.exe', "voice", $(".tool_search input"));
                    _this.cloudSearchDom.find(".search_input").find('input').focus();
                });

            })

            .find(".search_input").find('input').on("input propertychange",function(){
               if($(this).val()&&$(this).val().length>20){
                  // alert("最多只允许输入8个字");
                   $(this).val($(this).val().substr(0,20));
               }
            });


    };

    Search.fn.search = function(isReload){
        var _this = this;
            //应测试的要求，刷新下滚动条，把滚动条放最上面
        isReload && ($("#cloudResLibTplPanel").find('.has_checked_cont_warp').scrollTop(0));
            //只要执行了搜索操作，原来资源搜索一开始的提示语“请输入关键字”就应该隐藏了
            _this.inputKeyWord = false;
            $("#search_input_keyword").hide();

            switch (_currentSearch){

                case "畅言资源": url = _cloudUrl + $.param(_this.requestCloud);break;
                case "百度资源": url = _baiduUrl + $.param(_this.requestBaidu); console.log($.param(_this.requestBaidu));break;
                case "东阳资源": url = _SolrUrl + $.param(_this.requestSolr);break;
            }
            _ebookContext.getUser().getDataByUserToken(url).done(function(result){
            console.log(result);
            $("#no_search").hide();
            if(result.total<=0||result==""){
                $("#searchList").html("");
                $("#search_more").hide();
                $("#search_list_not_found").show();
                return;
            }else{
                $("#search_list_not_found").hide();
            }
            _this.dataFormat(result,isReload);
        });
    };

    /**
     * 数据格式转变
     */
    Search.fn.dataFormat = function(result,isReload){
        var _this=this;
        //东阳资源返回列表封装
        if(_currentSearch=="东阳资源"){
            var response = result.response,datas = result.response.docs,data=[];
            for(var i=0,length=datas.length; i<length; i++){
                datas[i].extension = getSuffix(datas[i].productname);
               var  _title = getTitle(datas[i].title[0])
                var item = {
                    "id":datas[i].contentidlist[0],
                    "code":datas[i].productcode,
                    "title":_title||"未命名文件",
                    "extension":datas[i].extension,
                    "thumburl":"",//datas[i].filePicturePath,
                    "creator":datas[i].provider,
                    "length":  datas[i].fileSize||"",
                    "lastmodify":datas[i].prodcreatetime,
                    "description":datas[i].productdesc.length>100?datas[i].productdesc.substr(0,99)+"···":datas[i].productdesc,
                    "fileurl":datas[i].url||"",
                    "desc":datas[i].productdesc,
                    "previewurl":datas[i].swfFileUrl,
                    "statistics":{"downloadcount":0}
                }
                data.push(item);
            }
            result={
                "data":data,
                "total":response.numFound
            }
            /**
             * 获取标题名称不包含后缀
             * @param title
             * @returns {string}
             */
            function getTitle(title){
                if (title != "") {
                    var names = title.split("\\");
                    var pos = names[names.length - 1].lastIndexOf(".");
                    return names[names.length - 1].substring(pos, names.length - 1);
                }
            }
            /**
             * 获取后缀
             * @param title
             * @returns {string}
             */
            function getSuffix(title){
                if (title != "") {
                    var names = title.split("\\");
                    var pos = names[names.length - 1].lastIndexOf(".");
                    var length = names[names.length - 1].length;
                    return names[names.length - 1].substr(pos+1, length - 1);
                }
            }
        }
        //百度资源返回列表封装
        if(_currentSearch=="百度资源"){
            var datas = result.data,data=[];
            for(var i=0,length=datas.length; i<length; i++){
                var item = {
                    "id":datas[i].id,
                    "title":datas[i].title||"未命名文件",
                    "extension":"doc",
                    "thumburl":"",
                    "creator":"",
                    "length":  "",
                    "lastmodify":"2014-07-12",
                    "description":"",
                    "fileurl":"http:"+datas[i].realpath,
                    "desc":"",
                    "previewurl":"",
                    "statistics":{"downloadcount":0}
                }
                data.push(item);
            }
            result={
                data:data,
                total:result.total// do what?
            }
        }
        //畅言资源返回列表封装
        if(_currentSearch=="畅言资源"){
            for(var i =0;i<result.data.length;i++){
                if(!result.data[i].title){
                    result.data[i].title = "未命名文件";
                }
            }
        }
        console.log(result);
        if(isReload) _this.result = result;
        else {
            $.merge(_this.result.data, result.data);
        }
        _this.setSearchList(result,isReload);
    };
    Search.fn.setSearchList = function(result, isReload){
        var _this = this;
            var data = result.data;
        if(isReload){
            $("#searchList").html("");
        }
        $("#search_more").show();
        var thumburl ='';
        for(var i=0;i<data.length;i++){
            thumburl = data[i].thumburl;
            if(!thumburl){
                thumburl = _this.setDefaultPic(data[i].extension);
            }
           var _eachResourceTpl = _this._eachResourceTpl
                .replace("{fid}",data[i].id)
                .replace("{thumbpath}",thumburl)
                .replace("{namePlusExt}",data[i].title+"."+data[i].extension)
                .replace("{description}",data[i].description)
                .replace("{modifytime}",data[i].lastmodify)
                .replace("{size}",(data[i].length/(1000000)).toFixed(2))
                .replace("{type}",data[i].extension)
                .replace("{fileUrl}",data[i].fileurl)
                .replace("{preViewUrl}",data[i].previewurl)
                .replace("{thumbpath}",data[i].thumburl)
                .replace("{type}",data[i].extension)
                .replace("{downloadCount}",data[i].statistics.downloadcount);
            $("#searchList").append(_eachResourceTpl);
        }
        if(_this.result.data.length>=_this.result.total) $("#search_more").hide();
    };
    Search.fn.close = function(){
        this.searchPanel && this.searchPanel.hide();
    };
    exports.Instance = new Search();
});
