/**
 * Created by pengfu on 14-12-23.
 */
;
define(function(require,exports){

    var _cloudresourceBase = require('./cloudresourcebase');
    var _snsBase = AppRemoteSvcCfgBase.CYSNSBASEFEED + "?";
    var _ebookContext = require('../../ebookcontext').Instance;
    var _shellCmd = require('../../../common/shellcmd');
    var ResPageControl = require('./resourcepagecontrol').ResourcePageControl;
    var _resourceErr = require('./resourceerror').Instance;
    var _scoreUrlBase = AppSvcHelper.CYSVC + "&";

    var _path = require('../../../common/path');


    function ResContent(){
        var _self = this;

        var _hasInit = false;

//        var _login = false;

        var _resPageControl = null;

        //存放多张缩略图的数组
        var _thumbnailArr = [];

        //多张缩略图的索引
        var _currIndex = 0;

        //打分成功标志
        var _scoreSucess = false;

        //下载相关参数
        var _downloadParam = {};
        $.each(("id title author thumbnail description keywords publisher " +
            "subject volumn bookCode username realname unit course fileSize grade " +
            "category file extension source sourcepage savepath dbpath photo").split(" "), function (i, name) {

            _downloadParam[ name ] = '';
        });

        var _indexUrl = '';

        //添加评论
        var _addComment = {
            method  : 'sns.feed.addcomment',
            uid     : '',
            content : '',
            to_comment_id:'',
            to_uid  : '',
            resourceId : ''
        };

       //获取评论
       var _getComment = {
            method  : 'sns.feed.commentlist',
            resourceId : '',
            page:   1,
            limit : 10
        }

        //打分
        var _score = {
            method: 'res.resource.statistic.update',
            key:    'scorecount',
            resourceid :   '',
            score:''
        }

        //增加阅读数
        var _addViewCount = {
            method: 'res.resource.statistic.update',
            key:    'viewcount',
            resourceid :   ''
        }

        //让label标签加1
        var _addLabel = {
            method: 'res.label.add',
            uid:'',
            resId:'',
            labelId:''

        }

        //获取某个资源的label列表
        var _getLabel = {
            method:'res.label.list',
            resId:''
        }

       var _addDownloadCount = {
            method: 'res.resource.statistic.update',
            key:    'downloadcount',
            resourceid :   ''

        }

        var _commentTplLogin =  '<li>'+
            '<p class="clearfix"><a href="javascript:;" class="blue_text" userid="{userid}" name="people">{commentor}：</a>{commentContent}</p>'+
            '<p class="clearfix"><span class="fl gray">{time}</span><span class="fr"><a href="javascript:;" flag="commentFlag" class="blue_text">回复评论</a></span></p>'+
            '<p class="clearfix" style="display: none;"><span class="fl"><input name="" type="text" value=""></span><span class="fr"><a href="javascript:;" flag="replyFlag" myuid={uid} mycommentid={commentid} resId={resourceId} class="smartbar_btn" style="width: 50px" title="回复">回复</a></span></p>'+
            '</li>';
        var _commentTplNoLogin =  '<li>'+
            '<p class="clearfix"><a href="javascript:;" class="blue_text" userid="{userid}" name="people">{commentor}：</a>{commentContent}</p>'+
            '<p class="clearfix" style="display: none"><span class="fl gray">{time}</span><span class="fr"><a href="javascript:;" flag="commentFlag" class="blue_text">回复评论</a></span></p>'+
            '<p class="clearfix" style="display: none;"><span class="fl"><input name="" type="text" value=""></span><span class="fr"><a href="javascript:;" flag="replyFlag" myuid={uid} mycommentid={commentid} resId={resourceId} class="smartbar_btn" style="width: 50px" title="回复">回复</a></span></p>'+
            '</li>';
        var _commentTpl = '' ;

        var _otherCommentTplLogin = '<li>'+
            '<p class="clearfix"><a href="javascript:;" class="blue_text" userid="{userid}" name="people">{subjector}</a><a> 对 </a><a href="javascript:;" class="blue_text" userid="{to_userid}" name="people">{objector}</a><a>说：</a>{commentContent}</p>'+
            '<p class="clearfix"><span class="fl gray">{time}</span><span class="fr"><a href="javascript:;" flag="commentFlag" class="blue_text">回复评论</a></span></p>'+
            '<p class="clearfix" style="display: none"><span class="fl"><input name="" type="text" value=""></span><span class="fr"><a href="javascript:;" flag="replyFlag" myuid={uid} mycommentid={commentid} resId={resourceId} class="smartbar_btn" style="width: 50px" title="回复">回复</a></span></p>'+
            '</li>';
        var _otherCommentTplNoLogin = '<li>'+
            '<p class="clearfix"><a href="javascript:;" class="blue_text" userid="{userid}" name="people">{subjector}</a><a> 对 </a><a href="javascript:;" class="blue_text" userid="{to_userid}" name="people">{objector}</a><a>说：</a>{commentContent}</p>'+
            '<p class="clearfix" style="display: none"><span class="fl gray">{time}</span><span class="fr"><a href="javascript:;" flag="commentFlag" class="blue_text">回复评论</a></span></p>'+
            '<p class="clearfix" style="display: none"><span class="fl"><input name="" type="text" value=""></span><span class="fr"><a href="javascript:;" flag="replyFlag" myuid={uid} mycommentid={commentid} resId={resourceId} class="smartbar_btn" style="width: 50px" title="回复">回复</a></span></p>'+
            '</li>';

        var _otherCommentTpl = '';

//        var _compressionTpl = '<a href="#" class="yx_btnred">内容详实(<em>272</em>)</a><a href="#" class="yx_btnorange">内容原创(<em>402</em>)</a><a href="#" class="yx_btnblue">趣味性强(<em>322</em>)</a><a href="#" class="yx_btngreen">效果美观(<em>182</em>)</a><a href="#" class="yx_btnred">互动性强(<em>282</em>)</a><a href="#" class="yx_btnorange">素材质量一般(<em>22</em>)</a><a href="#" class="yx_btnblue">不符合教学要求(<em>2</em>)</a>';

//        var _compressionTpl = '<a href="#" class="yx_btnred">内容详实(<em>272</em>)</a><a href="#" class="yx_btnorange">内容原创(<em>402</em>)</a><a href="#" class="yx_btnblue">趣味性强(<em>322</em>)</a><a href="#" class="yx_btngreen">效果美观(<em>182</em>)</a><a href="#" class="yx_btnred">互动性强(<em>282</em>)</a><a href="#" class="yx_btnorange">素材质量一般(<em>22</em>)</a><a href="#" class="yx_btnblue">不符合教学要求(<em>2</em>)</a><a href="#" class="yx_btngreen">实用性强(<em>2</em>)</a><a href="#" class="yx_btnred">思路新颖(<em>2</em>)</a><a href="#" class="yx_btnorange">内容非常生动(<em>2</em>)</a><a href="#" class="yx_btnblue">应用价值不高(<em>2</em>)</a>';
        _self.bookContainer =null;
        _self.smartBarEle = null;
        _self.resultData = null;
        _self.buttons = {
            btn_closeResCntPage:$("#btn_closeResCntPage"),
            btn_resourcepreview:$("#btn_resourcepreview"),
            btn_addToBook:$("#btn_addToBook"),
            btn_IComment:$("#btn_IComment")
        };

        _self.controls = {
            resourceContentPage:$("#resourceContentPage"),
            resourceCntTitle:$("#resourceCntTitle"),
            commentArea:$("#commentArea"),
            commentList:$("#commentList"),
            scoreStarId:$("#scoreStarId"),
            resShareId:$("#resShareId"),
            findErrorId:$("#findErrorId"),
            userCompressionId:$("#userCompressionId"),
            resourceTitleId:$("#resourceTitleId"),
            commentsCounts:$("#commentsCounts"),
            resourceStarsId:$("#resourceStarsId"),
            resourceAuthorId:$("#resourceAuthorId"),
            extensionTypeId:$("#extensionTypeId"),
            previewCountId:$("#previewCountId"),
            downloadCountId:$("#downloadCountId"),
            byteCountId:$("#byteCountId"),
            uploadTimeId:$("#uploadTimeId"),
            resourceDesId:$("#resourceDesId"),
            editorPreId:$("#editorPreId"),
            editorNextId:$("#editorNextId"),
            viewThumbsId:$("#viewThumbsId"),
            downloadresId:$("#downloadresId"),
            resContProBarId:$("#resContProBarId"),
            realBarId:$("#realBarId"),
            cancelResContId:$("#cancelResContId"),
            comments_dl:$("#comments_dl")



        };

        _self.init = function(bookContainer,smartBarEle){
            if(_hasInit){
                return;
            }
            setGlobalContextResContMgr(_self);
            _hasInit = true;
            _self.bookContainer = bookContainer;
            _self.smartBarEle = smartBarEle;

            _resPageControl = new ResPageControl("resContPageContr");
            _resPageControl.onclick = function(index){
                _self.getComments(index).done(function(retObj){
                    _self.renderComments(retObj);
                    _self.bindEvents();
                })
            }

            _self.buttons.btn_closeResCntPage.click(function(){
                _self.closeResContentPanel();
            })

            _self.controls.resourceContentPage.draggable({

                handle: _self.controls.resourceCntTitle,
                containment: "window"
            });

            //预览
            _self.buttons.btn_resourcepreview.click(function(){
                var   type = _self.resultData.extension;
                var   url =  _self.resultData.previewurl;
                _self.closeResContentPanel();
                _self.previewRes(type,url,_self.resultData);
            })

            //直接点击图片区域也是预览效果
            _self.controls.viewThumbsId.click(function(){
                var   type = _self.resultData.extension;
                var   url =  _self.resultData.previewurl;
                _self.closeResContentPanel();
                _self.previewRes(type,url,_self.resultData);
            })

            //加入课本
            _self.buttons.btn_addToBook.click(function(){

                _self._swithToBar();
                var resultData = _self.resultData;
                newWidgetPos=null;

                _self.downloadParam.sourcepage = "resourcecontent";
                _self.downLoadFile(resultData,"resourcecontent");
            })

            //取消下载
            _self.controls.cancelResContId.click(function(){
                _self._swithToAddBook();
                _shellCmd.cancleDownload(_self.resultData.id);
            })

            //我要评论
            _self.buttons.btn_IComment.click(function(){
                var uid,resId,content;
                uid = _ebookContext.getUser().getUid();
                resId = _self.resultData.id;
                content = _self.controls.commentArea.val();

                _self.addOneComment(uid,resId,content,"","").done(function(retObj){
                    if(retObj.status == 1){
                        //评论成功，输入框清空
                        _self.controls.commentArea.val("");
                        //评论成功，刷新评论列表
                        _self.getComments(1).done(function(retObj){
                             console.log(retObj);
                             _self.renderComments(retObj);
                             _self.bindEvents();

                        })
                    }else if(retObj.status == -1){
                        $.Zebra_Dialog("您尚未开通畅言云服务不能进行评论，请在网页中登录以开通云服务。", {
                            'type': 'information',
                            'title': AppTips.WarmTips,
                            'buttons': ["去登录"],
                            'onClose': function (capition) {
                                if (capition == "去登录") {
                                    _shellCmd.openPageOutside(AppVersionCfg.cloudSSO);
                                }
                            }
                        });
                    }
                })

            })

            //为打分星星控件绑定事件
            var starsDomList = _self.controls.scoreStarId.find('input');
            starsDomList.click(function(){
                if(sessionStorage.getItem(_self.resultData.id) === 'true'){
                    showAlertTips("您已打分成功，不能重复打分");
                    return;
                }
                var index = $(this).index();
                $.each(starsDomList,function(){
                    $(this).removeClass('star_btn').addClass('star_btngray');
                })
                var newStarts = starsDomList.slice(0,index+1);
                $.each(newStarts,function(){
                    $(this).removeClass('star_btngray').addClass('star_btn');
                })
                var resourceid = _self.resultData.id;
                var scoreval = (index + 1);
                var scoreRq = _score;
                scoreRq.resourceid = resourceid;
                scoreRq.score = scoreval;
                var url = _scoreUrlBase + $.param(scoreRq);
                _ebookContext.getUser().getDataByUserToken(url).done(function (result) {
                    console.log(result);
                    if(result){
                        sessionStorage.setItem(resourceid,'true');
                        showAlertTips("打分成功");
                    }
                })

            })

            //资源分享
            _self.controls.resShareId.click(function(){

                _self.resultData.type = '4';//表示从资源中心分享
                _self.shareResToCloud(_self.resultData,"资源已分享到我的主页");
            })

            //资源纠错
            _self.controls.findErrorId.click(function(){
                _resourceErr.showResErrorPanel(_self.resultData);
            })

            //多张缩略图切换事件绑定
            _self.controls.editorPreId.click(function(){
                _self.viewPreImg();
            })

            _self.controls.editorNextId.click(function(){
                _self.viewNextImg();
            })

            //下载另存为事件绑定
            _self.controls.downloadresId.click(function(){
                var resultData = _self.resultData;
                var fileName = resultData.title||resultData.id;
                var dotExt = "."+resultData.extension;
                var downloadParam = _downloadParam;
                downloadParam.id = resultData.id;
                downloadParam.title = resultData.title;
                downloadParam.file = resultData.fileurl;
                downloadParam.dbpath = _ebookContext.getUser().getUserDbFullPath();
                downloadParam.sourcepage = "resourcecontent";

                _shellCmd.saveFileDialog(fileName,dotExt).done(function(ret){
                    console.log(ret);
                    var pathRes = "";
                    if (ret && ret.length > 0) {
                        pathRes = ret[0];
                    }
                    else return;
                    pathRes = pathRes.replace(/\\/g, "\/");
//                    downloadParam.title = pathRes;
                    var ffname = pathRes + '.'+resultData.extension;
                    _shellCmd.isFileExist(ffname).done(function(result){
                        if(result){
                            //同名文件存在，弹出对话框询问是否覆盖
                            $.Zebra_Dialog("此位置包含同名文件，是否替换？", {
                                'type': 'question',
                                'title': AppTips.WarmTips,
                                'buttons': [ AppTips.CancelTips, AppTips.OkTips],
                                'onClose': function (capition) {
                                    if (capition == AppTips.OkTips) {
                                        _self._downloadFile(pathRes,downloadParam);
                                    }
                                    else if (capition == AppTips.CancelTips) {
                                        return;
                                    }

                                }
                            });
                        }else{
                            _self._downloadFile(pathRes,downloadParam);

                        }
                    })

                })
            })


            //我要评论的文本区域绑定事件
            _self.controls.commentArea.bind('input propertychange',function(){
                var len = $(this).val().length;
                if(len > 200){
                    //答案过长，截断处理
                    $(this).val($(this).val().substr(0,200));
                    showAlertTips('评论不能超过200字');
                }
            })

            //点击资源作者跳转其个人主页
            _self.controls.resourceAuthorId.click(function(){
                _indexUrl && _shellCmd.openPageOutside(_indexUrl);
            })

            //绑定大家印象事件
            _self.controls.userCompressionId.find('a').click(function(){
                var that = this;
                if($(this).hasClass('yx_btngray')){
                    return;
                }
                var labelId = $(this).attr('labelId');
//                alert(labelId);
                var addLabel = _addLabel;
                addLabel.uid = _ebookContext.getUser().getUid();
                addLabel.resId = _self.resultData.id;
                addLabel.labelId = labelId;
                var url = _scoreUrlBase + $.param(addLabel);
                _ebookContext.getUser().getDataByUserToken(url).done(function(ret){
                    //TODO:添加成功后的处理
                    console.log(ret);
                    if(ret && ret.return == 'true'){
                        //更新成功,置灰UI
                        var v = $(that).find('em')[0].innerHTML;
                        $(that).find('em')[0].innerHTML = parseInt(v)+1;
                        $(that).removeClass().addClass('yx_btngray');
                        sessionStorage.setItem(_self.resultData.id + '_'+labelId,'true');
                    }

                })
            })

            _resourceErr.init(bookContainer,smartBarEle);

        }

        //切换到"加入课本视图"
        _self._swithToAddBook = function(){
            _self.buttons.btn_addToBook.show();
            _self.controls.resContProBarId.hide();
            _self.controls.realBarId.css('width','0%');
            _self.controls.realBarId[0].innerHTML = '0%';
        }

        //切换到"进度条视图"

        _self._swithToBar = function(){
            _self.buttons.btn_addToBook.hide();
            _self.controls.resContProBarId.show();
        }

        //下载
        _self._downloadFile = function(pathRes ,downloadParam){
            var index = pathRes.lastIndexOf('/');
            var dir = pathRes.substring(0, index).trim();
            var savePath = _path.toPosix(dir);
            var saveTitle = pathRes.substring(index+1, pathRes.length).trim();
            downloadParam.savepath = savePath;
            downloadParam.title = saveTitle;
            downloadParam.sourcepage = 'resourcecontentsave';

            var str = JSON.stringify(downloadParam);
            _shellCmd.fileDownload(str);
        }

        //预览下一张缩略图
        _self.viewNextImg = function(){
            if (_currIndex >= _thumbnailArr.length - 1) {
                _currIndex = 0;
            } else {
                _currIndex = _currIndex + 1;
            }
            _self.showImg(_currIndex);
        }

        //预览上一张缩略图
        _self.viewPreImg = function(){
            if (_currIndex <= 0) {
                _currIndex = _thumbnailArr.length - 1;
            } else {
                _currIndex = _currIndex - 1;
            }
            _self.showImg(_currIndex);
        }

        _self.showImg = function(index){
            _self.controls.viewThumbsId.attr('src',_thumbnailArr[index]);
        }

//        _self._doDefaultUserThing = function(){
//
//        }

        /**
         * 展示资源详情页
         * @param resultData 资源数据
         */
        _self.showResContentPanel = function(resultData){

            //判断是登录还是未登录，未登录不让用我要评论功能
            if(_ebookContext.getUser().getName() == AppCfg.defaultuser){
                _self.controls.comments_dl.css('display','none');
                _self.controls.resShareId.css('display','none');
                $.each(_self.controls.userCompressionId.find('a'),function(){
                    $(this).removeClass().addClass('yx_btngray');
                })
            }else{
                _self.controls.comments_dl.css('display','block');
                _self.controls.resShareId.css('display','block');
            }


            _thumbnailArr = [];
            _self.resultData = resultData;

            for(var i in resultData.screenshots){
                _thumbnailArr.push(resultData.screenshots[i]);
            }
            if(_thumbnailArr.length == 0){
                _thumbnailArr[0] = resultData.thumburl;

                //这时只有一张缩略图，应该隐藏左右翻图片的箭头
                _self.controls.editorPreId.hide();
                _self.controls.editorNextId.hide();
            }else{
                //显示左右箭头
                _self.controls.editorPreId.show();
                _self.controls.editorNextId.show();

            }
            _self.controls.resourceContentPage.show();
            //居中显示
            var bookContainerWidth = _self.bookContainer.getContent().width(),
                resourcePageWidth = _self.controls.resourceContentPage.width(),
                left = ((bookContainerWidth - resourcePageWidth) / 2).toFixed(2),
                bookContainerHeight = _self.bookContainer.getContent().height();
//                top = (bookContainerHeight -
//                    _self.smartBarEle.data("realHeight") -
//                    _self.controls.resourceContentPage.height()) / 2;

            _self.controls.resourceContentPage.css({

                left: left + "px",
                top: "80px"
//                margin:"10% auto"
            });
            var containerWidth = parseInt($("#bookContainer").css("width"))
            if(containerWidth<800){
                correctToBaseResolution( _self.controls.resourceContentPage, {keepScale: true});
                _self.controls.resourceContentPage.css("top","-60px");
                _self.controls.resourceContentPage.draggable({disabled:true});
            }

            //显示缩略图
            _self.controls.viewThumbsId.attr('src',_thumbnailArr[0]);

            //显示标题
            _self.controls.resourceTitleId[0].innerHTML = resultData.title.length > 14?resultData.title.substring(0,12)+'...':resultData.title;
            _self.controls.resourceTitleId.attr('title',resultData.title);

            //显示星星数
            var percent = resultData.statistics.score + "%";
            _self.controls.resourceStarsId.css('width',percent);

            //显示资源作者
            _self.controls.resourceAuthorId[0].innerHTML = resultData.creator;

            //显示基本信息
            _self.controls.extensionTypeId[0].innerHTML = "格式"+resultData.extension;

            _self.controls.previewCountId[0].innerHTML = resultData.statistics.viewcount+"次阅读";

            _self.controls.downloadCountId[0].innerHTML = resultData.statistics.downloadcount +"次下载";

            _self.controls.byteCountId[0].innerHTML = resultData.length/1000 + "kb大小";

            var time1 = new Date(resultData.lastmodify);
            var time2 = time1.Format("yyyy-MM-dd hh:mm:ss");

            _self.controls.uploadTimeId[0].innerHTML = time2 +"上传";

            _self.controls.resourceDesId[0].innerHTML = resultData.description;

            //评分数
            _self.controls.commentsCounts[0].innerHTML = '('+resultData.statistics.scorecount +'人评分)';

            //大家印象
//            _self.controls.userCompressionId.empty();
//            _self.controls.userCompressionId.append(_compressionTpl);
//
//            _self.controls.userCompressionId.find('a').click(function(){
//                if($(this).hasClass('yx_btngray')){
//                    return;
//                }
//                var v = $(this).find('em')[0].innerHTML;
//                $(this).find('em')[0].innerHTML = parseInt(v)+1;
//                $(this).removeClass().addClass('yx_btngray');
//            })
            //TODO:获取并显示大家印象列表
            _self.getResLabelList(resultData.id).done(function(retObj){
                _self.renderLabelList(retObj);
            })


            _self.getComments(1).done(function(retObj){
                console.log(retObj);
                _self.renderComments(retObj);
                _self.bindEvents();

            })

            //资源详情页打开，给该资源的阅读数加1
            var addViewCount = _addViewCount;
            addViewCount.resourceid = resultData.id;
            var url = _scoreUrlBase + $.param(addViewCount);
            _ebookContext.getUser().getDataByUserToken(url).done(function(ret){
                console.log(ret);
            })

            //根据resultData中的creator查询uid，根据uid去畅言云查询snsid，拼接个人主页的跳转地址
            var url = AppRemoteSvcCfg.GeRenZhongXin +resultData.creator;
            _ebookContext.getUser().getDataByUserToken(url).done(function(userInfo){
                if(userInfo){
                    var userServiceUrl = AppRemoteSvcCfg.SNSID +userInfo.id;
                    _shellCmd.getHttpRequest(userServiceUrl).done(function(res){
                        if(res)
                        {
                            var resObj = JSON.parse(res);

                            if(AppVersionCfg.AppVersion == "YueJiaoYun"){
                                _indexUrl= AppRemoteSvcCfg.YJYSNSMainPage + resObj.uid;
                            }else{
                                _indexUrl= AppRemoteSvcCfg.SNSMainPage + resObj.uid;
                            }

                        }else{
                           _indexUrl = '';
                        }
                    })
                }
            })
        }


        /**
         * 获取某一个资源的大家印象标签列表
         */
        _self.getResLabelList = function(resId){
            var defer = $.Deferred();
            var getLabel = _getLabel;
            getLabel.resId = resId;
            var url = _scoreUrlBase + $.param(getLabel);
            _ebookContext.getUser().getDataByUserToken(url).done(function(ret){
                console.log(ret);
                if(ret){
                    defer.resolve(ret);
                }else{
                    defer.resolve('');
                }


            })
            return defer.promise();
        }

        /**
         * 展示标签列表
         */
        _self.renderLabelList = function(retObj){
//            retObj = [{"labelId":1,"labelName":"内容详实","labelCount":1},{"labelId":2,"labelName":"内容原创","labelCount":1},{"labelId":3,"labelName":"趣味性强","labelCount":0},{"labelId":4,"labelName":"效果美观","labelCount":0},{"labelId":5,"labelName":"互动性强","labelCount":0},{"labelId":6,"labelName":"素材质量一般","labelCount":0},{"labelId":7,"labelName":"不符合教学要求","labelCount":0},{"labelId":8,"labelName":"实用性强","labelCount":0},{"labelId":9,"labelName":"思路新颖","labelCount":0},{"labelId":10,"labelName":"内容非常生动","labelCount":0},{"labelId":11,"labelName":"应用价值不高","labelCount":0}];
            for(var i = 0, len = retObj.length; i < len; i++){
                var lid = retObj[i]["labelId"];
                var str = 'a[labelId='+lid +']';
                var aDom =  _self.controls.userCompressionId.find(str);
                aDom.find('em')[0].innerHTML = retObj[i]["labelCount"];
                if(sessionStorage.getItem(_self.resultData.id +'_'+lid) === 'true'){
                    //已经成功评价过
                    aDom.removeClass().addClass('yx_btngray');
                }

            }
        }

        /**
         *
         * @param uid 增加评论的人
         * @param resouceId 评论资源的id
         * @param content 评论内容
         * @param to_uid 对谁评论，可以为空
         */
        _self.addOneComment = function(uid,resouceId,content,to_uid,to_comment_id){
            var defer = $.Deferred();
            var addComReq = _addComment;
            addComReq.uid = uid;
            addComReq.resourceId = resouceId;
//            addComReq.content = content;
//            addComReq.content = encodeURIComponent(content);
            addComReq.content = (content);
            addComReq.to_uid = to_uid;
            addComReq.to_comment_id = to_comment_id;

            var url = _snsBase + $.param(addComReq);
            _shellCmd.getHttpRequest(url).done(function(ret){
                console.log(ret);
                if(ret){
                    var retObj = JSON.parse(ret);
                    defer.resolve(retObj);
                }
            })
            return defer.promise();
        }

        /**
         *
         * @param page 评论页
         * @returns {*}
         */
        _self.getComments = function(page){
            var def = $.Deferred();
            var getComment = _getComment;
            getComment.resourceId = _self.resultData.id;
            getComment.page = page;
            var url = _snsBase + $.param(getComment);
            _shellCmd.getHttpRequest(url).done(function(ret){
                if(ret){
                    _resPageControl.init(page,getComment.limit,JSON.parse(ret).total);
                    _resPageControl.render();
                    //给页面上评论数赋值--是评分数，而不是评论数
//                    _self.controls.commentsCounts[0].innerHTML = '('+JSON.parse(ret).total +'人评论)';

                    def.resolve(JSON.parse(ret));
                }else{
                    def.resolve(ret);
                }

            })
            return def.promise();

        }

        /**
         *
         * @param retObj 评论对象
         */
        _self.renderComments = function(retObj){
            if(_ebookContext.getUser().getName() == AppCfg.defaultuser){
                _commentTpl = _commentTplNoLogin;
                _otherCommentTpl = _otherCommentTplNoLogin;
            }else{
                _commentTpl = _commentTplLogin;
                _otherCommentTpl = _otherCommentTplLogin;
            }
            var commentTpl;

            _self.controls.commentList.empty();
            if(!retObj.data) return;
            var i= 0,len = retObj.data.length;
            for(i = 0;i < len;i++){
                if(!retObj.data[i].to_user_info){
                    //没有to_user_info，则是一个人的评论
                    commentTpl = _commentTpl;

                    var newDate = new Date();
                    newDate.setTime(retObj.data[i].ctime * 1000);
//                    var time = newDate.toLocaleString();
                    var time = newDate.Format("yyyy-MM-dd hh:mm:ss");
//                    var time = newDate.getFullYear()+'-'+(newDate.getMonth()+1)+'-'+newDate.getDay()+' '+newDate.getHours()+':'+newDate.getMinutes()+':'+newDate.getSeconds();
//                    var content = decodeURIComponent(retObj.data[i].content).replace(/&/g, '&amp');
                    var content = (retObj.data[i].content).replace(/&/g, '&amp');
                    commentTpl = commentTpl.replace("{commentor}",retObj.data[i].user_info.uname)
                        .replace("{commentContent}",(content))
                        .replace("{time}",time)
                        .replace("{uid}",retObj.data[i].uid)
                        .replace("{commentid}",retObj.data[i].comment_id)
                        .replace("{resourceId}",_self.resultData.id)
                        .replace("{userid}",retObj.data[i].uid)
                        .replace("{to_userid}",retObj.data[i].to_uid);
                    _self.controls.commentList.append(commentTpl);

                }else{

                    commentTpl = _otherCommentTpl;
                    var newDate = new Date();
                    newDate.setTime(retObj.data[i].ctime * 1000);
//                    var time = newDate.toLocaleString();
                    var time = newDate.Format("yyyy-MM-dd hh:mm:ss");
//                    var content = decodeURIComponent(retObj.data[i].content).replace(/&/g, '&amp');
                    var content = (retObj.data[i].content).replace(/&/g, '&amp');
                    commentTpl = commentTpl.replace("{subjector}",retObj.data[i].user_info.uname)
                        .replace("{objector}",retObj.data[i].to_user_info.uname)
                        .replace("{commentContent}",(content))
                        .replace("{time}",time)
                        .replace("{uid}",retObj.data[i].uid)
                        .replace("{commentid}",retObj.data[i].comment_id)
                        .replace("{resourceId}",_self.resultData.id)
                        .replace("{userid}",retObj.data[i].uid)
                        .replace("{to_userid}",retObj.data[i].to_uid);
                    _self.controls.commentList.append(commentTpl);
                }
            }
        }

        _self.bindEvents = function(){
            //TODO:绑定事件
            _self.controls.commentList.find('a[flag=commentFlag]').click(function(){
//                alert($(this).parent().parent().parent().index());
                $(this).parent().parent().next().show();
            })
            _self.controls.commentList.find('a[flag=replyFlag]').click(function(){
//                alert($(this).parent().parent().parent().index());
//                $(this).parent().parent().next().show();
                var uid = _ebookContext.getUser().getUid();
                var resId = $(this).attr("resId");
                var content =  $(this).parent().parent().find('input').val();
                var to_uid = $(this).attr("myuid");

                var to_comment_id = $(this).attr("mycommentid");
                _self.addOneComment(uid,resId,content,to_uid,to_comment_id).done(function(retObj){
                    if(retObj.status == 1){
                        //success
                        //TODO:评论成功，刷新评论列表
                        _self.getComments(1).done(function(retObj2){
                            console.log(retObj2);
                            _self.renderComments(retObj2);
                            _self.bindEvents();

                        })
                    }else if(retObj.status == -1){
//                        showAlertTips("请先确认是否开通个人空间");
                        $.Zebra_Dialog("您尚未开通畅言云服务不能进行评论，请在网页中登录以开通云服务。", {
                            'type': 'information',
                            'title': AppTips.WarmTips,
                            'buttons': ["去登录"],
                            'onClose': function (capition) {
                                if (capition == "去登录") {
                                    _shellCmd.openPageOutside(AppVersionCfg.cloudSSO);
                                }
                            }
                        });
                    }
                });

            })

            _self.controls.commentList.find('input').bind('input propertychange',function(){
                var len = $(this).val().length;
                if(len > 200){
                    //答案过长，截断处理
                    $(this).val($(this).val().substr(0,200));
                    showAlertTips('评论不能超过200字');
                }
            })

            //点击评论者图标链接相应个人主页
            _self.controls.commentList.find('a[name=people]').click(function(){
                var uid = $(this).attr('userid');
//                alert(uid);
                var url = AppRemoteSvcCfg.SNSMainPage + uid;
                _shellCmd.openPageOutside(url);

            })


        }

        _self.closeResContentPanel = function(){
            _self.controls.resourceContentPage.hide();
            //关闭窗口时将数组清空
            _self.clearData();

        }

        _self.clearData = function(){
            _thumbnailArr = [];
            _currIndex = 0;
            _indexUrl = '';
            _self.controls.commentArea.val("");
            _scoreSucess = false;
            _self.buttons.btn_addToBook.removeClass().addClass('greenbtn');
            _self._resetStar();
            _self._swithToAddBook();
            _self._resumeLabelUI();
        }

        _self._resumeLabelUI = function(){
            var aDomList = _self.controls.userCompressionId.find('a');
            $(aDomList[0]).removeClass().addClass('yx_btnred');
            $(aDomList[1]).removeClass().addClass('yx_btnorange');
            $(aDomList[2]).removeClass().addClass('yx_btnblue');
            $(aDomList[3]).removeClass().addClass('yx_btngreen');
            $(aDomList[4]).removeClass().addClass('yx_btnred');
            $(aDomList[5]).removeClass().addClass('yx_btnorange');
            $(aDomList[6]).removeClass().addClass('yx_btnblue');
            $(aDomList[7]).removeClass().addClass('yx_btngreen');
            $(aDomList[8]).removeClass().addClass('yx_btnred');
            $(aDomList[9]).removeClass().addClass('yx_btnorange');
            $(aDomList[10]).removeClass().addClass('yx_btnblue');
        }

        _self._resetStar = function(){
            var starsDomList = _self.controls.scoreStarId.find('input');
            $.each(starsDomList,function(){
                $(this).removeClass('star_btn').addClass('star_btngray');
            })

        }

        _self._addDownloadCount = function(id){
            var defer = $.Deferred();

            //下载完成后还应该给下载数加1.
            var addDownload = _addDownloadCount;
            addDownload.resourceid = id;
            var url = _scoreUrlBase + $.param(addDownload);
            _ebookContext.getUser().getDataByUserToken(url).done(function (result) {
                defer.resolve(result);
            })
            return defer.promise();
        }

        _self.onMessageReceived = function(obj){
            if (obj.evt == 'file_download') {
                if (obj.data.sourcepage == 'resourcecontent') {

                    if(obj.data.progress <= 1){
                        var pro = Number(obj.data.progress) * 100 + "%";
                        console.log(pro);
//                        $("#"+obj.data.id).find('.book_progress').css('width',pro);
                        _self.controls.realBarId.css('width',pro);
                        _self.controls.realBarId[0].innerHTML = pro;
                    }
                    //下载完成
                    if(obj.data.progress >= 2){
                        _self.controls.realBarId.css('width','100%');
                        _self.controls.realBarId[0].innerHTML = '100%';

                        var array = [];
                        var basePath = _path.trimPosix(Config.binPath);
                        array[0] = basePath + obj.data.file;

                        var option = {
                            userName:  obj.data.rawData.author,
                            userPhoto : "",
                            score : obj.data.rawData.score,
                            uploadTime : obj.data.rawData.uploadTime,
                            resourceId:obj.data.id

                        }
                        _self.bookContainer.insertWidget(array,option);
                        _self._swithToAddBook();

                        _self._addDownloadCount(obj.data.id).done(function(ret){
                            console.log(ret);
                        });

                    }
                }
                else if(obj.data.sourcepage == 'resourcecontentsave'){
                    //下载完成
                    if(obj.data.progress >= 2){
                        _self._addDownloadCount(obj.data.id).done(function(ret){
                            console.log(ret);
                        });
                    }
                }
            }
        }


    }

    ResContent.prototype = new _cloudresourceBase();
    exports.Instance = new ResContent();
})
