/**
 * Created by pengfu on 14-7-23.
 */
;
define(function (require, exports) {

    var NetDiskResBase = require('./netdiskbase').NetDiskResBase;
    var _ebookContext = require('../../../ebookcontext').Instance;
    var shellcmd = require('../../../../common/shellcmd');
    var netDiskURL = AppSvcHelper.CYSVC+'&';
    require('jquery');

    function NetDiskRecord() {
        var _this = this;
        _this._ulDomStr = '<ul class="net_disk"></ul>';
        _this._rowDomStr = '<li class="clearfix"></li>';//每个li包括每个横排4个资源
        _this._eachResDomStr = '<div class="net_disk_wrap" id="{fid}">' +
            '<a style="cursor:pointer;" title="{resNamePlusExt}" class="net_disk_detail">' +
            '<img alt="{resNamePlusExt}"  src="{thumbSrc}" /></a>' +
            '<div style="width:90px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap">{resNamePlusExt}</div>' +
            '<a title="查看" class="smartbar_btn smartbar_btn_b" style="cursor:pointer;">查看</a>' +
            '<a title="加入课本" class="smartbar_btn smartbar_btn_g" style="cursor:pointer;">加入课本</a> </div>';
        this.netDiskDom = $("#netdiskrecordPanel");
        this.request.folderType = 'yun_ketang';
        _this.Month = 8;
        _this.Year =  2014;
        //调用获取年份
//        _this.getYear();
        _this.seekMore = this.netDiskDom.find('.smartbar_netdisk_more');
        _this.notFound = this.netDiskDom.find('.smartbar_netdisk_not_found');
        _this.seekMore.click(function () {
            _this.request.page++;
            _this.buildDom(false);
        });
        //时间数组
        _this.timeStringArr=[];
        _this.firstLoad = 0;
    }

    NetDiskRecord.prototype = new NetDiskResBase();
    NetDiskRecord.prototype.constructor = NetDiskRecord;

    NetDiskRecord.prototype.reset = function () {
        var _this = this;
         //时间数组
        _this.timeStringArr=[];
        _this.firstLoad = 0;
        _this.getYear();
    }

    /**
     * 获取时间轴年份
     * @param callback
     */
    NetDiskRecord.prototype.getYear = function(){
        var _this = this;
        var _request = {};
        $.extend(_request,_this.request);
        _request.method = 'pan.timeline.year.list';
        _request.folderType = "yun_ketang";
        var url = netDiskURL+ $.param(_request);
        _ebookContext.getUser().getDataByUserToken(url).done(function(ret){
            if(ret.total==0||ret==""){
                    $("#recordListContainer").find("p[name='record_nores']").remove();
                    var no_res = $('<p class="no_res01" name="record_nores">' +
                        '<img src="assert/images/no_res01.png"><br>' +
                        '<span>您的授课记录暂无内容</span></p>');
                    $("#recordListContainer").append(no_res);
                    return;
            }
            _this.setYear(ret);
        });
    };

    /**
     * 设置年份
     * @param result
     */
    NetDiskRecord.prototype.setYear = function(result){
        $("#timelineContainer").html("");
        var _this = this;
        var result = result.data;
        for(var i=0; i< result.length ;i++){
            var li_year = '<dl name="yearItem" contend="{contend}">' +
                '<dt><a  style="text-decoration: none;cursor:pointer;">{year}年</a></dt>'
                '</dl>';
            li_year =  li_year.replace("{year}",result[i])
                .replace("{contend}",result[i]);
            $("#timelineContainer").append(li_year);
        }
        //默认是最近一年
        _this.Year = result[0];
        _this.getMonth(true);
    };

    /**
     * 获取时间轴月份
     * @param callback
     */
    NetDiskRecord.prototype.getMonth = function(isSetRes){
        var _this = this;
        var _request = {};
        $.extend(_request,_this.request);
        _request.method = 'pan.timeline.month.list';
        _request.folderType = "yun_ketang";
        _request.year = _this.Year;

        var url = netDiskURL+ $.param(_request);
        _ebookContext.getUser().getDataByUserToken(url).done(function(ret){
             _this.setMonth(ret , isSetRes);
        });
    };


    /**
     * 设置月份
     * @param result
     */
    NetDiskRecord.prototype.setMonth =function(result , isSetRes){
        var _this = this;
        var result = result.data;
        for(var i=0; i< result.length ;i++){
            var li_Month = '<dd name="MonthItem" contend="{contend}">' +
                '<a  style="text-decoration: none;cursor: pointer;">{month}月</a>' +
                '</dd>';
            li_Month= li_Month.replace("{month}",result[i])
                .replace("{contend}",result[i]);
            $("#timelineContainer").
                find("dl[name='yearItem']").
                filter("dl[contend='"+_this.Year+"']").append($(li_Month));
        }
        //设置默认显示月份
        _this.registerTimeLineEvent();
        isSetRes && (_this.Month = result[0]);
        isSetRes && $("#recordListContainer").html("");
        isSetRes && _this.buildDom(true);
    };

    /**
     * 时间轴事件绑定
     */
    NetDiskRecord.prototype.registerTimeLineEvent = function(){
        var _this = this;
        //点击年份Item

        _this.netDiskDom.find("dl[name='yearItem']").unbind("click");
        _this.netDiskDom.find("dl[name='yearItem']").on("click",function(e){
            _this.netDiskDom.find("dl[name='yearItem']").removeClass('record_active');
            $(this).addClass("record_active");
            var _dd =  $(this).find(">dd");
            (_dd.length>0)&&_dd.remove();
            _this.Year = $(this).attr("contend");
            (_dd.length<=0)&&_this.getMonth(false);
            event.preventDefault();
        });
        //点击月份Item
        _this.netDiskDom.find("dd[name='MonthItem']").unbind("click");
        _this.netDiskDom.find("dd[name='MonthItem']").on("click",function(event){
            _this.netDiskDom.find("dd[name='MonthItem']").find('>a').removeClass('record_active');
            $(this).find('>a').addClass('record_active');
            _this.netDiskDom.find("dl[name='yearItem']").removeClass('record_active');
            $(this.parentNode).addClass("record_active");
            _this.Month = $(this).attr("contend");
            _this.Year =  $(this.parentNode).attr("contend");
            $("#recordListContainer").html("");
            _this.buildDom(true);
            event.preventDefault();
            return false;
        });
    };


    NetDiskRecord.prototype._getThumbSrc = function (url, extname) {
        var _this = this;
        return url ? url : (_this.setDefaultPic(extname));
    }

    NetDiskRecord.prototype.buildDom = function(isreload){
        var _this = this;
        var _request = {};
        $.extend(_request,_this.request);
        _request.method = 'pan.timeline.file.list';
        _request.year = _this.Year;
        _request.month = _this.Month;
        var url = netDiskURL+ $.param(_request);
        _ebookContext.getUser().getDataByUserToken(url).done(function(ret){
            //网络失去连接，ret值为""
            if(ret == ""){
                $("#recordListContainer").find("p[name='record_nores']").remove();
                var no_res = $('<p class="no_res01" name="record_nores">' +
                    '<img src="assert/images/no_res01.png"><br>' +
                    '<span>您的授课记录暂无内容</span></p>');
                $("#recordListContainer").append(no_res);
                return;
            }
            _this.dateFormat(ret,isreload);
            //绑定事件
            _this._registerEvent();
        });

        if(_this.firstLoad==0) {
            $("#timelineContainer").
                find("dl[name='yearItem']").
                filter("dl[contend='"+_this.Year+"']").addClass("record_active");
            $("#timelineContainer").
                find("dl[name='yearItem']").
                filter("dl[contend='"+_this.Year+"']").find("dd[contend='"+_this.Month+"']").find('>a').addClass("record_active");
        }
        _this.firstLoad++;
    };

    NetDiskRecord.prototype.dateFormat = function(ret ,isreload ){
        var _this = this;
        var data = ret.data||"";
        _this.timeStringArr=[];
        for(var i=0;i<data.length;i++){
           var temp  =  getTimeString (data[i]);
            ret.data[i] = temp;
        }
        function getTimeString(ret){
                function getLocalTime(nS) {
                    return new Date(parseInt(nS) * 1000);
                }
                var myDate = getLocalTime(ret.createtime);
                var year = myDate.getFullYear();
                var month = myDate.getMonth()+1;
                var date = myDate.getDate();
                var timeStr = year+"年"+month+"月"+date+"日";
                ret.showTimeString = timeStr;
                for(var i=0;i<_this.timeStringArr.length;i++){
                    if(timeStr==_this.timeStringArr[i])  break;
                }
                if(i>=_this.timeStringArr.length)  _this.timeStringArr.push(timeStr);
                return ret;
        }
        _this.resultJson=ret;
            //把json结果render到界面上
//        _this._renderRlt(ret,isreload);
        _this.setRecordList(ret,isreload);
    };
    /**
     * 设置我的授课记录列表
     * @param result
     * @param isreload
     */
    NetDiskRecord.prototype.setRecordList = function(result,isreload){
        var _this = this;
        $("#recordListContainer").find("p[name='record_nores']").remove();
        if (result.total==0) {
            var no_res = $('<p class="no_res01" name="record_nores">' +
                '<img src="assert/images/no_res01.png"><br>' +
                '<span>您的授课记录暂无内容</span></p>');
            $("#recordListContainer").append(no_res);
            return;
        }
        var data = result.data;
        for(var j=0;j<_this.timeStringArr.length;j++){
            var recordTemp= $('<ul class=clearfix></ul>');
            var i = 0,Num=0;
            for(;i < data.length;i++){
                if(_this.timeStringArr[j]==data[i].showTimeString){
                    var li = $('<li name="recordItem">'+
                        '<a class="sm_stemp_img_warp" style="cursor:pointer;">'+
                        '<span class="sm_stemp_img_box">'+
                        '<img id="record_viewImage" name ="record_viewImage" src="assert/images/sm_stemp_img01.png">'+
                        '<div class="sm_stemp_text text_size_overfollow" id="title" style="width: 100%;text-align: center;">唐诗三百首鉴赏与解析五年级下册.jpg</div>'+
                        '</span>'+
                        '</a>'+
                        '<div class="re_gr_btn clearfix sm_stemp_btn" id="recordBtn">'+
                        '<span name="record_preview">预览</span>'+
                        '<span name="record_addToBook">加入课本</span>'+
                        '</div>'+
                        '</li>');
                    var type = data[i].extension,
                        url = _this.setDefaultPic(type);
                    (!data[i].thumbpath||data[i].thumbpath.length==0) && (data[i].thumbpath = url);
                    li.attr("id", data[i].fid);
                    li.attr("contend", i);
                    li.find('#record_viewImage').attr("src", data[i].thumbpath);
                    li.find('#title').attr("title", data[i].aliasname||data[i].name);
                    li.find("#title").text(data[i].aliasname||data[i].name);
                    recordTemp.append(li);
                    Num++;
                }
            }
            var temp = $('<div class="sm_skjl_right_temp">' +
                '<div class="sm_skjl_right_temp_tit">'+
                '<span class="sm_skjl_r_time" id="TimeTitle"></span>'+
                '<em class="sm_skjl_r_jilu" id="recordNum"></em>'+
                '<i class="sm_time_ic sm_time_ic_on"></i>'+
                '</div>'+
                '<div class="sm_skjl_right_temp_con" id="recordtempList">'+
                '</div>'+
                '</div>');
            temp.find("#TimeTitle").text(_this.timeStringArr[j]);
            temp.find("#recordNum").text(Num+"条记录");
            temp.find("#recordtempList").append(recordTemp);
            $("#recordListContainer").append(temp);
        }
        _this._registerEvent();
    };
    NetDiskRecord.prototype._renderRlt = function(ret,isreload){


        console.log(isreload)
        var _this = this;
        var tmpEachResDomStr,resCount ,resnameplusext,thumbSrc,jsonObj,
            ulDom = $(_this._ulDomStr),eachResDomStr = _this._eachResDomStr,rowDomStr = _this._rowDomStr,
            rowDom = $(rowDomStr),j = 0;

        console.log("授课记录：当前请求--分页:"+_this.request.page+" ,limit:"+_this.request.limit);
        console.log("授课记录：获取的json结果为：");
        console.log(ret);
        if((!ret || ret.data.length == 0) && _this.request.page == 1){
            _this.seekMore.hide();
            _this.notFound.show();
        }else{
            _this.notFound.hide();
        }
        if( isreload ){
            _this.resultJson = ret;
            ret.data.length >= ret.total? _this.seekMore.hide():_this.seekMore.show();
        }else{
            $.merge(_this.resultJson.data, ret.data);
            if(_this.resultJson.data.length >= ret.total){

                _this.seekMore.hide();
            }
        }
        jsonObj = ret;
        resCount = jsonObj.data.length;
        //遍历jsonObj，将每个资源赋值给_eachResDom,然后4个一组给_rowDom
        //for循环执行完了，ul结构应该有了
        for(var j=0;j<_this.timeStringArr.length;j++){
            var rowDom = $(_this._rowDomStr);
            rowDom.append('<h3 style="float: left">'+_this.timeStringArr[j]+'</h3>');
            for(var i = 0;i < resCount;i++){
                resnameplusext = jsonObj.data[i].aliasname +'.'+ jsonObj.data[i].extension;
                thumbSrc = _this._getThumbSrc(jsonObj.data[i].thumbpath,jsonObj.data[i].extension);
                eachResDomStr = eachResDomStr.replace(/\{resNamePlusExt\}/g,resnameplusext)
                    .replace("{thumbSrc}",thumbSrc).replace("{fid}",jsonObj.data[i].fid);
                tmpEachResDomStr = eachResDomStr;
                eachResDomStr = _this._eachResDomStr;
                if(_this.timeStringArr[j]==jsonObj.data[i].showTimeString)
                    rowDom.append(tmpEachResDomStr);
            }
            ulDom.append(rowDom);
            //将ul结构放到“点击查看更多”之前
            _this.seekMore.before(ulDom);
            //最后一行下面的虚线去掉
            var liDom = _this.netDiskDom.find('.net_disk > li'),len = liDom.length;
            liDom.each(function(){
                if($(this).index('#netdiskrecordPanel .net_disk > li') < len - 1){
                    $(this).css("border-bottom","1px dashed #b8b8b8");
                }else{
                    $(this).css("border-bottom","1px dashed #ffffff");
                }
            });
        }
    };
    NetDiskRecord.prototype._registerEvent = function(){
        var _this = this;
        //加入到课本
        _this.netDiskDom.find("span[name='record_addToBook']").unbind('click').click(function () {
            var i = $(this).index("#netdiskrecordPanel span[name='record_addToBook']");
            var resultData = _this.resultJson.data[i];
            console.log(resultData)
            newWidgetPos = null;
            resultData.id = resultData.fid;
            resultData.fileurl = resultData.downloadpath;
            resultData.title = resultData.aliasname;
            resultData.thumburl = resultData.thumbpath;
            resultData.resFrom = 'teachRecord';
            resultData.creator = decodeURI(_ebookContext.getUser()._userName)||_ebookContext.getUser()._name||"";
            _this.downLoadFile(resultData);
        });
        //点预览按钮资源预览
        _this.netDiskDom.find("span[name='record_preview']").unbind('click').click(function () {
            var i = $(this).index("#netdiskrecordPanel span[name='record_preview']"), type, url;
            var resultData = _this.resultJson.data[i];
            var type = resultData.extension;
            resultData.resFrom = 'teachRecord';
            //TODO:调用查看接口单独获取预览url
            _this.previewRequest.fileId = resultData.fid;
            var reqUrl = netDiskURL + $.param(_this.previewRequest);
            _ebookContext.getUser().getDataByUserToken(reqUrl).done(function (previewUrl) {

                console.log("授课记录查看资源：");
                console.log("type :" + type);
                console.log("url:" + previewUrl);
                resultData.id = resultData.fid;
                resultData.fileurl = resultData.downloadpath;
                resultData.title = resultData.aliasname;
                resultData.resFrom = 'teachRecord';
                resultData.thumburl = resultData.thumbpath;
                resultData.creator = decodeURI(_ebookContext.getUser()._userName)||_ebookContext.getUser()._name||"";
                _this.previewRes(type, previewUrl,resultData);
            });
        });
        //点击资源缩略图预览文件
        _this.netDiskDom.find("img[name=record_viewImage]").unbind('click').click(function () {
            var i = $(this).index("#netdiskrecordPanel img[name=record_viewImage]"), type, url;
            var resultData = _this.resultJson.data[i];
            var type = resultData.extension;
            resultData.resFrom = 'teachRecord';
            //TODO:调用查看接口单独获取预览url
            _this.previewRequest.fileId = resultData.fid;
            var reqUrl = netDiskURL + $.param(_this.previewRequest);
            _ebookContext.getUser().getDataByUserToken(reqUrl).done(function (previewUrl) {
                console.log("授课记录查看资源：");
                console.log("type :" + type);
                console.log("url:" + previewUrl);
                resultData.id = resultData.fid;
                resultData.fileurl = resultData.downloadpath;
                resultData.title = resultData.aliasname;
                resultData.resFrom = 'teachRecord';
                resultData.thumburl = resultData.thumbpath;
                resultData.creator = decodeURI(_ebookContext.getUser()._userName)||_ebookContext.getUser()._name||"";
                _this.previewRes(type, previewUrl,resultData);
            });
        });
        //拖拽下载
        _this.netDiskDom.find("li[name='recordItem']").on("dragend", function (e) {
            console.log("授课记录 drag end !!!")
            var index = $(this).index("#netdiskrecordPanel li[name='recordItem']");
            var resultData = _this.resultJson.data[index];
            console.log(resultData)
            resultData.id = resultData.fid;
            resultData.fileurl = resultData.downloadpath;
            resultData.title = resultData.aliasname;
            resultData.resFrom = 'teachRecord';
            resultData.thumburl = resultData.thumbpath;
            resultData.creator = decodeURI(_ebookContext.getUser()._userName)||_ebookContext.getUser()._name||"";
            newWidgetPos = {
                left : e.originalEvent.clientX,
                top : e.originalEvent.clientY
            }
            _this.downLoadFile(resultData);
        });
    }
    exports.Instance = new NetDiskRecord();

})