/**
 * Created by pengfu on 14-8-20.
 */
;
define(function (require, exports) {
    var cloudList = require('./cloudlist').Instance;
    var cloudSearch = require('./search').Instance;
    var _shellcmd = require('../../../common/shellcmd');

    function cloudResLibTpl() {
        var _this = this;
        this.isShow = false;
        this.bookContainer = null;
        this.smartBarEle = null;

        this.controls = {
            cloudResLibTplPanel: $("#cloudResLibTplPanel"),
            cloudResourceListPanel: $("#cloudResourceListPanel"),
            cloudResourceSearchPanel: $("#cloudResourceSearchPanel"),

            resourceListId: $("#resourceListId"),
            resourceSearchId: $("#resourceSearchId"),

            //关闭按钮
            cloudResourceClose: $("#cloudResourceClose")
        }

        this.init = function (bookContainer, smartBarEle) {
            _this.bookContainer = bookContainer;
            _this.smartBarEle = smartBarEle;

            //cloudList 初始化
            cloudList.init(bookContainer);

            //cloudSearch 初始化
            cloudSearch.init(bookContainer);

            _this.controls.cloudResLibTplPanel.draggable({
//                handle: _this.controls.cloudResLibTplPanel.find('.smartbar_tit.clearfix'),
//                containment: 'parent'
                handle: _this.controls.cloudResLibTplPanel.find('.smartbar_tit.clearfix'),
                containment:'window'

            });

            //点击资源列表
            _this.controls.resourceListId.click(function () {
                _this.controls.resourceListId.removeClass().addClass("smartbar_tab current");
                _this.controls.resourceSearchId.removeClass().addClass("smartbar_tab");
                _this.controls.cloudResourceSearchPanel.hide();
                _this.controls.cloudResourceListPanel.show();

            });

            //点击资源搜索
            _this.controls.resourceSearchId.click(function () {
                _this.controls.resourceSearchId.removeClass().addClass("smartbar_tab current");
                _this.controls.resourceListId.removeClass().addClass("smartbar_tab");
                _this.controls.cloudResourceListPanel.hide();
                _this.controls.cloudResourceSearchPanel.show();
            });

//            //点击关闭按钮
//            _this.controls.cloudResourceClose.click(function () {
//                _shellcmd.killProcess('osk.exe');
//                _this.controls.cloudResLibTplPanel.hide();
//            })


        }

        this.show = function () {

            //TODO:改变弹出框css
//                correctToBaseResolution(_self.controls.myNetworkDiskTplPanel, {keepScale: true});
            _this.controls.cloudResLibTplPanel.show();
            var bookContainerWidth = this.bookContainer.getContent().width(),
                smartBarWidth = _this.controls.cloudResLibTplPanel.width(),
                left = ((bookContainerWidth - smartBarWidth) / 2).toFixed(2),
                bookContainerHeight = this.bookContainer.getContent().height(),
                top = (bookContainerHeight -
                    _this.smartBarEle.data("realHeight") -
                    _this.controls.cloudResLibTplPanel.height()) / 2;

            _this.controls.cloudResLibTplPanel.css({
                position: "absolute",

                left: left + "px",
//                    top  : top  + "px"
                top: "80px"

//                margin:"10% auto"
            });

            console.log($("#bookContainer").css("width"))
            var containerWidth = parseInt($("#bookContainer").css("width"))
            if(containerWidth<800){
                correctToBaseResolution( _this.controls.cloudResLibTplPanel, {keepScale: true});
                _this.controls.cloudResLibTplPanel.css("top","-60px");
                _this.controls.cloudResLibTplPanel.draggable({disabled:true});
            }

            _this.controls.resourceListId.removeClass().addClass("smartbar_tab current");
            _this.controls.resourceSearchId.removeClass().addClass("smartbar_tab");
            _this.controls.cloudResourceSearchPanel.hide();
//                _this.controls.cloudResourceListPanel.show();
            cloudList.show();


        }
    }

    exports.Instance = new cloudResLibTpl();

})
