/**
 *
 * User: chengyang@iflytek.com
 * Date: 14-7-24 下午4:14
 * Version: 1.0
 */

define(function (require, exports, module) {

    require('jquery');
    require('jquery_media');
    require('flexpaper');
    require('flowplayer');
    var _path = require('../../../common/path');
    var _shellcmd = require('../../../common/shellcmd'),
        _ebookContext = require('../../ebookcontext').Instance;
    var path = require('../../../common/path');
    var getUserId = AppRemoteSvcCfg.UserGet;

    var downloadUrlBase = AppSvcHelper.CYSVC + "&";

    var mainContend = $("#wrap");

    function CloudresourceBase() {
        var _this = this;
        //下载参数
        this.downloadParam = {};
        $.each(("id title author thumbnail description keywords publisher " +
            "subject volumn bookCode username realname unit course fileSize grade " +
            "category file extension source sourcepage savepath dbpath photo").split(" "), function (i, name) {

            _this.downloadParam[ name ] = '';
        });

        this.bookContainer = arguments[0];
        this.downloadParam.sourcepage = "CloudresourceBase";
        this.basePath = _path.trimPosix(Config.binPath);

        this.preview = $("#smartbar_preview");

        this.preview.css({
            position: 'absolute',
            left: ($("#bookContainer").width() - 722) / 2-15,
            top:"10px",
            "z-index": 550
        });

        this.preview.draggable({
            handle: this.preview.find('.smartbar_preview_tit'),
            containment: 'parent'
        });

        this.preview.find(".smartbar_preview_repository_close").click(function () {
            _this.preview.hide();
            ////左右箭头全局设置,设置为true，表示左右箭头不再翻页
            global_flag = false;
            //解决关闭预览界面后音频仍有可能继续播放的bug，貌似没有stop方法，这里用pause也没有什么影响。
            if($("#audioId").get(0)){
                $("#audioId").get(0).pause();
            }

        });

        this.addDownloadCountRqst = {
            method: 'res.resource.statistic.update',
            key:    'downloadcount',
            resourceid :   ''

        }

        this.requestFileInfo = {
            method      :   'pan.file.get',
            folderType  :  'yun_beike',
            brief       :   true
        };

    }

    //设置默认图片
    CloudresourceBase.prototype.setDefaultPic = function (type) {

        var url;
        switch (type) {
            case 'doc':
            case 'docx':
                url = 'assert/images/icons/doc.png';
                break;
            case 'txt':
                url = 'assert/images/icons/txt.png';
                break;
            case 'ppt':
            case 'pptx':
                url = 'assert/images/icons/ppt.png';
                break;
            case 'xlsx':
            case 'xls':
                url = 'assert/images/icons/xls.png';
                break;
            case 'pdf':
                url = 'assert/images/icons/pdf.png';
                break;
            case 'jpg':
            case 'png':
            case 'bmp':
            case "gif":
            case "jpeg":
                url = 'assert/images/icons/img.png';
                break;
            case 'mp3':
            case 'wma':
            case 'wav':
            case 'ogg':
            case 'ape':
            case 'mid':
            case 'midi':
                url = 'assert/images/icons/video.png';
                break;
            case 'mp4':
            case 'flv':
            case 'avi':
            case 'rmvb':
            case 'wmv':
            case '3gp':
            case 'mpg':
            case 'rm':
            case 'asf':
                url = 'assert/images/icons/movie.png';
                break;
            case 'swf':
                url = 'assert/images/icons/swf.png';
                break;
            case 'rar':
            case 'zip':
                url = 'assert/images/icons/rar.png';
                break;
            case 'book':
            case 'book1':
            case 'book2':
                url = 'assert/images/icons/bag1.png';
                break;
            case 'card':
                url = 'assert/images/icons/card.png';
                break;
            case "":
                url = 'assert/images/icons/card_wjj.png';
                break;
            case 'mtbk':
                url = 'assert/images/icons/mtbk.png';
                break;
            default:
                url = 'assert/images/icons/default.png';
                break;
        }
        return url;
    };

    CloudresourceBase.prototype.previewRes = function (type, url,resultData) {
        var _this = this;
        //左右箭头全局设置,设置为true，表示左右箭头不再翻页
        global_flag = true;
//        if(url.length == 0){
//            console.error("预览url为空");
//            return;
//        }
        switch (type) {
            case "jpg":
            case "png":
            case "gif":
            case "jpeg":
            case "bmp":
                this.previewImg(url);
                break;
            case "mp3":
            case "wma":
            case "wav":
            case "ogg":
            case "ape":
            case "mid":
            case "midi":
                this.previewAudio(url);
                break;
//            case "mp4":
//                this.previewMp4(url);
//                break;
            case "avi":
            case "flv":
            case "wmv":
            case "3gp":
            case "mpg":
            case "rmvb":
            case "rm":
            case "asf":
            case "mp4":
                this.previewFlv(url);
                break;
            case "swf":
                this.previewFlash(url);
                break;
            case "doc":
            case "docx":
            case "txt":
            case "xlsx":
            case "xls":
            case "ppt":
            case "pptx":
            case "pdf":
                this.previewOffice(url);
                break;
            case "icw":
                this.previewIcw(url);
                break;
            default :
//                this.preview.empty();
                $.Zebra_Dialog("暂不支持预览." + type + "格式", {
                    'type': 'information',
                    'title': AppTips.WarmTips,
                    'buttons': [ AppTips.OkTips],
                    'zIndex': 1000
                });

                break;
        }

        (resultData!='')&&(_this._bindAddToBookEvt(resultData));
    };

    CloudresourceBase.prototype._bindAddToBookEvt = function(obj){
        var _this = this;
//        this.preview.find('.smartbar_addtobook_btn').on('click',function(){
//            _this.downLoadFile(obj);
//        })
        //将预览窗口名改为资源名
        var title ='';
        obj.title?(title = obj.title):(title = '资源预览');
        if (getBlackboardFlag()&&obj.fileurl!=undefined){
            //var realName = path.basename(obj ,'.jpg');
            //返回原先位置
            this.preview.css({
                position: 'absolute',
                left: ($("#bookContainer").width() - 722) / 2-15,
                top:"10px",
                "z-index": 550
            });
            title = obj.title;
        }
        if (!getBlackboardFlag()){
            this.preview.find('.smartbar_addtobook_btn').text('加入课本');
            this.preview.find('.smartbar_addtobook_btn').attr('title','加入课本');
        } else {
            this.preview.find('.smartbar_addtobook_btn').text('加入黑板');
            this.preview.find('.smartbar_addtobook_btn').attr('title','加入黑板');
        }
        
        this.preview.find('#previewWinTitle').get(0).innerHTML = title;
        //绑定事件
        this.preview.find('.smartbar_addtobook_btn').unbind('click').bind('click',function(){
            if (!getBlackboardFlag()||obj.fileurl!=undefined){
                _this.downLoadFile(obj);
                _this.preview.hide();
            }
            else{
                var array = [];
                array[0] = obj.url;
                _this.bookContainer.insertWidget(array,'');
                _this.preview.hide();
            }

            if($("#audioId").get(0)){
                $("#audioId").get(0).pause();
            }
        })
    }



    CloudresourceBase.prototype.previewImg = function (url) {

        var content = this.preview.find('.smartbar_preview_tab_cont');
        content.get(0).innerHTML = "<img src='" + url + "' style='max-height:450px;max-width:650px;'></img>";
        var imgDom = content.find('img');
        var img = new Image();
        img.src = url;
        img.onload = function () {
            var marginobj = _computeMarginValue(img, 700, 465);
            imgDom.css({
                maxWidth: 700,
                maxHeight: 465,
                marginTop: marginobj.margintop
//                marginLeft: marginobj.marginleft
            });

        }
    //    correctToBaseResolution(this.preview, {keepScale: true});
        var containerWidth = parseInt($("#bookContainer").css("width"))
        if (containerWidth < 800) {
            correctToBaseResolution(this.preview, {keepScale: true});
            this.preview.css("top", "-60px");
            this.preview.draggable({disabled:true});
        }
        this.preview.show();

        function _computeMarginValue(img, width, height) {
            var w, h, margin_top, margin_left;
            var marginObj = {};
            if (img.height <= height && img.width <= width) {
                margin_top = (height - img.height) / 2;
                margin_left = (width - img.width) / 2;
            } else if (img.height > height && img.width <= width) {
                h = height;
                w = (img.width / img.height) * h;
                margin_top = 0;
                margin_left = (width - w) / 2;
            } else if (img.height <= height && img.width > width) {
                w = width;
                h = (img.height / img.width) * w;
                margin_top = (height - h) / 2;
                margin_left = 0;
            } else {
                if (img.width / img.height >= width / height) {
                    w = width;
                    h = (img.height / img.width) * w;
                    margin_top = (height - h) / 2;
                    margin_left = 0;
                } else {
                    h = height;
                    w = (img.width / img.height) * h;
                    margin_top = 0;
                    margin_left = (width - w) / 2;
                }
            }
            marginObj.margintop = margin_top;
            marginObj.marginleft = margin_left;
            return marginObj;

        }
    };


    // 预览音频
    CloudresourceBase.prototype.previewAudio = function (url) {
        var content = this.preview.find('.smartbar_preview_tab_cont');
        content.get(0).innerHTML =
            "<div style='background-color: gray;width: 100%;height: 100%'>" +
                "<audio id='audioId' src='" + url + "'controls='controls' autoplay='autoplay' style='margin-top:30%;'></audio>" +
                "</div>";
//        correctToBaseResolution(this.preview, {keepScale: true});
        var containerWidth = parseInt($("#bookContainer").css("width"))
        if (containerWidth < 800) {
            correctToBaseResolution(this.preview, {keepScale: true});
            this.preview.css("top", "-60px");
            this.preview.draggable({disabled:true});
        }
        this.preview.show();
    };

    //预览MP4视频文件
    CloudresourceBase.prototype.previewMp4 = function (fileurl) {
        var content = this.preview.find('.smartbar_preview_tab_cont');
        content.get(0).innerHTML =
            "<div style='margin:8% 4% auto;width:92%;height:75%  '>" +
                "<video  src='" + fileurl + "' style='width:100%;height:100%;' controls='controls' autoplay='autoplay'></video>" +
                "</div>";
//        correctToBaseResolution(this.preview, {keepScale: true});
        var containerWidth = parseInt($("#bookContainer").css("width"))
        if (containerWidth < 800) {
            correctToBaseResolution(this.preview, {keepScale: true});
            this.preview.css("top", "-60px");
            this.preview.draggable({disabled:true});
        }
        this.preview.show();
    }

    CloudresourceBase.prototype.previewIcw = function(url){
        var content = this.preview.find('.smartbar_preview_tab_cont');
//        var iframeUrl = "http://yun.changyan.com/yunres/Public/_static/js/webCourseware/main/player.html?package="+
//            url +"&route=http%3A%2F%2Fyun.changyan.com%2Fyunres%2Findex.php%3F%26m%3DSearch%26c%3DRequestContent%26a%3Dindex";
        var iframeUrl = AppRemoteSvcCfgBase.ICWiframe+
            url +"&route=http%3A%2F%2Fyun.changyan.com%2Fyunres%2Findex.php%3F%26m%3DSearch%26c%3DRequestContent%26a%3Dindex";
//        var iframeUrl = AppRemoteSvcCfgBase.ICWiframe+
//            url +"&route=http%3A%2F%2F172.16.95.79%2Fyuncloud%2Fyunres%2Findex.php%3F%26m%3DSearch%26c%3DRequestContent%26a%3Dindex";
        var innerHtml =   '<div style="margin:8% 4% auto;width:91%;height:80%">'+
            '<iframe src="{iframeSrc}" style="width: 92%;height: 92%;border: none"></iframe>'+
            '</div>';
        innerHtml = innerHtml.replace("{iframeSrc}",iframeUrl);
        content[0].innerHTML = innerHtml;

        var containerWidth = parseInt($("#bookContainer").css("width"));
        if (containerWidth < 800) {
            correctToBaseResolution(this.preview, {keepScale: true});
            this.preview.css("top", "-60px");
            this.preview.draggable({disabled:true});
        }
        this.preview.show();
    }

    // 预览flash动画
    CloudresourceBase.prototype.previewFlash = function (url) {
        var content = this.preview.find('.smartbar_preview_tab_cont');
        content.get(0).innerHTML =
            "<div style='margin:5% 4% auto;width:92%;height:92% '>" +
                "<embed  src='" + url + "' style='width:92%;height:92%' autostart='true' play='true' wmode='transparent'></embed>" +
                "</div>";
//        correctToBaseResolution(this.preview, {keepScale: true});
        var containerWidth = parseInt($("#bookContainer").css("width"))
        if (containerWidth < 800) {
            correctToBaseResolution(this.preview, {keepScale: true});
            this.preview.css("top", "-60px");
            this.preview.draggable({disabled:true});
        }
        this.preview.show();
    }

    // 预览FLV视频文件
    CloudresourceBase.prototype.previewFlv = function (url) {
        var content = this.preview.find('.smartbar_preview_tab_cont');
        content.get(0).innerHTML =
            "<div id='preview_flv' style='margin:3% 3% auto;width:94%;height:94%'></div>";
        $f("preview_flv", "./assert/js/thirdparty/flowplayer/flowplayer-3.2.16.swf", {
            clip: {    url: url, scaling: "fit", autoPlay: false},
            plugins: {
                controls: {
                    autoHide: false,
                    url: "./assert/js/thirdparty/flowplayer/flowplayer.controls-3.2.15.swf"
                }
            }
        });
//        correctToBaseResolution(this.preview, {keepScale: true});
        var containerWidth = parseInt($("#bookContainer").css("width"))
        if (containerWidth < 800) {
            correctToBaseResolution(this.preview, {keepScale: true});
            this.preview.css("top", "-60px");
            this.preview.draggable({disabled:true});
        }
        this.preview.show();
    }


// 预览office文件
    CloudresourceBase.prototype.previewOffice = function (url) {
        var content = this.preview.find('.smartbar_preview_tab_cont');
        content.get(0).innerHTML = "<div id='preview_office'></div>";
        $("#preview_office").css("height", "94%");
        $("#preview_office").css("width", "98%");
        $("#preview_office").css("margin", "3% 2% auto");
        var fp = new FlexPaperViewer(
            './assert/js/thirdparty/flexpaper/FlexPaperViewer',
            'preview_office', {
                config: {
                    SwfFile: url,
                    Scale: 1.0,
                    ZoomTransition: 'easeOut',
                    ZoomTime: 0.5,
                    ZoomInterval: 0.2,
                    FitPageOnLoad: false,
                    FitWidthOnLoad: false,
                    FullScreenAsMaxWindow: false,
                    ProgressiveLoading: false,
                    MinZoomSize: 0.2,
                    MaxZoomSize: 5,
                    SearchMatchAll: false,
                    InitViewMode: 'Portrait',
                    PrintPaperAsBitmap: false,
                    ViewModeToolsVisible: true,
                    ZoomToolsVisible: true,
                    NavToolsVisible: true,
                    CursorToolsVisible: true,
                    SearchToolsVisible: false,
                    PrintToolsVisible: false,
                    localeChain: 'zh_CN'
                }
            });
//        correctToBaseResolution(this.preview, {keepScale: true});
        var containerWidth = parseInt($("#bookContainer").css("width"))
        if (containerWidth < 800) {
            correctToBaseResolution(this.preview, {keepScale: true});
            this.preview.css("top", "-60px");
            this.preview.draggable({disabled:true});
            $("#preview_office").css("height", "126%");
            $("#preview_office").css("width", "131%");
        }
        this.preview.show();
    }

    /**
     * 加入课本
     */
    CloudresourceBase.prototype.downLoadFile = function (resultData,fromwhere) {
        var _this = this;
        var resourcePath, resFrom;
        resFrom = resultData.resFrom;
        console.log(resultData)
        _this.downloadParam.author = resultData.creator;
        _this.downloadParam.id = resultData.id;
        _this.downloadParam.title = resultData.title;
        _this.downloadParam.file = resultData.fileurl;
        _this.downloadParam.uploadTime = resultData.lastmodify;
        resultData.statistics && (_this.downloadParam.score = resultData.statistics.score);
      //  _this.downloadParam.userPhoto = resultData.fileurl;
        _this.downloadParam.thumbnail = resultData.thumburl;
        _this.downloadParam.savepath = _ebookContext.getUser().getUserResourceRelativeBasePath() + '/' + resultData.id;
        _this.downloadParam.dbpath = _ebookContext.getUser().getUserDbFullPath();
        console.log(_this.downloadParam)
         var url = getUserId +"&key=loginName&value="+resultData.creator;
        //先显示进度条
        (fromwhere != 'resourcecontent') && _this.downloadProcess(resFrom, resultData);
      //获取用户UID
        _ebookContext.getUser().getDataByUserToken(url).done(function(result){
            if(result){
            //获取用户头像
               var getPhoto = AppRemoteSvcCfg.YUN_CHANGYAN+"&method=sns.user.get&uid="+result.id;
                _ebookContext.getUser().getDataByUserToken(getPhoto).done(function(result){
                    var photoSrc=  "";
                        if(result&&result.avatar) photoSrc = result.avatar.avatar_middle;
                    resourcePath = _this.basePath + _this.downloadParam.savepath + '/' + resultData.id + '.' + resultData.extension;
                    _this.downloadParam.photo = photoSrc;
                    _shellcmd.isFileExist(resourcePath).done(function (ret) {
                        /**疆版**/
//                        var unicodeStr = "";
//                        var Title = _this.downloadParam.title;
//                        for (var i = 0 ;i < Title.length-1 ;i++){
//                            unicodeStr += Title.charCodeAt(i)+'`';
//                        }
//                        unicodeStr += Title.charCodeAt(i);
//                        _this.downloadParam.filesavename = unicodeStr;

                        if (ret) {
                            _this.downloadParam.savepath = _ebookContext.getUser().getUserResourceRelativeBasePath()
                                + '/' + resultData.id + '.' + (new Date()).getTime();
                            console.log(_this.downloadParam);
                            var str = JSON.stringify(_this.downloadParam);
                            _shellcmd.fileDownload(str);

                        } else {
                            console.log(_this.downloadParam)
                            var str = JSON.stringify(_this.downloadParam);
                            _shellcmd.fileDownload(str);
                        }
//                        _this.downloadProcess(resFrom, resultData);
                    });
                });
            }else{
                    _this.downloadParam.photo = "";
                    resourcePath = _this.basePath + _this.downloadParam.savepath + '/' + resultData.id + '.' + resultData.extension;
                    console.log(resourcePath)
                    _shellcmd.isFileExist(resourcePath).done(function (ret) {
                        if (ret) {
                            _this.downloadParam.savepath = _ebookContext.getUser().getUserResourceRelativeBasePath()
                                + '/' + resultData.id + '.' + (new Date()).getTime();
                            console.log(_this.downloadParam)
                            var str = JSON.stringify(_this.downloadParam);
                           _shellcmd.fileDownload(str);

                        } else {
                            console.log(_this.downloadParam)
                            var str = JSON.stringify(_this.downloadParam);
                            _shellcmd.fileDownload(str);
                        }
//                       _this.downloadProcess(resFrom, resultData);
                    });
            }
        });
       // _this.downloadParam.photo = _ebookContext.getUser().getUserResourceRelativeBasePath() + '/' + resultData.id+"_photo.jpg"


    };


    /**
     * 资源分享到畅言云
     */
    CloudresourceBase.prototype.shareResToCloud = function(resultData){
        var uId = _ebookContext.getUser().getUid() ||'',
            _content ="" ;
            var resInfo= [{resId:resultData.id||'',
                resName:resultData.title||'',
                extension:resultData.extension,
                classId:'',
                yun_resId:'',
                type: resultData.type||'1',
                shareId:""
            }];
            console.log(resInfo);
            if(resultData.resFrom == "upload" ) _content = "文件上传成功，已分享到的个人主页！";
            else if(resultData.resFrom == "recommend" ) _content = "资源分享成功！";
            else if(arguments[1]) _content = arguments[1];
            var requestUrl = AppRemoteSvcCfg.resShare+ uId + '&resInfo=' + JSON.stringify(resInfo);
            _ebookContext.getUser().getDataByUserToken(requestUrl).done(function (result) {
                console.log(result)
                if(result){
                   var tips =  tipsDialog({
                        "id":"resShareTips" + new Date().getTime(),
                        "content":_content,
                        "action":"openRemote",
                        "actionName":"点击查看",
                        "callback":function(){
                            var url = AppVersionCfg.cloudSSO;
                            _shellcmd.openPageOutside(url);
                        }
                    });
                    console.log(tips);
                }else{
                    var tips =  tipsDialog({
                        "id":"resShareTips" + new Date().getTime(),
                        "content":"文件分享失败"
                    });
                }
            });
    }


    /**
     *
     * @param resFrom 下载来源
     * @param resultData 下载所需数据
     */
    CloudresourceBase.prototype.downloadProcess = function (resFrom, resultData) {
        $("#" + resultData.id).find("span[name='downloadGroup']").remove();
        $("#" + resultData.id).find("div[name='downloadGroup']").remove();
        $("#" + resultData.id).find("div[name='resourceLibDiv']").remove();

        //云资源库进度条--废弃
        var downloadIcon = ' <div style="text-align: center;width: 100px;height: 80px;" name="downloadGroup">' +
            '<div style="width: 90px;height: 10px;border-radius: 5px;border: 1px solid #c0c0c0;margin-top: 20px;">' +
            '<div style="width: 1%;height: 10px;background-color:#00c8ef;border-radius: 5px;" name="downloadprocess"></div>' +
            '</div>' +
            '<a style="cursor:pointer;" id="cancle">取消</a>' +
            ' </div>';
        //推荐资源进度条
        var download = '<div class="scoller_bar_wap" name="downloadGroup">' +
            '<span class="scoller_bar_con">' +
            '<i name="downloadprocess" class="scoller_bar_on" style="width:1%;"></i>' +
            '</span>' +
            '<span class="li_closed" id="cancle"></span>' +
            '</div>';
        //同步资源进度条
        var synDownload ='<span class="sm_gs_text" name="downloadGroup" style="height: 35px;">'+
                            '<div class="scoller_bar_wap scoller_bar_wap2">'+
                                '<span class="scoller_bar_con scoller_bar_con2">'+
                                '<i name="downloadprocess" class="scoller_bar_on" style="width:1%;"></i>'+
                                '</span>'+
                            '<span class="li_closed" id="cancle"></span>'+
                            '</div>'+
                        '</span>';
      //  我的素材
        var myDocumentDownload ='<span class="sm_gs_text" name="downloadGroup" style="height: 35px;">'+
            '<div class="scoller_bar_wap scoller_bar_wap2">'+
            '<span class="scoller_bar_con scoller_bar_con2">'+
            '<i name="downloadprocess" class="scoller_bar_on" style="width:1%;"></i>'+
            '</span>'+
            '<span class="li_closed" id="cancle"></span>'+
            '</div>'+
            '</span>';
        //备课本(不包含备课本中推荐资源)
        var mybeikeDownload ='<span class="sm_gs_text" name="downloadGroup" style="height: 30px;">'+
            '<div class="scoller_bar_wap scoller_bar_wap2">'+
            '<span class="scoller_bar_con scoller_bar_con2">'+
            '<i name="downloadprocess" class="scoller_bar_on" style="width:1%;"></i>'+
            '</span>'+
            '<span class="li_closed" id="cancle"></span>'+
            '</div>'+
            '</span>';
        //备课本中推荐资源
        var myBeikeRecmdDownload = '<span class="sm_gs_text" name="downloadGroup" style="height: 14px;">'+
            '<div class="scoller_bar_wap scoller_bar_wap2">'+
            '<span class="scoller_bar_con scoller_bar_con2">'+
            '<i name="downloadprocess" class="scoller_bar_on" style="width:1%;"></i>'+
            '</span>'+
            '<span class="li_closed" id="cancle"></span>'+
            '</div>'+
            '</span>';

        //授课记录进度条
        var teachRecord = '<div class="sm_scrool_bar" name="downloadGroup" style="height: 25px;">'+
                                '<span class="sm_scrool_bar_bg">'+
                                    '<i name="downloadprocess" class="sm_scrool_bar_on" style="width:1%"></i>'+
                                '</span>'+
                                '<span class="li_closed" id="cancle"></span>'+
                            '</div>';
        //云资源库进度条--2014.8.20
        var resourceLib = '<div class="smartbar_btn_box" name="resourceLibDiv">'+
                                '<div class="scoller_bar_wap">'+
                                    '<span class="scoller_bar_con">'+
                                        '<i class="scoller_bar_on" name="downloadprocess" style="width:1%;"></i>'+
                                        '</span>'+
                                    ' <span class="li_closed" id="cancle"></span>'+
                                '</div>'+
                            ' </div>';
        // 资源排行榜进度条 =
        var resRank= '<div class="scoller_bar_wap" name="resRank">'+
            '<span class="scoller_bar_con">'+
            '<i class="scoller_bar_on" name="downloadprocess" style="width:1%;"></i>'+
            '</span>'+
            ' <span class="li_closed" id=""></span>'+
            '</div>';
        //TODO:
         if(resFrom == "yun_store"){
             $("#" + resultData.id).find('.smartbar_btn_box').find('a').hide();
             $("#" + resultData.id).find('.smartbar_btn_box').append(resourceLib);
         }
        if(resFrom == "yun_search"){
            $("#searchList").find("#" + resultData.id).find('.smartbar_btn_box').find('a').hide();
            $("#searchList").find("#" + resultData.id).find('.smartbar_btn_box').append(resourceLib);
        }
        if(resFrom=="resRank"){
            $("." + resultData.id +"rank .ranking_btn").find('a').hide();
            $("." + resultData.id +"rank .ranking_btn").append(resRank);
        }
        //来自云资源库的下载--废弃
//        if (resFrom == "yun_store") {
//            $("#" + resultData.id).find('.smartbar_search_btn_box').find('a').hide();
//            $("#" + resultData.id).find('.smartbar_search_btn_box').append(downloadIcon);
//        }
        //来自推荐资源的下载
        if (resFrom == "recommend") {
            $("#" + resultData.id).find("p").hide();
            $("#recommendList").find("#" + resultData.id).find('a').append(download);
        }
        //来自同步资源的下载
        if (resFrom == "synRes") {
            $("#recommend_container").find("#" + resultData.id).find('#title').hide();
            $("#recommend_container").find("#" + resultData.id).find("a").append(synDownload);
        }
        //来自云盘的下载
        if (resFrom == "netdisk") {
            $("#" + resultData.id).find('.smartbar_btn.smartbar_btn_b').hide();
            $("#" + resultData.id).find('.smartbar_btn.smartbar_btn_g').hide();
            $("#" + resultData.id).append(downloadIcon);
        }
        //来自我的素材的下载
        if (resFrom == "myDocument") {
            $("#DocumentContainer").find("#" + resultData.id).find('#title').hide();
            $("#DocumentContainer").find("#" + resultData.id).find("a").append(myDocumentDownload);
        }

        //来自备课本的下载
        if(resFrom == 'netdisklesson'){
            $("#prepareLessonTxtPanel").find("#" + resultData.id).find("div[class1=wenzi]").hide();
            $("#prepareLessonTxtPanel").find("#" + resultData.id).find("a").append(mybeikeDownload);
        }

        //来自备课本中推荐资源下载
        if(resFrom == 'netdisklessonRecmd'){
            $("#prepareLessonTxtPanel").find("#" + resultData.id).find("div[class1=wenzi]").hide();
            $("#prepareLessonTxtPanel").find("#" + resultData.id).find("a").append(myBeikeRecmdDownload);
        }
        //来自授课记录的下载
        if(resFrom =="teachRecord"){
            $("#recordListContainer").find("#" + resultData.id).find("div[name='downloadGroup']").remove();
            $("#recordListContainer").find("#" + resultData.id).find("#recordBtn").hide();
            $("#recordListContainer").find("#" + resultData.id).append(teachRecord);
        }

        //取消下载
        $("#" + resultData.id).find("#cancle").click(function (event) {
            var resid = resultData.id;
            _shellcmd.cancleDownload(resid).done(function (ret) {
                if (resFrom == "yun_store") {
                    $("#cloudResourceListPanel").find("#" + resultData.id).find("div[name='resourceLibDiv']").remove();
                    $("#cloudResourceListPanel").find("#" + resultData.id).find('.smartbar_btn_box').find('a').show();
                    event.stopPropagation();
                }
                if (resFrom == "yun_search") {
                    $("#cloudResourceSearchPanel").find("#" + resultData.id).find("div[name='resourceLibDiv']").remove();
                    $("#cloudResourceSearchPanel").find("#" + resultData.id).find('.smartbar_btn_box').find('a').show();
                    event.stopPropagation();
                }
                if (resFrom == "recommend") {
                    $("#recommendList").find("#" + resultData.id).find("div[name='downloadGroup']").remove();
                    $("#" + resultData.id).find("p").show();
                    event.stopPropagation();
                }
                if (resFrom == "netdisk") {
                    $("#" + resultData.id).find("div[name='downloadGroup']").remove();
                    $("#" + resultData.id).find('.smartbar_btn.smartbar_btn_b').show();
                    $("#" + resultData.id).find('.smartbar_btn.smartbar_btn_g').show();
                }
                if (resFrom == "myDocument") {
                    $("#DocumentContainer").find("#" + resultData.id).find("span[name='downloadGroup']").remove();
                    $("#DocumentContainer").find("#" + resultData.id).find('#title').show();
                    event.stopPropagation();
                }
                if (resFrom == "teachRecord") {
                    $("#recordListContainer").find("#" + resultData.id).find("div[name='downloadGroup']").remove();
                    $("#recordListContainer").find("#" + resultData.id).find("#recordBtn").show();
                    event.stopPropagation();
                }
                if(resFrom == "netdisklesson"){
                    $("#prepareLessonTxtPanel").find("#" + resultData.id).find("span[name='downloadGroup']").remove();
                    $("#prepareLessonTxtPanel").find("#" + resultData.id).find("div[class1=wenzi]").show();
                    event.stopPropagation();
                }
                if(resFrom == "netdisklessonRecmd"){
                    $("#prepareLessonTxtPanel").find("#" + resultData.id).find("span[name='downloadGroup']").remove();
                    $("#prepareLessonTxtPanel").find("#" + resultData.id).find("div[class1=wenzi]").show();
                    event.stopPropagation();
                }
            });
            $("#downloadRes").find("#" + resultData.id).find("td[name='protext']").html("已取消下载");
            event.stopPropagation();
            return false;
        });

        //同步资源取消下载
        $("#recommend_container").find("#" + resultData.id).find("#cancle").click(function (event) {
            var resid = resultData.id;
            _shellcmd.cancleDownload(resid).done(function (ret) {
                if (resFrom == "synRes") {
                    $("#recommend_container").find("name")
                    $("#recommend_container").find("#" + resultData.id).find("span[name='downloadGroup']").remove();
                    $("#recommend_container").find("#" + resultData.id).find('#title').show();
                    event.stopPropagation();
                }
            });
            $("#downloadRes").find("#" + resultData.id).find("td[name='protext']").html("已取消下载");
            event.stopPropagation();
            return false;
        });
        //资源排行取消下载
        $("." + resultData.id+"rank").find(".li_closed").click(function(event){
            var resid = resultData.id;
            _shellcmd.cancleDownload(resid).done(function (ret) {
                if (resFrom == "resRank") {
                    $("." + resultData.id+"rank").find("div[name='resRank']").remove();
                    $("." + resultData.id +"rank .ranking_btn").find('a').show();
                    event.stopPropagation();
                }
            });
            event.stopPropagation();
            return false;
        });

        //备课本推荐资源取消下载
        $("#prepareLessonTxtPanel").find("#" + resultData.id).find("#cancle").click(function (event) {
            var resid = resultData.id;
            _shellcmd.cancleDownload(resid).done(function (ret) {

                if(resFrom == "netdisklesson"){
                    $("#prepareLessonTxtPanel").find("#" + resultData.id).find("span[name='downloadGroup']").remove();
                    $("#prepareLessonTxtPanel").find("#" + resultData.id).find("div[class1=wenzi]").show();
                    event.stopPropagation();
                }
            });
            $("#downloadRes").find("#" + resultData.id).find("td[name='protext']").html("已取消下载");
            event.stopPropagation();
            return false;
        });


        //阻止推荐资源点击事件事件冒泡
        $("#" + resultData.id).find("span[name='downloadGroup']").click(function (event) {
            event.stopPropagation();
            return false;
        });
        $("#" + resultData.id).find("div[name='downloadGroup']").click(function (event) {
            event.stopPropagation();
            return false;
        });
        $("#" + resultData.id).find("div[name='resourceLibDiv']").click(function (event) {
            event.stopPropagation();
            return false;
        });

        //塞入下载管理器
        var downloadItem = '<tr class="{_idFlag}">' +
            '<td>{_id}</td>' +
            '<td >{_title}</td>' +
            '<td name="protext">{_process}</td>' +
            '</tr>';
        downloadItem = downloadItem.replace("{_id}", resultData.id).replace("{_idFlag}", resultData.id).
            replace("{_title}", $("#" + resultData.id).find('a').attr("title"));
        $("#downloadRes").append(downloadItem);
    };

    //这里接收外壳发来的下载进度
    CloudresourceBase.prototype.onMessageReceived = function (obj) {
        var _this = this;
        console.log(obj);
        //上传成功返回的结果
        if(obj.evt ==  "uploaddllcall") {
            if(obj.type == 4){
                var resData  ={};
                resData.id = obj.data.data;
                resData.resFrom = "upload";
                resData.type="1";
                var uId = _ebookContext.getUser().getUid() ||'';
                var url =  AppSvcHelper.CYSVC + '&' + $.param(this.requestFileInfo ) +  '&fileId='+ resData.id + '&uid=' + uId;
                _ebookContext.getUser().getDataByUserToken(url).done(function(ret){
                    if(ret){
                        resData.title = ret.name;
                        resData.extension = ret.extension;
                    }
                    _this.shareResToCloud(resData);
                   /* var resources = [{
                        "id": resultData.id||"",
                        "resName":resultData.title||"",
                        "extension":resultData.extension,
                        "size":resultData.length||"",
                        "source":resultData.source||""
                    }];
                    var requestUrl = AppRemoteSvcCfg.getShareId +'&uid='+ uId +'&resources='+JSON.stringify(resources);
                    _ebookContext.getUser().getDataByUserToken(requestUrl).done(function (result){
                        if(result) resData.shareId = result[0];
                        _this.shareResToCloud(resData);
                    });*/
                });
            }
        }
        //下载进程返回的结果
        if(obj.evt ==  "file_download"){
            //下载中
            if (parseFloat(obj.data.progress) <= 1) {
                var _progress = Number(obj.data.progress) * 100 + "%";
                //下载管理器
                $("#downloadRes").find("." + obj.data.id).find("td[name='protext']").html(_progress);
                $("#recommendList").find("#" + obj.data.id).find("i[name='downloadprocess']").css("width", _progress);
                $("#recommend_container").find("#" + obj.data.id).find("i[name='downloadprocess']").css("width", _progress);
                $("#DocumentContainer").find("#" + obj.data.id).find("i[name='downloadprocess']").css("width", _progress);
                $("#recordListContainer").find("#" + obj.data.id).find("i[name='downloadprocess']").css("width", _progress);
                $(".net_disk").find("#" + obj.data.id).find("div[name='downloadprocess']").css("width", _progress);
                $("#" + obj.data.id).find("div[name='downloadprocess']").css("width", _progress);
                $("#prepareLessonTxtPanel").find("#" + obj.data.id).find("i[name='downloadprocess']").css("width", _progress);
                $("#cloudResourceListPanel").find("#" + obj.data.id).find("i[name='downloadprocess']").css("width", _progress);
                $("#cloudResourceSearchPanel").find("#" + obj.data.id).find("i[name='downloadprocess']").css("width", _progress);
                //资源排行
                $("." + obj.data.id+"rank").find("i[name='downloadprocess']").css("width", _progress);
            }
            //下载完成
            if (parseFloat(obj.data.progress) >= 2) {
            $("#downloadRes").find("." + obj.data.id).find("td[name='protext']").html("100%");
            //推荐资源
            $("#recommendList").find("#" + obj.data.id).find("i[name='downloadprocess']").css("width", "100%");
            //同步资源
            $("#recommend_container").find("#" + obj.data.id).find("i[name='downloadprocess']").css("width", "100%");
            //云盘
            $(".net_disk").find("#" + obj.data.id).find("div[name='downloadprocess']").css("width", "100%");
            //云资源库
//            $("#" + obj.data.id).find("div[name='downloadprocess']").css("width", "100%");
            $("#" + obj.data.id).find("i[name='downloadprocess']").css("width", "100%");
            //云资源搜索
            $("#searchList").find("#" + obj.data.id).find("i[name='downloadprocess']").css("width", "100%");
            //我的素材
            $("#DocumentContainer").find("#" + obj.data.id).find("i[name='downloadprocess']").css("width", "100%");
            //授课记录
            $("#recordListContainer").find("#" + obj.data.id).find("i[name='downloadprocess']").css("width", "100%");
            //备课本
            $("#prepareLessonTxtPanel").find("#" + obj.data.id).find("i[name='downloadprocess']").css("width", "100%");
            //资源排行
            $("." + obj.data.id+"rank").find("i[name='downloadprocess']").css("width", "100%");
            var array = [];
            var basePath = _path.trimPosix(Config.binPath);
            array[0] = basePath + obj.data.file;

            var option = {
                userName:  obj.data.rawData.author,
                userPhoto : "",
                score : obj.data.rawData.score,
                uploadTime : obj.data.rawData.uploadTime,
                resourceId:obj.data.id
                //title: obj.data.rawData.title
            }

            /**
             * 这里会有一个问题，以后再优化
             * 当拖拽下载到课本上的时候，
             * 这个位置的记录是可以被改动的
             * 要考虑：
             * 下载过程中翻页，
             * 下载过程中再次拖拽下载
             * 下载过程中单击“加入课本”
             *
             * 由于大多数file下载较快，暂不考虑
             */
            if(newWidgetPos){
                //拖拽下载
                var $pageItem = $('.pageItem');
                var isDoublePage = $pageItem.length === 2;
                var pageindex = 1;
                var pageScale = _ebookContext.getTransformMatrix($pageItem);
                var viewWidth =  $("#bookContainer").width();
                var x, y;
                if (isDoublePage) {
                    x = (newWidgetPos.left - 70 - viewWidth/2 );
                    //判断是否是第二页
                    if(x>0){
                        x = x / pageScale[0];
                        pageindex = 2;
                    }
                    else{
                        x = (newWidgetPos.left - 70) / pageScale[0];
                    }
                }
                else {
                    x = (newWidgetPos.left - 70) / pageScale[0];
                }
                y = (newWidgetPos.top - 90) / pageScale[3];
                console.log(x, y);
                console.log(newWidgetPos.left, newWidgetPos.top);
                _this.bookContainer.insertWidgetWithPos(array[0], [x, y],pageindex, option);
            }
            else{
                //单击“加入课本”下载
                _this.bookContainer.insertWidget(array,option);
            }
            //成功后移除进度条
            //推荐资源
            $("ul[name='recommendItem']").find("#" + obj.data.id).find("div[name='downloadGroup']").remove();
            $("#recommendList").find("#" + obj.data.id).find("p").show();
            //同步资源
            $("#recommend_container").find("#" + obj.data.id).find("span[name='downloadGroup']").remove();
            $("#recommend_container").find("#" + obj.data.id).find('#title').show();
            //云盘
            $(".net_disk").find("#" + obj.data.id).find("div[name='downloadGroup']").remove();
            $("#" + obj.data.id).find('.smartbar_btn.smartbar_btn_b').show();
            $("#" + obj.data.id).find('.smartbar_btn.smartbar_btn_g').show();
            //云资源库
//            $("#" + obj.data.id).find("div[name='downloadGroup']").remove();
//            $("#" + obj.data.id).find('.smartbar_search_btn_box').find('a').show();

            $("#" + obj.data.id).find("div[name='resourceLibDiv']").remove();
            $("#" + obj.data.id).find('.smartbar_btn_box').find('a').show();
            //我的素材
            $("#DocumentContainer").find("#" + obj.data.id).find("span[name='downloadGroup']").remove();
            $("#DocumentContainer").find("#" + obj.data.id).find('#title').show();
            //授课记录
            $("#recordListContainer").find("#" + obj.data.id).find("div[name='downloadGroup']").remove();
            $("#recordListContainer").find("#" + obj.data.id).find("#recordBtn").show();
            //备课本
            $("#prepareLessonTxtPanel").find("#" + obj.data.id).find("span[name='downloadGroup']").remove();
            $("#prepareLessonTxtPanel").find("#" + obj.data.id).find("div[class1=wenzi]").show();
            //资源排行榜
            $("." + obj.data.id + "rank").find("div[name='resRank']").remove();
            $("." + obj.data.id + "rank .ranking_btn").find('a').show();
            //下载完成后还应该给下载数加1.
            _this.addDownloadCountRqst.resourceid = obj.data.id;
            var url = downloadUrlBase + $.param(_this.addDownloadCountRqst);
            _ebookContext.getUser().getDataByUserToken(url).done(function (result) {
                console.log(result);
            })

        }
        }
    };

    module.exports = CloudresourceBase;
});
