﻿/**
 *
 */
define(function (require, exports, module) {

    require('xml2json');
    require('browserContext');
    var path = require('../../common/path');
    var model = require('../model');
    var PageItem = require('./pageitem').PageItem;
    var WBItem = require('./wbitem').WBItem;
    var ebkContext = require('../ebookcontext').Instance;
    var shellcmd = require('../../common/shellcmd');
    var trace = require('../trace').Instance;
    var remotebookDirAccess = require('../../common/remotebookdiraccess');
    var bookDirParser = require('../../common/bookdirectoryparser');
    var booklichelper = require('../bookshelf/booklichelper.js');
    var bookAccessor = require('../bookshelf/bookaccessor').Instance;


    /**
     * 电子书辅助类
     * 主要获取电子书的数据
     */
    function PageProvider() {
        var _self = this;
        //book序列化回来的完整对象
        _self.bookObj = null;
        _self.bookPages = [];
        //页面缩放的比例,当前只有拖拽时用到
        _self.zoomRate = 1;
        // 页数
        _self.pageCount = 0;
        //目录信息
        _self.bookMenu = null;

        /**
         * 页面原始尺寸
         * @type {model.Size}
         */
        _self.bookImageSize = new model.Size();

        _self.bookImageSize.width = 1110;
        _self.bookImageSize.height = 1570;

        _self.WBImageSize = new model.Size();

        /**
         *
         * @type {string}
         */
        _self.bookCode = "";
        //tch 文件
        _self.tchFile = "";
        //tch 的bookid
        _self.tchBookId = "";
        //是否为双语课本
        _self.isDoubleLanguage = false;

        _self.wbnum = 1;

        /**
         * 书本资源路径
         * @type {string}
         */
        _self.audioPlayer = null;
        //保存已经解压出来的pageItem
        _self.pages = [];

        _self.setPlayer = function (hotspotPlayer, audioPlayer) {
            hotspotPlayer.init(this);
            this.audioPlayer = audioPlayer;
            var hotspotMgr = require('./hotspot/hotspotmgr');
            hotspotMgr.init(hotspotPlayer);
        }

        _self.getUserBookDir = function () {
            return ebkContext.getUserBookPath();
        }

        _self.getUserBookBaseDir = function () {
            return ebkContext.getUser().getUserBookBasePath();
        }

        _self.getUserToken = function () {
            return ebkContext.getMatchToken();
        }

        _self.getStdEncryptBook = function () {
            return  path.trimPosix(path.join(_self.getStdBookDir(), _self.bookCode + ".book2"));
        }

        _self.getStdBookLic = function () {
            var lic = path.trimPosix(path.join(_self.getStdBookDir(), _self.bookCode + ".lic"));
            return lic;
        }

        _self.getBookDirectory = function () {
            var dirPath = path.trimPosix(path.join(_self.getStdBookDir(), _self.bookCode + ".json"));
            return dirPath;
        }

        _self.getStdBookDir = function () {
            return ebkContext.getStdBookPath();
        }

        _self.getBookXmlFile = function () {
            return path.trimPosix(path.join(_self.getStdBookDir(), _self.bookCode + '.xml'));
        }

        _self._getTchFile = function () {
            return path.trimPosix(path.join(_self.getStdBookDir(), _self.bookCode + '.tch'));
        }

        _self._getWBoardPath = function () {
            return ebkContext.getUser().getUserWBPath();
        }

        /**
         * 合并远程和本地书本目录信息
         * @param bookObj
         * @returns {*} 返回空表示合并失败
         * @private
         */
        _self._mergeBookDirction = function (bookObj) {
            var def = $.Deferred();
            //20140617 ---- 资源网关目录查询修改
            if (!_self.bookObj || !_self.bookObj.IndexInfo || !_self.bookObj.IndexInfo.Code) {  //如果这些信息没有，
                def.resolve(null);
                return def.promise();
            }
            var bookId = _self.bookObj.IndexInfo.Code;
            var remoteAccess = new remotebookDirAccess.RemoteBookDirectoryAccess();
            //先用本地已经下载保存的JSON文件
            remoteAccess.getBookDirFromFile(_self.getBookDirectory()).done(function (content) {
                if (content) {
                    var downloadDate = new Date(content.DownloadDate);
                    var days = Math.ceil((new Date().getTime() - downloadDate.getTime()) / 86400000);
                    if (isNaN(days) || days > 10) { //应该更新一下了
                        remoteAccess.getBookDirFromWeb(_self.getBookDirectory(), bookId).done(function (newContent) {
                            if (newContent) {
                                var bookDirectoryParser = new bookDirParser.BookDirectoryParser(newContent, bookObj);
                                var bookJson = bookDirectoryParser.parseJson();
                                if (bookJson) {
                                    remoteAccess.saveRemoteBookDir(bookJson, _self.getBookDirectory());
                                    def.resolve(bookJson);
                                } else {
                                    def.resolve(content);
                                }
                            } else { //如果下载的也不可用，则用随书XML
                                def.resolve(content);
                            }
                        });
                    } else {
                        def.resolve(content);
                    }
                } else { //如果本地JSON文件不可用，则尝试重新下载
                    remoteAccess.getBookDirFromWeb(_self.getBookDirectory(), bookId).done(function (content) {
                        if (content && content.statuscode != 400) {
                            var bookDirectoryParser = new bookDirParser.BookDirectoryParser(content, bookObj);
                            var bookJson = bookDirectoryParser.parseJson();
                            if (bookJson) {
                                remoteAccess.saveRemoteBookDir(bookJson, _self.getBookDirectory());
                                def.resolve(bookJson);
                            } else {
                                def.resolve(null);
                            }
                        } else { //如果下载的也不可用，则用随书XML
                            def.resolve(null);
                        }
                    })
                }
            });
            return def.promise();
        }

        /**
         * 加载书本
         * @param {string} bookCode 书本编号
         */
        _self.loadBook = function (bookCode, errorflag) {
            console.log("pageprovider.js:pageProvider->loadBook begin");
            var def = $.Deferred();

            if (_self.bookCode != bookCode || errorflag) {
                ebkContext.setBookCode(bookCode);
                _self.bookCode = bookCode;

                console.time("_getBookObject");
                _self._getBookObject().done(function (obj) {
                    console.timeEnd("解压_getBookObject");
                    console.log(obj);
                    _self.bookObj = obj;

                    var isNewBookObj = false;
                    _self._mergeBookDirction(obj).done(function (newBookObj) {
                        if (newBookObj) { //合并成功则用合并后的目录
                            _self.bookObj = newBookObj;
                            isNewBookObj = true;
                        }
                        try {
                            _self.isDoubleLanguage = _self.bookObj.DoubleLanguage === "true";
                            _self.tchBookId = _self.bookObj.IndexInfo.TchId;

                            /**************************************************************
                             * Caution:
                             * 如果Unit只有一个单元，转化成数组
                             * 主要是解决18本人教体验书的打开问题
                             *                ----------  by  yczhu
                             ****************************************************************/
                            (!_self.bookObj.Units.Unit.length && _self.bookObj.Units.Unit ) &&
                            (_self.bookObj.Units.Unit = [_self.bookObj.Units.Unit]);

                            var bookMenu = new Array(_self.bookObj.Units.Unit.length);
                            for (var i = 0; i < _self.bookObj.Units.Unit.length; i++) {
                                var unit = _self.bookObj.Units.Unit[i];
                                var unitPageIndex = "-1", unitPageIndexEnd = "-1";  //单元起始页码
                                if (unit.Pages.BookPage != null && unit.Pages.BookPage.length > 1) {

                                    unitPageIndex = unit.Pages.BookPage[0].Code;
                                    unitPageIndexEnd = unit.Pages.BookPage[ unit.Pages.BookPage.length - 1].Code
                                    _self.bookPages = _self.bookPages.concat(unit.Pages.BookPage);
                                } else if (unit.Pages.BookPage != null) {
                                    unitPageIndex = unit.Pages.BookPage.Code;
                                    unitPageIndexEnd = unit.Pages.BookPage.Code;
                                    _self.bookPages.push(unit.Pages.BookPage);
                                }
                                var unitCode = (i + 1).toString();
                                if (isNewBookObj) {
                                    unitCode = unit.UnitCode;
                                } else {    //服务端unitCode均为两位编码，所以如果不足两位，我们需要在前面添加“0”补足为两位编码
                                    if (unitCode.length < 2) {
                                        unitCode = "0" + unitCode;
                                    }
                                }
                                var menuItem = new model.MenuItem(unit.Name, unit.Code, unitPageIndex, unitPageIndexEnd, unitCode);
                                menuItem.courses = unit.Courses.Course;
                                bookMenu[i] = menuItem;
                            }
                            _self.bookMenu = bookMenu;
                            var size = _self.bookObj.PageImageSize;
                            _self.bookImageSize.width = size["Width"];
                            _self.bookImageSize.height = size["Height"];

                            if (_self.bookObj.Units && _self.bookObj.Units.Unit) {
                                _self.pageCount = _self._getPageLength(_self.bookObj);
                            }
                            def.resolve();
                        } catch (ex) {
                            hideLoading();
                            console.log('error caugth by pageprovider loadbook');
                            if (!errorflag) {
                                _self.doLicError(bookCode).done(function (ret) {
                                    if(ret){
                                        _self.loadBook(bookCode,true).done(function(){
                                            def.resolve();
                                        })
                                    }
                                    else{
                                        _self.openBookError(bookCode);
                                        def.resolve();
                                    }
                                });
                            }
                            else {
                                _self.openBookError(bookCode);
                                def.resolve();
                            }
                        }
                    })
                });
            } else {
                console.warn('book %s is already loaded');
                def.resolve();
            }
            _self._initDir(_self.bookCode);
            return def.promise();
        };

        _self._initDir = function (bookcode) {
            var tmpDir = path.join(ebkContext.getSysTmpPath(), _self.bookCode, 'audio');
            shellcmd.createDirIfNotExist(tmpDir);
        };

        _self._getPageLength = function (book) {
            return _self.bookPages.length;
        };

        /**
         * 获取书本对象（背景 + 热区）
         * @param bookXml
         */
        _self._getBookObject = function () {
            var xml = null;
            var bookXml = path.join(_self.getStdBookDir(), _self.bookCode + ".xml");
            bookXml = path.trimPosix(bookXml);
            var xml2BookObj = function (xml) {
                if (isString(xml)) {
                    if (xml.length > 0) {
                        require('xml2json');
                        var obj = $.xml2json(xml);
                        if (obj.DoubleLanguage === "true") {
                            _self.isDoubleLanguage = true;
                        }
                        return obj;
                    }
                }
                return xml;
            };

            var def = $.Deferred();
            var ret = shellcmd.isFileExistSync(bookXml);
            if (ret) {
                //如果找到祼的描述文件,就不使用drm了
                AppCfg.useDrm = false;
            }
            if (!AppCfg.useDrm) {
                xml = shellcmd.readFile(bookXml);
                def.resolve(xml2BookObj(xml));
            }
            else {
                var file = '{0}.xml'.format(_self.bookCode);
                if (!AppCfg.saveDRMXAML) {
                    _self.retriveDrmRes(file, '').done(function (res) {
                        xml = res;
                        def.resolve(xml2BookObj(xml));
                    });
                } else {  //save it
                    var tmpDir = path.join(ebkContext.getSysTmpPath(), _self.bookCode);
                    var saveTo = path.join(tmpDir, file);

                    var ret = shellcmd.isFileExistSync(saveTo);
                    if (ret) {
                        var xmlFile = shellcmd.readFile(saveTo);
                        //把XML保存到磁盘中的整个流程走不通，所以这里注释掉。
                        // shellcmd.saveFile(xmlFile, _self.getBookXmlFile());
                        def.resolve(xml2BookObj(xmlFile));
                    } else {
                        _self.retriveDrmRes(file, saveTo).done(function (ret) {
                            def.resolve(xml2BookObj(shellcmd.readFile(saveTo)));
                        });
                    }
                }
            }
            return def.promise();
        };

        _self.retriveDrmRes = function (file, saveTo) {
            var def = $.Deferred();
            var zip = _self.getStdEncryptBook();
            var lic = _self.getStdBookLic();
            _self.getUserToken().done(function (token) {
                shellcmd.readEncryptFile(token, zip, lic, file, saveTo).done(function (ret) {
                    def.resolve(ret);
                });
            });

            return def.promise();
        };

        _self.isEncryptFileExist = function (file) {
            var def = $.Deferred();
            var zip = _self.getStdEncryptBook();
            shellcmd.isEncryptFileExist(zip, file).done(function (ret) {
                def.resolve(ret);
            });
            return def.promise();
        };

        /**
         * 解析电子书数据对象
         */
        _self.loadPageItem = function (pageIndex, notUseCurrentPageItem) {
            var def = $.Deferred();
            if (!_self._hasPageItem(pageIndex) || notUseCurrentPageItem) {
                var page = new PageItem(_self, pageIndex, _self.audioPlayer);
                if (notUseCurrentPageItem) {
                    page._isModify = true;
                }
                page.load().done(function () {
                    _self.pages.push(page);
                    def.resolve(page);
                });
            } else {
                def.resolve(_self.getPageItem(pageIndex));
            }
            return def.promise();
        };

        _self.getPageItem = function (pageIndex) {
            for (var i = 0, len = _self.pages.length; i < len; i++) {
                if (_self.pages[i].pageIndex === pageIndex) {
                    return _self.pages[i];
                }
            }
            return null;
        };

        _self._removePageItem = function (pageIndex) {
            _self.pages = _self.pages.filter(function (p) {
                return p.pageIndex != pageIndex;
            });
        };

        _self._removeWBItem = function (pageIndex) {
            _self.pages = _self.pages.filter(function (p) {
                return p.WBIndex != pageIndex;
            });
        };

        _self._hasPageItem = function (pageIndex) {
            return _self.pages.some(function (p, i, arr) {
                return p.pageIndex === pageIndex;
            });
        };

        _self.unloadWBItem = function (WBIndex) {
            $.each(_self.pages, function () {
                (this.WBIndex === WBIndex) && this.unload();
            });
            _self._removeWBItem(WBIndex);
        };


        _self.unloadPageItem = function (pageIndex) {
            $.each(_self.pages, function () {
                (this.pageIndex === pageIndex) && this.unload();
            });
            _self._removePageItem(pageIndex);
        };

        /**
         * 页面卸载
         * @param {boolean=} index 默认为false，只是卸载当前页面，如果为true，则卸载整个书本页面。如从书本跳转到书架
         */
        _self.unloadAllPage = function (index) {
            $.each(_self.pages, function () {
                this.unload(index);
            });
            _self.pages = [];
        };

        /**
         * 获取当前页面的元数据：所属书本、单元、课时
         * @param pageIndex
         */
        _self.getPageMetadata = function (pageIndex) {
            pageIndex = parseInt(pageIndex);//传入的可能是字符串，强制转化为数字
            var metadata = {};
            //获取单元
            var unitItem;
            if (pageIndex >= _self.bookMenu[_self.bookMenu.length - 1].pageIndex) {
                unitItem = _self.bookMenu[_self.bookMenu.length - 1];
            } else {
                for (var i = 0; i < _self.bookMenu.length; i++) {
                    if (pageIndex >= _self.bookMenu[i].pageIndex && pageIndex < _self.bookMenu[i + 1].pageIndex) {
                        unitItem = _self.bookMenu[i];
                        break;
                    }
                }
            }

            //获取课时
            var courseItem;
            var courses = $.makeArray(unitItem.courses);
            if (courses && courses.length == 1) {
                courseItem = courses[0];
            } else if (courses && courses.length > 1) {
                courseItem = courses[0];
                if (pageIndex > courses[0].ImageIndex) {
                    for (var i = 1; i <= courses.length; i++) {
                        if (!courses[i]) { //如果超出索引，则认为是最后一课
                            courseItem = courses[i - 1];
                            break;
                        }
                        if (pageIndex >= courses[i - 1].ImageIndex && pageIndex < courses[i].ImageIndex) {
                            courseItem = courses[i - 1];
                            break;
                        }
                    }
                }
            }
            var tempUnit = JSON.parse(JSON.stringify(unitItem, ["title", "pageCode", "pageIndex", "unitCode"]));
            metadata["unit"] = tempUnit;
            metadata["course"] = courseItem;
            return metadata;
        }

        /**
         * 获取当前单元UnitCode
         * @returns {*}
         * @private
         */
        _self.getUnit = function (currPageIndex) {
            var metadata = _self.getPageMetadata(currPageIndex);
            return metadata.unit.unitCode;
        }

        /**
         * 获取当前课时
         * @param currPageIndex
         * @returns {string}
         */
        _self.getCourse = function (currPageIndex) {
            var metadata = _self.getPageMetadata(currPageIndex);
            var courseCode = metadata.course ? metadata.course.Code : "";
            return courseCode;
        }

        /**
         * 获取点读的音频
         * 暂时是MP3,回头转WOV
         */
        _self.getAudioPath = function (audioId, lan) {
            var def = $.Deferred();
            //真实的资源应该是WOV文件
            var audiofile = 'audio/{0}_{1}.wov'.format(audioId, lan);
            //找不到wov就找MP3
            var audiofileMp3 = 'audio/{0}_{1}.mp3'.format(audioId, lan);
            if (!AppCfg.useDrm) {
                var ret = path.trimPosix(path.join(_self.getStdBookDir(), audiofile));
                if (!shellcmd.isFileExistSync(ret)) {
                    ret = path.trimPosix(path.join(_self.getStdBookDir(), audiofileMp3));
                }
                def.resolve(ret);
            }
            else {
                _self.isEncryptFileExist(audiofileMp3).done(function (isexistMp3) {
                    if (isexistMp3) {
                        //使用MP3
                        audiofile = audiofileMp3;
                    }
                    var tmpDir = path.join(ebkContext.getSysTmpPath(), _self.bookCode);
                    var saveTo = path.join(tmpDir, audiofile);

                    var ret = shellcmd.isFileExistSync(saveTo);
                    if (!ret) {
                        var ret = _self.retriveDrmRes(audiofile, saveTo).done(function (result) {
                            //console.log('get audio from drm:', ret);
                            def.resolve(path.trimPosix(saveTo));
                        });
                    } else {
                        def.resolve(path.trimPosix(saveTo));
                    }
                });
            }
            return def.promise();
        }

        _self.loadWBItem = function (wbnum) {
            var def = $.Deferred();
            _self.wbnum = wbnum ? wbnum : _self.wbnum;
            var page = new WBItem(_self, _self.wbnum, _self._getWBoardPath(), _self.audioPlayer);
            page.load().done(function () {
                _self.pages.push(page);
                def.resolve(page);
            });
            return def.promise();
        }

        _self.doLicError = function (bookCode) {
            var def = $.Deferred();
            var userhere =  ebkContext.getUser();
            //清除lic
            userhere.getUserToken().done(function (token) {
                var msg = {
                    licfile: path.trimPosix(ebkContext.getUser().getBookLicenseFullPath(bookCode)),
                    token: token
                }
                shellcmd.removeResLicFromMem(JSON.stringify(msg)).done(function(){
                    //先获取bookid 再更新lic
                    bookAccessor.getBookId(bookCode,userhere).done(function(retid){
                        if(retid){
                            var task1 = shellcmd.getHardwareType();
                            var task2 = shellcmd.getHardwareInfo(userhere.getName());
                            $.when(task1,task2).done(function(hdType,hdInfo){
                                booklichelper.callGetBookLicense(retid,bookCode,userhere,hdInfo,hdType).done(function(ret){
                                    def.resolve(ret);
                                })
                            })
                        }
                        else{
                            def.resolve();
                        }
                    })

                });
            });
            return def.promise();
        }

        _self.openBookError = function (bookCode) {
            $.Zebra_Dialog(AppBookShelfTipsList.OpenBookError, {
                'type': 'information',
                'title': AppTips.WarmTips,
                'buttons': [ AppTips.OkTips],
                'onClose': function (capition) {
                    //这个时候需要清除内存中的该书本的LIC，并返回书架
                    ebkContext.getUser().getUserToken().done(function (token) {
                        var msg = {
                            licfile: path.trimPosix(ebkContext.getUser().getBookLicenseFullPath(bookCode)),
                            token: token
                        }
                        shellcmd.removeResLicFromMem(JSON.stringify(msg));
                        var _pageNavigatorHelper = require('../../common/pagenavigatorhelper');
                        _pageNavigatorHelper.goToBookShelf(ebkContext.getUser());
                    })
                }
            });
        }
    }

    exports.Instance = new PageProvider();
});