/**
 * 书本导航模块
 * User: yuwang@iflytek.com
 * Date: 13-7-10 下午2:59
 * Version: 1.0
 */

define(function (require, exports) {
    var _pageProvider = require('./pageprovider').Instance;
    var _bookContainer;

    this.init = function (bookContainer) {
        _bookContainer = bookContainer;
        var bookMenu = _pageProvider.bookMenu;
        var dir = '<ul>';
        var templateTitle = '<div class="text">{0}</div>';
        var templatePageCode = '<div class="page" data-pageindex={0} data-pageindexend={1} data-unitcode={2} data-coursecode={3}>{4}</div><div class="clear"></div>';
        for (var i = 0; i < bookMenu.length; i++) {
            var item = '<li>';
            item += templateTitle.format(bookMenu[i].title);
            if (bookMenu[i].pageIndex == '-1') {
                item += templatePageCode.format(bookMenu[i + 1].pageIndex, bookMenu[i + 1].pageIndex, bookMenu[i].unitCode, "-1", bookMenu[i].pageCode);

            } else {
                item += templatePageCode.format(bookMenu[i].pageIndex, bookMenu[i].pageIndexEnd, bookMenu[i].unitCode, "-1", bookMenu[i].pageCode);
            }
            item += '</li>'
            dir += item;
            if (bookMenu[i].courses) {
                var courses = $.makeArray(bookMenu[i].courses);
                for (var k = 0; k < courses.length; ++k) {
                    var pageIndex = parseInt(courses[k].ImageIndex);
                    var pageIndexEnd = parseInt(courses[k].PageCodeEnd) - parseInt(courses[k].PageCode) + pageIndex;
                    var item = '<li>';
                    item += templateTitle.format("&nbsp;&nbsp;&nbsp;" + courses[k].Name);
                    item += templatePageCode.format(pageIndex, pageIndexEnd, bookMenu[i].unitCode, courses[k].Code, courses[k].PageCode);
                    item += '</li>'
                    dir += item;
                }

            }
        }
        dir += '</ul>';

        $("#contentLeft").click(function () {
            //计算左边课本目录弹出框的位置
            var posLeft = $("#contentLeft").position();
            var directory_box_left = $("#directory_box_left");

            directory_box_left.blur(function () {
                directory_box_left.hide();    //目录框，失去焦点，则隐藏
            });

            directory_box_left.toggle();

            if($(window).width() < 1000){
                //80是上面head和主工具栏的高度
                directory_box_left.css("top", (posLeft.top + 60));
            }
            else{
                directory_box_left.css("top", (posLeft.top + 20));
            }
            //43是左边箭头directory_arrowleft的top值,
            var scale = correctToBaseResolution(directory_box_left, {scaleFromCenter: false});
            scale[5] -= 43 * scale[3];

            directory_box_left.css({'-webkit-transform': 'matrix(' + scale.join(',') + ')',
                "left": $("#leftToolbar").css('width')});
            var pageMetadata = _bookContainer.getCurrPageMetadata();
            var curUnitCode = pageMetadata.unit.unitCode;
            var curCourseCode = "-1";
            if (pageMetadata.course) {
                curCourseCode = pageMetadata.course.Code;
            }
            $("#directory_box_right").css({display: "none"});
            $("#directory_content_left").html(dir);

            var li = $("#directory_content_left li");

            li.each(function () {              //遍历设置选中状态
                var unitCode= $(this).find(".page").attr("data-unitcode");
                var courseCode=  $(this).find(".page").attr("data-coursecode");
                if (unitCode==curUnitCode && courseCode==curCourseCode) {
                    $(this).addClass("current");
                    return false;
                }
            });

            li.on("click", function () {
                li.removeClass("current");
                $(this).addClass("current");
                var pageIndex = $(this).find(".page").attr("data-pageindex");
                _bookContainer.setPageIndex(parseInt(pageIndex));
            });
        });


        $("#contentRight").click(function () {
            var directory_box_right = $("#directory_box_right");

            directory_box_right.toggle();

            directory_box_right.blur(function () {
                directory_box_right.hide();
            });
            //计算右边课本目录弹出框的位置
            var posRight = $("#contentRight").position();
            if($(window).width() < 1000){
                //80是上面head和主工具栏的高度
                directory_box_right.css("top", (posRight.top + 60));
            }
            else{
                directory_box_right.css("top", (posRight.top + 20));
            }
            var scale = correctToBaseResolution(directory_box_right, {scaleFromCenter: false});
            scale[4] += (1 - scale[0]) * directory_box_right.outerWidth();
            scale[5] -= 43 * scale[3];
            directory_box_right.css({'-webkit-transform': 'matrix(' + scale.join(',') + ')',
                "right": $("#leftToolbar").css('width')});

            var pageMetadata = _bookContainer.getCurrPageMetadata();
            var curUnitCode=pageMetadata.unit.unitCode;
            var curCourseCode="-1";
            if (pageMetadata.course) {
                curCourseCode=pageMetadata.course.Code;
            }

            $("#directory_box_left").css({display: "none"});

            $("#directory_content_right").html(dir);

            var li = $("#directory_content_right li");

            li.each(function () {
                var unitCode= $(this).find(".page").attr("data-unitcode");
                var courseCode=  $(this).find(".page").attr("data-coursecode");
                if (unitCode == curUnitCode && courseCode == curCourseCode) {
                    $(this).addClass("current");
                    return false;
                }
            });

            li.on("click", function () {
                li.removeClass("current");
                $(this).addClass("current");
                var pageIndex = $(this).find(".page").attr("data-pageindex");
                _bookContainer.setPageIndex(parseInt(pageIndex));
            });
        });
    };

    exports.init = init;
})
