/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-4
 * Time: 下午4:43
 * To change this template use File | Settings | File Templates.
 */
;
define(function (require, exports) {

    var actionType = require('../../trace').ActionType;
    var _pageProvider = require('../pageprovider').Instance;
    var _containerHelper = require('../containerhelper');
    var ebookContext = require('../../ebookcontext').Instance;
    var shellcmd = require('../../../common/shellcmd');
    var path = require('../../../common/path');
    var commonfunc = require('../../../common/commonfunc');

    function ImportRes() {

    }

    ImportRes.prototype.importBookRes = function () {

        shellcmd.resImport().done(function (ret) {
            var importPath = ret.trim();
            if (importPath === "")  return;

            AlertCover(importPath);
        });
    }

    function AlertCover(importPath){
        $.Zebra_Dialog(AppImportAndExportTips.ImportTips, {
            'type': 'question',
            'title': AppTips.WarmTips,
            'buttons': [AppTips.CancelTips, AppTips.OkTips],
            'onClose': function (capition) {
                 (capition == AppTips.OkTips) && CoverBook(importPath);
            }
        });
    }

    function CoverBook(importPath){
        var tips;
        //判断导入文件是否合法
        shellcmd.getZipInnercode(importPath).done(function (ret) {
            var data = null;
            if (ret != ""){
                data = eval('(' + ret + ')');
            }
            if (data && data.bookcode == _pageProvider.bookCode) {
                console.log({account: ebookContext.getUser().getName(), bookCode: _pageProvider.bookCode, filePath: importPath});
                //     trace.log('ebook', actionType.StartImportTeb, {account: ebookContext.getUser().getName(), bookCode: _pageProvider.bookCode, filePath: importPath});

                var pathDir = path.dirname(path.trimPosix(_pageProvider.getUserBookDir()));
                var args = '{"zippath":"' + importPath + '","despath":"' + pathDir + '"}';

                //清空书本资源后导入资源
                _containerHelper._clearBookRes(data.files,_pageProvider).done(function () {
                    showLoading();
                    shellcmd.unzip(args).done(function (ret) {
                        hideLoading();
                        if (ret) {
                            $.each(_pageProvider.pages, function (i, e) {
                                if ($.inArray("" + e.pageIndex, data.files) != -1)
                                    e.importBookRes();
                            });
                            //$(_canvasManager).trigger('restoreStrokeWithoutHidePageCanvas');
                            tips = AppImportAndExportTips.ImportSuccess;
                        }
                        else tips = AppImportAndExportTips.ImportFailed;
                        addTipDialog(tips);
                        //         trace.log('ebook', actionType.EndImportTeb, {bookCode: _pageProvider.bookCode});
                    })
                });

            }
            else {
                tips = AppImportAndExportTips.ImportInvalid;
                addTipDialog(tips);
                //     trace.log('ebook', actionType.EndImportTeb, {bookCode: _pageProvider.bookCode});
            }
        });
    }

    function addTipDialog(tips, buttons, callback) {
        if (!tips) return;
        $.Zebra_Dialog(tips, {
            'type': 'information',
            'title': AppTips.WarmTips,
            'buttons': buttons == undefined ? [AppTips.OkTips] : buttons,
            'onClose': function (caption) {
                if (typeof callback === 'function') callback(caption);
            }
        });
    }

    exports.Instance = new ImportRes();
});
