/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-4
 * Time: 下午4:43
 * To change this template use File | Settings | File Templates.
 */
;define(function(require,exports){
    var _pageProvider = require('../pageprovider').Instance;
    var ebookContext = require('../../ebookcontext').Instance;
    var shellcmd = require('../../../common/shellcmd');
    var _taskQueue = require('../../../common/taskQueue').Instance;
    var _define = require('../../define');
    var path = require('../../../common/path');
    var commonfunc = require('../../../common/commonfunc');

    function ExportRes(){
        var _self = this;
        _self._container = null;
    }

    ExportRes.prototype.init = function(_container){
        var _self = this;
        _self._container = _container;
    }

    ExportRes.prototype.getPageViewType = function () {
        return this._container.getPageViewType();
    };

    ExportRes.prototype.exportBookRes = function(){
        var _self = this;
        var exportBookResContent = _self._initExportBookScanPanel(_pageProvider.bookObj);
        var parmDom = {
            txtPathSelect: exportBookResContent.find("#posSelect"),
            txtTitleSelect: exportBookResContent.find("#titleSelect"),
            divSelectBox: exportBookResContent.find(".sel"),
            btnSelectDir: exportBookResContent.find("#btnSelectDir"),
            btnCancel: exportBookResContent.find("#btnCancel"),
            btnSubmit: exportBookResContent.find("#btnSubmit"),
            btnClose: exportBookResContent.find(".close_res"),
            btnSelectAll: exportBookResContent.find("#selectAll"),
            chek_export: exportBookResContent.find("#chek_export"),
            chek_upload: exportBookResContent.find("#chek_upload"),
            chek_cloud_upload: exportBookResContent.find("#chek_cloud_upload"),
            content: exportBookResContent
        };
        _self._bindExportBookResCommands(parmDom);
        //先进行保存操作
        $.each(_pageProvider.pages, function (i, e) {
            e.saveXaml();
        });
        _self._showExportBookScanPanel(parmDom,_pageProvider.bookObj);
    }

    ExportRes.prototype._initExportBookScanPanel = function(){
        var exportBookResContent = $(document.getElementById('template_res_export_panel').innerHTML);

        LAN.translateObj(exportBookResContent);
        //语言翻译
        if(AppCfg.lang == "uyghur"){
            exportBookResContent.find(".pop_seltext").css("direction","rtl");
            exportBookResContent.find(".pop_seltext font").css("padding","0 10px 0 0");
            exportBookResContent.find(".pop_btn input").css("width","100px");
        }
        //显示上传至教研平台  -----  已经废弃，不知道教研平台还存不存在  by yczhu
        if (!AppCfg.showJiaoYan) {
            exportBookResContent.find("#chek_upload").prop("checked", false);
            exportBookResContent.find("#chek_upload_item").hide();
        }
        //显示上传至教研云
        if (!AppCfg.showCloud) {
            exportBookResContent.find("#chek_cloud_upload").prop("checked", false);
            exportBookResContent.find("#chek_cloud_upload_item").hide();

        }
        if (!AppCfg.showCloud && !AppCfg.showJiaoYan) {
            exportBookResContent.find("#chek_export").prop("checked", true).attr("disabled", true);
            exportBookResContent.find("#export_upload_title").html(AppImportAndExportTips.ExportTitle);
            exportBookResContent.find("#export_upload_content_tips").html(AppImportAndExportTips.ExportContentTips);
            exportBookResContent.find("#export_upload_file_tips").html(AppImportAndExportTips.ExportFileTips);
        }

        if(ebookContext.getUser().getName() == AppCfg.defaultuser){
            exportBookResContent.find("#chek_cloud_upload_item").css("color","#999").find("#chek_cloud_upload").attr("disabled","disabled");
        }

        var bookMenu = _pageProvider.bookMenu;
        var dir = '<ul>';
        var templateCheck = '<input style="margin: 0px 5px 0px 0px;float: left" type="checkbox" data-pageindex={0} data-pageindexend={1} data-unitcode={2} data-coursecode={3}>';
        var templateTitle = '<div class="text" style="float:left">{0}</div>';
        var templatePageCode = '<div class="page" style="float: right" data-pageindex={0} data-pageindexend={1} data-unitcode={2} data-coursecode={3}>{4}</div><div class="clear"></div>';
        for (var i = 0; i < bookMenu.length; i++) {
            var itemUnit = '<li class="unit" >';
            if (bookMenu[i].pageIndex == '-1') {
                itemUnit += templateCheck.format(bookMenu[i + 1].pageIndex, bookMenu[i + 1].pageIndex, bookMenu[i].unitCode, "-1");
            } else {
                itemUnit += templateCheck.format(bookMenu[i].pageIndex, bookMenu[i].pageIndexEnd, bookMenu[i].unitCode, "-1");
            }
            itemUnit += templateTitle.format(bookMenu[i].title);
            if (bookMenu[i].pageIndex == '-1') {
                itemUnit += templatePageCode.format(bookMenu[i + 1].pageIndex, bookMenu[i + 1].pageIndex, bookMenu[i].unitCode, "-1", bookMenu[i].pageCode);
            } else {
                itemUnit += templatePageCode.format(bookMenu[i].pageIndex, bookMenu[i].pageIndexEnd, bookMenu[i].unitCode, "-1", bookMenu[i].pageCode);
            }
            dir += itemUnit;
            if (bookMenu[i].courses) {
                var courses = $.makeArray(bookMenu[i].courses);
                if (courses.length > 0) {
                    dir += '<ul class="course">';
                    for (var k = 0; k < courses.length; ++k) {
                        var pageIndex = parseInt(courses[k].ImageIndex);
                        var pageIndexEnd = parseInt(courses[k].PageCodeEnd) - parseInt(courses[k].PageCode) + pageIndex;
                        var itemCourse = '<li class="unit">';
                        itemCourse += templateCheck.format(pageIndex, pageIndexEnd, bookMenu[i].unitCode, courses[k].Code);
                        itemCourse += templateTitle.format(courses[k].Name);
                        itemCourse += templatePageCode.format(pageIndex, pageIndexEnd, bookMenu[i].unitCode, courses[k].Code, courses[k].PageCode);
                        itemCourse += '</li>'
                        dir += itemCourse;
                    }
                    dir += '</ul>';
                }
            }
            dir += '</li>';
        }
        dir += '</ul>';
        var $directory = exportBookResContent.find(".sel");
        $directory.html(dir);

        $("body").append(exportBookResContent);
        var exportPanel = exportBookResContent.find("#exportPanel");
        exportPanel.css({  //设置位置
            position: 'absolute',
            left: ($(window).width() - exportPanel.outerWidth()) / 2,
            top: ($(window).height() - exportPanel.outerHeight()) / 2 + $(document).scrollTop()
        });
        exportPanel.draggable({               //设置可拖动
            containment: "body",
            handle: ".pop_top"
        });
        return exportBookResContent;
    }

    ExportRes.prototype._exportTebkFile = function (argsJson, defer) {
        shellcmd.isDirExist(argsJson.rootdir).done(function (ret) {
            if (ret) {
                showLoading({tips: AppTips.HandlingTips});
                console.log("导出文件为：" + JSON.stringify(argsJson));
                shellcmd.resExport(JSON.stringify(argsJson)).done(function (ret) {
                    var tips;
                    if (ret == 'true')   tips = AppImportAndExportTips.ExportSuccess;
                    else if (ret == 'empty') tips = AppImportAndExportTips.ExportChapterInvalid;
                    else {
                        tips = AppImportAndExportTips.ExportFailed;
                        var filePath = argsJson.exportpos + '/' + argsJson.name + '.mtbk';
                        shellcmd.deleteFile(filePath);
                    }
                    addTipDialog(tips);
                    hideLoading();
                    defer.resolve();
                });
            }
            else {
                addTipDialog(AppImportAndExportTips.ExportDirInvalid);
                defer.resolve();
            }
        });
    }

    ExportRes.prototype._uploadTekbFile = function (argsJson, uploadUrls) {
        //保证每个上传进程间隔一定时间
        var doMtbkUpload=function(filePath,url,delay){
            setTimeout(function(){
                shellcmd.uplaodByDll(filePath,encodeURI(url));
            },delay);

        } ;
        var chapters = argsJson.chapters;
        console.log("上传文件为:", JSON.stringify(argsJson));
        shellcmd.chaptersExport(JSON.stringify(argsJson)).done(function (ret) {
            console.log("resUpload result: " + ret);
            if (ret == 'true') {
                for (var u in uploadUrls) {
                    //暂且将多平台去除，只支持一个平台
                    for (var i in chapters) {
                        var filePath = argsJson.exportpos + "/" + chapters[i].name + ".mtbk";
//                        var param = {
//                            uploadurl: uploadUrls[u],
//                            filepath: filePath,
//                            id: commonfunc.newGuid(),
//                            filename: chapters[i].name + ".mtbk",
////                            filename: chapters[i].name,//新接口没有后缀名
//                            account: AppCfg.defaultuser ? AppCfg.defaultuser : ebookContext.getUser().getName(),
//                            bookcode: argsJson.bookcode,
//                            unit: chapters[i].unit,
//                            restype:"1405",
//                            ressource:'UGC',
//                            course: chapters[i].course ? chapters[i].course : "-1",
//                            token: ebookContext.getUser().getTicket(),
//                            access_token : ebookContext.getUser().getDynamicToken(),
//                            reservedata:""
//                        };

                        var param = {
//                            uploadurl: uploadUrls[u],
//                            filepath: filePath,
                            filename: chapters[i].name + ".mtbk",
//                            account: AppCfg.defaultuser ? AppCfg.defaultuser : ebookContext.getUser().getName(),
                            bookcode: argsJson.bookcode,
                            unit: chapters[i].unit,
                            course: chapters[i].course

                        };
                        var uploadUrl = AppRemoteSvcCfg.uploadMTBK.
                            format(ebookContext.getUser().getUid(),"yun_mtbk",param.filename,param.bookcode,param.unit,param.course);

                        uploadUrl +=  "&access_token=" + ebookContext.getUser().getDynamicToken();
                        var delay= (parseInt(i))*(parseInt(u)+1)*3000 ;
                        doMtbkUpload(filePath,uploadUrl,delay);
                    }
                }
            } else if (ret == 'empty') {
                addTipDialog(AppImportAndExportTips.ExportChapterInvalid);
            }
        });
    }

    ExportRes.prototype._bindExportBookResCommands = function (parmDom) {
        var _self = this;

        if (!parmDom) return;

        //取消按钮
        parmDom.btnCancel.click(function (event) {
            parmDom.content.remove();
            event.stopPropagation();
        });

        //关闭按钮
        parmDom.btnClose.click(function () {
            parmDom.content.remove();
            event.stopPropagation();
        });


        var $checkboxs = parmDom.divSelectBox.find(":checkbox");

        parmDom.btnSelectAll.click(function () {            //全选按钮

            if ($(this).prop("checked")) {
                $checkboxs.prop("checked", true); // 不要用attr
                $checkboxs.parents("ul.course:first").css("opacity", 1);
                parmDom.divSelectBox.css("opacity", 0.7);
                $checkboxs.attr("disabled", true);
            }
            else {
                $checkboxs.attr("disabled", false);
                $checkboxs.prop("checked", false);
                parmDom.divSelectBox.css("opacity", 1);
                parmDom.divSelectBox.find(".course").css("opacity", 1);
            }
            event.stopPropagation();
        });

        parmDom.divSelectBox.on('click', function (e) {

            var target = e.target || e.srcElement;
            if (target.type === "checkbox") {
                target = $(target);
                var parentEle = target.parent();

                var siblingCheckboxs = parentEle.siblings().find("input:checkbox");
                var childrenCheckboxs = target.siblings().find("input:checkbox");
                siblingCheckboxs = $.merge(siblingCheckboxs, target);
                if (target.prop("checked")) {
                    childrenCheckboxs.prop("checked", true);
                    childrenCheckboxs.attr("disabled", true);

                    parentEle.find("ul.course:first").css("opacity", 0.7);
                    if (!siblingCheckboxs.not(":checked").length) {
                        var prev = parentEle.parents("li.unit:first");
                        if (prev.length) {
                            var parentCheckbox = prev.find(">:checkbox:first");
                            parentCheckbox.trigger('click');
                        }
                        else  parmDom.btnSelectAll.trigger('click');
                    }
                }
                else {
                    childrenCheckboxs.attr("disabled", false);
                    childrenCheckboxs.prop("checked", false);
                    parentEle.find("ul").css("opacity", 1);
                }
            }
            e.stopPropagation();
        });

        var _pageViewType = _self.getPageViewType();
        var isDoublePage = _pageViewType === _define.PageViewType.SimpleDoublePage || _pageViewType === _define.PageViewType.TurnJsDoublePage;
        var singleHeight;
        var prepareCheckbox, hasSelect = false;
        $.each($checkboxs, function (i, e) {
            var element = $(e);
            var pageIndex = parseInt(element.attr("data-pageindex"));
            var pageIndexEnd = parseInt(element.attr("data-pageindexend"));
            var currPageIndex = parseInt(_self._container.getPageIndex());
            // console.log(pageIndex + "  " + currPageIndex + "  " + pageIndexEnd);
            var pages = [pageIndex, pageIndexEnd];
            var isSelect = false;
            if (isDoublePage) {
                if ((currPageIndex >= pages[0] && currPageIndex <= pages[1]) || (currPageIndex + 1 >= pages[0] && currPageIndex + 1 <= pages[1])) {
                    isSelect = true;
                }
            } else if (currPageIndex >= pages[0] && currPageIndex <= pages[1]) {
                isSelect = true;
            }

            if (isSelect) {

                //判断下面是否有课时，如果有暂时不选中,因为下面的课时中可能有页码符合条件
                if (!element.siblings().find("input:checkbox").length) {
                    if (!singleHeight) singleHeight = parseInt(element.parent().outerHeight());
                    parmDom.divSelectBox[0].scrollTop = i * (singleHeight + 5);
                    element.trigger('click');
                    hasSelect = true;
                }
                else prepareCheckbox = element;
            }
        });
        //下面的课时中没有有页码符合条件
        if (!hasSelect && prepareCheckbox) {
            prepareCheckbox.trigger('click');
        }
    }

    ExportRes.prototype._showExportBookScanPanel = function (parmDom, bookObj) {
        var _self = this;
        if (!parmDom || !bookObj) return;

        parmDom.btnSubmit.click(function (event) {        //提交按钮
            var isSelectChapter = false;
            var argsJson = {
                exportpos: null,
                name: null,
                rootdir: path.trimPosix(_pageProvider.getUserBookBaseDir()),
                bookcode: bookObj.IndexInfo.Code,
                folders: []
            };
            var nowDate = new Date();
            var dateStamp = "" + nowDate.getFullYear() + (nowDate.getMonth() + 1) + nowDate.getDate() + nowDate.getHours() + nowDate.getMinutes();

            var index = 0, num = 0, selectUnits = [];
            var $checkboxs = $.makeArray(parmDom.divSelectBox.find(":checkbox"));
            $.each($checkboxs, function (i, e) {
                var element = $(e);
                if (element.prop("checked")) {
                    isSelectChapter = true;
                    var pageIndex = parseInt(element.attr("data-pageindex"));
                    var pageIndexEnd = parseInt(element.attr("data-pageindexend"));
                    var pages = [pageIndex, pageIndexEnd];
                    var name = element.siblings(".text").text().replace(/[\/\\":<>\?\*]/g, "_").replace(/_+/g, '_');
                    selectUnits[num++] = {
                        unitCode: element.attr("data-unitcode"),
                        courseCode: element.attr("data-coursecode"),
                        name: name + "_" + dateStamp,
                        page: pages
                    };
                    //拼接导出或上传的页码范围
                    var start = pages[0], end = pages[1];
                    if (index > 0 && (argsJson.folders[index - 1] - start) >= 0) return;
                    do {
                        argsJson.folders[index++] = "" + start;
                        ++start;
                    } while (end && start <= end)
                }
            });

            var isExportChecked = parmDom.chek_export.prop("checked");
            var isUploadChecked = parmDom.chek_upload.prop("checked");
            var isCloudUploadChecked = parmDom.chek_cloud_upload.prop("checked");

            if (!isSelectChapter) addTipDialog(AppImportAndExportTips.ExportSelectChapter);
            else if (!isExportChecked && !isUploadChecked && !isCloudUploadChecked) addTipDialog(AppImportAndExportTips.ExportWaysFailed);
            else {
                var fileName = "授课文件-" + bookObj.IndexInfo.Title + dateStamp;
                if (!ebookContext.getUser().getIsOnline() && (isUploadChecked || isCloudUploadChecked)) {
                    if (isExportChecked) {
                        $.Zebra_Dialog(AppTips.CanExportNotUploadMsg, {
                            'type': 'question',
                            'title': AppTips.WarmTips,
                            'buttons': [AppTips.CancelTips, AppTips.OkTips],
                            'onClose': function (capition) {
                                if (capition == AppTips.OkTips) {
                                    if (isExportChecked) { //选择导出本地
                                        _self._showExportDialog(fileName, argsJson, parmDom);
                                    }
                                }
                            }
                        });
                    }
                    else {
                        $.Zebra_Dialog(AppTips.CanNotUploadMsg, {
                            'type': 'information',
                            'title': AppTips.WarmTips,
                            'buttons': [AppTips.OkTips],
                            'onClose': function (capition) {
                                if (capition == AppTips.OkTips) {

                                }
                            }
                        });
                    }
                } else {
                    //选择导出本地,同时导出和上传好像有点问题，所以如果两者同时选中，先导出到本地在上传
                    var defer = $.Deferred();
                    if (isExportChecked) {
                        _self._showExportDialog(fileName, argsJson, parmDom, defer);
                    }
                    else defer.resolve();


                    //选择上传至区域平台
                    if (isUploadChecked || isCloudUploadChecked) {
                        var uploadArgsJson = {
                            exportpos: ebookContext.getSysTmpPath(),//path.trimPosix(path.join(Config.binPath, "temp")),
                            bookcode: bookObj.IndexInfo.Code,
                            rootdir: path.trimPosix(_pageProvider.getUserBookBaseDir()),
                            chapters: []
                        };
                        var j = 0, lastStartCode = 0 , lastEndCode = 0;
                        for (var i = 0, len = selectUnits.length; i < len; ++i) {
                            //单元内课时与课时之前的页数放到下一个课时内进行打包
                            if (selectUnits[i].courseCode != "-1") {
                                if (i + 1 < len && selectUnits[i + 1].courseCode != "-1" && selectUnits[i].unitCode === selectUnits[i + 1].unitCode) {
                                    selectUnits[i].page[1] = selectUnits[i + 1].page[0] - 1;
                                } else if (lastEndCode) {
                                    selectUnits[i].page[1] = lastEndCode;
                                    lastEndCode = 0;
                                }
                            }
                            if (selectUnits[i].page[0] > selectUnits[i].page[1])
                                continue;
                            //打包成课时
                            if (selectUnits[i].courseCode != "-1") {
                                //修正该课时的起始页
                                if (lastStartCode) selectUnits[i].page[0] = lastStartCode;
                                lastStartCode = 0;
                            } else {  //打包成单元
                                //如果该单元包含课时，那么它会和第一个课时一起打包，先标记该单元的起始页
                                if (i + 1 < len && selectUnits[i + 1].courseCode != "-1" && selectUnits[i].unitCode === selectUnits[i + 1].unitCode) {
                                    lastStartCode = selectUnits[i].page[0];
                                    lastEndCode = selectUnits[i].page[1];
                                    continue;
                                }
                                else  lastStartCode = 0;
                            }
                            uploadArgsJson.chapters[j++] = {
                                //非法字符都替换成_
                                name: selectUnits[i].name,
                                page: (function (i) {
                                    var end = selectUnits[i].page.length > 1 ? selectUnits[i].page[1] : selectUnits[i].page[0];
                                    var start = selectUnits[i].page[0];
                                    var str = "";
                                    while (start <= end) {
                                        str += start++;
                                        if (start <= end) str += "|";
                                    }
                                    return str;
                                })(i),
                                unit: selectUnits[i].unitCode,
                                course: selectUnits[i].courseCode
                            };
                        }
                        //显示上传提示信息
                        _taskQueue.clearTask();

                        var uploadUrls = [];


                        if(isCloudUploadChecked){
                            uploadUrls.push(AppRemoteSvcCfg.uploadMTBK);

//                            for(var i= 0,len = uploadArgsJson.chapters.length; i < len; i+=1){
//                                var fileName = uploadArgsJson.chapters[i].name;
//                                var url =  AppRemoteSvcCfg.uploadMTBK.format(ebookContext.getUser().getUid(),"yun_mtbk",fileName) +
//                                    "&access_token=" + ebookContext.getUser().getDynamicToken();
//                                console.log(url);
//                                uploadUrls.push(url);
//                            }

                            _taskQueue.doTask({time: 3000, status: "start", msg: AppUploadTips.UploadToCloudMsg});
                        }

                        defer.done(function () {
                            _self._uploadTekbFile(uploadArgsJson, uploadUrls);
                        });

                        parmDom.btnCancel.trigger("click");
                    }
                }
            }
            event.stopPropagation();
        });
    }

    ExportRes.prototype._showExportDialog = function (fileName, argsJson, parmDom, defer) {
        var _self = this;
        var _fileExt = path.extname(fileName);
        if (_fileExt != ".mtbk")
            fileName += ".mtbk";
        shellcmd.saveFileDialog(fileName, ".mtbk").done(function (ret) {
            var pathRes = "";
            if (ret && ret.length > 0) {
                pathRes = ret[0];
            }
            else return;
            pathRes = pathRes.replace(/\\/g, "\/");
            if (path.extname(pathRes) != ".mtbk") {
                pathRes += ".mtbk";
                shellcmd.isFileExist(pathRes).done(function (ret) {
                    if (ret) {
                        addTipDialog(AppImportAndExportTips.ExportPathRepeat, [AppTips.CancelTips, AppTips.OkTips], function (capition) {
                            if (capition == AppTips.OkTips) {
                                var index = pathRes.lastIndexOf('/');
                                var title = pathRes.substring(index + 1, pathRes.lastIndexOf('.')).trim();
                                var dir = pathRes.substring(0, index).trim();
                                argsJson.exportpos = path.toPosix(dir);
                                argsJson.name = title;
                                _self._exportTebkFile(argsJson, defer);
                                parmDom.btnCancel.trigger("click");
                            }
                        });
                    }
                    else {
                        var index = pathRes.lastIndexOf('/');
                        var title = pathRes.substring(index + 1, pathRes.lastIndexOf('.')).trim();
                        var dir = pathRes.substring(0, index).trim();
                        argsJson.exportpos = path.toPosix(dir);
                        argsJson.name = title;
                        _self._exportTebkFile(argsJson, defer);
                        parmDom.btnCancel.trigger("click");
                    }
                })
            }
            else {
                var index = pathRes.lastIndexOf('/');
                var title = pathRes.substring(index + 1, pathRes.lastIndexOf('.')).trim();
                var dir = pathRes.substring(0, index).trim();
                argsJson.exportpos = path.toPosix(dir);
                argsJson.name = title;
                _self._exportTebkFile(argsJson, defer);
                parmDom.btnCancel.trigger("click");
            }
        });
    }

    function addTipDialog(tips, buttons, callback) {
        if (!tips) return;
        $.Zebra_Dialog(tips, {
            'type': 'information',
            'title': AppTips.WarmTips,
            'buttons': buttons == undefined ? [AppTips.OkTips] : buttons,
            'onClose': function (caption) {
                if (typeof callback === 'function') callback(caption);
            }
        });
    }

    ExportRes.prototype.onMessageReceived = function(obj){
//        console.log("exportmtbk received callback")
            console.log(obj.evt);
            console.log(obj.type);
            console.log( obj.data);
    }

    exports.Instance = new ExportRes();
});
