/**
 * Created with JetBrains WebStorm.
 * User: feiqian
 * Date: 13-12-18
 * Time: 上午10:40
 * To change this template use File | Settings | File Templates.
 */
define(function (require, exports, module) {
    var Player = require('./player');
    var EventUtil = require('../../../common/eventUtil');
    var define = require('../../define');
    //不同播放器的管理类
    function PlayerMgr() {
        this._playerList = [];//不同的播放器
        this._currPlayer = null;
        this._isPlay = false;
    }

    PlayerMgr.prototype = new EventUtil();
    PlayerMgr.constructor = PlayerMgr;

    (function (methods) {
        for (var i = 0, len = methods.length; i < len; ++i) {
            var method = methods[i];
            PlayerMgr.prototype[method] = (function (method) {
                /**
                 * @param {enum=} playerType  要操作的全局播放器的类型
                 * */
                return function (playerType) {
                    if (!this._currPlayer || !this._currPlayer[method] || (playerType && this._currPlayer.PlayerType !== playerType)) return;
                    this._currPlayer[method]();
                }
            })(method)
        }
    })(['stop', 'pause', 'resume']);

    /**
     * 创建不同播放器
     * @param playerType
     * @returns {*}
     */
    PlayerMgr.prototype.createPlayer = function (playerType) {
        var players = this._playerList[playerType];
        var player;
        if (!players || !players._isSingleton) {
            switch (playerType) {
                case define.PlayerType.HotspotPlayer:
                    player = new Player.HotspotPlayer();
                    player.PlayerType = define.PlayerType.HotspotPlayer;
                    this._playerList[playerType] = [];
                    //当前播放器类型是单例的
                    this._playerList[playerType]._isSingleton = true;
                    break;
                case define.PlayerType.AudioPlayer:
                    player = new Player.AudioPlayer();
                    player.PlayerType = define.PlayerType.AudioPlayer;
                    this._playerList[playerType] = [];
                    this._playerList[playerType]._isSingleton = true;
                    break;
                case define.PlayerType.VideoPlayer:
                    player = new Player.VideoPlayer();
                    player.PlayerType = define.PlayerType.VideoPlayer;
                    if (!players) {
                        this._playerList[playerType] = [];
                        this._playerList[playerType]._isSingleton = false;
                    }
                    break;
            }
            if (player) {
                this._playerList[playerType].push(player);
                this._wrap(player);
            }
        }
        else player = players[0];
        return player;
    }

    /**
     * 对播放器的播放行为进行包装,便于统一进行一些行为的处理。
     * @param player 定义的player类型至少应含有play，pause，stop，resume四个方法
     * @private
     */
    PlayerMgr.prototype._wrap = function (player) {
        var _self = this;

        var _child_play = player.play;
        player.play = function (id) {
            if (!_self.isPlay(player) || _self._currPlayer.id !== id) {
                if (_self._currPlayer) {
                    var p = _self._playerList[_self._currPlayer.PlayerType];
                    if (p) {
                        p._isSingleton ? _self._currPlayer.stop() : _self._currPlayer.pause();
                    }
                }
                _child_play.apply(player, arguments);
                _self._currPlayer = player;
            }
        };

        var _child_pause = player.pause;
        player.pause = function () {
            if (_self.isPlay(player)) {
                _child_pause.apply(player, arguments);
            }
        };

        var _child_stop = player.stop;
        player.stop = function () {
            if (_self.isPlay(player)) {
                _child_stop.apply(player, arguments);
            }
        }

        var _child_resume = player.resume;
        player.resume = function () {
            !_self.isPlay(player) && _child_resume.apply(player, arguments);
        }

        //监控各个player的事件,并继续抛出事件。如果其他模块要监控各个player的事件，统一通过app_global_playerMgr进行监听就可以了

        player.bind('play.playMgr', function () {
            _self._isPlay = true;
            console.log("%c player playing", "color:blue");
            _self.triggerHandler('play', [player.PlayerType]);
        });

        player.bind('pause.playMgr', function () {
            _self._isPlay = false;
            console.log("%c player pause", "color:blue");
            _self.triggerHandler('pause', [player.PlayerType]);
        });

        player.bind('ended.playMgr', function () {
            if (player === _self._currPlayer) _self._isPlay = false;
            _self.triggerHandler('ended', [player.PlayerType]);
            console.log("%c player ended", "color:blue");
        });
    }

    /**
     * 是否有相关的播放器实例或者某个播放器类型或者有任何播放器在播放
     * @param {string,object=} player
     * @returns {*}
     */
    PlayerMgr.prototype.isPlay = function (player) {
        return this._isPlay && (player === undefined ? true : (typeof  player === 'object' ? player === this._currPlayer : player === this._currPlayer.PlayerType));
    }

    /**
     * 接收事件回调
     * @param msg
     */
    PlayerMgr.prototype.onMessageReceived = function (msg) {

        //console.log('onMessageReceived', msg);
        if (this._currPlayer && this._currPlayer.PlayerType === define.PlayerType.HotspotPlayer) {
            if (msg.evt == 'play_start') {
                this._currPlayer.trigger('play');
            }
            else if (msg.evt == 'play_resume') {
                this._currPlayer.trigger('play');
            }
            else if (msg.evt == 'play_pause') {
                this._currPlayer.trigger('pause');
            }
            else if (msg.evt == 'play_end') {
                this._currPlayer.trigger('ended');
            }
        }
    }

    /**
     * 销毁某个播放器或者全部播放器实例
     * @param {object=} player
     */
    PlayerMgr.prototype.destroy = function (player) {
        if (this._playerList) {
            for (var i = 0, len = this._playerList.length; i < len; ++i) {
                var players = this._playerList[i];
                if (players) {
                    for (var j = 0, length = players.length; j < length; ++j) {
                        var value = players[j];
                        if (value) {
                            if (player === undefined) {
                                value.eventUtilDestroy();
                            }
                            else if (player === value) {
                                players.splice(j, 1);
                                if (!players.length) {
                                    player.eventUtilDestroy();
                                    this._playerList[i] = null;
                                }
                                return;
                            }
                        }
                    }
                }
            }
            if (!player) {
                this.stop();
                this._playerList = null;
                this._currPlayer = null;
            }
        }
    }


    exports.Instance = new PlayerMgr();
})