/**
 * Created with JetBrains WebStorm.
 * User: feiqian
 * Date: 13-12-18
 * Time: 上午8:49
 * To change this template use File | Settings | File Templates.
 */
define(function (require, exports) {
    var path = require('../../../common/path');
    var shellcmd = require('../../../common/shellcmd');
    var EventUtil = require('../../../common/eventUtil');
    var define = require('../../define');
    var videoControl = require('videoControl');

    //热区播放器
    function HotspotPlayer() {
        this.id = null;
        this._isEnd = true;
        this.flshPlayer = null;
    }

    HotspotPlayer.prototype = new EventUtil();
    HotspotPlayer.constructor = HotspotPlayer;

    HotspotPlayer.prototype.init = function (pageProvider) {
        this._provider = pageProvider;
        var _self = this;
        this.bind('ended', function () {
            _self._isEnd = true;
        });
        this.bind('play', function () {
            _self._isEnd = false;
        });
        this.bind('pause', function () {
            _self._isEnd = false;
        })
    }

    HotspotPlayer.prototype.play = function (audioId, languageType) {
        var lan = languageType;
        var _self = this;
        this._getAudioSrc(audioId, lan).done(function (ret) {
            if (ret) {
                _self.id = ret;
                (!_self.flshPlayer) && (_self.flshPlayer = niftyplayer('niftyPlayer1'));
                _self.flshPlayer && _self.flshPlayer.loadAndPlay(ret);

                _self.flshPlayer.registerEvent('onSongOver','endHostPlay()');

                _self.triggerHandler('play');

//                setTimeout(function () {
//                    _self.id = ret;
//                    shellcmd.sndPlay(ret);
//                    _self.triggerHandler('play');
//                }, 0);
            }
        });
    }

    HotspotPlayer.prototype._getAudioSrc = function (audioId, lan) {
        var def = $.Deferred();
        this._provider.getAudioPath(audioId, lan).done(function (audio) {
            def.resolve(audio);
        });
        return def.promise();
    }

    HotspotPlayer.prototype.stop = function () {
        this.flshPlayer && this.flshPlayer.stop();

     //   shellcmd.sndStop();
        this.triggerHandler('ended');
    }

    HotspotPlayer.prototype.pause = function () {
        this.flshPlayer && this.flshPlayer.pause();

     //   shellcmd.sndPause();
        this.triggerHandler('pause');
    }

    HotspotPlayer.prototype.resume = function () {
        //这步由flash组件解决
        (this.flshPlayer && this.flshPlayer.play(this.id));
      //  (this._isEnd) ? (shellcmd.sndPlay(this.id)) : (shellcmd.sndResume());
        this.triggerHandler('play');
    }

    //播放器基类
    function PlayerBase() {
        this.src = null;
        this._host = null;
        //这个Id是当前播放的widget的Id
        this.id = null;
        this.currPlayTime = null;
    }

    PlayerBase.prototype._bindCommands = function () {
        var _self = this;
        if (this._host) {
            this._host.unbind('.playerBase');

            this._host.bind('play.playerBase', function () {
                _self.triggerHandler($('#' + _self.id), 'play');
            });

            this._host.bind('pause.playerBase', function () {
                _self.currPlayTime = _self._host[0].currentTime || 0;
                _self.triggerHandler($('#' + _self.id), 'pause');
            });

            this._host.bind('ended.playerBase', function () {
                _self.currPlayTime = 0;
                _self.triggerHandler($('#' + _self.id), 'ended');
            });

            this._host.bind('remove.playerBase', function () {
                _self.triggerHandler($('#' + _self.id), 'ended');
                _self.releaseRes();
            });

            this._host.bind('canplay', function () {
                if (_self.currPlayTime) _self._host[0].currentTime = _self.currPlayTime;
            })
        }
    }

    PlayerBase.prototype._bindError = function () {
        var _self = this;
        this._host.unbind('error').bind('error', function (e) {
            var mediaError = e.target.error;
            if (mediaError.code === mediaError.MEDIA_ERR_DECODE || mediaError.code === mediaError.MEDIA_ERR_SRC_NOT_SUPPORTED) {
                $.Zebra_Dialog(_self.PlayerType === define.PlayerType.AudioPlayer ? AppTips.AudioPlayFailed : AppTips.VideoPlayFailed, {
                    'type': 'information',
                    'title': AppTips.WarmTips,
                    'buttons': [AppTips.CancelTips, AppTips.OkTips],
                    'zIndex': 600,
                    'forceClosePrev': true,
                    'onClose': function (capition) {
                        _self.triggerHandler($('#' + _self.id), 'play_error', [capition === AppTips.OkTips]);
                        _self.stop();
                        _self.releaseRes();
                    }
                });
            }
            console.log(mediaError.code);
            e.stopPropagation();
        });
    }

    PlayerBase.prototype.stop = function () {
        if (this._host) {
            this._host[0].currentTime && (this._host[0].currentTime = 0);
            this._host[0].pause();
            this._host.triggerHandler('remove.playerBase');
            //触发强行被停止播放事件
            this.triggerHandler('play_remove');
        }
    }

    PlayerBase.prototype.pause = function () {
        this._host && this._host[0].pause();
    }

    /**
     *判断是否正在播放
     * @param {string=} src
     * @returns {boolean}
     */
    PlayerBase.prototype.isPlay = function (id) {
        return app_global_playerMgr.isPlay(this) && (id == undefined ? true : this.id === id);
    }

    /**
     * 释放占用的内存
     */
    PlayerBase.prototype.releaseRes = function () {
        if (this._host) {
            this._host.unbind('error');
            this._host.attr('src', ' ');
            this.id = this.src = this.currPlayTime = null;
        }
    }

    PlayerBase.prototype.setTempNewPlayer = function () {
        this._backup();
        this.init.apply(this, arguments);
        var _self = this;
        this._host.on('remove', function () {
            _self._restore();
            event.stopPropagation();
        });
    }

    PlayerBase.prototype.getCurrPlayTime = function () {
        return !this._host ? 0 : this._host[0].currentTime;
    }

    PlayerBase.prototype.resume = function () {
        this.play(this.id, this.src);
    }

    //音频播放器，对html5 audio进行包装
    function AudioPlayer() {

    }

    AudioPlayer.prototype = $.extend(new EventUtil(), new PlayerBase());
    AudioPlayer.constructor = AudioPlayer;

    AudioPlayer.prototype._backup = function () {
        this._oldHost = this._host;
        this._oldSrc = this.src;
        this._oldId = this.id;
    }

    AudioPlayer.prototype._restore = function () {
        this._oldSrc && (this.src = this._oldSrc);
        this.id = this._oldId;
        this.init(this._oldHost);
        this._oldHost = this._oldId = this._oldSrc = null;
    }

    AudioPlayer.prototype.init = function (host) {
        this._host = host;
        this._bindCommands();
    }

    AudioPlayer.prototype.play = function (id, src) {
        if (!this._host) return;
        if (document.getElementById(id) && src) {
            var _self = this;
            //延迟播放,否则之前的stop方法触发的事件会被下面的play方法覆盖掉
//            setTimeout(function () {
//                if (_self.id !== id || _self._host.attr('src') !== src) {
//                    _self.src = src;
//                    _self.id = id;
//                    _self._host.attr('src', src);
//                    _self._bindError();
//                }
//                _self._host[0].play();
//            },0);

                if (_self.id !== id || _self._host.attr('src') !== src) {
                    _self.src = src;
                    _self.id = id;
                    _self._host.attr('src', src);
                    _self._bindError();
                }
            setTimeout(function () {
                _self._host[0].play();
            },100);
        }
    }

    AudioPlayer.prototype.destroy = function () {
        app_global_playerMgr.destroy(this);
        this.releaseRes();
        this._host = null;
    }

    //视频播放，对html5 video进行包装
    function VideoPlayer() {

    }

    VideoPlayer.prototype = $.extend(new EventUtil(), new PlayerBase());
    VideoPlayer.constructor = VideoPlayer;

    VideoPlayer.prototype.init = function (content) {
        this._content = content;
        this._host = this._content.find("video:first");

        this._bindCommands();
        var _self = this;
        this._host.bind('video_play', function () {
            _self.resume();
        });
    }

    /**
     *
     * @param {!string} id
     * @param {!string} src
     * @param {object=} options
     */
    VideoPlayer.prototype.play = function (id, src, options) {
        if (!this._host) return;

        if (id && src) {
            var _self = this;
            setTimeout(function () {
                if (_self.id !== id || _self._host.attr('src') !== src) {
                    _self.id = id;
                    _self.src = src;

                    options = options || {};
                    var bound;
                    if ((bound = options.bound)) {
                        _self._content.css({"left": bound.left, "top": bound.top});
                        _self._host.css({"width": bound.width, "height": bound.height});
                    }
                    _self.currPlayTime = options.currentTime;
                    _self._host.attr('src', src);
                    _self._bindError();
                    //设置视频控制条
                    try {
                        videoControl(_self._content, options.container);
                    } catch (e) {
                        console.error(e.message);
                    }
                }
                else _self._host[0].play();
            }, 0);
        }
    }

    VideoPlayer.prototype.destroy = function () {
        if (this._content) {
            app_global_playerMgr.destroy(this);
            this.releaseRes();
            this._content = this._host = null;
        }
    }

    VideoPlayer.prototype._backup = function () {
        this._oldContent = this._content;
        this._oldHost = this._host;
    }

    VideoPlayer.prototype._restore = function () {
        this.init(this._oldContent);
    }

    exports.HotspotPlayer = HotspotPlayer;
    exports.AudioPlayer = AudioPlayer;
    exports.VideoPlayer = VideoPlayer;
})
