/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 13-12-2
 * Time: 上午8:18
 * To change this template use File | Settings | File Templates.
 */
define(function (require, exports, module) {
    var _define=require('../define');
    var _shellcmd = require('../../common/shellcmd');
    var path = require('../../common/path');

    function CurtainMgr() {
        var _self = this;
        _self.buttons = {};
        _self.controls = {};
        _self._bookContainer=null;
        _self.openaction = true;

        //颜色幕布大小
        _self.width = 160;
        _self.height = 160;
        //图片幕布大小
        _self.imgHeight = 160;
        _self.imgWidth = 160;

        _self.top = ($(window).height() - 192)/2;
        _self.left = ($(window).width() - 256)/2;


        _self.isShow = false;

        _self.nowMaxZIndex = "";

        _self.init = function (buttons, controls,bookContainer) {
            _self.buttons = buttons;
            _self.controls = controls;
            _self._bookContainer = bookContainer;
            _self.buttons.colors = [];
            _self.controls.templateCurtain.appendTo("body");
            _self.controls.mainPanel = _self.controls.templateCurtain.find("#mainCurtainPanel");
            _self.buttons.closeMainCurtain = _self.controls.mainPanel.find("#closeMainCurtain");
            _self.controls.curtainColor = _self.controls.mainPanel.find("#curtainColor");
            _self.controls.curtainPic = _self.controls.mainPanel.find("#curtainPic");
            _self.buttons.pics = _self.controls.curtainPic.find("dd");
            _self.buttons.colors = _self.controls.curtainColor.find("dd");
            _self.buttons.btnUserPanel = _self.controls.mainPanel.find("#btnUserPanel");

            _self.controls.userPanel = _self.controls.templateCurtain.find("#userCurtainPanel");
            _self.buttons.closeUserCurtain = _self.controls.userPanel.find("#closeUserCurtain");
            _self.buttons.btnMainPanel = _self.controls.userPanel.find("#btnMainPanel");
            _self.controls.selectedImg = _self.controls.userPanel.find("#selectedImg");
            _self.buttons.OKforImg = _self.controls.userPanel.find("#OKforImg");

            LAN.translateObj(_self.controls.userPanel);

            LAN.translateObj(_self.controls.mainPanel);

            //smartbar
            _self.buttons.smartBarCurtain.click(function () {
                if(!_self.isShow){
                    _self.controls.mainPanel.css("top",_self.top).css("left",_self.left).show();
                }
                else{
                    _self.closeMainCurtainPanel();
                }
            });

            _self.controls.mainPanel.draggable({
                handle: "#mainCurtainTop",
                containment: "window"
            });

            _self.controls.userPanel.draggable({
                handle: "#userCurtainTop",
                containment: "window"
            });

            _self.buttons.closeMainCurtain.click(function () {
                _self.closeMainCurtainPanel();
            });

            ////弹出幕布管理自定义面板
            _self.buttons.btnUserPanel.click(function () {
                _self.closeMainCurtainPanel();
                _self.controls.userPanel.css("top",_self.top).css("left",_self.left).show();
                event.stopPropagation();
            });

            //弹出幕布管理系统面板
            _self.buttons.btnMainPanel.click(function () {
                _self.closeUserCurtainPanel();
                _self.controls.mainPanel.css("top",_self.top).css("left",_self.left).show();
                event.stopPropagation();
            });

            _self.buttons.closeUserCurtain.click(function () {
                _self.closeUserCurtainPanel();
            });

            _self.buttons.colors.click(function () {
                var $hereSelf = $(this);
                _self.addNewCurtain("",$hereSelf.attr("imgurl"), 20, 30,_self.width,_self.height);
            });

            /**
             * 添加图片幕布
             */
            _self.buttons.pics.click(function(){
                var $hereSelf = $(this);
                _self.addNewCurtain("",$hereSelf.attr("imgurl"), 20, 30,_self.imgWidth,_self.imgHeight);
            })

            //弹出操作系统选择图片的对话框
            _self.controls.selectedImg.click(function(){
                var ret = { "multi": false, "ext": [".jpg", ".jpeg",".bmp",".png",".gif"]};
                _shellcmd.openFileDialog(ret).done(function(result){
                    if(result.length>0){
                        //获取图片名称
                        var imgName = result[0].slice(result[0].lastIndexOf('\\')+1);
                        //拼接保存路径
                        var imgRelativePath = path.join("webapp/assert/images/curtains",imgName);
                        var imgSavePath = path.join(path.trimPosix(Config.binPath),imgRelativePath);
                        _shellcmd.copyFile(result[0],imgSavePath).done(function(){
                            _self.controls.selectedImg.attr("src",imgSavePath);
                        })
                    }
                });
            });

            //使用自定义幕布
            _self.buttons.OKforImg.click(function(){
                var newUrl = _self.controls.selectedImg.attr("src");
                var defaultIMG = "assert/images/curtains/" + ( AppCfg.lang == "zhcn" ? "default_img.png":"wy_default_img.png");
                if( newUrl != defaultIMG ){
                    //宽高定为预览框的宽高
                    _self.addNewCurtain("",newUrl, 20, 30,_self.imgWidth,_self.imgHeight);
                }
            });
        }

        _self.closeMainCurtainPanel = function () {
            _self.controls.mainPanel.hide();
        }

        _self.closeUserCurtainPanel = function () {
            _self.controls.userPanel.hide();
        }

        //添加新幕布
        _self.addNewCurtain = function (color,imgSrc,x, y,w,h) {
            _self._bookContainer.insertSingleWidget(imgSrc, _define.WidgetType.FadeCurtain,"",{
                style:"color:#"+color,
                initLeft:x,
                initTop:y,
                width:w,
                height:h
            });
            _self.closeMainCurtainPanel();
            _self.closeUserCurtainPanel();
        }
    }

    exports.Instance = new CurtainMgr();
});

