/**
 * Created with JetBrains WebStorm.
 * User: yczhu
 * Date: 14-7-8
 * Time: 下午7:07
 * To change this template use File | Settings | File Templates.
 */
;
/**
 * Idea : 因为白板视图下要求笔迹可以保存，又要求笔迹可以识别
 * 故用单页试图继承实现比较方便容易
 *
 * 但单页视图在实现上用了大量的内部私有变量，暂时没有时间改造为继承的样子。
 * 先仿之以实现功能，优化代码维护的时候可以考虑改写。
 *
 * Caution :
 * 虽然笔记识别是白板视图的一部分，但是，这部分代码并不在这里。
 * 单击的启动入口在canvasmgr.js里面
 * 主要代码在strokeResult.js里面
 *
 *                ---------------- by yczhu
 */
define(function (require, exports) {

    var define = require('../../define');
    var model = require('../../model');
    var BookViewBase = require("./bookviewbase").BookViewBase;

    function WhiteBoardView(container, pageProvider) {
        var _self = this;
        _self._isEditing = false;
        _self.WBItem = null;
        _self.WBIndex = 1;
        _self.MaxPage = 10;
        //初始化标记
        _self.ready = false;

        _self._pageProvider = pageProvider;
        _self._container = container;
        _self._viewDOM = null;
        _self._WBWrapper = null;
        _self._zoom = null;
        _self._WBCSS = null;

        _self.setMaxPage = function (num) {
            _self.MaxPage = num;
        }

        _self.getMaxPage = function () {
            return _self.MaxPage;
        }

        _self.isNextPageEnable = function () {
            return _self.WBIndex < _self.MaxPage;
        };

        _self.isPreviousPageEnable = function () {
            return _self.WBIndex > 1;
        }

        _self.getPageIndex = function () {
            return _self.WBIndex;
        };

        _self.nextPage = function () {
            _self.isNextPageEnable && _self.setPageIndex(_self.WBIndex + 1);
        };

        _self.previousPage = function () {
            _self.isPreviousPageEnable && _self.setPageIndex(_self.WBIndex - 1);
        };

        //设置页码的返回结果一定是false;
        //否则会改变书本的页码
        _self.setPageIndex = function (newWBIndex) {
            var def = $.Deferred();
            if (newWBIndex === _self.WBIndex && _self.ready) {
                return def.resolve(false);
            }

            (newWBIndex > _self.MaxPage) && ( newWBIndex = _self.MaxPage);
            (newWBIndex <= 0) && ( newWBIndex = 1);

            if (_self.WBIndex !== newWBIndex || !_self.ready) {
                showLoading({tips: AppBlackBoardTipsList.Loading});
                //这里处理翻页
                if (_self.WBItem) {
                    $(_self).trigger('beforePageChange');
                    _self._pageProvider.unloadWBItem(_self.WBIndex);
                    _self.WBItem.getContent().remove();
                }

                var loadtask = _self._pageProvider.loadWBItem(newWBIndex);
                loadtask.done(function (ret) {
                    _self.WBItem = ret;
                    _self.WBItem.getContent().css( _self._WBCSS);


                    if (_self.WBItem) {
                        _self._WBWrapper.append(_self.WBItem.getContent());
                    }

                    _self.unTransFormWidget();

                    _self.WBIndex = newWBIndex;
                    $(_self).trigger('pageChanged');
                    if (_self._isEditing) _self.setIsEditing(_self._isEditing);
                    hideLoading();
                    _self.ready = true;
                    def.resolve(false);
                });
            }
            else return def.resolve(false);
            return def.promise();
        }

        function _init() {
            var imageSize = {
                width : _self._container.width(),
                height: _self._container.height()
            }

            _self._pageProvider.WBImageSize = imageSize;

            var viewWidth = _self._container.width();
            var viewHeight = viewWidth / (imageSize.width / imageSize.height);
            _self._viewDOM = $('<div/>').attr('class', 'viewdom').css({
                'width': viewWidth + 'px',
                'height': viewHeight + 'px',
                'position': 'relative',
                'class': 'viewdom'
            });
            _self._WBWrapper = $('<div/>');
            _self._viewDOM.append(_self._WBWrapper);
            _self._container.append(_self._viewDOM);

            _self._zoom = viewWidth / imageSize.width;
            _self._pageProvider.zoomRate = _self._zoom;
            var zoomCSS = {
                '-webkit-transform': 'scale(' + _self._zoom + ')',
                'position': 'absolute'
            };

            _self._WBCSS = $.extend({
                'left': -imageSize.width * (1 - _self._zoom) / 2 + 'px',
                'top': -imageSize.height * (1 - _self._zoom) / 2 + 'px'
            }, zoomCSS);
        }

        _self.getAnimationPageImgs = function () {
            return [];
        };

        _self.refresh = function () {
            //不使用当前页强制加载
            _self._pageProvider.loadWBItem(_self._WBIndex, true).done(function (ret) {
                _self._WBItem = ret;
                var tmp = _self._WBIndex;
                _self._WBIndex = -1;
                _self.setPageIndex(tmp);
            });
        };

        _self.getViewDOM = function () {
            return _self._viewDOM;
        };

        //这个方法要统一返回数组
        _self.getShowPageItem = function () {
            return _self.WBItem ? [_self.WBItem] : [];
        };

        _self.paintStroke = function (canvas, isStrokeChanged,strokes) {
            var item = _self.getShowPageItem()[0];
            //先做手势合并，然后笔迹分层的时候会处理擦除的问题。
            item.mergeStrokes(strokes);
            item.paintStroke(canvas, new model.Bound(0, 0, canvas.width, canvas.height), isStrokeChanged);
        };

        _self.doEraser = function(l,t,w,h){
            var item = _self.getShowPageItem()[0];
            item.doEraser(l,t,w,h);
        }

        _self.recognition = function(lan){
            _self.getShowPageItem()[0].recognition(lan);
        }

        _self.restoreStroke = function (canvas) {
            //目前这块不做处理。
//            var w = canvas.width;
//            var h = canvas.height;
//            var pageItem = _self.getShowPageItem()[0];
        //    pageItem && pageItem.restoreStroke(canvas, new model.Bound(0, 0, w, h));
        };

        _self.reloadStrokes = function(canvasmgr){
            //不再获取，直接赋值为[]
            var strokes = [];
            canvasmgr.setStrokes(strokes);
            _self.getShowPageItem()[0].getStrokes();
//                .done(function(strokes){
//                //获取不到strokes的时候，设置为[]（翻页时会导致）。
//                strokes = strokes ? strokes : [];
//                canvasmgr.setStrokes(strokes);
//            });
        }

        _self.saveStrokesToLocal = function () {
            _self.getShowPageItem()[0].saveStrokesToLocal();
        }

        _init();
    }

    WhiteBoardView.prototype = new BookViewBase();
    WhiteBoardView.prototype.constructor = WhiteBoardView;

    WhiteBoardView.prototype.isDoublePage = function () {
        return false;
    };

    exports.WhiteBoardView = WhiteBoardView;
});
