/**
 * Created with JetBrains WebStorm.
 * User: Administrator
 * Date: 14-7-5
 * Time: 下午3:19
 * To change this template use File | Settings | File Templates.
 */
;define(function(require,exports){

    require('jqjson');
    require('hammer');
    var model = require('../../model');
    var define = require('../../define');
    var trace = require('../../trace').Instance;
    var actionType = require('../../trace').ActionType;
    var BookViewBase = require("./bookviewbase").BookViewBase;

    /**
     * 简单单页视图
     * @extend  BookViewBase
     */
    function SimpleSinglePageView(container, pageProvider) {
        var _container = container;
        var _pageProvider = pageProvider;
        var _self = this;

        var _viewDOM;
        var _singlePageCSS;
        var _pageIndex = 0;
        var _zoom;

        var _singlePageWrapper;
        var _singlePageItem;

        function _init() {
            var imageSize = _pageProvider.bookImageSize;

            var viewWidth = _container.width();
            var viewHeight = viewWidth / (imageSize.width / imageSize.height);
            _viewDOM = $('<div/>').attr('class', 'viewdom').css({
                'width': viewWidth + 'px',
                'height': viewHeight + 'px',
                'position': 'relative',
                'class': 'viewdom'
            });
            _singlePageWrapper = $('<div/>');
            _viewDOM.append(_singlePageWrapper);

            _container.append(_viewDOM);

            _zoom = viewWidth / imageSize.width;
            _pageProvider.zoomRate = _zoom;
            var zoomCSS = {
                '-webkit-transform': 'scale(' + _zoom + ')',
                'position': 'absolute'
            };

            _singlePageCSS = $.extend({
                'left': -imageSize.width * (1 - _zoom) / 2 + 'px',
                'top': -imageSize.height * (1 - _zoom) / 2 + 'px'
            }, zoomCSS);
        }

        /**
         * @inheritDoc
         */
        this.isNextPageEnable = function () {
            return _pageIndex < _pageProvider.pageCount;
        };

        /**
         * @inheritDoc
         */
        this.nextPage = function () {
            if (_pageIndex < _pageProvider.pageCount) {
                _self.setPageIndex(_pageIndex + 1);
            }
        };

        /**
         * @inheritDoc
         */
        this.isPreviousPageEnable = function () {
            return _pageIndex > 1;
        };

        /**
         * @inheritDoc
         */
        this.previousPage = function () {
            if (_pageIndex > 1) {
                _self.setPageIndex(_pageIndex - 1);
            }
        };

        /**
         *  @inheritDoc
         */
        this.getAnimationPageImgs = function (curIdx, slideToLeft) {
            return [];
        };


        /**
         *  @inheritDoc
         */
        this.refresh = function () {
            var notUseCurrentPageItem = true;
            var loadtask = _pageProvider.loadPageItem(_pageIndex, notUseCurrentPageItem);
            loadtask.done(function (ret) {
                _singlePageItem = ret;
                var tmp = _pageIndex;
                _pageIndex = -1;
                _self.setPageIndex(tmp);
            });

        };

        /**
         *  @inheritDoc
         */
        this.setPageIndex = function (newPageIndex) {

            var def = $.Deferred();

            if (newPageIndex === _pageIndex) {
                return def.resolve(false);
            }
            if (newPageIndex > _pageProvider.pageCount) {
                newPageIndex = _pageProvider.pageCount - 1
            }
            if (newPageIndex <= 0) {
                newPageIndex = 1;
            }
            if (_pageIndex !== newPageIndex) {
                _self.isPageLoading=true;
                showLoading({tips: AppBlackBoardTipsList.Loading});
                if (_singlePageItem) {
                    $(_self).trigger('beforePageChange', {oldIndex: _pageIndex, newIndex: newPageIndex});
                    _pageProvider.unloadPageItem(_singlePageItem.pageIndex);
                    _singlePageItem.getContent().remove();
                }

                var loadtask = _pageProvider.loadPageItem(newPageIndex);
                loadtask.done(function (ret) {
                    _singlePageItem = ret;
                    _singlePageItem.getContent().css(_singlePageCSS);

                    if (_singlePageItem) {
                        _singlePageWrapper.append(_singlePageItem.getContent());
                    }

                    _self.unTransFormWidget();

                    _pageIndex = newPageIndex;
                    $(_self).trigger('pageChanged', {oldIndex: _pageIndex, newIndex: newPageIndex});
                    if (_self._isEditing) _self.setIsEditing(_self._isEditing);
                    trace.log('ebook', actionType.SetPage, {pageIndex: _pageIndex});
                    hideLoading();
                    _self.isPageLoading=false;
                    def.resolve(newPageIndex);
                });
            }
            else return def.resolve(false);
            return def.promise();
        };

        /**
         * @inheritDoc
         */
        this.getPageIndex = function () {
            return _pageIndex;
        };

        /**
         * @inheritDoc
         */
        this.getViewDOM = function () {
            return _viewDOM;
        };

        /**
         * @inheritDoc
         */
        this.getShowPageItem = function () {
            var arr = [];
            if (_singlePageItem)
                arr.push(_singlePageItem);
            return arr;
        };

        /**
         * @inheritDoc
         */
        this.paintStroke = function (canvas, isStrokeChanged) {
            var showPageItems = this.getShowPageItem();
            //console.log(showPageItems);
            var singlePageItem = showPageItems[0];
            singlePageItem.paintStroke(canvas, new model.Bound(0, 0, canvas.width, canvas.height), isStrokeChanged);
        };

        /**
         * 恢复笔迹
         * @param {HTMLCanvasElement} canvas
         */
        this.restoreStroke = function (canvas) {
            var showPageItems = this.getShowPageItem();
            var w = canvas.width;
            var h = canvas.height;
            //console.log('restoreStroke, canvas size:{w:%s, h:%s}', w, h);

            var pageItem = showPageItems[0];
            if (pageItem) {
                pageItem.restoreStroke(canvas, new model.Bound(0, 0, w, h));
            }
        };
        /**
         * 保存笔迹
         */
        this.saveStrokesToLocal = function () {
            var showPageItems = this.getShowPageItem();
            var pageItem = showPageItems[0];
            pageItem.saveStrokesToLocal();
        }

        _init();
    }

    SimpleSinglePageView.prototype = new BookViewBase();
    SimpleSinglePageView.prototype.constructor = SimpleSinglePageView;

    SimpleSinglePageView.prototype.isDoublePage = function () {
        return false;
    };

    exports.SimpleSinglePageView = SimpleSinglePageView;
});
