/**
 * Created with JetBrains WebStorm.
 * User: Administrator
 * Date: 14-7-5
 * Time: 下午3:19
 * To change this template use File | Settings | File Templates.
 */
;
define(function (require, exports) {

    require('jqjson');
    require('hammer');
    var model = require('../../model');
    var define = require('../../define');
    //这个pageitem可以认为是只有用到加载翻页动画
    var PageItem = require('../pageitem').PageItem;

    var trace = require('../../trace').Instance;
    var actionType = require('../../trace').ActionType;
    var BookViewBase = require("./bookviewbase").BookViewBase;

    /**
     * 简单双页视图
     * @param {jQuery} container
     * @param {PageProvider} pageProvider
     * @extend  BookViewBase
     */
    function SimpleDoublePageView(container, pageProvider) {

        /**
         * 翻页响应区域
         * @const
         * @type {number}
         */
        var TURN_CORNER_AREA = 70;

        var _container = container;
        var _pageProvider = pageProvider;
        var _ltCorner, _lbCorner, _rtCorner, _rbCorner;

        var _self = this;

        /**
         * @type {jQuery}
         */
        var _viewDOM;
        var _tempView;
        var _pageTransformCSS;
        var _pageIndex = 0;
        var _preparePageIndex = -1;
        var _timeOut;

        var _leftPageWrapper, _leftPageItem, _leftPageIndex;
        var _rightPageWrapper, _rightPageItem, _rightPageIndex;

        var _tempLeftPage,_tempMidLeftPage;
        var _tempMidRightPage,_tempRightPage;

        function _init() {
            var viewWidth = _container.width();
            var viewHeight = _container.height();
            var imageSize = _pageProvider.bookImageSize;

            _viewDOM = $('<div/>').attr('class', 'viewdom').css({
                'width': viewWidth + 'px',
                'height': viewHeight + 'px',
                'position': 'relative'
            });

            var pageWrapperCss = {width: viewWidth / 2 + 'px', height: viewHeight + 'px', float: 'left'};
            _leftPageWrapper = $('<div/>').attr('class', 'leftPageWrapper').css(pageWrapperCss);
            _rightPageWrapper = $('<div/>').attr('class', 'rightPageWrapper').css(pageWrapperCss);
            _viewDOM.append(_leftPageWrapper).append(_rightPageWrapper);
            _container.append(_viewDOM);

            var zoomX = viewWidth / 2 / imageSize.width;
            var zoomY = viewHeight / imageSize.height;
            _pageProvider.zoomRate = zoomX;

            var translateX = -imageSize.width * (1 - zoomX) / 2;
            var translateY = -imageSize.height * (1 - zoomY) / 2;
            _pageTransformCSS = {
                '-webkit-transform': 'matrix(' + zoomX + ',0,0,' + zoomY + ',' + translateX + ' ,' + translateY + ')'
            };

            _setTurnPageCorner(imageSize.width, imageSize.height);
            _bindEvents();

            //增加水平滑动翻页动画效果
            _tempView = $('<div/>').attr("class", "tempView").css({
                'width': imageSize.width * 4 + 'px',
                'height': imageSize.height + 'px',
                'position': 'absolute',
                'class': 'tempView',
                'zIndex': 200,
                'display': "none",
                'top': '0px'
            });

            var tempPageCss = {width: imageSize.width + 'px', height: imageSize.height + 'px'};
            _tempLeftPage = $('<div/>').attr('class', 'tempLeftPage').css(tempPageCss);
            _tempMidLeftPage = $('<div/>').attr('class', 'tempMidLeftPage').css(tempPageCss);
            _tempMidRightPage = $('<div/>').attr('class', 'tempMidRightPage').css(tempPageCss);
            _tempRightPage = $('<div/>').attr('class', 'tempRightPage').css(tempPageCss);
            var tempPageWrapperCss = {"width": viewWidth / 2, "height": viewHeight, "float": "left"};
            var tempLeftPageWrapper = $("<div/>").css(tempPageWrapperCss).append(_tempLeftPage);
            var tempMidLeftPageWrapper = $("<div/>").css(tempPageWrapperCss).append(_tempMidLeftPage);
            var tempMidRightPageWrapper = $("<div/>").css(tempPageWrapperCss).append(_tempMidRightPage);
            var tempRightPageWrapper = $("<div/>").css(tempPageWrapperCss).append(_tempRightPage);
            _tempView.append(tempLeftPageWrapper).append(tempMidLeftPageWrapper).append(tempMidRightPageWrapper).append(tempRightPageWrapper);
            _container.append(_tempView);
        }

        function _setTurnPageCorner(pageWidth, pageHeight) {
            _ltCorner = new model.Bound(0, 0, TURN_CORNER_AREA, TURN_CORNER_AREA);
            _lbCorner = new model.Bound(0, pageHeight - TURN_CORNER_AREA, TURN_CORNER_AREA, TURN_CORNER_AREA);
            _rtCorner = new model.Bound(pageWidth - TURN_CORNER_AREA, 0, TURN_CORNER_AREA, TURN_CORNER_AREA);
            _rbCorner = new model.Bound(_rtCorner.left, _lbCorner.top, TURN_CORNER_AREA, TURN_CORNER_AREA);
        }

        function _getClickPoint(wrapper, e) {
            var wrapperOffset = $(wrapper).offset();
            var targetOffset = $(e.target).offset();
            var point = new model.Point(targetOffset.left - wrapperOffset.left + e.offsetX, targetOffset.top - wrapperOffset.top + e.offsetY);
            return point;
        }

        function _bindEvents() {

//            // 左页页角点击翻页事件处理
//            _leftPageWrapper.click(function (e) {
//                var point = _getClickPoint(this, e);
//                if (_ltCorner.isContainsPoint(point) || _lbCorner.isContainsPoint(point)) {
//                    _self.previousPage();
//                }
//            });
//
//            // 右页页角点击翻页事件处理
//            _rightPageWrapper.click(function (e) {
//                var point = _getClickPoint(this, e);
//                if (_rtCorner.isContainsPoint(point) || _rbCorner.isContainsPoint(point)) {
//                    _self.nextPage();
//                }
//            })


        }

        /**
         * @inheritDoc
         */
        this.isNextPageEnable = function () {
            return _pageIndex < _pageProvider.pageCount - 1;
        };

        /**
         * @inheritDoc
         */
        this.nextPage = function () {
            if (_self.isNextPageEnable()) {
                if (_pageIndex >= _pageProvider.pageCount - 2) {
                    _self.setPageIndex(_pageProvider.pageCount - 1);
                } else {
                    _self.setPageIndex(_pageIndex + 1);
                }
            }
        };

        /**
         * @inheritDoc
         */
        this.isPreviousPageEnable = function () {
            return _pageIndex > 1;
        };

        /**
         * @inheritDoc
         */
        this.previousPage = function () {
            if (_pageIndex <= 2) {
                _self.setPageIndex(1);
            } else {
                _self.setPageIndex(_pageIndex - 1);
            }
        };

        /**
         *  @inheritDoc
         */
        this.refresh = function () {
            var notUseCurrentPageItem = true;
            var leftload = _pageProvider.loadPageItem(_pageIndex - 0, notUseCurrentPageItem);
            var rightload = _pageProvider.loadPageItem(_pageIndex - 0 + 1, notUseCurrentPageItem);
            $.when(leftload, rightload).done(function (ret1, ret2) {
                _leftPageItem = ret1;
                _rightPageItem = ret2;
                var tmp = _pageIndex;
                _pageIndex = -1;
                _self.setPageIndex(tmp);
            });

        };

        /**
         *  @inheritDoc
         */
        this.setPageIndex = function (newPageIndex) {
            var def = $.Deferred();
            if (newPageIndex === _pageIndex) {
                return def.resolve(false);
            }
            //修复bug：单页模式下处于最后一页再切换到双页模式下会出现最后一页处于左页，右页显示空白
            (newPageIndex >= _pageProvider.pageCount - 1) && (newPageIndex = _pageProvider.pageCount - 1);
            (newPageIndex > _pageProvider.pageCount) && (newPageIndex = _pageProvider.pageCount - 2);
            (newPageIndex <= 0) && ( newPageIndex = 1);

            if (_pageIndex !== newPageIndex) {
                _self.isPageLoading = true;
                var range = Math.abs(newPageIndex - _pageIndex);
                if (AppCfg.useSlideAnimation) {
                    if (_self.isTempViewAnimating) {
                        _preparePageIndex = newPageIndex;
                        clearTimeout(_timeOut);
                        _timeOut = setTimeout(function () {
                            _self.setPageIndex(_preparePageIndex);
                        }, 200);
                        return;
                    }
                    if (_pageIndex != 0 && range < 2) {
                      (_pageIndex > newPageIndex) && _self.showAnimateSlide(true);
                      (_pageIndex < newPageIndex) && _self.showAnimateSlide(false);
                    } else {
                        showLoading({tips: AppBlackBoardTipsList.Loading});
                    }
                } else {
                    showLoading({tips: AppBlackBoardTipsList.Loading});
                }
                if (_leftPageItem && _rightPageItem) {
                    $(_self).trigger('beforePageChange', {oldIndex: _pageIndex, newIndex: newPageIndex});
                }
                if (_leftPageItem) {
                    _pageProvider.unloadPageItem(_leftPageItem.pageIndex);
                    _leftPageItem.getContent().remove();
                    _leftPageWrapper.empty();
                }
                if (_rightPageItem) {
                    _pageProvider.unloadPageItem(_rightPageItem.pageIndex);
                    _rightPageItem.getContent().remove();
                    _rightPageWrapper.empty();
                }

                var leftload = _pageProvider.loadPageItem(newPageIndex - 0);
                var rightload = _pageProvider.loadPageItem(newPageIndex - 0 + 1);
                $.when(leftload, rightload).done(function (ret1, ret2) {

                    _leftPageItem = ret1;
                    _leftPageItem.getContent().css(_pageTransformCSS);
                    if (_leftPageItem) {
                        _leftPageWrapper.empty().append(_leftPageItem.getContent());
                    }

                    _rightPageItem = ret2;
                    _rightPageItem.getContent().css(_pageTransformCSS);
                    if (_rightPageItem) {
                        _rightPageWrapper.empty().append(_rightPageItem.getContent());
                    }

                    _self.unTransFormWidget();

                    if (_self._isEditing) _self.setIsEditing(_self._isEditing);
                    _pageIndex = newPageIndex;
                    if (_pageIndex !== 0) {
                        $(_self).trigger('pageChanged', {oldIndex: _pageIndex, newIndex: newPageIndex});
                    }
                    trace.log('ebook', actionType.SetPage, {pageIndex: _pageIndex});

                    def.resolve(newPageIndex);
                    setTimeout(function () {
                        _self._preloadPage(_pageIndex);
                        hideLoading();
                        _self.isPageLoading = false;
                    }, 0);
                });
            }
            else def.resolve(false);
            return def.promise();
        };

        /***
         * 预加载两页做动画
         * @private
         */
        this._preloadPage = function (curIdx) {
            var pre = curIdx - 1;
            var next = curIdx + 2;
            if (pre > 0) {
                var p1 = new PageItem(_pageProvider, pre, null);
                p1.loadBackground();
            }
            if (next <= pageProvider.pageCount) {
                var p2 = new PageItem(_pageProvider, next, null);
                p2.loadBackground();
            }
        };

        /**
         * 获取左右滑动动画所需的图片,返回三页的图片数组
         * @param curIdx     当前的页索引
         * @param isSlideToLeft 是否向左滑动
         */
        this.getAnimationPageImgs = function (curIdx, isSlideToLeft) {
            var arr = [];
            var pre = curIdx - 1;
            var next = curIdx + 2;
            //滑不动了
            if ((pre <= 0 && isSlideToLeft ) || (isSlideToLeft == false && (next > pageProvider.pageCount))) {
                return arr;
            }
            if (isSlideToLeft) {
                var p1 = new PageItem(_pageProvider, pre, null);
                var p2 = new PageItem(_pageProvider, curIdx, null);
                var p3 = new PageItem(_pageProvider, curIdx + 1, null);
                var bg1 = p1.getBackgroud();
                var bg2 = p2.getBackgroud();
                var bg3 = p3.getBackgroud();
                if (bg1 == null || bg2 == null || bg3 == null)
                    return arr;
                arr.push(bg1);
                arr.push(bg2);
                arr.push(bg3);
            } else {
                var p1 = new PageItem(_pageProvider, curIdx, null);
                var p2 = new PageItem(_pageProvider, curIdx + 1, null);
                var p3 = new PageItem(_pageProvider, curIdx + 2, null);
                var bg1 = p1.getBackgroud();
                var bg2 = p2.getBackgroud();
                var bg3 = p3.getBackgroud();
                if (bg1 == null || bg2 == null || bg3 == null)
                    return arr;
                arr.push(bg1);
                arr.push(bg2);
                arr.push(bg3);
            }
            return arr;
        };

        /**
         * @inheritDoc
         */
        this.getPageIndex = function () {
            return _pageIndex;
        };

        /**
         * @inheritDoc
         */
        this.getViewDOM = function () {
            return _viewDOM;
        };

        /**
         * @inheritDoc
         */
        this.getShowPageItem = function () {
            var arr = [];
            _leftPageItem && arr.push(_leftPageItem);
            _rightPageItem && arr.push(_rightPageItem);
            return arr;
        };

        /**
         * 把canvasmgr的笔迹绘制到这里以便于保存
         * @param canvas
         */
        this.paintStroke = function (canvas, isStrokeChanged) {
            var showPageItems = this.getShowPageItem();
            //console.log(showPageItems);
            var w = canvas.width;
            var h = canvas.height;

            // TODO: 判断左页或右页不存在的情况
            var leftPageItem = showPageItems[0];
            leftPageItem.paintStroke(canvas, new model.Bound(0, 0, w / 2, h), isStrokeChanged);

            var rightPaeItem = showPageItems[1];
            rightPaeItem.paintStroke(canvas, new model.Bound(w / 2, 0, w / 2, h), isStrokeChanged);
        };

        /**
         * 恢复笔迹
         * @param {HTMLCanvasElement} canvas
         */
        this.restoreStroke = function (canvas) {
            var showPageItems = this.getShowPageItem();
            var w = canvas.width;
            var h = canvas.height;
            //console.log('restoreStroke, canvas size:{w:%s, h:%s}', w, h);

            // TODO: 判断左页或右页不存在的情况
            var leftPageItem = showPageItems[0];
            leftPageItem.restoreStroke(canvas, new model.Bound(0, 0, w / 2, h));

            var rightPageItem = showPageItems[1];
            rightPageItem.restoreStroke(canvas, new model.Bound(w / 2, 0, w / 2, h));
        };

        /**
         * 保存笔迹
         */
        this.saveStrokesToLocal = function () {
            var showPageItems = this.getShowPageItem();
            var leftPageItem = showPageItems[0];
            leftPageItem.saveStrokesToLocal();

            var rightPageItem = showPageItems[1];
            rightPageItem.saveStrokesToLocal();
        }

        /**
         * 翻页动画显示
         * @param isSlideToLeft {boolean} 是否向前滑动
         */
        this.showAnimateSlide = function (isSlideToLeft) {
            var backGroundImgs = _self.getAnimationPageImgs(_pageIndex, isSlideToLeft);
            if (backGroundImgs.length < 1) return;
            var viewWidth = _container.width();
            var viewHeight = _container.height();
            var imageSize = _pageProvider.bookImageSize;
            _tempView.css("left", -viewWidth / 2 + "px");
            if (isSlideToLeft) {
                //需要填充三张图片为1,2,3
                _tempLeftPage.css("background-image", "url(" + backGroundImgs[0] + ")");
                _tempMidLeftPage.css("background-image", "url(" + backGroundImgs[1] + ")");
                _tempMidRightPage.css("background-image", "url(" + backGroundImgs[2] + ")");
            } else {
                //需要填充的三张图片是2,3,4
                _tempMidLeftPage.css("background-image", "url(" + backGroundImgs[0] + ")");
                _tempMidRightPage.css("background-image", "url(" + backGroundImgs[1] + ")");
                _tempRightPage.css("background-image", "url(" + backGroundImgs[2] + ")");
            }

            var zoomX = viewWidth / 2 / imageSize.width;
            var zoomY = viewHeight / imageSize.height;
            var translateX = -imageSize.width * (1 - zoomX) / 2;
            var translateY = -imageSize.height * (1 - zoomY) / 2;
            var tempTransformCSS = {
                '-webkit-transform': 'matrix(' + zoomX + ',0,0,' + zoomY + ',' + translateX + ' ,' + translateY + ')'
            };
            _tempLeftPage.css(tempTransformCSS);
            _tempMidLeftPage.css(tempTransformCSS);
            _tempMidRightPage.css(tempTransformCSS);
            _tempRightPage.css(tempTransformCSS);
            _tempView.show();
            if (isSlideToLeft === true) {
                _self.isTempViewAnimating = true;
                _tempView.animate({
                    left: "0px"
                }, 1000, function () {
                    _tempView.hide();
                    _tempView.css("left", -viewWidth / 2);
                    _self.isTempViewAnimating = false;
                });
            }
            if (isSlideToLeft === false) {
                _self.isTempViewAnimating = true;
                _tempView.animate({
                    left: -viewWidth + "px"
                }, 1000, function () {
                    _tempView.hide();
                    _tempView.css("left", -viewWidth / 2 );
                    _self.isTempViewAnimating = false;
                });
            }
        }

        _init();
    }

    SimpleDoublePageView.prototype = new BookViewBase();
    SimpleDoublePageView.prototype.constructor = SimpleDoublePageView;

    exports.SimpleDoublePageView = SimpleDoublePageView;
});
