;
/**
 * 这个类是视图类基类，大多数函数在实现时需要重载
 *
 * 最初的架构思路是
 * toolbar ---- container ---- bookview ---- item
 * 请尽量不要破坏这种关系。
 *
 *         -------- by  yczhu
 */
define(function (require, exports) {

    require('jqjson');
    require('hammer');
    var model = require('../../model');
    var define = require('../../define');
    var trace = require('../../trace').Instance;

    /**
     * 书本视图基类
     */
    function BookViewBase() {
        /**
         * 默认添加元素的页面
         */
        this.selectedPage = null;

        this._isEditing = false;

        this.isTempViewAnimating = false;

        this.isPageLoading = false;
        /**
         * 是否是双页
         * @returns {boolean}
         */
        this.isDoublePage = function () {
            return true;
        };

        /**
         * 设置视图是否是编辑状态
         * @param {boolean} isEditing
         */
        this.setIsEditing = function (isEditing) {
            this._isEditing = isEditing;
            var pages = this.getShowPageItem();
            $.each(pages, function () {
                this.setIsEditing(isEditing);
            });
        };

        /**
         * 获取当前页码
         * @return {int}
         */
        this.getPageIndex = function () {
            throw new Error('getPageIndex need implement');
        };

        /**
         * 设置当前页码
         * @param {int} pageIndex 页码
         */
        this.setPageIndex = function (pageIndex) {
            throw new Error('setPageIndex need implement');
        };

        /**
         * 是否可以向下翻页
         * @return {boolean}
         */
        this.isNextPageEnable = function () {
            throw new Error("isNextPageEnable need implement");
        };

        /**
         * 下一页
         */
        this.nextPage = function () {
            throw new Error('nextPage need implement');
        };

        /**
         * 是否能够向上翻页
         * @return {boolean}
         */
        this.isPreviousPageEnable = function () {
            throw new Error("isPreviousPageEnable need implement");
        };

        /**
         * 上一页
         */
        this.previousPage = function () {
            throw new Error('previousPage need implement');
        };

        /**
         * 获取DOM
         * @return {jQuery}
         */
        this.getViewDOM = function () {
            throw new Error('getViewDOM need implement');
        };


        /**
         * 获取左右滑动动画所需的图片,返回三页的数组
         * @param curIdx     当前的页索引
         * @param slideToLeft 是否向左滑动
         */
        this.getAnimationPageImgs = function (curIdx, slideToLeft) {
            throw new Error('getAnimationPageImgs need implement');
        };

        /**
         * 获取当前显示的页对象
         * @return PageItem对象
         */
        this.getShowPageItem = function () {
            throw new Error('getShowPageItem need implement');
        };

        /**
         * 强制刷新当前view
         */
        this.refresh = function () {
            throw new Error('refresh need implement');
        };

        /**
         * 从外面添加资源,如插入一个图片
         */
        this.insertWidget = function (files,option) {
            var p = this.selectedPage || this.getShowPageItem()[0];
            if (p) {
                var obj1 = {},obj2 = {};
                $.each(files, function (i, file) {
                    obj1 = $.extend({ notCopySrc: true,
                        insertFromOuter: true,
                        file: file}, option);
                    obj2 = $.extend({ file: file,
                        multiFiles: files,
                        insertFromOuter: true}, option);
                    if (i) {
                        //是否要拷贝源文件,因为是批量复制，除了第一个其余都不需要拷贝源文件
                        p.insertWidget(null, obj1);
                    }
                    else {
                        p.insertWidget(null, obj2);
                    }
                });
            }
        };

        this.insertWidgetWithPos = function(file,pos,pageIndex,option){
            var p = this.selectedPage || this.getShowPageItem()[0];
            if(pageIndex == 2) p = this.getShowPageItem()[1];
            if(p){
                var obj = $.extend({ file: file,
                    left: pos[0],
                    top: pos[1]}, option);
                p.insertWidget(null,obj);
            }
        }

        /**
         * 从外面添加单个资源,如插入一个诗词卡片
         */
        this.insertSingleWidget = function (file, widgetType, type, options) {
            var p  = this.selectedPage || this.getShowPageItem()[0];
            if (p) {
                options = $.extend({type: type, file: file, insertFromOuter: true}, options);
                p.insertWidget(widgetType, options);
            }
        }

        /**
         * 绘制笔迹
         * @param {HTMLCanvasElement} canvas
         */
        this.paintStroke = function (canvas) {
            throw  new Error('paintStroke need implement')
        };

        /**
         * 恢复笔迹
         * @param {HTMLCanvasElement} canvas
         */
        this.restoreStroke = function (canvas) {
            throw  new Error('restoreStroke need implement')
        };

        /**
         * 保存笔迹
         */
        this.saveStrokesToLocal = function () {
            throw  new Error('restoreStroke need implement')
        }

        /**
         * 显示所有热区
         */
        this.showAllHotspots = function () {
            //console.log('BookViewBase::showAllHotspots');
            var pageItems = this.getShowPageItem();
            $.each(pageItems, function () {
                //console.log('BookViewBase::each in');
                this.showAllHotspots();
            })
        };

        /**
         * 影藏所有热区
         */
        this.hideAllHotspots = function () {
            var pageItems = this.getShowPageItem();
            $.each(pageItems, function () {
                this.hideAllHotspots();
            })
        };

        /**
         * 清空本页资源
         */
        this.clearCurrentPageRes = function () {
            var pageItems = this.getShowPageItem();
            $.each(pageItems, function () {
                this.clearCurrentPageRes();
            })
        }

        //啥也不干
        this.doEraser = function(l,t,w,h){
        }

        //啥也不干
        this.recognition = function(){

        }

    }

    BookViewBase.prototype.unTransFormWidget = function(){
        var matrix = $('.pageItem').css('-webkit-transform')
        matrix = matrix.substr(7, matrix.length - 8).split(",");
        var wZoom = matrix[0] ? 0.7/matrix[0] : 1 ;
        var hZoom = matrix[3] ? 0.7/matrix[3] : 1 ;
        $(".widgeticon").css("-webkit-transform","matrix(" +wZoom + ",0,0,"+hZoom+",0,0)");
    }

    /**
     * 是否显示全部热区
     * @type {boolean}
     * @protected
     */
    BookViewBase.isShowAllHotsopts = false;

    exports.BookViewBase = BookViewBase;
});