define(function (require, exports, module) {

    var lab = require('asynLAB');

    var hasInit = false;
    /**
    *  初始化speech相关JS
    *  @param {boolean}  useLocalPlayer 是否使用本地播放器
     * @param {boolean}  useAndriodAdapter 是否使用Android适配器
    *  @param {Function} callback JS加载完毕回调
    */
    exports.init = function (useLocalPlayer, useAndriodAdapter, callback) {

        var callbackFun = function(){
            hasInit = true;
            if (typeof callback === "function") {
                callback.call(this, useLocalPlayer, useAndriodAdapter);
            }
        };

        if (hasInit) {
            if (typeof callback === "function") {
                callback.call(this, useLocalPlayer, useAndriodAdapter);
            }
        } else {

            // 加载音频组件相关JS
            lab.script(require.resolve("./iFlyPlayer/jwplayer/jwplayer"))
            .script(require.resolve("./iFlyPlayer/iFlyPlayer")).wait()
            .script(require.resolve("./SpeechRecorder/Settings"))
            .script(require.resolve("./SpeechRecorder/swfobject")).wait()
            .script(require.resolve("./SpeechRecorder/SpeechRecorder"))
            .script(require.resolve("./SpeechJS/SpeechJS")).wait(function () {
                   // LogUtil.reload({ top: 20, left: 1120, showPanel: true, showConsole: true });
                });

            if(!useLocalPlayer){
                lab.script(require.resolve("./SpeechJS/Adapter/JWPlayerAdapter"));
            }else{
                if(useAndriodAdapter){
                    lab.script(require.resolve("./SpeechJS/Adapter/AndroidPlayerAdapter"));
                }else{
                    lab.script(require.resolve("./SpeechJS/Adapter/SmartBookPlayerAdapter"));
                }
            }

            if(useAndriodAdapter){
                lab.script(require.resolve("./SpeechJS/Adapter/AndroidRecorderAdapter")).wait(callbackFun);
            }else{
                lab.script(require.resolve("./SpeechJS/Adapter/SpeechRecorderAdapter")).wait(callbackFun);
            }
        }
    }
});