﻿/**
 * SpeechUI 模板处理模块
 * @module speechui/common/resource
 * @date 2013/06/09
 */
define(function (require, exports) {

    var define = require('../define');

    /**
     * 读取文件类容(同步方法!!)
     * @param {string} filePath  文件路径
     * @return {string}
     */
    function readFile(filePath) {

        //filePath = path.trimPosix(filePath);
        var retval;
        //var file = cef.fs;
        var file = window.require("fs");
        try {
            //retval = file.readAll(filePath);
            retval = file.readFile(filePath,function(data){
                console.log(data);
                return data.toString();
            });
        } catch (e) {
            console.error(e);
            retval = null;
        }
        return retval;
    }

    /**
    * 初始化SpeechUI
    * @param {speechui.define.CardName} cardName 卡片名称
    * @param {object=} options
    * @return {string} 卡片模板
    */
    exports.getTemplate = function (cardName,options) {

        // TODO：处理本地运行时卡片模板的获取
		var def = $.Deferred();
        var tmpUrl;
        switch (cardName) {
            case define.CardName.EnWordEval:
                return window.enwordevalStr;
                break;
            case define.CardName.CnWordEval:
                return window.cnwordevalStr;
                break;
            case define.CardName.Poetry:
                tmpUrl = require.resolve('../../view/templates/poetry.html#');
                break;
            case define.CardName.Gallery:
                tmpUrl =  require.resolve('../../view/templates/gallerycard.html#');
                break;
            case define.CardName.Situ:
                return window.situStr;
                break;
            case define.CardName.History:
                tmpUrl = require.resolve('../../view/templates/history.html#');
                break;
            case  define.CardName.FlipCard:
                tmpUrl = require.resolve('../../view/templates/flipcard.html#');
                break;
            case  define.CardName.PPT:
                tmpUrl = require.resolve('../../view/templates/pptcard.html#');
                break;
            case  define.CardName.Exercise:
                var type = options;
                tmpUrl =  require.resolve('../../view/templates/exercise'+(type?type:'')+'.html#');
                break;
            case define.CardName.Pickcard:
                tmpUrl = require.resolve('../../view/templates/pickcard.html#');
                break;
            case define.CardName.Matchcard:
                tmpUrl = require.resolve('../../view/templates/matchcard.html#');
                break;
            default:
                throw new Error('Unknown cardName:' + cardName);
        }
        //console.log(tmpUrl);
        tmpUrl=decodeURI(tmpUrl);
        var tpl = '';
        // 本地路径
        /*if(!tmpUrl) return eval('window.'+cardName+'Str');
        else */
        //if(tmpUrl.indexOf('file:///') > -1){
            //tpl = readFile(tmpUrl.substr('file:///'.length))
            //tpl = readFile(tmpUrl.replace('file:///',""));
        //} else{
            $.ajax(tmpUrl, {
                async: false,
                success: function (result) {
                    tpl = result;
                    def.resolve(tpl);
                },
                error: function () {
                    throw new Error("get " + cardName + " template error");
                    def.resolve(null);
                }
            });
        //}
        return def.promise();
    };
});