/**
 * 时间轴模板--纵向
 * Created by ythuang on 14-7-1.
 */
define(function (require, exports, module) {
    var _cardbase = require('./cardbase');
    var _define = require('../define');
    var tplparse = require('../thirdparty/template');

    /**
     * 时间轴模板构造函数
     * @param option
     * @constructor
     */
    function HistoryCard(option, currentheight, currentwidth) {
        if (!('items' in option)) {
            throw new Error('option Parameters!');
        }
        var _dom;
        var _self = this;
        var _currentheight = currentheight;
        var _currentwidth = Math.floor(currentwidth);

        var _popDom = $('<div id="spot_play_box" style="position: absolute;width: 100%;height: 100%;top: 0;left: 0;z-index: 2">' +
            '<div id="spot_playbox_ctrl" style="position: absolute;background-color: #000000;opacity: 0.5;width: 100%;height: 100%">' +
            '</div><a href="javascript:void(0)" class="spot-close-btn" id="spot_close_btn"></a><div id="spot_playbox_container" ' +
            'style="position: absolute;width: 90%;height: 90%;text-align: center;top: 5%;left: 5%;">' +
            '<img style="position:relative;max-width: 98%; max-height: 96%;" id="spot_content_image" src=""></div></div>');

        /**
         *初始时间轴卡片
         */
        function init() {

            if (option.style === 'vertical') {
                // 纵向
                _self.getTemplate().done(function (tpl) {
                    var tml = '';
                    for (var i = 0; i < option.items.length; i++) {
                        tml += '<li style="overflow: hidden">' +
                            '<div class="sjz_box_r_img" style="display: table-cell;vertical-align: middle;text-align: center;cursor:pointer;"><span><img src="' +
                            option.items[i].img +
                            '" style="max-height: 100%;max-width: 100%;width: auto;height: auto;"></span></div>' +
                            '<p class="sjz_box_r_tit" style="white-space: nowrap;text-overflow: ellipsis;overflow: hidden;width: 316px;">' +
                            option.items[i].title +
                            '</p>' +
                            '<div class="sjz_box_r_con" style="overflow: auto;border: none;font-size: 16px;width: 100%;height:100%;line-height: normal;font-family: arial;word-wrap: break-word;width: 316px;">' +
                            option.items[i].text +
                            '</div>' +
                            '</li>';
                    }
                    tpl = tpl.replace('{{html}}', tml);

                    var html = tplparse.render(tpl, option);          //模版解析
                    _dom = $(html);                                   //为防止卡片间相互影响，使用dom
                    _dom.find(".sjz_box_l_list li:eq(0) i").css('background-position', '0 -40px');
                    _dom.find(".sjz_box_l_list li:eq(0)").addClass('sjz_box_on');

                    var dl_height = 0.88 * _currentheight;
                    var li_height = 110;

                    // 设置样式
                    _dom.find('.timeline_con_ul sjz_box_r_img').css({'height': _currentheight * 0.4 + 'px'});
                    _dom.find('.class_fl_tit').css({'line-height': 0.08 * currentheight + 'px'});
                    _dom.find('.timeline_con_ul li').css({'height': dl_height + 'px'});
                    _dom.find('.sjz_box_r_con').css({'height': 0.26 * _currentheight + 'px'});
                    _dom.find('.sjz_box_r_img').css({'height': 0.35 * _currentwidth + 'px'});
                    _dom.find('.sjz_box_r_img img').css({'max-height': 0.34 * _currentwidth + 'px'});


                    _dom.find('.sjz_box_r_img').on('vclick', function () {
                        var imgSrc = $(this).find('img').attr('src');
                        if (imgSrc === '') {
                            return;
                        }
                        _popDom.find('#spot_playbox_container').css({'line-height': $('#mainContainer').height() * 0.9 + 'px'});
                        _popDom.find('img').attr('src', imgSrc);

                        $('body').append(_popDom);
                        _popDom.find('.spot-close-btn').on('vclick', function () {
                            _popDom.remove();
                        });
                    });

                    _dom.find(".sjz_box_l_list li").each(function (i) {
                        $(this).on("vclick", function (e) {
                            if ($(this).attr('class') != "sjz_box_on") {

                                _dom.find('.sjz_box_l_list li').each(function () {
                                    $(this).find('i').css('background-position', '0px 0px');
                                    $(this).removeClass('sjz_box_on');
                                });

                                $(this).find('i').css('background-position', '0 -40px');
                                $(this).addClass('sjz_box_on');

                                _dom.find(".timeline_con_ul li img").each(function (j) {
                                    if (i == j) {
                                        if (i == 0) {
                                            _dom.find(".timeline_con_ul").animate({'margin-top': -dl_height * j + "px"});
                                        } else if (i + 2 >= option.items.length && i != 1) {
                                            _dom.find(".timeline_con_ul").animate({'margin-top': -dl_height * j + "px"});
                                            _dom.find(".sjz_box_l_list").animate({'margin-top': -li_height * (j - 2) + "px"});
                                        } else {
                                            _dom.find(".timeline_con_ul").animate({'margin-top': -dl_height * j + "px"});
                                            _dom.find(".sjz_box_l_list").animate({'margin-top': -li_height * (j - 1) + "px"});
                                        }
                                    }
                                });
                            }
                            e.preventDefault();
                        });
                    });
                });

            } else {
                // 横向
                var tpl = ['<div class="classified_box_warp" style="background: #fff;">',
                    '    <div class="class_fl_tit" style="height: 8%">',
                    '        <span style="white-space: nowrap;max-width: 94%;text-overflow: ellipsis;margin-left: 3%;float: left;overflow: hidden;">{{title}}</span>',
                    '    </div>',
                    '    <div class="classified_box" style="padding: 30px 0px;">',
                    '        <div class="sjz_box" style="padding: 0;">',
                    '            <div class="sjz_box_top" style="position: relative">',
                    '                <ul class="timeline_con_ul" style="position:relative;left: 0px;width: 20000px;display: inline-block;top: 4%;">',
                    '                    {{html}}',
                    '                </ul>',
                    '            </div>',
                    '            <div class="sjz_box_bot">',
                    '                <ul class="sjz_box_l_list2 clearfix">',
                    '                    {{#items}}',
                    '                        <li class="sjz_li sjz_li_02" style="margin: 0 10px;"><i class="sjz_li_ic2"></i><div style="clear: both"></div><span><em style="margin-left: 0;font-size: 13px;">{{time}}</em></span></li>',
                    '                    {{/items}}',
                    '                </ul>',
                    '            </div>',
                    '        </div>',
                    '    </div>',
                    '</div>'].join("");
                var tml = '';
                for (var i = 0; i < option.items.length; i++) {
                    tml += '<li style="float: left;"><div class="sjz_box_r_img" style="display: table-cell;vertical-align: middle;text-align: center;cursor:pointer;"><span><img src="' +
                        option.items[i].img +
                        '" style="max-height: 100%;max-width: 100%;width: auto;height: auto;"></span></div><p class="sjz_box_r_tit" style="white-space: nowrap;text-overflow: ellipsis;overflow: hidden;width: 480px;">' +
                        option.items[i].title +
                        '</p><div class="sjz_box_r_con" style="font-size: 16px;width: 100%;overflow: auto;height:100%;line-height: normal;font-family: arial;word-wrap: break-word;width: 480px;">' +
                        option.items[i].text +
                        '</div></li>';
                }
                tpl = tpl.replace('{{html}}', tml);

                var html = tplparse.render(tpl, option);          //模版解析
                _dom = $(html);                                   //为防止卡片间相互影响，使用dom
                _dom.find(".sjz_box_l_list2 li:eq(0) i").css('background-position', '0 -40px');
                _dom.find(".sjz_box_l_list2 li:eq(0)").addClass('sjz_box_on');

                var li_height = 150;

                // 设置样式
                _dom.find('.class_fl_tit').css({'line-height': 0.08 * currentheight + 'px'});
                _dom.find(".timeline_con_ul li").each(function (i) {
                    $(this).css({'margin': '0 ' + 0.1 * _currentwidth + 'px', 'top': '15%'});
                });
                _dom.find('.timeline_con_ul li,.sjz_box_r_img').css({'width': 0.8 * _currentwidth + 'px'});
                _dom.find('.sjz_box_r_img').css({'height': 0.30 * _currentwidth + 'px'});
                _dom.find('.sjz_box_r_img img').css({'max-height': 0.29 * _currentwidth + 'px'});

                _dom.find('.sjz_box_top').css({'height': 0.63 * _currentheight + 'px'});
                _dom.find('.sjz_box_r_con').css({'height': 0.16 * _currentheight + 'px'});
                _dom.find('.sjz_box_bot').css({'width': _currentwidth + 'px', 'margin-top': _currentheight * 0.06 + 'px'});

                _dom.find('.sjz_box_r_img').on('vclick', function () {
                    var imgSrc = $(this).find('img').attr('src');
                    if (imgSrc === '') {
                        return;
                    }
                    _popDom.find('#spot_playbox_container').css({'line-height': $('#mainContainer').height() * 0.9 + 'px'});
                    _popDom.find('img').attr('src', imgSrc);

                    $('body').append(_popDom);
                    _popDom.find('.spot-close-btn').on('vclick', function () {
                        _popDom.remove();
                    });
                });

                _dom.find(".sjz_box_l_list2 li").each(function (i) {
                    $(this).on("tap", function (e) {
                        if ($(this).attr('class') != "sjz_box_on") {
                            _dom.find('.sjz_box_l_list2 li').each(function () {
                                $(this).find('i').css('background-position', '0px 0px');
                                $(this).removeClass('sjz_box_on');
                            });

                            $(this).find('i').css('background-position', '0 -40px');
                            $(this).addClass('sjz_box_on');


                            _dom.find(".timeline_con_ul li img").each(function (j) {
                                if (i == j) {
                                    if (i == 0) {
                                        _dom.find(".timeline_con_ul").animate({'left': -_currentwidth * j + "px"});
                                    } else if (i + 1 >= option.items.length && i != 1) {
                                        _dom.find(".timeline_con_ul").animate({'left': -_currentwidth * j + "px"});
                                        _dom.find(".sjz_box_l_list2").animate({'margin-left': -li_height * (j - 2) + "px"});

                                    } else {
                                        _dom.find(".timeline_con_ul").animate({'left': -_currentwidth * j + "px"});
                                        _dom.find(".sjz_box_l_list2").animate({'margin-left': -li_height * (j - 1) + "px"});
                                    }
                                }
                            });
                        }
                        e.preventDefault();
                    });
                });

            }
        }

        this.getContent = function () {
            return  _dom;
        }

        init(); //调用入口
    }

    HistoryCard.prototype = new _cardbase.CardBase();
    HistoryCard.prototype.constructor = HistoryCard;
    HistoryCard.prototype.getCardName = function () {
        return _define.CardName.History;
    };
    exports.Constructor = HistoryCard;
});