/**
 * Created by ythuang on 14-7-4.
 */
define(function (require, exports, module) {
    var _cardbase = require('./cardbase');
    var _define = require('../define');

    /**
     * 翻翻卡模板构造函数
     * @param option
     * @constructor
     */
    function FlipCard(option, currentwidth, currentheight) {
        if (!('cards' in option)) {
            throw new Error('option Parameters!');
        }

        var _dom;
        var _self = this;
        var _currentheight = currentheight;
        var _currentwidth = currentwidth;

        /**
         *初始时间轴卡片
         */
        function init() {
            _self.getTemplate().done(function (tpl) {

                var cardNum = option.cards.length;
                var tmphtml = '';
                if (cardNum < 3) {
                    tmphtml = '<tr>';
                    for (var i = 0; i < cardNum; i++) {

                        if (option.cards[i].back.type == 'img') {
                            tmphtml += '<td><div class="box viewport-flip" title="点击翻面"><a href="javascript:void(0)" class="list flip out" style="display: none"><div style="vertical-align: middle;display: table-cell"><img src="' + option.cards[i].back.value + '" alt=""/></div></a>';
                        } else {
                            tmphtml += '<td><div class="box viewport-flip" title="点击翻面"><a href="javascript:void(0)" class="list flip out" style="display: none"><div style="word-break: break-all;vertical-align: middle;display: table-cell"><span style="display: inline-block">' + option.cards[i].back.value + '</span></div></a>'
                        }

                        if (option.cards[i].front.type == 'img') {
                            tmphtml += '<a href="javascript:void(0)" class="list flip"><div style="vertical-align: middle;display: table-cell"><img src="' + option.cards[i].front.value + '" alt="正面"/></div></a></div></td>';
                        } else {
                            tmphtml += '<a href="javascript:void(0)" class="list flip"><div style="word-break: break-all;vertical-align: middle;display: table-cell"><span style="display: inline-block">' + option.cards[i].front.value + '</span></div></a></div></td>';
                        }

                    }
                    tmphtml += '</tr>';
                }
                else if (cardNum < 5) {
                    for (var i = 0; i < cardNum; i++) {
                        if (i < 3) {
                            if (i == 0) {
                                tmphtml += '<tr>';
                            }

                            if (option.cards[i].back.type == 'img') {
                                tmphtml += '<td><div class="box viewport-flip" title="点击翻面"><a href="javascript:void(0)" class="list flip out" style="display: none"><div style="vertical-align: middle;display: table-cell"><img src="' + option.cards[i].back.value + '" alt=""/></div></a>';
                            } else {
                                tmphtml += '<td><div class="box viewport-flip" title="点击翻面"><a href="javascript:void(0)" class="list flip out" style="display: none"><div style="word-break: break-all;vertical-align: middle;display: table-cell"><span style="display: inline-block">' + option.cards[i].back.value + '</span></div></a>';
                            }

                            if (option.cards[i].front.type == 'img') {
                                tmphtml += '<a href="javascript:void(0)" class="list flip"><div style="vertical-align: middle;display: table-cell"><img src="' + option.cards[i].front.value + '" alt="正面"/></div></a></div></td>';
                            } else {
                                tmphtml += '<a href="javascript:void(0)" class="list flip"><div style="word-break: break-all;vertical-align: middle;display: table-cell"><span style="display: inline-block">' + option.cards[i].front.value + '</span></div></a></div></td>';
                            }

                            if (i == 1) {
                                tmphtml += '</tr>';
                            }
                        } else {
                            if (i == 2) {
                                tmphtml += '<tr>';
                            }

                            if (option.cards[i].back.type == 'img') {
                                tmphtml += '<td><div class="box viewport-flip" title="点击翻面"><a href="javascript:void(0)" class="list flip out" style="display: none"><div style="vertical-align: middle;display: table-cell"><img src="' + option.cards[i].back.value + '" alt=""/></div></a>';
                            } else {
                                tmphtml += '<td><div class="box viewport-flip" title="点击翻面"><a href="javascript:void(0)" class="list flip out" style="display: none"><div style="word-break: break-all;vertical-align: middle;display: table-cell"><span style="display: inline-block">' + option.cards[i].back.value + '</span></div></a>';
                            }

                            if (option.cards[i].front.type == 'img') {
                                tmphtml += '<a href="javascript:void(0)" class="list flip"><div style="vertical-align: middle;display: table-cell"><img src="' + option.cards[i].front.value + '" alt="正面"/></div></a></div></td>';
                            } else {
                                tmphtml += '<a href="javascript:void(0)" class="list flip"><div style="word-break: break-all;vertical-align: middle;display: table-cell"><span style="display: inline-block">' + option.cards[i].front.value + '</span></div></a></div></td>';
                            }

                            if (i == 3) {
                                tmphtml += '</tr>';
                            }
                        }
                    }

                }
                else if (cardNum < 10) {
                    for (var i = 0; i < cardNum; i++) {
                        if (i == 0 || i == 3 || i == 6) {
                            tmphtml += '<tr>';
                        }

                        if (option.cards[i].back.type == 'img') {
                            tmphtml += '<td><div class="box viewport-flip" title="点击翻面"><a href="javascript:void(0)" class="list flip out" style="display: none"><div style="vertical-align: middle;display: table-cell"><img src="' + option.cards[i].back.value + '" alt=""/></div></a>';
                        } else {
                            tmphtml += '<td><div class="box viewport-flip" title="点击翻面"><a href="javascript:void(0)" class="list flip out" style="display: none"><div style="word-break: break-all;vertical-align: middle;display: table-cell"><span style="display: inline-block">' + option.cards[i].back.value + '</span></div></a>';
                        }

                        if (option.cards[i].front.type == 'img') {
                            tmphtml += '<a href="javascript:void(0)" class="list flip"><div style="vertical-align: middle;display: table-cell"><img src="' + option.cards[i].front.value + '" alt="正面"/></div></a></div></td>';
                        } else {
                            tmphtml += '<a href="javascript:void(0)" class="list flip"><div style="word-break: break-all;vertical-align: middle;display: table-cell"><span style="display: inline-block">' + option.cards[i].front.value + '</span></div></a></div></td>';
                        }

                        if (i == 2 || i == 5 || i == 8) {
                            tmphtml += '</tr>';
                        }
                    }
                }

                var html = tpl.replace("{{html}}", tmphtml).replace("{{title}}", option.title);
                _dom = $(html);
                // 动态设置样式
                _dom.find('.class_fl_tit').css({'line-height': 0.08 * _currentheight + 'px'});

                if (cardNum == 1) {
                    var text_height = _currentheight * 0.87;
                    var text_width = _currentwidth * 0.96;

                    _dom.find("a.list").css({"width": "100%", "height": "100%", "font-size": "16px"});
                    _dom.find(".list div").css({"height": text_height + "px", 'width': text_width + 'px'});
                    _dom.find(".list div img").css({"max-height": text_height + "px"});

                    _dom.find(".box").css({"width": "96%", "height": "87%", 'margin-left': '2%', 'margin-top': '2%'});
                } else if (cardNum == 2) {
                    var text_height = _currentheight * 0.87;
                    var text_width = _currentwidth * 0.46;

                    _dom.find("a.list").css({"width": "100%", "height": "100%", "font-size": "16px"});
                    _dom.find(".list div").css({"height": text_height + "px", 'width': text_width + 'px'});
                    _dom.find(".list div img").css({"max-height": text_height + "px"});

                    _dom.find(".box").css({"width": "46%", "height": "87%", 'margin-left': '2%', 'margin-top': '2%'});
                } else if (cardNum < 5) {
                    var text_height = _currentheight * 0.41;
                    var text_width = _currentwidth * 0.46;

                    _dom.find("a.list").css({"width": "100%", "height": "100%", "font-size": "16px"});
                    _dom.find(".list div").css({"height": text_height + "px", 'width': text_width + 'px'});
                    _dom.find(".list div img").css({"max-height": text_height + "px"});

                    _dom.find(".box").css({"width": "46%", "height": "41%", 'margin-left': '2%', 'margin-top': '2%'});
                } else if (cardNum < 7) {
                    var text_height = _currentheight * 0.41;
                    var text_width = _currentwidth * 0.293;

                    _dom.find("a.list").css({"width": "100%", "height": "100%", "font-size": "16px"});
                    _dom.find(".list div").css({"height": text_height + "px", 'width': text_width + 'px'});
                    _dom.find(".list div img").css({"max-height": text_height + "px"});

                    _dom.find(".box").css({"width": "29.3%", "height": "41%", 'margin-left': '2%', 'margin-top': '2%'});
                } else {
                    var text_height = _currentheight * 0.266;
                    var text_width = _currentwidth * 0.293;

                    _dom.find("a.list").css({"width": "100%", "height": "100%", "font-size": "16px"});
                    _dom.find(".list div").css({"height": text_height + "px", 'width': text_width + 'px'});
                    _dom.find(".list div img").css({"max-height": text_height + "px"});

                    _dom.find(".box").css({"width": "29.3%", "height": "26.6%", 'margin-left': '2%', 'margin-top': '2%'});
                }

                // 在前面显示的元素，隐藏在后面的元素
                var eleBack = [], eleFront = [], eleList = _dom.find(".list");
                // 确定前面与后面元素
                var isEnable = true;
                var funBackOrFront = function () {
                    eleBack = [];
                    eleFront = [];
                    eleList.each(function () {
                        if ($(this).hasClass("out")) {
                            eleBack.push($(this));
                        } else {
                            eleFront.push($(this));
                        }
                    });
                };
                funBackOrFront();

                _dom.find(".box").on("tap", function (event) {
                    if (isEnable) {
                        isEnable = false;
                        var indexTd = $(this).parents("td").index();
                        var indexTr = $(this).parents("td").parents("tr").index();
                        var flipcardIndex = indexTd + 3 * indexTr;
                        if (cardNum < 5) {
                            flipcardIndex = indexTd + 2 * indexTr;
                        }
                        eleFront[flipcardIndex].addClass("out").removeClass("in").fadeOut(225);
                        setTimeout(function () {
                            eleBack[flipcardIndex].addClass("in").removeClass("out").fadeIn(225);
                            isEnable = true;
                            // 重新确定正反元素
                            funBackOrFront();
                        }, 225);
                        event.preventDefault();
                    }
                });
            });
        }

        this.getContent = function () {
            return  _dom;
        }

        init(); //调用入口
    }

    FlipCard.prototype = new _cardbase.CardBase();
    FlipCard.prototype.constructor = FlipCard;
    FlipCard.prototype.getCardName = function () {
        return _define.CardName.FlipCard;
    };
    exports.Constructor = FlipCard;
});