﻿/**
 * 英文词语评测卡片
 * @module   speechui/code/cards/EnWordEvalCard
 * @date     2013/06/09
 * @version  1.0
 */
define(function (require, exports, module) {

    var _speech   = require('../common/speech');
    var _cardbase = require('./cardbase');
    var _define   = require('../define');
    var _tplParse = require('../thirdparty/template');
    var _resMgr   = require('../common/resource');
    var mask      = require('../common/mask');
    var $         = require('jquery');
                    require('../../view/css/word.css');
    /**
    * 英文词语评测卡片类
    * @constructor
    * @extends {speechui.cards.cardbase.CardBase}
    */
    function EnWordEvalCard() {
       // 为了方便CnCard继承，将需要参数的语句移到init()方法中
       // 但同时会导致构造函数和init中各有一部分参数，逻辑比较混乱，容易出错
       // 因此将初始化的操作全部移到init方法中
    }

    EnWordEvalCard.prototype = new _cardbase.CardBase();
    EnWordEvalCard.prototype.constructor = EnWordEvalCard;

    /**
     * 卡片初始化
     * @param {{
     *     id:       string,
     *     paperUrl: string,
     *     audios:   Array.<string>
     * }} options  卡片加载参数
     * @extends {speechui.cards.cardbase.CardBase}
     */
    EnWordEvalCard.prototype.init = function(options){
        //载入dom
        this.tpl        = this.getTemplate();  //获取模板
        //if(this.tpl.indexOf('/')) this.tpl = _shellcmd.readFileAsync(this.tpl);
        this.paper      = (options.paperContent != '' ? options.paperContent : _resMgr.getUrlContent(options.paperUrl));//获取试卷
        this.audios     = options.audios;   //标准音频
        this.records    = [];               //录音音频
        this.wordArray  = [];               //单词信息
        this.scoreArray = [];               //得分信息
        this.panelWord  = [];               //用于在页面上显示word
        this.getWordInfo();

        this.html    = this.render();   //渲染
        this.dom     = $(this.html);    //为防止卡片间相互影响，使用dom
        this.popHtml = this.dom.find('.word_pop_html').html();

        this.dom.find('.word_pop_html').remove();
        $('body').append(this.dom);

        //卡片状态信息
        this.Status = {
            normal      :  'normal',
            pop         :  'pop',
            recording   :  'recording',
            playWording :  'playWording',
            playReading :  'playReading',
            playComing  :  'playComing'
        };
        this.curStatus     = this.Status.normal;
        this.popStatus     = this.Status.pop;
        this.prePopStatus  = this.Status.pop;
        this.initStatus    = true;
        this.wordIndex     = 0;
        this.recordID;

        //绑定事件
        this.clickEvent = {};
        this.registerClickEvent();
        this.registerCallBack(this);
        this.blind();
        this.forceStop = false;

        //遮盖罩mask
        this.maskType = {
            common : 'common',
            card   : 'card',
            top    : 'top'
        };
        this.maskOption = {
            self    : this,
            type    : this.maskType.common,
            msg     : '资源加载中，请稍候',
            lagTime : 1,
            flag    : true
        };
        mask.showMask(this.maskOption);

    };

    /**
     * 获取卡片名称
     * @return String
     * @protected
     */
    EnWordEvalCard.prototype.getCardName = function () {
        return _define.CardName.EnWordEval;
    };

    /**
     * 获取卡片单词信息
     * @protected
     */
    EnWordEvalCard.prototype.getWordInfo = function () {
        //初始化wordArray、scoreArray和records
        this.wordArray  = this.paper.split('\n');
        this.panelWord  = this.wordArray;
        for(var i = 0; i < this.wordArray.length - 1; i++ ){
            this.scoreArray.push("");
            var info = {
                id    : '',
                begin : 0 ,
                end   : 0 ,
                flag  : true ,
                time  : 0
            };
            this.records.push(info);
        }
    };

    /**
     * 卡片渲染
     * @return String
     * @protected
     */
    EnWordEvalCard.prototype.render = function () {
        var text = {
            words : []
        };
        for (var i = 0; i < this.wordArray.length - 1; i++) {
            text.words.push({
                word  : this.panelWord[i + 1],
                index : i
            });
        }
        return _tplParse.render(this.tpl, text);
    };

    /**
     * 卡片事件绑定
     * @protected
     */
    EnWordEvalCard.prototype.blind = function () {
        this.enableSingleFunBtn('.word_startRec');
        this.enableSingleFunBtn('.word_playWord');
        this.enableSingleFunBtn('.word_panel_index');
        this.enableSingleFunBtn('.showPY');
    };

    /**
     * 点击事件
     * @protected
     */
    EnWordEvalCard.prototype.registerClickEvent = function () {
        this.clickEvent = {
            onStartRec : function(){
                if(_speech.speecher.Recorder.isReady){
                    var dom = this.dom;
                    this.recordID = "word-card-" + new Date().getTime();
                    var success = _speech.speecher.Recorder.record({
                        evalType: SeEvalType.ReadWord,
                        evalText: this.paper,
                        evalParams: "vadEnable=true, vadSpeechTail=2500",
                        sndId: this.recordID
                    });
                    LogUtil.debug("Begin record:" + success);
                    if(success){
                        this.curStatus = this.Status.recording;
                        this.disableAllFunBtn();
                        dom.find('.word_startRec').hide();
                        dom.find('.word_stopRec').show();
                        this.enableSingleFunBtn('.word_stopRec');
                    }
                }
            },
            onStopRec : function() {
                var success = _speech.speecher.Recorder.stop();
                if(success){
                    this.disableSingleFunBtn('.word_stopRec');
                    this.maskOption.type = this.maskType.common;
                    this.maskOption.msg = "正在评测中，请稍候";
                    this.maskOption.flag = true;
                    mask.showMask(this.maskOption);
                }
                LogUtil.debug("Stop record:" + success);
            },
            onPlayWord : function() {
                if(_speech.speecher.Player.isReady){
                    var dom    = this.dom;
                    var audios = this.audios;

                    this.curStatus = this.Status.playWording;
                    for(var i = 0; i < audios.length; i++){
                        this.setWordPanelColor(i, 'gray');
                    }

                    dom.find('.word_playWord').hide();
                    dom.find('.word_stopWord').show();
                    this.disableAllFunBtn();
                    this.enableSingleFunBtn('.word_stopWord');

                    var score = this.dom.find('.word_eval_0').text();
                    var color = (score == "" || score >= 60 ? 'green': 'red');
                    this.setWordPanelColor(this.wordIndex, color);

                    _speech.speecher.Player.loadAudio(encodeURI(audios[0]));
                    _speech.speecher.Player.play();
                }
            },
            onStopWord : function() {
                this.curStatus = this.Status.normal;
                _speech.speecher.Player.stop();
            },
            onPlayRead : function() {
                var dom    = this.dom;
                var audios = this.audios;

                this.curStatus = this.Status.playReading;
                for(var i = 0; i < audios.length; i++){
                    this.setWordPanelColor(i, 'gray');
                }
                dom.find('.word_playRead').hide();
                dom.find('.word_stopRead').show();
                this.disableAllFunBtn();
                this.enableSingleFunBtn('.word_stopRead');
                _speech.speecher.Recorder.loadAudio(this.records[0].id, false);
            },
            onStopRead : function() {
                this.curStatus = this.Status.normal;
                _speech.speecher.Recorder.stopPlay();
            },
            onPlayCom : function() {
                this.wordIndex = 0;
                this.openPop();
                this.disableAllFunBtn();
                this.enableAllFunBtn();
                this.setPopWordScore();
                this.clickEvent.onPlayCom.call(this);
                this.popStatus = this.Status.playComing;
            },
            onPopWordPanel : function(id){
                this.wordIndex = id;
                this.openPop();
                this.disableAllFunBtn();
                this.setPopStyle();
                this.setPopWordScore();
                this.popStatus = this.Status.pop;
            }
        }
    };

    /**
     * SpeechJS回调事件
     * @param {EnWordEvalCard} self
     * @protected
     */
    EnWordEvalCard.prototype.registerCallBack = function (self) {
        _speech.registerEvent({
            recordEvents: {
                onReady : function () {
                    window.readyInfo.recorder = true;
                    if( window.readyInfo.recorder == true &&  window.readyInfo.player == true){
                        self.maskOption.flag = false;
                        mask.showMask(self.maskOption);
                    }
                },
                onEvalResult : function (e) {
                    self.dom.find('.word_mic').css("width", 0);
                    if(e.resultType == EvalCallbackType.ENDPOINT){
                        self.clickEvent.onStopRec.call(self);
                    }else if(e.resultType === EvalCallbackType.SCORE){
                        for (var i = 0; i < e.result.Sentences.length; i++) {
                            var wordResult = e.result.Sentences[i].Words[0];
                            self.scoreArray[i] = Math.round(wordResult.Score * 20);

                            var recordInfo = {};
                            recordInfo.begin = wordResult.BegPos;
                            recordInfo.end   = wordResult.EndPos;
                            recordInfo.id    = self.recordID;
                            recordInfo.flag  = false;
                            recordInfo.time  = new Date().getTime();
                            self.records[i]  = recordInfo;
                        }
                        self.initStatus = false;
                        self.curStatus = self.Status.normal;
                        self.disableAllFunBtn();
                        self.enableAllFunBtn();
                        self.dom.find('.word_stopRec').hide();
                        self.dom.find('.word_startRec').show();

                        self.maskOption.flag = false;
                        mask.showMask(self.maskOption);
                        self.setWordScore();
                    }
                },
                onRecording : function (e) {
                    var volume = e.energy;
                    if(volume < 50){
                        volume += 20;
                    }else if(volume>=50 && volume<60){
                        volume = 70;
                    }else if(volume>=60 && volume<80){
                        volume = 80;
                    }
                    self.dom.find('.word_mic').css("width", volume);
                },
                onAudioLoaded : function(){
                    var score = self.dom.find('.word_eval_' + self.wordIndex).text();
                    var color = (score == "" || score >= 60 ? 'green': 'red');
                    self.setWordPanelColor(self.wordIndex, color);

                    _speech.speecher.Recorder.playRange(self.records[self.wordIndex].begin, self.records[self.wordIndex].end);
                    if(self.wordIndex == self.audios.length-1){
                        self.wordIndex++;
                    }
                },
                onPlayStop : function(){
                    if(self.curStatus == self.Status.playReading && self.wordIndex < self.audios.length){
                        setTimeout(function() {
                            self.setWordPanelColor(self.wordIndex, 'gray');
                            self.wordIndex++;
                            _speech.speecher.Recorder.loadAudio(self.records[self.wordIndex].id, false);
                        }, 500);
                    }else{
                        self.wordIndex == self.audios.length ? self.wordIndex-- : "" ;
                        self.setWordPanelColor(self.wordIndex, 'gray');
                        self.wordIndex = 0;

                        self.disableAllFunBtn();
                        self.enableAllFunBtn();
                        self.dom.find('.word_stopRead').hide();
                        self.dom.find('.word_playRead').show();
                        self.curStatus = self.Status.normal;
                    }
                },
                onError : function(e){
                    if(self.curStatus == self.Status.recording || self.curStatus == self.Status.playReading){

                        if( e.errorType == 3 || (e.errorType == 2 && e.errorCode == 10118) ){
                            self.maskOption.msg = "没有检测到声音";
                        }else if( (e.errorType == 2 && e.errorCode == 11004) || (e.errorType == 1 && e.errorCode == 4002) ){
                            self.maskOption.msg = "登陆云平台失败";
                        }else if( e.errorType == 2 && (e.errorCode == 10115 || e.errorCode == 10116) ){
                            var time = new Date().getTime();
                            if( time - self.records[self.wordIndex].time < 5000 ){
                                self.maskOption.msg = "正在上传语音文件";
                            }else{
                                self.maskOption.msg = "音频加载出错";
                            }
                        }else{
                            self.maskOption.msg = "网络连接出错";
                        }

                        self.maskOption.type = self.maskType.common;
                        self.maskOption.flag = true;
                        mask.showMask(self.maskOption);
                        setTimeout(function() {
                            self.showAllFunBtn();
                            self.disableAllFunBtn();
                            if(self.initStatus) {
                                self.enableSingleFunBtn('.word_startRec');
                                self.enableSingleFunBtn('.word_playWord');
                                self.enableSingleFunBtn('.word_panel_index');
                            }else{
                                self.enableAllFunBtn();
                            }
                            self.maskOption.flag = false;
                            mask.showMask(self.maskOption);
                            self.wordIndex = 0;
                            self.curStatus = self.Status.normal;
                        }, 2500);
                    }
                }
            },
            playEvents:{
                onReady: function(){
                    window.readyInfo.player = true;
                    if( window.readyInfo.recorder == true &&  window.readyInfo.player == true){
                        self.maskOption.flag = false;
                        mask.showMask(self.maskOption);
                    }
                },
                onStop : function(){
                    if(self.curStatus == self.Status.playWording &&
                        self.wordIndex < self.audios.length &&
                        self.wordIndex != self.audios.length - 1
                        ){
                            setTimeout(function(){
                                self.setWordPanelColor(self.wordIndex, 'gray');
                                self.wordIndex++;
                                var score = self.dom.find('.word_eval_' + self.wordIndex).text();
                                var color = (score == "" || score >= 60 ? 'green': 'red');
                                self.setWordPanelColor(self.wordIndex, color);

                                _speech.speecher.Player.loadAudio(encodeURI(self.audios[self.wordIndex]));
                                _speech.speecher.Player.play();
                                if(self.wordIndex == self.audios.length-1){
                                    self.wordIndex++;
                                }
                            }, 800);
                        } else{
                            if(self.wordIndex == self.audios.length){
                                self.wordIndex--;
                            }

                            self.setWordPanelColor(self.wordIndex, 'gray');
                            self.disableAllFunBtn();
                            self.wordIndex = 0;
                            if(self.initStatus) {
                                self.enableSingleFunBtn('.word_startRec');
                                self.enableSingleFunBtn('.word_playWord');
                                self.enableSingleFunBtn('.word_panel_index');
                            }else{
                                self.enableAllFunBtn();
                            }
                            self.dom.find('.word_stopWord').hide();
                            self.dom.find('.word_playWord').show();
                            self.curStatus = self.Status.normal;
                        }
                }
            }
        });
    };

    /**
     * 弹出层点击事件
     * @protected
     */
    EnWordEvalCard.prototype.registerPopClickEvent = function () {
        this.clickEvent = {
            onStartRec : function(){
                var dom = this.dom;
                this.recordID = "word-card-" + new Date().getTime();
                var success = _speech.speecher.Recorder.record({
                    evalType: SeEvalType.ReadWord,
                    evalText: "[word]\n" + this.wordArray[this.wordIndex+1],
                    evalParams: "vadEnable=true, vadSpeechTail=2500",
                    sndId: this.recordID
                });
                LogUtil.debug("Begin record:" + success);
                if(success){
                    this.popStatus = this.Status.recording;
                    this.disableAllFunBtn();
                    dom.find('.pop_word_startRec').hide();
                    dom.find('.pop_word_stopRec').show();
                    this.enableSingleFunBtn('.pop_word_stopRec');
                }
            },
            onStopRec : function() {
                var success = _speech.speecher.Recorder.stop();
                if(success){
                    this.maskOption.type = this.maskType.top;
                    this.maskOption.msg = "正在评测中，请稍候";
                    this.maskOption.flag = true;
                    mask.showMask(this.maskOption);
                    this.disableSingleFunBtn('.pop_word_stopRec');
                }
                LogUtil.debug("Stop record:" + success);
            },
            onPlayWord : function(){
                this.dom.find('.pop_word_playWord').hide();
                this.dom.find('.pop_word_stopWord').show();
                this.disableAllFunBtn();
                this.enableSingleFunBtn('.pop_word_stopWord');
                this.enableSingleFunBtn('.pop_pre');
                this.enableSingleFunBtn('.pop_next');

                this.popStatus    = this.Status.playWording;
                this.prePopStatus = this.Status.playWording;

                _speech.speecher.Player.loadAudio(encodeURI(this.audios[this.wordIndex]));
                _speech.speecher.Player.play();

            },
            onStopWord : function() {
                this.popStatus = this.Status.pop;
                _speech.speecher.Player.stop();
            },
            onPlayRead : function() {
                this.dom.find('.pop_word_playRead').hide();
                this.dom.find('.pop_word_stopRead').show();
                this.disableAllFunBtn();
                this.enableSingleFunBtn('.pop_word_stopRead');
                this.enableSingleFunBtn('.pop_pre');
                this.enableSingleFunBtn('.pop_next');

                this.popStatus    = this.Status.playReading;
                this.prePopStatus = this.Status.playReading;

                _speech.speecher.Recorder.loadAudio(this.records[this.wordIndex].id, false);
            },
            onStopRead : function() {
                this.popStatus = this.Status.pop;
                _speech.speecher.Recorder.stopPlay();
            },

            onPlayCom : function() {
                this.dom.find('.pop_word_playCom').hide();
                this.dom.find('.pop_word_stopCom').show();
                this.disableAllFunBtn();
                this.enableSingleFunBtn('.pop_word_stopCom');
                this.enableSingleFunBtn('.pop_pre');
                this.enableSingleFunBtn('.pop_next');

                this.popStatus    = this.Status.playComing;
                this.prePopStatus = this.Status.playComing;

                _speech.speecher.Player.loadAudio(encodeURI(this.audios[this.wordIndex]));
                _speech.speecher.Player.play();
            },
            onStopCom : function() {
                this.popStatus = this.Status.pop;
                this.forceStop = true;
                _speech.speecher.Player.stop();
                _speech.speecher.Recorder.stopPlay();
            },
            onPopNextBtn: function(){
                if(this.wordIndex < this.audios.length - 1){
                    this.wordIndex++;
                }
                this.setPopWordScore();
                _speech.speecher.Player.stop();
                _speech.speecher.Recorder.stopPlay();
                if(this.popStatus == this.Status.pop){
                    this.disableAllFunBtn();
                    this.setPopStyle();
                }else{
                    this.setPreNext();
                }
            },
            onPopPreBtn: function(){
                this.wordIndex--;
                this.setPopWordScore();
                _speech.speecher.Player.stop();
                _speech.speecher.Recorder.stopPlay();
                if(this.popStatus == this.Status.pop){
                    this.disableAllFunBtn();
                    this.setPopStyle();
                }else{
                    this.setPreNext();
                }
            }

        }
    };

    /**
     * 弹出层SpeechJS回调事件
     * @param {EnWordEvalCard} self
     * @protected
     */
    EnWordEvalCard.prototype.registerPopCallBack = function (self) {
        _speech.registerEvent({
            recordEvents: {
                onReady : function () {
                },
                onEvalResult : function (e) {
                    self.dom.find('.pop_word_mic').css("width", 0);
                    if(e.resultType == EvalCallbackType.ENDPOINT){
                        self.clickEvent.onStopRec.call(self);
                    }else if(e.resultType === EvalCallbackType.SCORE){
                        var wordResult = e.result.Sentences[0].Words[0];
                        self.scoreArray[self.wordIndex] = Math.round(wordResult.Score * 20);

                        var recordInfo = {};
                        recordInfo.begin = wordResult.BegPos;
                        recordInfo.end   = wordResult.EndPos;
                        recordInfo.id    = self.recordID;
                        recordInfo.flag  = false;
                        recordInfo.time  = new Date().getTime();
                        self.records[self.wordIndex] = recordInfo;

                        for(var i = 0; i < self.records.length; i++ ){
                            if(self.records[i].id == ''){
                                self.records[i].id = self.recordID;
                            }
                        }
                        self.maskOption.type = self.maskType.top;
                        self.maskOption.flag = false;
                        mask.showMask(self.maskOption);
                        self.maskOption.type = self.maskType.card;

                        self.setPopWordScore();
                        self.disableAllFunBtn();
                        self.enableAllFunBtn();
                        self.dom.find('.pop_word_stopRec').hide();
                        self.dom.find('.pop_word_startRec').show();

                        self.popStatus = self.Status.pop;
                    }
                },
                onError : function(e){
                    if(self.popStatus == self.Status.recording   ||
                        self.popStatus == self.Status.playReading ||
                        self.popStatus == self.Status.playComing ||
                        self.prePopStatus == self.Status.playComing){

                        if( e.errorType == 3 || (e.errorType == 2 && e.errorCode == 10118) ){
                            self.maskOption.msg = "没有检测到声音";
                        }else if( (e.errorType == 2 && e.errorCode == 11004) || (e.errorType == 1 && e.errorCode == 4002) ){
                            self.maskOption.msg = "登陆云平台失败";
                        }else if( e.errorType == 2 && (e.errorCode == 10115 || e.errorCode == 10116) ){
                            var time = new Date().getTime();
                            if( time - self.records[self.wordIndex].time < 5000 ){
                                self.maskOption.msg = "正在上传语音文件";
                            }else{
                                self.maskOption.msg = "音频加载出错";
                            }
                        }else{
                            self.maskOption.msg = "网络连接出错";
                        }
                        self.maskOption.type = self.maskType.top;
                        self.maskOption.flag = true;
                        mask.showMask(self.maskOption);
                        setTimeout(function() {
                            self.maskOption.flag = false;
                            mask.showMask(self.maskOption);
                            self.maskOption.type = self.maskType.card;
                            self.disableAllFunBtn();
                            self.showAllFunBtn();
                            self.setPopStyle();
                            self.popStatus = self.Status.pop;
                        }, 2500);
                    }
                },
                onRecording : function (e) {
                    var volume = e.energy;
                    if(volume < 50){
                        volume += 20;
                    }else if(volume>=50 && volume<60){
                        volume = 70;
                    }else if(volume>=60 && volume<80){
                        volume = 80;
                    }
                    self.dom.find('.pop_word_mic').css("width", volume);
                },
                onAudioLoaded : function(){
                    _speech.speecher.Recorder.playRange(self.records[self.wordIndex].begin, self.records[self.wordIndex].end);
                },
                onPlayStop : function(){
                    if( self.dom.find('.chk').attr('checked') ){
                        do{
                            self.wordIndex++;
                        }while( self.wordIndex < self.audios.length && self.records[self.wordIndex].flag )

                        if(self.wordIndex >= self.audios.length){
                            self.wordIndex = self.audios.length - 1;
                            self.popStatus = self.Status.pop;
                        }else{
                            if( self.popStatus == self.Status.playReading ){
                                setTimeout(function() {
                                    _speech.speecher.Recorder.loadAudio(self.records[self.wordIndex].id);
                                    self.setPopWordScore();
                                    self.setPreNext();
                                }, 500);
                            }
                            if( self.popStatus == self.Status.playComing ){
                                setTimeout(function() {
                                    _speech.speecher.Player.loadAudio(encodeURI(self.audios[self.wordIndex]));
                                    _speech.speecher.Player.play();
                                    self.setPopWordScore();
                                    self.setPreNext();
                                }, 200);
                            }
                        }
                    }
                    if(self.dom.find('.chk').attr('checked') == undefined || self.popStatus == self.Status.pop){
                        self.popStatus = self.Status.pop;
                        if(self.prePopStatus == self.Status.playReading){
                            self.dom.find('.pop_word_playRead').show();
                            self.dom.find('.pop_word_stopRead').hide();
                        }
                        if(self.prePopStatus == self.Status.playComing){
                            self.dom.find('.pop_word_playCom').show();
                            self.dom.find('.pop_word_stopCom').hide();
                        }
                        self.disableAllFunBtn();
                        self.setPopStyle();
                        self.setPopWordScore();
                    }

                    self.forceStop = false;
                }
            },
            playEvents:{
                onStop : function(){
                    if(self.dom.find('.chk').attr('checked') && self.popStatus == self.Status.playWording){
                        self.wordIndex++;
                        if(self.wordIndex >= self.audios.length){
                            self.wordIndex = self.audios.length - 1;
                            self.popStatus = self.Status.pop;
                        }else{
                            setTimeout(function(){
                                _speech.speecher.Player.loadAudio(encodeURI(self.audios[self.wordIndex]));
                                _speech.speecher.Player.play();
                                self.setPopWordScore();
                                self.setPreNext();
                            }, 500)
                        }
                    }
                    if(self.dom.find('.chk').attr('checked') && self.popStatus == self.Status.playComing){
                            _speech.speecher.Recorder.loadAudio(self.records[self.wordIndex].id, false);
                    }

                    if(self.dom.find('.chk').attr('checked') == undefined || self.popStatus == self.Status.pop){
                        if(self.prePopStatus == self.Status.playWording){
                            self.popStatus = self.Status.pop;
                            self.dom.find('.pop_word_playWord').show();
                            self.dom.find('.pop_word_stopWord').hide();
                            self.disableAllFunBtn();
                            self.setPopStyle();
                        }
                        if(self.prePopStatus == self.Status.playComing){
                            if(!self.forceStop){
                                _speech.speecher.Recorder.loadAudio(self.records[self.wordIndex].id, false);
                            }else{
                                self.dom.find('.pop_word_playCom').show();
                                self.dom.find('.pop_word_stopCom').hide();
                                self.disableAllFunBtn();
                                self.setPopStyle();
                            }
                        }
                    }

                    self.forceStop = false;
                }
            }
        });
    };

    /**
     * 注册“开始录音”点击事件
     * @param {{
    *      data:{ self: EnWordEvalCard }
    * }} e
     * @protected
     */
    EnWordEvalCard.prototype.onStartRec = function (e) {
        e.data.self.clickEvent.onStartRec && e.data.self.clickEvent.onStartRec.call(e.data.self);
    };

    /**
     * 注册“停止录音”点击事件
     * @param {{
    *      data:{ self: EnWordEvalCard }
    * }} e
     * @protected
     */
    EnWordEvalCard.prototype.onStopRec = function (e) {
        e.data.self.clickEvent.onStopRec && e.data.self.clickEvent.onStopRec.call(e.data.self);
    };

    /**
     * 注册“原声播放”点击事件
     * @param {{
    *      data:{ self: EnWordEvalCard }
    * }} e
     * @protected
     */
    EnWordEvalCard.prototype.onPlayWord = function (e) {
        e.data.self.clickEvent.onPlayWord && e.data.self.clickEvent.onPlayWord.call(e.data.self);
    };

    /**
     * 注册“停止原声播放”点击事件
     * @param {{
    *      data:{ self: EnWordEvalCard }
    * }} e
     * @protected
     */
    EnWordEvalCard.prototype.onStopWord = function (e) {
        e.data.self.clickEvent.onStopWord && e.data.self.clickEvent.onStopWord.call(e.data.self);
    };

    /**
     * 注册“我的朗读”点击事件
     * @param {{
    *      data:{ self: EnWordEvalCard }
    * }} e
     * @protected
     */
    EnWordEvalCard.prototype.onPlayRead = function (e) {
        e.data.self.clickEvent.onPlayRead && e.data.self.clickEvent.onPlayRead.call(e.data.self);
    };

    /**
     * 注册“停止我的朗读”点击事件
     * @param {{
    *      data:{ self: EnWordEvalCard }
    * }} e
     * @protected
     */
    EnWordEvalCard.prototype.onStopRead = function (e) {
        e.data.self.clickEvent.onStopRead && e.data.self.clickEvent.onStopRead.call(e.data.self);
    };

    /**
     * 注册“对比朗读”点击事件
     * @param {{
    *      data:{ self: EnWordEvalCard }
    * }} e
     * @protected
     */
    EnWordEvalCard.prototype.onPlayCom = function (e) {
        e.data.self.clickEvent.onPlayCom && e.data.self.clickEvent.onPlayCom.call(e.data.self);
    };

    /**
     * 注册“停止对比朗读”点击事件
     * @param {{
    *      data:{ self: EnWordEvalCard }
    * }} e
     * @protected
     */
    EnWordEvalCard.prototype.onStopCom = function (e) {
        e.data.self.clickEvent.onStopCom && e.data.self.clickEvent.onStopCom.call(e.data.self);
    };

    /**
     * 注册“单词点击”事件
     * @param {{
    *      data:{ self : EnWordEvalCard
    *             id   : Number
    *      }
    * }} e
     * @protected
     */
    EnWordEvalCard.prototype.onPopWordPanel = function (e) {
        e.data.self.clickEvent.onPopWordPanel && e.data.self.clickEvent.onPopWordPanel.call(e.data.self, e.data.id);
    };


    /**
     * 注册“下一个”点击事件
     * @param {{
    *      data:{ self : EnWordEvalCard }
    * }} e
     * @protected
     */
    EnWordEvalCard.prototype.onPopNextBtn = function (e) {
        e.data.self.clickEvent.onPopNextBtn && e.data.self.clickEvent.onPopNextBtn.call(e.data.self);
    };

    /**
     * 注册“上一个”点击事件
     * @param {{
    *      data:{ self : EnWordEvalCard }
    * }} e
     * @protected
     */
    EnWordEvalCard.prototype.onPopPreBtn = function (e) {
        e.data.self.clickEvent.onPopPreBtn && e.data.self.clickEvent.onPopPreBtn.call(e.data.self);
    };

    /**
     * 注册“显示拼音”点击事件
     * @param {{
    *      data:{ self: EnWordEvalCard }
    * }} e
     * @protected
     */
    EnWordEvalCard.prototype.onShowPY = function (e) {
        e.data.self.clickEvent.onShowPY && e.data.self.clickEvent.onShowPY.call(e.data.self);
    };

    /**
     * 打开卡片弹出层
     */
    EnWordEvalCard.prototype.openPop = function () {
        this.disableAllFunBtn();
        this.maskOption.type = this.maskType.card;
        this.maskOption.msg  = this.popHtml;
        this.maskOption.flag = true;
        mask.showMask(this.maskOption);

        this.curStatus = this.Status.pop;
        this.dom.find('.chk').removeAttr("checked");
        this.registerPopCallBack(this);
        this.registerPopClickEvent();
    };

    /**
     * 关闭卡片弹出层
     * @param {{
     *      data:{ self : EnWordEvalCard }
     * }} e
     */
    EnWordEvalCard.prototype.closePop = function (e) {
        var self = e.data.self;
        self.maskOption.flag = false;
        mask.showMask(self.maskOption);
        self.disableAllFunBtn();

        self.wordIndex = 0;
        self.setWordScore();
        self.curStatus = self.Status.normal;
        self.registerCallBack(self);
        self.registerClickEvent();
        self.clickEvent.onShowPY && self.clickEvent.onShowPY.call(self);
        if(self.initStatus){
            self.enableSingleFunBtn('.word_startRec');
            self.enableSingleFunBtn('.word_playWord');
            self.enableSingleFunBtn('.word_panel_index');
        }else{
            self.enableAllFunBtn();
        }
    };

    /**
     * 设置单词背景颜色
     * @param {Number} index
     * @param {String} color
     */
    EnWordEvalCard.prototype.setWordPanelColor = function(index, color){
        switch(color){
            case 'green':
                this.dom.find('.word_panel_' + index).removeClass('graycard').removeClass('redcard').addClass('gncard');
                this.dom.find('.word_line_' + index).removeClass('grayline').removeClass('redline').addClass('gnline');
                this.dom.find('.word_text_' + index).removeClass('dimgray').removeClass('red').addClass('green');
                break;
            case 'red':
                this.dom.find('.word_panel_' + index).removeClass('graycard').removeClass('gncard').addClass('redcard');
                this.dom.find('.word_line_' + index).removeClass('grayline').removeClass('gnline').addClass('redline');
                this.dom.find('.word_text_' + index).removeClass('dimgray').removeClass('green').addClass('red');
                break;
            case 'gray':
                this.dom.find('.word_panel_' + index).removeClass('greencard').removeClass('redcard').addClass('graycard');
                this.dom.find('.word_line_' + index).removeClass('redline').removeClass('gnline').addClass('grayline');
                this.dom.find('.word_text_' + index).removeClass('red').removeClass('green').addClass('dimgray');
                break;
        }
    };

    /**
     * 设置得分信息
     */
    EnWordEvalCard.prototype.setWordScore = function(){
        for(var i = 0; i < this.scoreArray.length; i++){
            if(this.scoreArray[i] >= 60){
                this.dom.find('.word_eval_' + i).text("").text(this.scoreArray[i]).removeClass('red').addClass('green');
                this.setWordPanelColor(i, 'green');
            }else if( this.scoreArray[i] <= 59 ){
                if(this.scoreArray[i] === ""){
                    this.dom.find('.word_eval_' + i).text("").text(this.scoreArray[i]).removeClass('red').addClass('green');
                    this.setWordPanelColor(i, 'gray');
                }else{
                    this.dom.find('.word_eval_' + i).text("").text(this.scoreArray[i]).removeClass('green').addClass('red');
                    this.setWordPanelColor(i, 'red');
                }
            }
        }
    };

    /**
     * 设置弹出层得分信息
     */
    EnWordEvalCard.prototype.setPopWordScore = function(){
        var txt   = this.dom.find('.pop_word_txt');
        var score = this.dom.find('.pop_word_score_result');

        txt.text("").text( this.wordArray[this.wordIndex+1] );
        score.text("").text( this.scoreArray[this.wordIndex] );

        if(this.scoreArray[this.wordIndex] >= 60){
            score.removeClass('red').addClass('green');
        }else{
            score.removeClass('green').addClass('red');
        }
    };

    /**
     * 设置弹出层的显示样式
     */
    EnWordEvalCard.prototype.setPopStyle = function(){
        if(this.records[this.wordIndex].flag){
            this.enableSingleFunBtn('.pop_word_startRec');
            this.enableSingleFunBtn('.pop_word_playWord');
            this.enableSingleFunBtn('.pop_pre');
            this.enableSingleFunBtn('.pop_next');
            this.enableSingleFunBtn('.pop_close_mask');
        }else{
            this.enableAllFunBtn();
        }
    }

    EnWordEvalCard.prototype.setPreNext = function(){
        this.disableSingleFunBtn('.pop_pre');
        this.disableSingleFunBtn('.pop_next');
        this.enableSingleFunBtn('.pop_pre');
        this.enableSingleFunBtn('.pop_next');
    }

    /**
     * enable所有按钮
     */
    EnWordEvalCard.prototype.enableAllFunBtn = function () {
        var pop = (this.curStatus == this.Status.pop ? "pop_" : "");
        this.enableSingleFunBtn('.' + pop + 'word_stopRec');
        this.enableSingleFunBtn('.' + pop + 'word_startRec');

        this.enableSingleFunBtn('.' + pop + 'word_stopWord');
        this.enableSingleFunBtn('.' + pop + 'word_playWord');

        this.enableSingleFunBtn('.' + pop + 'word_stopRead');
        this.enableSingleFunBtn('.' + pop + 'word_playRead');

        this.enableSingleFunBtn('.' + pop + 'word_playCom');
        this.enableSingleFunBtn('.' + pop + 'word_stopCom');

        this.enableSingleFunBtn('.' + pop + 'word_panel_index');
        this.enableSingleFunBtn('.' + pop + 'close_mask');

        this.enableSingleFunBtn('.' + pop + 'pre');
        this.enableSingleFunBtn('.' + pop + 'next');
    };

    /**
     * disable所有按钮
     */
    EnWordEvalCard.prototype.disableAllFunBtn = function () {
        var pop = (this.curStatus == this.Status.pop ? "pop_" : "");
        this.disableSingleFunBtn('.' + pop + 'word_stopRec');
        this.disableSingleFunBtn('.' + pop + 'word_startRec');

        this.disableSingleFunBtn('.' + pop + 'word_stopWord');
        this.disableSingleFunBtn('.' + pop + 'word_playWord');

        this.disableSingleFunBtn('.' + pop + 'word_stopRead');
        this.disableSingleFunBtn('.' + pop + 'word_playRead');

        this.disableSingleFunBtn('.' + pop + 'word_playCom');
        this.disableSingleFunBtn('.' + pop + 'word_stopCom');

        this.disableSingleFunBtn('.' + pop + 'word_panel_index');
        this.disableSingleFunBtn('.' + pop + 'close_mask');

        this.disableSingleFunBtn('.' + pop + 'pre');
        this.disableSingleFunBtn('.' + pop + 'next');
    };

    /**
     * enable单个按钮
     */
    EnWordEvalCard.prototype.enableSingleFunBtn = function(id){
        var dom = this.dom;
        var pop = (this.curStatus == this.Status.pop ? "pop_" : "");
        switch(id){
            case  '.' + pop + 'word_stopRec':
                dom.find(id).removeClass( pop + 'word_rec_stop_dis').addClass( pop + 'word_rec_stop').bind('click',{ self : this }, this.onStopRec);
                break;
            case  '.' + pop + 'word_startRec':
                dom.find(id).removeClass( pop + 'word_rec_start_dis').addClass( pop + 'word_rec_start').bind('click', { self : this }, this.onStartRec);
                break;
            case  '.' + pop + 'word_stopWord':
                dom.find(id).removeClass( pop + 'word_stop_dis').addClass( pop + 'word_stop').bind('click', { self : this }, this.onStopWord);
                break;
            case  '.' + pop + 'word_playWord':
                dom.find(id).removeClass( pop + 'word_play_dis').addClass( pop + 'word_play').bind('click', { self : this }, this.onPlayWord);
                break;
            case  '.' + pop + 'word_stopRead':
                dom.find(id).removeClass( pop + 'word_read_stop_dis').addClass( pop + 'word_read_stop').bind('click',{ self : this }, this.onStopRead);
                break;
            case  '.' + pop + 'word_playRead':
                dom.find(id).removeClass( pop + 'word_read_play_dis').addClass( pop + 'word_read_play').bind('click', { self : this }, this.onPlayRead);
                break;
            case  '.' + pop + 'word_playCom':
                dom.find(id).removeClass( pop + 'word_db_play_dis').addClass( pop + 'word_db_play').bind('click', { self : this }, this.onPlayCom);
                break;
            case  '.' + pop + 'word_stopCom':
                dom.find(id).removeClass( pop + 'word_db_stop_dis').addClass( pop + 'word_db_stop').bind('click', { self : this }, this.onStopCom);
                break;
            case  '.showPY':
                dom.find('.change_yb > input').bind('click', { self : this }, this.onShowPY);
                break;
            case '.pop_pre':
                if(this.wordIndex != 0){
                    dom.find(id).removeClass('pop_btn_predis').addClass('pop_btn_prenor')
                        .bind('click', { self : this }, this.onPopPreBtn)
                        .bind('mouseover', function(){dom.find( '.pop_pre').addClass('pop_btn_prehov')})
                        .bind('mouseout', function(){dom.find( '.pop_pre').removeClass('pop_btn_prehov')});
                }
                break;
            case '.pop_next':
                if(this.wordIndex != this.wordArray.length - 2){
                    dom.find(id).removeClass('pop_btn_nextdis').addClass('pop_btn_nextnor')
                        .bind('click', { self : this }, this.onPopNextBtn)
                        .bind('mouseover', function(){dom.find( '.pop_next').addClass('pop_btn_nexthov')})
                        .bind('mouseout', function(){dom.find( '.pop_next').removeClass('pop_btn_nexthov')});

                }
                break;
            case '.pop_close_mask':
                dom.find(id).removeClass('pop_close_hover').addClass('pop_close')
                    .bind('click', { self : this }, this.closePop)
                    .bind('mouseover', function(){dom.find( '.pop_close_mask').addClass('pop_close_hover')})
                    .bind('mouseout', function(){dom.find( '.pop_close_mask').removeClass('pop_close_hover')});
                break;
            case '.word_panel_index' :
                for(var i = 0; i < this.wordArray.length - 1; i++){
                    dom.find('.' + pop +'word_panel_' + i).bind('click', { self : this, id : i}, this.onPopWordPanel);
                }
                break;
        }
    };

    /**
     * disable单个按钮
     */
    EnWordEvalCard.prototype.disableSingleFunBtn = function(id){
        var dom = this.dom;
        var pop = (this.curStatus == this.Status.pop ? "pop_" : "");
        switch(id){
            case  '.' + pop + 'word_stopRec':
                dom.find(id).removeClass( pop + 'word_rec_stop').addClass( pop + 'word_rec_stop_dis').unbind('click', this.onStopRec);
                break;
            case  '.' + pop + 'word_startRec':
                dom.find(id).removeClass( pop + 'word_rec_start').addClass( pop + 'word_rec_start_dis').unbind('click', this.onStartRec);
                break;
            case  '.' + pop + 'word_stopWord':
                dom.find(id).removeClass( pop + 'word_stop').addClass( pop + 'word_stop_dis').unbind('click', this.onStopWord);
                break;
            case  '.' + pop + 'word_playWord':
                dom.find(id).removeClass( pop + 'word_play').addClass( pop + 'word_play_dis').unbind('click', this.onPlayWord);
                break;
            case  '.' + pop + 'word_stopRead':
                dom.find(id).removeClass( pop + 'word_read_stop').addClass( pop + 'word_read_stop_dis').unbind('click', this.onStopRead);
                break;
            case  '.' + pop + 'word_playRead':
                dom.find(id).removeClass( pop + 'word_read_play').addClass( pop + 'word_read_play_dis').unbind('click', this.onPlayRead);
                break;
            case  '.' + pop + 'word_playCom':
                dom.find(id).removeClass( pop + 'word_db_play').addClass( pop + 'word_db_play_dis').unbind('click', this.onPlayCom);
                break;
            case  '.' + pop + 'word_stopCom':
                dom.find(id).removeClass( pop + 'word_db_stop').addClass( pop + 'word_db_stop_dis').unbind('click', this.onStopCom);
                break;
            case '.pop_pre':
                dom.find(id).removeClass('pop_btn_prenor').addClass('pop_btn_predis').unbind('click', this.onPopPreBtn).unbind('mouseover').unbind('mouseout');
                break;
            case '.pop_next':
                dom.find(id).removeClass('pop_btn_nextnor').addClass('pop_btn_nextdis').unbind('click', this.onPopNextBtn).unbind('mouseover').unbind('mouseout');
                break;
            case '.word_panel_index' :
                for(var i = 0; i < this.wordArray.length - 1; i++){
                    dom.find('.' + pop + 'word_panel_' + i).unbind('click',this.onPopWordPanel);
                }
                break;
            case '.pop_close_mask':
                dom.find(id).removeClass('pop_close').addClass('pop_close_hover')
                    .unbind('click',this.closePop).unbind('mouseover').unbind('mouseout');
                break;
        }
    };

    /**
     * 显示所有按钮
     */
    EnWordEvalCard.prototype.showAllFunBtn = function(){
        var pop = (this.curStatus == this.Status.pop ? "pop_" : "");

        this.dom.find('.' + pop + 'word_stopRec').hide();
        this.dom.find('.' + pop + 'word_stopWord').hide();
        this.dom.find('.' + pop + 'word_stopRead').hide();
        this.dom.find('.' + pop + 'word_stopCom').hide();

        this.dom.find('.' + pop + 'word_startRec').show();
        this.dom.find('.' + pop + 'word_playWord').show();
        this.dom.find('.' + pop + 'word_playRead').show();
        this.dom.find('.' + pop + 'word_playCom').show();
    };

    /**
     * @export {speechui.cards.EnWordEvalCard.Constructor}
     */
    exports.Constructor = EnWordEvalCard;
});