/*
 * Decompiled with CFR 0.152.
 */
package sun.usagetracker;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import sun.usagetracker.UsageTrackerClient;

public final class UsageTrackerClient {
    private static final Object LOCK = new Object();
    private static final String ORCL_UT_CONFIG_FILE_NAME = "usagetracker.properties";
    private static final String ORCL_UT_USAGE_DIR = ".oracle_jre_usage";
    private static final String ORCL_UT_PROPERTY_NAME = "com.oracle.usagetracker.";
    private static final String ORCL_UT_PROPERTY_RUN_SYNCHRONOUSLY = "com.oracle.usagetracker.run.synchronous";
    private static final String ORCL_UT_PROPERTY_CONFIG_FILE_NAME = "com.oracle.usagetracker.config.file";
    private static final String ORCL_UT_LOGTOFILE = "com.oracle.usagetracker.logToFile";
    private static final String ORCL_UT_LOGFILEMAXSIZE = "com.oracle.usagetracker.logFileMaxSize";
    private static final String ORCL_UT_LOGTOUDP = "com.oracle.usagetracker.logToUDP";
    private static final String ORCL_UT_TRACK_LAST_USAGE = "com.oracle.usagetracker.track.last.usage";
    private static final String ORCL_UT_VERBOSE = "com.oracle.usagetracker.verbose";
    private static final String ORCL_UT_DEBUG = "com.oracle.usagetracker.debug";
    private static final String ORCL_UT_ADDITIONALPROPERTIES = "com.oracle.usagetracker.additionalProperties";
    private static final String ORCL_UT_SEPARATOR = "com.oracle.usagetracker.separator";
    private static final String ORCL_UT_QUOTE = "com.oracle.usagetracker.quote";
    private static final String ORCL_UT_QUOTE_INNER = "com.oracle.usagetracker.innerQuote";
    private static final String DEFAULT_SEP = ",";
    private static final String DEFAULT_QUOTE = "\"";
    private static final String DEFAULT_QUOTE_INNER = "'";
    private static final AtomicBoolean isFirstRun = new AtomicBoolean(true);
    private static final String javaHome = UsageTrackerClient.getPropertyPrivileged("java.home");
    private static final String userHomeKeyword = "${user.home}";
    private static String separator;
    private static String quote;
    private static String innerQuote;
    private static boolean enabled;
    private static boolean verbose;
    private static boolean debug;
    private static boolean trackTime;
    private static String[] additionalProperties;
    private static String fullLogFilename;
    private static long logFileMaxSize;
    private static String datagramHost;
    private static int datagramPort;
    private static String staticMessage;

    private static String getPropertyPrivileged(String string) {
        return UsageTrackerClient.getPropertyPrivileged(string, null);
    }

    private static String getPropertyPrivileged(final String string, final String string2) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(string, string2);
            }
        });
    }

    private static String getEnvPrivileged(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getenv(string);
            }
        });
    }

    private static File getConfigFilePrivileged() {
        File file = null;
        String[] stringArray = new String[]{UsageTrackerClient.getPropertyPrivileged(ORCL_UT_PROPERTY_CONFIG_FILE_NAME), UsageTrackerClient.getOSSpecificConfigFilePath(), javaHome + File.separator + "lib" + File.separator + "management" + File.separator + ORCL_UT_CONFIG_FILE_NAME};
        for (final String string : stringArray) {
            if (string != null && (file = AccessController.doPrivileged(new PrivilegedAction<File>(){

                @Override
                public File run() {
                    File file = new File(string);
                    return file.exists() ? file : null;
                }
            })) != null) break;
        }
        return file;
    }

    private static String getOSSpecificConfigFilePath() {
        String string = UsageTrackerClient.getPropertyPrivileged("os.name");
        if (string != null) {
            if (string.toLowerCase().startsWith("sunos")) {
                return "/etc/oracle/java/usagetracker.properties";
            }
            if (string.toLowerCase().startsWith("mac")) {
                return "/Library/Application Support/Oracle/Java/usagetracker.properties";
            }
            if (string.toLowerCase().startsWith("win")) {
                String string2 = UsageTrackerClient.getEnvPrivileged("ProgramFiles");
                return string2 == null ? null : string2 + "\\Java\\conf\\" + ORCL_UT_CONFIG_FILE_NAME;
            }
            if (string.toLowerCase().startsWith("linux")) {
                return "/etc/oracle/java/usagetracker.properties";
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getFullLogFilename(Properties properties) {
        String string = properties.getProperty(ORCL_UT_LOGTOFILE, "");
        if (string.isEmpty()) {
            return null;
        }
        if (string.startsWith(userHomeKeyword)) {
            if (string.length() > userHomeKeyword.length()) {
                return UsageTrackerClient.getPropertyPrivileged("user.home") + string.substring(userHomeKeyword.length());
            }
            this.printVerbose("UsageTracker: blank filename after user.home.");
            return null;
        }
        if (new File(string).isAbsolute()) return string;
        this.printVerbose("UsageTracker: relative path disallowed.");
        return null;
    }

    private long getLogFileMaxSize(Properties properties) {
        String string = properties.getProperty(ORCL_UT_LOGFILEMAXSIZE, "");
        if (!string.isEmpty()) {
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.printVerbose("UsageTracker: bad maximum file size.");
            }
        }
        return -1L;
    }

    private String[] getAdditionalProperties(Properties properties) {
        String string = properties.getProperty(ORCL_UT_ADDITIONALPROPERTIES, "");
        return string.isEmpty() ? new String[]{} : string.split(DEFAULT_SEP);
    }

    private String parseDatagramHost(String string) {
        if (string != null) {
            int n = string.indexOf(58);
            if (n > 0 && n < string.length() - 1) {
                return string.substring(0, n);
            }
            this.printVerbose("UsageTracker: bad UDP details.");
        }
        return null;
    }

    private int parseDatagramPort(String string) {
        if (string != null) {
            int n = string.indexOf(58);
            try {
                return Integer.parseInt(string.substring(n + 1));
            }
            catch (Exception exception) {
                this.printVerbose("UsageTracker: bad UDP port.");
            }
        }
        return 0;
    }

    private void printVerbose(String string) {
        if (verbose) {
            System.err.println(string);
        }
    }

    private void printDebug(String string) {
        if (debug) {
            System.err.println(string);
        }
    }

    private void printDebugStackTrace(Throwable throwable) {
        if (debug) {
            throwable.printStackTrace();
        }
    }

    private void setupAndTimestamp(long l) {
        if (isFirstRun.compareAndSet(true, false)) {
            File file = UsageTrackerClient.getConfigFilePrivileged();
            if (file != null) {
                this.setup(file);
            }
            if (trackTime) {
                this.registerUsage(l);
            }
        }
    }

    public void run(final String string, final String string2) {
        this.printDebug("UsageTracker.run: " + string + ", javaCommand: " + string2);
        try {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    long l = System.currentTimeMillis();
                    boolean bl = Boolean.parseBoolean(System.getProperty(UsageTrackerClient.ORCL_UT_PROPERTY_RUN_SYNCHRONOUSLY, "true"));
                    if (bl) {
                        UsageTrackerClient.this.setupAndTimestamp(l);
                        UsageTrackerClient.this.printVerbose("UsageTracker: running synchronous.");
                    }
                    if (enabled || !bl) {
                        UsageTrackerRunnable usageTrackerRunnable = new UsageTrackerRunnable(UsageTrackerClient.this, string, string2, l, !bl);
                        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                        while (threadGroup.getParent() != null) {
                            threadGroup = threadGroup.getParent();
                        }
                        Thread thread = new Thread(threadGroup, (Runnable)usageTrackerRunnable, "UsageTracker");
                        thread.setDaemon(true);
                        thread.start();
                    }
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            this.printVerbose("UsageTracker: error in starting thread.");
            this.printDebugStackTrace(throwable);
        }
    }

    private boolean getBooleanProperty(Properties properties, String string) {
        return Boolean.parseBoolean(properties.getProperty(string));
    }

    private void setup(File file) {
        Object object;
        Properties properties = new Properties();
        if (file != null) {
            try {
                object = new FileInputStream(file);
                Throwable throwable = null;
                try (BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);){
                    properties.load(bufferedInputStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((FileInputStream)object).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((FileInputStream)object).close();
                        }
                    }
                }
            }
            catch (Exception exception) {
                properties.clear();
            }
        }
        verbose = this.getBooleanProperty(properties, ORCL_UT_VERBOSE);
        debug = this.getBooleanProperty(properties, ORCL_UT_DEBUG);
        separator = properties.getProperty(ORCL_UT_SEPARATOR, DEFAULT_SEP);
        quote = properties.getProperty(ORCL_UT_QUOTE, DEFAULT_QUOTE);
        innerQuote = properties.getProperty(ORCL_UT_QUOTE_INNER, DEFAULT_QUOTE_INNER);
        fullLogFilename = this.getFullLogFilename(properties);
        logFileMaxSize = this.getLogFileMaxSize(properties);
        additionalProperties = this.getAdditionalProperties(properties);
        object = properties.getProperty(ORCL_UT_LOGTOUDP);
        datagramHost = this.parseDatagramHost((String)object);
        datagramPort = this.parseDatagramPort((String)object);
        enabled = fullLogFilename != null || datagramHost != null && datagramPort > 0;
        trackTime = Boolean.parseBoolean(properties.getProperty(ORCL_UT_TRACK_LAST_USAGE, "true"));
    }

    private void registerUsage(long l) {
        block18: {
            try {
                String string = new File(System.getProperty("java.home")).getCanonicalPath();
                String string2 = System.getProperty("user.home");
                if (string2 == null) break block18;
                File file = new File(string2 + File.separator + ORCL_UT_USAGE_DIR, this.getPathHash(string) + ".timestamp");
                if (!file.exists()) {
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    file.createNewFile();
                }
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    String string3 = string + System.lineSeparator() + l + System.lineSeparator();
                    fileOutputStream.write(string3.getBytes("UTF-8"));
                }
                catch (IOException iOException) {
                    this.printDebugStackTrace(iOException);
                }
            }
            catch (IOException iOException) {
                this.printDebugStackTrace(iOException);
            }
        }
    }

    private String getPathHash(String string) {
        long l = 0L;
        for (int i = 0; i < string.length(); ++i) {
            l = 31L * l + (long)string.charAt(i);
        }
        return Long.toHexString(l);
    }

    static /* synthetic */ String access$300() {
        return separator;
    }

    static /* synthetic */ Object access$400() {
        return LOCK;
    }

    static /* synthetic */ String access$500() {
        return staticMessage;
    }

    static /* synthetic */ String access$600() {
        return javaHome;
    }

    static /* synthetic */ String access$700(String string) {
        return UsageTrackerClient.getPropertyPrivileged(string);
    }

    static /* synthetic */ String access$800() {
        return innerQuote;
    }

    static /* synthetic */ String[] access$900() {
        return additionalProperties;
    }

    static /* synthetic */ String access$502(String string) {
        staticMessage = string;
        return staticMessage;
    }

    static /* synthetic */ String access$1000() {
        return quote;
    }

    static /* synthetic */ void access$1100(UsageTrackerClient usageTrackerClient, String string) {
        usageTrackerClient.printDebug(string);
    }

    static /* synthetic */ String access$1200() {
        return datagramHost;
    }

    static /* synthetic */ int access$1300() {
        return datagramPort;
    }

    static /* synthetic */ void access$1400(UsageTrackerClient usageTrackerClient, Throwable throwable) {
        usageTrackerClient.printDebugStackTrace(throwable);
    }

    static /* synthetic */ String access$1500() {
        return fullLogFilename;
    }

    static /* synthetic */ long access$1600() {
        return logFileMaxSize;
    }

    static {
        trackTime = true;
    }
}

