/*
 * Decompiled with CFR 0.152.
 */
package sun.net.idn;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.Normalizer;
import java.text.ParseException;
import sun.net.idn.StringPrep;
import sun.net.idn.StringPrepDataReader;
import sun.text.Normalizer;
import sun.text.normalizer.CharTrie;
import sun.text.normalizer.NormalizerImpl;
import sun.text.normalizer.Trie;
import sun.text.normalizer.UCharacter;
import sun.text.normalizer.UCharacterIterator;
import sun.text.normalizer.UTF16;
import sun.text.normalizer.VersionInfo;

public final class StringPrep {
    public static final int DEFAULT = 0;
    public static final int ALLOW_UNASSIGNED = 1;
    private static final int UNASSIGNED = 0;
    private static final int MAP = 1;
    private static final int PROHIBITED = 2;
    private static final int DELETE = 3;
    private static final int TYPE_LIMIT = 4;
    private static final int NORMALIZATION_ON = 1;
    private static final int CHECK_BIDI_ON = 2;
    private static final int TYPE_THRESHOLD = 65520;
    private static final int MAX_INDEX_VALUE = 16319;
    private static final int MAX_INDEX_TOP_LENGTH = 3;
    private static final int INDEX_TRIE_SIZE = 0;
    private static final int INDEX_MAPPING_DATA_SIZE = 1;
    private static final int NORM_CORRECTNS_LAST_UNI_VERSION = 2;
    private static final int ONE_UCHAR_MAPPING_INDEX_START = 3;
    private static final int TWO_UCHARS_MAPPING_INDEX_START = 4;
    private static final int THREE_UCHARS_MAPPING_INDEX_START = 5;
    private static final int FOUR_UCHARS_MAPPING_INDEX_START = 6;
    private static final int OPTIONS = 7;
    private static final int INDEX_TOP = 16;
    private static final int DATA_BUFFER_SIZE = 25000;
    private StringPrepTrieImpl sprepTrieImpl;
    private int[] indexes;
    private char[] mappingData;
    private byte[] formatVersion;
    private VersionInfo sprepUniVer;
    private VersionInfo normCorrVer;
    private boolean doNFKC;
    private boolean checkBiDi;

    private char getCodePointValue(int n) {
        return this.sprepTrieImpl.sprepTrie.getCodePointValue(n);
    }

    private static VersionInfo getVersionInfo(int n) {
        int n2 = n & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 24 & 0xFF;
        return VersionInfo.getInstance(n5, n4, n3, n2);
    }

    private static VersionInfo getVersionInfo(byte[] byArray) {
        if (byArray.length != 4) {
            return null;
        }
        return VersionInfo.getInstance(byArray[0], byArray[1], byArray[2], byArray[3]);
    }

    public StringPrep(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream, 25000);
        StringPrepDataReader stringPrepDataReader = new StringPrepDataReader(bufferedInputStream);
        this.indexes = stringPrepDataReader.readIndexes(16);
        byte[] byArray = new byte[this.indexes[0]];
        this.mappingData = new char[this.indexes[1] / 2];
        stringPrepDataReader.read(byArray, this.mappingData);
        this.sprepTrieImpl = new StringPrepTrieImpl();
        this.sprepTrieImpl.sprepTrie = new CharTrie(new ByteArrayInputStream(byArray), this.sprepTrieImpl);
        this.formatVersion = stringPrepDataReader.getDataFormatVersion();
        this.doNFKC = (this.indexes[7] & 1) > 0;
        this.checkBiDi = (this.indexes[7] & 2) > 0;
        this.sprepUniVer = StringPrep.getVersionInfo(stringPrepDataReader.getUnicodeVersion());
        this.normCorrVer = StringPrep.getVersionInfo(this.indexes[2]);
        VersionInfo versionInfo = NormalizerImpl.getUnicodeVersion();
        if (versionInfo.compareTo(this.sprepUniVer) < 0 && versionInfo.compareTo(this.normCorrVer) < 0 && (this.indexes[7] & 1) > 0) {
            throw new IOException("Normalization Correction version not supported");
        }
        bufferedInputStream.close();
    }

    private static final void getValues(char c, Values values) {
        values.reset();
        if (c == '\u0000') {
            values.type = 4;
        } else if (c >= '\ufff0') {
            values.type = c - 65520;
        } else {
            values.type = 1;
            if ((c & 2) > 0) {
                values.isIndex = true;
                values.value = c >> 2;
            } else {
                values.isIndex = false;
                values.value = c << 16 >> 16;
                values.value >>= 2;
            }
            if (c >> 2 == 16319) {
                values.type = 3;
                values.isIndex = false;
                values.value = 0;
            }
        }
    }

    private StringBuffer map(UCharacterIterator uCharacterIterator, int n) throws ParseException {
        boolean bl;
        Values values = new Values(null);
        char c = '\u0000';
        int n2 = -1;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = bl = (n & 1) > 0;
        while ((n2 = uCharacterIterator.nextCodePoint()) != -1) {
            c = this.getCodePointValue(n2);
            StringPrep.getValues(c, values);
            if (values.type == 0 && !bl) {
                throw new ParseException("An unassigned code point was found in the input " + uCharacterIterator.getText(), uCharacterIterator.getIndex());
            }
            if (values.type == 1) {
                if (values.isIndex) {
                    int n3 = values.value;
                    int n4 = n3 >= this.indexes[3] && n3 < this.indexes[4] ? 1 : (n3 >= this.indexes[4] && n3 < this.indexes[5] ? 2 : (n3 >= this.indexes[5] && n3 < this.indexes[6] ? 3 : this.mappingData[n3++]));
                    stringBuffer.append(this.mappingData, n3, n4);
                    continue;
                }
                n2 -= values.value;
            } else if (values.type == 3) continue;
            UTF16.append(stringBuffer, n2);
        }
        return stringBuffer;
    }

    private StringBuffer normalize(StringBuffer stringBuffer) {
        return new StringBuffer(Normalizer.normalize(stringBuffer.toString(), Normalizer.Form.NFKC, 262432));
    }

    public StringBuffer prepare(UCharacterIterator uCharacterIterator, int n) throws ParseException {
        int n2;
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer = this.map(uCharacterIterator, n);
        if (this.doNFKC) {
            stringBuffer2 = this.normalize(stringBuffer);
        }
        UCharacterIterator uCharacterIterator2 = UCharacterIterator.getInstance(stringBuffer2);
        Values values = new Values(null);
        int n3 = 19;
        int n4 = 19;
        int n5 = -1;
        int n6 = -1;
        boolean bl = false;
        boolean bl2 = false;
        while ((n2 = uCharacterIterator2.nextCodePoint()) != -1) {
            char c = this.getCodePointValue(n2);
            StringPrep.getValues(c, values);
            if (values.type == 2) {
                throw new ParseException("A prohibited code point was found in the input" + uCharacterIterator2.getText(), values.value);
            }
            n3 = UCharacter.getDirection(n2);
            if (n4 == 19) {
                n4 = n3;
            }
            if (n3 == 0) {
                bl2 = true;
                n6 = uCharacterIterator2.getIndex() - 1;
            }
            if (n3 != 1 && n3 != 13) continue;
            bl = true;
            n5 = uCharacterIterator2.getIndex() - 1;
        }
        if (this.checkBiDi) {
            if (bl2 && bl) {
                throw new ParseException("The input does not conform to the rules for BiDi code points." + uCharacterIterator2.getText(), n5 > n6 ? n5 : n6);
            }
            if (bl && (n4 != 1 && n4 != 13 || n3 != 1 && n3 != 13)) {
                throw new ParseException("The input does not conform to the rules for BiDi code points." + uCharacterIterator2.getText(), n5 > n6 ? n5 : n6);
            }
        }
        return stringBuffer2;
    }

    private static final class StringPrepTrieImpl
    implements Trie.DataManipulate {
        private CharTrie sprepTrie = null;

        private StringPrepTrieImpl() {
        }

        @Override
        public int getFoldingOffset(int n) {
            return n;
        }
    }
}

