/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import sun.net.DefaultProgressMeteringPolicy;
import sun.net.ProgressEvent;
import sun.net.ProgressListener;
import sun.net.ProgressMeteringPolicy;
import sun.net.ProgressSource;

public class ProgressMonitor {
    private static ProgressMeteringPolicy meteringPolicy = new DefaultProgressMeteringPolicy();
    private static ProgressMonitor pm = new ProgressMonitor();
    private ArrayList<ProgressSource> progressSourceList = new ArrayList();
    private ArrayList<ProgressListener> progressListenerList = new ArrayList();

    public static synchronized ProgressMonitor getDefault() {
        return pm;
    }

    public static synchronized void setDefault(ProgressMonitor progressMonitor) {
        if (progressMonitor != null) {
            pm = progressMonitor;
        }
    }

    public static synchronized void setMeteringPolicy(ProgressMeteringPolicy progressMeteringPolicy) {
        if (progressMeteringPolicy != null) {
            meteringPolicy = progressMeteringPolicy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ProgressSource> getProgressSources() {
        ArrayList<ProgressSource> arrayList = new ArrayList<ProgressSource>();
        try {
            ArrayList<ProgressSource> arrayList2 = this.progressSourceList;
            synchronized (arrayList2) {
                for (ProgressSource progressSource : this.progressSourceList) {
                    arrayList.add((ProgressSource)progressSource.clone());
                }
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return arrayList;
    }

    public synchronized int getProgressUpdateThreshold() {
        return meteringPolicy.getProgressUpdateThreshold();
    }

    public boolean shouldMeterInput(URL uRL, String string) {
        return meteringPolicy.shouldMeterInput(uRL, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSource(ProgressSource progressSource) {
        ArrayList<Object> arrayList = this.progressSourceList;
        synchronized (arrayList) {
            if (this.progressSourceList.contains(progressSource)) {
                return;
            }
            this.progressSourceList.add(progressSource);
        }
        if (this.progressListenerList.size() > 0) {
            arrayList = new ArrayList();
            ArrayList<ProgressListener> arrayList2 = this.progressListenerList;
            synchronized (arrayList2) {
                Iterator<ProgressListener> progressListener = this.progressListenerList.iterator();
                while (progressListener.hasNext()) {
                    arrayList.add((ProgressSource)progressListener.next());
                }
            }
            for (ProgressListener progressListener : arrayList) {
                ProgressEvent progressEvent = new ProgressEvent(progressSource, progressSource.getURL(), progressSource.getMethod(), progressSource.getContentType(), progressSource.getState(), progressSource.getProgress(), progressSource.getExpected());
                progressListener.progressStart(progressEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSource(ProgressSource progressSource) {
        ArrayList<Object> arrayList = this.progressSourceList;
        synchronized (arrayList) {
            if (!this.progressSourceList.contains(progressSource)) {
                return;
            }
            progressSource.close();
            this.progressSourceList.remove(progressSource);
        }
        if (this.progressListenerList.size() > 0) {
            arrayList = new ArrayList();
            ArrayList<ProgressListener> arrayList2 = this.progressListenerList;
            synchronized (arrayList2) {
                Iterator<ProgressListener> progressListener = this.progressListenerList.iterator();
                while (progressListener.hasNext()) {
                    arrayList.add((ProgressSource)progressListener.next());
                }
            }
            for (ProgressListener progressListener : arrayList) {
                ProgressEvent progressEvent = new ProgressEvent(progressSource, progressSource.getURL(), progressSource.getMethod(), progressSource.getContentType(), progressSource.getState(), progressSource.getProgress(), progressSource.getExpected());
                progressListener.progressFinish(progressEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProgress(ProgressSource progressSource) {
        ArrayList<Object> arrayList = this.progressSourceList;
        synchronized (arrayList) {
            if (!this.progressSourceList.contains(progressSource)) {
                return;
            }
        }
        if (this.progressListenerList.size() > 0) {
            arrayList = new ArrayList();
            ArrayList<ProgressListener> arrayList2 = this.progressListenerList;
            synchronized (arrayList2) {
                Iterator<ProgressListener> progressListener = this.progressListenerList.iterator();
                while (progressListener.hasNext()) {
                    arrayList.add((ProgressSource)progressListener.next());
                }
            }
            for (ProgressListener progressListener : arrayList) {
                ProgressEvent progressEvent = new ProgressEvent(progressSource, progressSource.getURL(), progressSource.getMethod(), progressSource.getContentType(), progressSource.getState(), progressSource.getProgress(), progressSource.getExpected());
                progressListener.progressUpdate(progressEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressListener(ProgressListener progressListener) {
        ArrayList<ProgressListener> arrayList = this.progressListenerList;
        synchronized (arrayList) {
            this.progressListenerList.add(progressListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressListener(ProgressListener progressListener) {
        ArrayList<ProgressListener> arrayList = this.progressListenerList;
        synchronized (arrayList) {
            this.progressListenerList.remove(progressListener);
        }
    }
}

