/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import sun.misc.SoftCache;

public class SoftCache
extends AbstractMap
implements Map {
    private Map hash;
    private ReferenceQueue queue = new ReferenceQueue();
    private Set entrySet = null;

    private void processQueue() {
        ValueCell valueCell;
        while ((valueCell = (ValueCell)this.queue.poll()) != null) {
            if (valueCell.isValid()) {
                this.hash.remove(valueCell.key);
                continue;
            }
            ValueCell.dropped--;
        }
    }

    public SoftCache(int n, float f) {
        this.hash = new HashMap(n, f);
    }

    public SoftCache(int n) {
        this.hash = new HashMap(n);
    }

    public SoftCache() {
        this.hash = new HashMap();
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return ValueCell.strip(this.hash.get(object), false) != null;
    }

    protected Object fill(Object object) {
        return null;
    }

    public Object get(Object object) {
        this.processQueue();
        Object object2 = this.hash.get(object);
        if (object2 == null && (object2 = this.fill(object)) != null) {
            this.hash.put(object, ValueCell.create(object, object2, this.queue));
            return object2;
        }
        return ValueCell.strip(object2, false);
    }

    public Object put(Object object, Object object2) {
        this.processQueue();
        ValueCell valueCell = ValueCell.create(object, object2, this.queue);
        return ValueCell.strip(this.hash.put(object, valueCell), true);
    }

    public Object remove(Object object) {
        this.processQueue();
        return ValueCell.strip(this.hash.remove(object), true);
    }

    @Override
    public void clear() {
        this.processQueue();
        this.hash.clear();
    }

    private static boolean valEquals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet(this, null);
        }
        return this.entrySet;
    }

    static /* synthetic */ ReferenceQueue access$500(SoftCache softCache) {
        return softCache.queue;
    }

    static /* synthetic */ boolean access$600(Object object, Object object2) {
        return SoftCache.valEquals(object, object2);
    }

    static /* synthetic */ Map access$700(SoftCache softCache) {
        return softCache.hash;
    }

    static /* synthetic */ void access$800(SoftCache softCache) {
        softCache.processQueue();
    }

    private static class ValueCell
    extends SoftReference {
        private static Object INVALID_KEY = new Object();
        private static int dropped = 0;
        private Object key;

        private ValueCell(Object object, Object object2, ReferenceQueue referenceQueue) {
            super(object2, referenceQueue);
            this.key = object;
        }

        private static ValueCell create(Object object, Object object2, ReferenceQueue referenceQueue) {
            if (object2 == null) {
                return null;
            }
            return new ValueCell(object, object2, referenceQueue);
        }

        private static Object strip(Object object, boolean bl) {
            if (object == null) {
                return null;
            }
            ValueCell valueCell = (ValueCell)object;
            Object t = valueCell.get();
            if (bl) {
                valueCell.drop();
            }
            return t;
        }

        private boolean isValid() {
            return this.key != INVALID_KEY;
        }

        private void drop() {
            super.clear();
            this.key = INVALID_KEY;
            ++dropped;
        }
    }
}

